/*
 *	Draw a bunch of boxes
 *
 *	From code by Greg C.
 *
 *	Compile with:
 *	cc -O boxes.c -o boxes -lvt
 */
#include <vt.h>
#include <signal.h>

#define XMIN	0
#define YMIN	0
#include "sin.h"
#define SIN(x)	sin[(x+360)%360]
#define COS(x)  sin[((x)+450)%360]

typedef struct a_corner{
    int velocity, angle, x_c, y_c;
}a_corner;

a_corner uno, due;	/* Italian corners */
short	width, height;
struct colors {
	int	r;
	int	g;
	int	b;
} colors[] = {
	{ 2, 11, 13},
	{ 0,  0, 14},
	{ 0, 14,  0},
	{ 0, 14, 14},
	{14,  0,  0},
	{14,  0, 14},
	{14, 14,  0},
	{ 0, 14,  8},
	{ 0,  8, 14},
	{14,  8,  0},
	{ 8, 14,  0},
	{ 8,  0, 14},
	{14,  0,  8},
	{ 8, 14,  8},
	{14,  8, 14},
	{15, 15, 15}
};
struct wstate ws;

cleanup()
{
    BlockRefreshAdjust(1);
    SetPosition(1, 0, 0);
    SetColor(1, ws.bcolor);
    PaintRectangleInterior(1, 10000, 10000);
    SetWindowState(1, &ws);
    exit(0);
}

main(argc, argv)
int	argc;
char	*argv[];
{
long otemp, temp;
int	adjustsize(), ignoreref();
struct gconfig	gc;
register int x, y, delta_x, delta_y, color, cmin, cmax;

	if (GetGraphicsConfig(1, &gc) == -1) {
		printf("%s: not a window\n", argv[0]);
		exit(1);
	}

	signal(SIGTERM, cleanup);
	signal(SIGHUP, cleanup);
	signal(SIGQUIT, cleanup);
	signal(SIGINT, cleanup);

	srandom(103423);
	GetWindowState(1, &ws);
	width = ws.width;
	height= ws.height;
	SetLineDisc(1, TWSDISC);
	SetBuf(1, 100);
    	SetMouseMode(1, VT_MOUSE_DOWN);
	SetRefresh(1, 0, ignoreref);
	SetAdjust(1, 0, adjustsize);
	SetAddressing(1, VT_RELATIVE);
	init_corner(&uno);
	init_corner(&due);
	
	if (gc.realcolors > 2) {
	    register int	c;
	    /* color */
	    cmin = 0;
	    cmax = gc.realcolors - 1;
	    /* get some nice colors if available */
	    for (c=0; c<(sizeof(colors)/sizeof(struct colors)); c++) {
		SetLocalLUT(1, c,
		    colors[c].r, colors[c].g, colors[c].b, VT_SHARE);
	    }
	    /* free them up */
	    for (c=0; c<(sizeof(colors)/sizeof(struct colors)); c++) {
		SetLocalLUT(1, c, 0, 0, 0, VT_FREE);
	    }
	} else {
	    /* monochrome */
	    cmin = VT_Gray62;
	    cmax = VT_White;
	}
	color = cmin;

	cls();
	while (1) {
		update_corner(&uno);
		update_corner(&due);
		x = uno.x_c < due.x_c ? uno.x_c : due.x_c;
		y = uno.y_c < due.y_c ? uno.y_c : due.y_c;
		delta_x = uno.x_c-due.x_c;
		if (delta_x <0) delta_x = -delta_x;
		delta_y = uno.y_c-due.y_c;
		if (delta_y <0) delta_y = -delta_y;
		SetPosition(1, x, y);
		SetColor(1, color);
		PaintRectangleInterior(1, delta_x, delta_y);
		if (++color > cmax) color = cmin;
		temp = (long)delta_x*(long)delta_y;
		if(temp >(width*height/2)){
			if (temp>otemp){
				drag_corner(&due, &uno);
			}
			otemp = temp;
		}else{
			otemp = width*height;
		}
	}
}

init_corner(corner)
a_corner  *corner;
{
    corner->velocity = randu(20)+5;
    corner->angle = randu(360);
    corner->x_c = width/2;
    corner->y_c = height/2;
}

drag_corner(a, b)
a_corner  *a, *b;
{
    a->velocity = randu(7) - 3;
    a->angle = b->angle + randu(20) - 10;
}

update_corner(corner)
a_corner *corner;
{
    corner->x_c += COS(corner->angle)*(float)corner->velocity;
    corner->y_c += SIN(corner->angle)*(float)corner->velocity;
    if (corner->x_c <= XMIN){
	corner->x_c = XMIN;
	set_corner (corner, 0);
    }
    if (corner->y_c <= YMIN){
	corner->y_c = YMIN;
	set_corner (corner, 270);
    }
    if (corner->x_c >= width){
	corner->x_c = width;
	set_corner (corner, 180);
    }
    if (corner->y_c >= height){
	corner->y_c = height;
	set_corner (corner, 90);
    }
}

set_corner(corner, bias)
a_corner *corner;
int	bias;
{
    corner->velocity = randu(20)+10;
    corner->angle = randu(180)+bias;
}

randu(val)
int val;
{
    long random();
    return(random()%val);
}

cls()
{
	SetPosition(1, 0, 0);
	SetColor(1, VT_White);
	PaintRectangleInterior(1, 2000, 2000);
	SetColor(1, VT_Black);
}


ignoreref()
{
}

adjustsize(id, w, h)
int id;
short w, h;
{
	width=w;
	height=h;

	SetPosition(1, 0, 0);
	SetColor(1, VT_White);
	PaintRectangleInterior(1, 5000, 5000);
}
