#ifndef	_VT
#define	_VT

#include	<machine/defs.h>
#include	<vt/vt_hdrs.h>
#include	<vt/vt_param.h>
#include	<vt/vt_output.h>
#include	<vt/vt_key.h>

struct vtseq {
    int			type;
    union {
	unsigned char	ascii;
	struct {
	    unsigned char	mode;
	    unsigned char	keycode;
	}		hardkey;
	struct {
	    unsigned char	buttons;
	    unsigned char	window;
	    unsigned char	pane;
	    short		x, y;
	}		mouse;
    }	u;
};

struct tone {		/* tone structure */
	unsigned	freq	: 7;	/* tone frequency */
	unsigned	last	: 1;	/* last tone flag */
	unsigned	dur	: 6;	/* tone duration */
	unsigned	vol	: 2;	/* tone volume */
};

extern int	ActivateWindow();
extern int	BlockRefreshAdjust();
extern int	ChangeWindowDepth();
extern int	ChangeWindowPosition();
extern int	ChangeWindowSize();
extern int	CharacterBaseline();
extern int	CharacterHeight();
extern int	CharacterWidth();
extern int	DefineGlobalCursor();
extern int	DefineIcon();
extern int	DefineLocalCursor();
extern int	DeleteIcon();
extern int	DisplayBitmap();
extern int	DisplayGlobalRubberBox();
extern int	DisplayInvertIcon();
extern int	DisplayPopUp();
extern int	DisplayPopUpList();
extern int	DisplayPopUpVector();
extern int	DisplayStatus();
extern VT_FONTID	GetFontId();
extern int	GetGlobalLUT();
extern int	GetGraphicsConfig();
extern int	GetLocalLUT();
extern int	GetPermanentClipping();
extern int	GetProcessGroup();
extern int	GetRefreshClipping();
extern int	GetTemporaryClipping();
extern int	GetTopWindow();
extern int	GetWindowDepth();
extern int	GetWindowPosition();
extern int	GetWindowSize();
extern int	GetWindowState();
extern int	PaintIcon();
extern int	RemoveGlobalRubberBox();
extern int	RemoveStatus();
extern int	RestrictPermanentClipping();
extern int	RestrictTemporaryClipping();
extern int	(* SetAdjust())();
extern int	SetGlobalLUT();
extern int	SetLineDisc();
extern int	SetLocalLUT();
extern int	SetMouseMode();
extern int	SetPaneColors();
extern int	SetPermanentClipping();
extern int	(* SetRefresh())();
extern int	SetTemporaryClipping();
extern int	SetWindowTitle();
extern int	TrackFixedBox();
extern int	TrackRubberBox();
extern int	getvtchar();
extern int	getvtseq();

#define	VT_EOF		-1
#define	VT_ASCII	0


#endif
