(*$w-*)
function  ActivateWindow(
		fd:integer;		(* window file descriptor	*)
		window:short		(* window number		*)
	  ):integer;external;

function  BlockRefreshAdjust(
		block:integer		(* 0 = unblock, otherwise block	*)
	  ):integer;external;

procedure BumpPosition(
		fd:integer;		(* window file descriptor	*)
		dx ,			(* change in x coordinate	*)
		dy:short		(* change in y coordinate	*)
	  );external;

procedure BumpXPosition(
		fd:integer;		(* window file descriptor	*)
		dx:short		(* change in x coordinate	*)
	  );external;

procedure BumpYPosition(
		fd:integer;		(* window file descriptor	*)
		dy:short		(* change in y coordinate	*)
	  );external;

procedure ChangeWindowDepth(
		fd:integer;		(* window file descriptor	*)
		window,			(* window number		*)
		depth:short		(* new window depth		*)
	  );external;

procedure ChangeWindowPosition(
		fd:integer;		(* window file descriptor	*)
		window,			(* window number		*)
		x,y:short		(* new upper left coordinates	*)
	  );external;

procedure ChangeWindowSize(
		fd:integer;		(* window file descriptor	*)
		window,			(* window number		*)
		w,h:short		(* new width and height		*)
	  );external;

function  CharacterBaseline(
		font:short		(* font index			*)
	  ):short;external;

function  CharacterHeight(
		font:short		(* font index			*)
	  ):short;external;

function CharacterWidth(
		font:short;		(* font index			*)
		c:char		        (* character to be painted	*)
	  ):integer;external;

procedure CopyRegion(
		fd:integer;		(* window file descriptor	*)
		sx,sy, 			(* upper left coordinate of src	*)
		dx,dy, 			(* lower right coord of src	*)
		w,h:short		(* width and height of region	*)
	  );external;

procedure DefineGlobalCursor(
		fd:integer;		(* window file descriptor	*)
		var mask,		(* cursor mask			*)
		face:integer;		(* cursor face			*)
		x,y,			(* reference point		*)
		blink:short		(* blink rate			*)
	  );external;

function  DefineIcon(
		fd:integer;		(* window file descriptor	*)
		index,			(* index of icon to be defined	*)
		w,h:short;		(* size of icon in pixels	*)
		var face,mask:short	(* face and mask of icon	*)
	  ):integer;external;

procedure DefineLocalCursor(
		fd:integer;		(* window file descriptor	*)
		var mask,		(* cursor mask			*)
		face:integer;		(* cursor face			*)
		x,y,			(* reference point		*)
		blink:short		(* blink rate			*)
	  );external;

procedure DeleteIcon(
		fd:integer; 		(* window file descriptor	*)
		id:short		(* id of icon to be deleted	*)
	  );external;

function  DisplayBitmap(
		fd,			(* window file descriptor	*)
		mode:integer;		(* toggle, copy or paint	*)
		var rast:RASTER;	(* source raster		*)
		sx,sy,			(* upper left coord of source	*)
		dx,dy,			(* upper left coord of dest	*)
		w,h,			(* width and height of region	*)
		color:short		(* color of pixels in raster	*)
	  ):integer;external;

procedure DisplayGlobalRubberBox(
		fd:integer; 		(* window file descriptor	*)
		x,y,			(* upper left coordinate	*)
		w,h, 			(* width and height of box	*)
		thickness:short		(* box border thickness		*)
	  );external;

procedure DisplayInvertIcon(
		fd:integer; 		(* window file descriptor	*)
		id:short		(* id of icon to be inverted	*)
	  );external;

function  DisplayPopUp(
		fd:integer;		(* window file descriptor	*)
		var string:char		(* menu to be displayed		*)
	  ):integer;external;

procedure DisplayStatus(
		fd:integer;		(* window file descriptor	*)
		var string:char		(* null terminated string	*)
	  );external;

procedure Flush(
		fd:integer		(* window file descriptor	*)
	  );external;

function  GetFontId(
		var string:char		(* name of font file		*)
	  ):short;external;

function  GetGlobalLUT(
		fd:integer;		(* window file descriptor	*)
		color:integer;		(* color index in global lut	*)
		var red: integer;	(* returns red intensity	*)
		var green: integer;	(* returns green intensity	*)
		var blue: integer	(* returns blue intensity	*)
	  ):integer;external;

function  GetGraphicsConfig(
		fd:integer;		(* window file descriptor	*)
		var gwin:gconfig	(* graphics configuration	*)
	  ):integer;external;

procedure GetKeyboardParameters(
		fd:integer;		(* window file descriptor	*)
		var keyparms:kconfig	(* new keyboard parameters	*)
	  );external;

function  GetLocalLUT(
		fd:integer;		(* window file descriptor	*)
		color:integer;		(* color index in local lut	*)
		var red: integer;	(* returns red intensity	*)
		var green: integer;	(* returns green intensity	*)
		var blue: integer;	(* returns blue intensity	*)
		var ctype: integer	(* color type...free/share/own	*)
	  ):integer;external;

procedure GetMouseParameters(
		fd:integer;		(* window file descriptor	*)
		var mouseparams:mconfig (* new mouse parameters		*)
	  );external;

procedure GetPermanentClipping(
		fd:integer;		(* window file descriptor	*)
		var x,y,		(* returns upper left coord	*)
		w,h:short		(* returns width and height	*)
	  );external;

function  GetProcessGroup(
		fd:integer;		(* window file descriptor	*)
		var pgrp:integer	(* returned process group	*)
	  ):integer;external;

procedure GetTemporaryClipping(
		fd:integer;		(* window file descriptor	*)
		var x,y,		(* returns upper left coord	*)
		w,h:short		(* returns width and height	*)
	  );external;

function  GetTopWindow(
		fd:integer		(* window file descriptor	*)
	  ):integer;external;

function  getvtchar(
		fd:integer		(* window file descriptor	*)
	  ):integer;external;

function  getvtseq(
		fd:integer;		(* window file descriptor	*)
		var seq: vtseq		(* vt input sequence		*)
	  ):integer;external;

procedure GetVideoParameters(
		fd:integer;		(* window file descriptor	*)
		var videoparams:vconfig	(* new video parameters		*)
	  );external;

function  GetWindowDepth(
		fd:integer;		(* window file descriptor	*)
		window:short;		(* window number		*)
		var depth:short		(* returns depth		*)
	  ):integer;external;

function  GetWindowPosition(
		fd:integer;		(* window file descriptor	*)
		window:short;		(* window number		*)
		var x,y:short		(* returns current position	*)
	  ):integer;external;

function  GetWindowSize(
		fd:integer;		(* window file descriptor	*)
		window:short;		(* window number		*)
		var w,h:short		(* returns width and height	*)
	  ):integer;external;

function  GetWindowState(
		fd:integer;		(* window file descriptor	*)
		var cstate:wstate	(* window state structure	*)
	  ):integer;external;

procedure HideLocalCursor(
		fd:integer		(* window file descriptor	*)
	  );external;

procedure InvertRegion(
		fd:integer; 		(* window file descriptor	*)
		x,y, 			(* upper left coord of region	*)
		w,h:short		(* width and height of region	*)
	  );external;

function  LabelSoftKey(
		fd:integer; 		(* window file descriptor	*)
		var sfk:defsfk		(* soft function key data	*)
	  ):integer;external;

procedure MoveLocalCursor(
		fd:integer; 		(* window file descriptor	*)
		x,y:short		(* coordinate to move to	*)
	  );external;

procedure PaintArcBorder(
		fd:integer; 		(* window file descriptor	*)
		r, 			(* radius			*)
		xs,ys, 			(* coordinate of source		*)
		xe,ye:short		(* coordinate of dest		*)
	  );external;

procedure PaintArcInterior(
		fd:integer; 		(* window file descriptor	*)
		r, 			(* radius			*)
		xs,ys, 			(* coordinate of source		*)
		xe,ye:short		(* coordinate of dest		*)
	  );external;

procedure PaintCharacter(
		fd:integer;		(* window file descriptor	*)
		c:char		        (* character to be painted	*)
	  );external;

procedure PaintCircleBorder(
		fd:integer; 		(* window file descriptor	*)
		r:short			(* radius of circle		*)
	  );external;

procedure PaintCircleInterior(
		fd:integer; 		(* window file descriptor	*)
		r:short			(* radius of circle		*)
	  );external;

procedure PaintIcon(
		fd:integer;		(* window file descriptor	*)
		w,h,			(* icon width and height	*)
		index,			(* icon index			*)
		fcolor,bcolor:short;	(* foreground/background color	*)
		var name:char		(* icon label			*)
	  );external;

procedure PaintLine(
		fd:integer; 		(* window file descriptor	*)
		x, y:short		(* line endpoint		*)
	  );external;

procedure PaintRectangleBorder(
		fd:integer; 		(* window file descriptor	*)
		w,			(* width or lower right x coord	*)
		h:short			(* height or lower right y coord*)
	  );external;

procedure PaintRectangleInterior(
		fd:integer; 		(* window file descriptor	*)
		w,			(* width or lower right x coord	*)
		h:short			(* height or lower right y coord*)
	  );external;

procedure PaintPolygonInterior(
		fd,			(* window file descriptor	*)
		nsets:integer; 		(* number of vertices		*)
		var x,			(* x coords of vertices		*)
		y:short			(* y coords of vertices		*)
	  );external;

procedure PaintString(
		fd:integer;		(* window file descriptor	*)
		size:short;		(* length of string		*)
		var string:char		(* string to be painted		*)
	  );external;

procedure RemoveGlobalRubberBox(
		fd:integer		(* window file descriptor	*)
	  );external;

procedure RemoveStatus(
		fd:integer		(* window file descriptor	*)
	  );external;

procedure RestrictPermanentClipping(
		fd:integer; 		(* window file descriptor	*)
		x,y, 			(* upper left coordinate	*)
		w,h:short		(* width and height of region	*)
	  );external;

procedure RestrictTemporaryClipping(
		fd:integer; 		(* window file descriptor	*)
		x,y, 			(* upper left coordinate	*)
		w,h:short		(* width and height of region	*)
	  );external;

procedure SendTones(
		fd:integer; 		(* window file descriptor	*)
		tones:char		(* tones to play on speaker	*)
	  );external;

procedure SetAddressing(
		fd:integer; 		(* window file descriptor	*)
		mode:short		(* new addressing mode		*)
	  );external;

procedure SetAdjust(
		fd:integer; 		(* window file descriptor	*)
		id:integer 		(* id passed to routine		*)
	  );external;

procedure SetBColor(
		fd:integer; 		(* window file descriptor	*)
		bcolor:short		(* new clearback color		*)
	  );external;

procedure SetBPattern(
		fd:integer; 		(* window file descriptor	*)
		bpattern:short		(* new clearback pattern	*)
	  );external;

procedure SetBuf(
		fd,			(* window file descriptor	*)
		size:integer		(* new buffer size		*)
	  );external;

procedure SetCharAttributes(
		fd:integer; 		(* window file descriptor	*)
		attributes:short	(* new char attributes		*)
	  );external;

procedure SetColor(
		fd:integer; 		(* window file descriptor	*)
		color:short		(* new foreground color		*)
	  );external;

procedure SetDirection(
		fd:integer;		(* window file descriptor	*)
		direction: short	(* character increment direction*)
	  );external;

procedure SetFont(
		fd:integer; 		(* window file descriptor	*)
		font:short		(* fontid of new font		*)
	  );external;

function  SetGlobalLUT(
		fd:integer;		(* window file descriptor	*)
		color:integer;		(* color index in global lut	*)
		red: integer;		(* red intensity		*)
		green: integer;		(* green intensity		*)
		blue: integer		(* blue intensity		*)
	  ):integer;external;

procedure SetJustification(
		fd:integer;		(* window file descriptor	*)
		justification:short	(* new justification		*)
	  );external;

procedure SetKeyboardParameters(
		fd:integer;		(* window file descriptor	*)
		keyparms:kconfig	(* new keyboard parameters	*)
	  );external;

function  SetLineDisc(
		fd:integer;		(* window file descriptor	*)
		ldisc:short		(* new line discipline		*)
	  ):integer;external;

function  SetLocalLUT(
		fd:integer;		(* window file descriptor	*)
		color:integer;		(* color index in local lut	*)
		red: integer;		(* red intensity		*)
		green: integer;		(* green intensity		*)
		blue: integer;		(* blue intensity		*)
		ctype: integer		(* color type... free/share/own	*)
	  ):integer;external;

procedure SetMouseMode(
		fd:integer; 		(* window file descriptor	*)
		mode:MOUSESTATE		(* new mouse mode		*)
	  );external;

procedure SetMouseParameters(
		fd:integer;		(* window file descriptor	*)
		mouseparams:mconfig	(* new mouse parameters		*)
	  );external;

procedure SetOrientation(
		fd:integer; 		(* window file descriptor	*)
		orientation:short	(* new orientation		*)
	  );external;

procedure SetPaneColors(
		fd:integer; 		(* window file descriptor	*)
		window,			(* window number		*)
		pane, 			(* pane id			*)
		fcolor, 		(* foreground color		*)
		bcolor:short		(* background color		*)
	  );external;

procedure SetPattern(
		fd:integer; 		(* window file descriptor	*)
		pattern:short		(* new foreground pattern	*)
	  );external;

procedure SetPermanentClipping(
		fd:integer;		(* window file descriptor	*)
		x,y, 			(* upper left coordinate	*)
		w,h:short		(* width and height or region	*)
	  );external;

procedure SetPhase(
		fd:integer; 		(* window file descriptor	*)
		xphase,			(* new x coord of phase		*)
		yphase:short		(* new x coord of phase		*)
	  );external;

procedure SetPosition(
		fd:integer;		(* window file descriptor	*)
		x,			(* new x coordinate		*)
		y:short			(* new y coordinate		*)
	  );external;

procedure SetRefresh(
		fd:integer; 		(* window file descriptor	*)
		id:integer 		(* id passed to routine		*)
	  );external;

procedure SetStyle(
		fd:integer; 		(* window file descriptor	*)
		mask,			(* new line style mask		*)
		count:short		(* new line style count		*)
	  );external;

procedure SetTemporaryClipping(
		fd:integer; 		(* window file descriptor	*)
		x, y,			(* upper left coordinate	*)
		w, h:short		(* width and height of region	*)
	  );external;

procedure SetThickness(
		fd:integer; 		(* window file descriptor	*)
		thickness:short		(* new line and border thickness*)
	  );external;

procedure SetVideoParameters(
		fd:integer;		(* window file descriptor	*)
		videoparams:vconfig	(* new video parameters		*)
	  );external;

procedure SetWindowState(
		fd:integer;		(* window file descriptor	*)
		var cstate:wstate	(* window state structure	*)
	  );external;

function  SetWindowTitle(
		fd:integer;		(* window file descriptor	*)
		var string:char		(* new window title		*)
	  ):integer;external;

procedure SetXPosition(
		fd:integer;		(* window file descriptor	*)
		x:short			(* new x coordinate		*)
	  );external;

procedure SetYPosition(
		fd:integer;		(* window file descriptor	*)
		y:short			(* new y coordinate		*)
	  );external;

procedure ShowLocalCursor(
		fd:integer		(* window file descriptor	*)
	  );external;

function  TrackFixedBox(
		fd:integer;		(* window file descriptor	*)
		var x,y:short;		(* coordinates of initial box	*)
		w,h,			(* width and height of box	*)
		bx,by,bw,bh,		(* bounding region		*)
		thickness:short		(* box border thickness		*)
	  ):integer;external;

function  TrackRubberBox(
		fd:integer; 		(* window file descriptor	*)
		x,y:short; 		(* anchoring coordinates	*)
		var w,h:short;		(* returns width and height     *)
		bx,by,bw,bh,		(* bounding region		*)
		thickness:short		(* box border thickness		*)
	  ):integer;external;
(*$w+*)
