/*#define SDDEBUG /**/
/* sdminphys is temporary */
/*	sd.c	6.1	83/07/29	*/

#include "sd.h"

#if NSD > 0 || Nsd > 0
/*
 * Integrated Solutions VME-SCSI disk (SD controler, sd disk) driver
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dk.h"
#include "../h/dkbad.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/map.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#include "../is68kdev/qbvar.h"
#include "../is68kdev/sdreg.h"

#define Nsd_SD		4	/* max number of sd drives on SD controler */
#define SD_MAXCNT	0x1FFFE
#define	SD_TIMEOUT	hz*5

struct	size {
	daddr_t	nblocks;
	int	cyloff;
};

/* 
 * State of controller from last transfer. Since only one transfer can be done 
 * at a time per controller, only allocate one for each controller.
 */
struct	SD_stat {
	short		sd_ndrive;	/* Number of drives on controller */
	short		sd_wticks;	/* Monitor time for function */
	u_short		sd_cmd;		/* command to issue */
	u_int		sd_bn;		/* block number */
	u_int		sd_addr;	/* physical address of transfer */
	int		sd_bleft;	/* bytes left to transfer */
	int		sd_bpart;	/* bytes transferred */
} 			SD_stat[NSD];

int	sdprobe(),	sdslave(),	sdattach(),	sdintr();
int	sdstrat(),	sdminphys();
struct	qb_ctlr		*sdcinfo[NSD];
struct	qb_device	*sddinfo[Nsd];

/* 
 * SD controler addresses 
 */
u_short *SDstd[] = { (u_short *)0x7fffe0, (u_short *)0x7ffff0, 0 };

/*
 * SD/sd controler/device driver structure
 */
struct	qb_driver SDdriver =
	{ sdprobe, sdslave, sdattach, SDstd, "sd", sddinfo, "SD", sdcinfo };

/* 
 * sd drive structure: each drive can have a different geometry.
 */
struct sdst {
	ushort		st_ncpd;	/* Number of cylinders per drive */
	ushort		st_nspt;	/* Number of sectors per track */
	ushort		st_ntpc;	/* Number of tracks per cylinder */
	ushort		st_nspc;	/* Number of sectors per cylinder */
	struct size	st_size[8];
} sdst[Nsd];

struct	buf	rsdbuf[Nsd];
struct	dkbad	sdbad[Nsd];

#define	b_bn		b_resid	

int	sdwstart, sdwatch();		/* Have started guardian */

/* 
 * Check that controller exists
 */
sdprobe(sdaddr)
register struct sddevice	*sdaddr;
{
	if (sdwait(sdaddr))
		return (0);
	sdaddr->sdcs = SD_IE | SD_SIZE | SD_CBSY;
	/* return 0 if timeout, or if it is an ld controller */
	if (sdwait(sdaddr) || (sdaddr->sdcs == (SD_IE | SD_SIZE | SD_CBSY)))
		return (0);
	DELAY(8000);
	return (sizeof (struct sddevice));
}

/*
 * Check that a given drive exists
 */
sdslave(qi, sdaddr)
register struct qb_device	*qi;
register struct sddevice	*sdaddr;
{
	sdaddr->sdcs = (qi->qi_slave << 8) | SD_SIZE | SD_CBSY;
	if (sdwait(sdaddr) || (sdaddr->sdcs & SD_ERR) || (sdaddr->sdda == 0))
		return (0);
	return (1);
}

/*
 * Logicaly attach a unit to a drive/controler, and set up unit info
 */
sdattach(qi)
register struct qb_device	*qi;
{
	register struct sddevice *sdaddr;
	register struct sdst *st;

	/*
	 * Start watchdog for lost interupts from drive
	 */
	if (sdwstart == 0) {
		timeout(sdwatch, (caddr_t)0, SD_TIMEOUT);
		sdwstart++;
	}

	/*
	 * Initialize iostat values
	 */
	if (qi->qi_dk >= 0)
		dk_mspw[qi->qi_dk] = .000003906;   /* 16bit transfer time? */
	SD_stat[qi->qi_ctlr].sd_ndrive++;
	sdaddr = (struct sddevice *)qi->qi_mi->qm_addr;
	st = &sdst[qi->qi_unit];

	sdaddr->sdcs = qi->qi_slave<<8 | SD_SIZE | SD_CBSY;
	if (sdwait(sdaddr))
		printf("	TIMEOUT ");
	else {
		st->st_ntpc = sdaddr->sdda;	/* # of tracks (heads) */
		st->st_ncpd = sdaddr->sdae;	/* # of cylinders */
		st->st_nspt = sdaddr->sdwc;	/* # of sectors per track */
		printf("	(%d x %d x %d) ", st->st_nspt, st->st_ntpc, 
			st->st_ncpd);
		diskpart(st->st_size, st->st_nspt, st->st_ntpc, st->st_ncpd);
		st->st_nspc = st->st_nspt * st->st_ntpc;
	}
}

sdopen(dev)
	dev_t dev;
{
	register int unit = minor(dev) >> 3;
	register struct qb_device *qi;

	if (unit >= Nsd || (qi = sddinfo[unit]) == 0 || qi->qi_alive == 0)
		return (ENXIO);
	return (0);
}

sdstrategy(bp)
	register struct buf *bp;
{
	register struct qb_device *qi;
	register struct sdst *st;
	register int unit;
	int partition = minor(bp->b_dev) & 07, s;
	long bn, sz;

	unit = dkunit(bp);
	if (unit >= Nsd)
		goto bad;
	qi = sddinfo[unit];
	if (qi == 0 || qi->qi_alive == 0)
		goto bad;
	st = &sdst[qi->qi_unit];
	sz = (bp->b_bcount+511) >> 9;			/* number of sectors */
	if (bp->b_blkno < 0 ||
	    (bn = dkblock(bp))+sz > st->st_size[partition].nblocks)
		goto bad;
	badstrat(qi, bp, &sdbad[qi->qi_unit], sdstrat, st->st_nspt, st->st_ntpc,
		st->st_ncpd, st->st_size[partition].cyloff);
	return;
bad:
	bp->b_flags |= B_ERROR;
	iodone(bp);
	return;
}

sdstrat(qi, bp)
	register struct qb_device *qi;
	register struct buf *bp;
{
	register struct sdst *st = &sdst[qi->qi_unit];
	int partition = minor(bp->b_dev) & 07, s;
	register struct buf *dp;

	bp->b_bn = dkblock(bp) + (st->st_size[partition].cyloff * st->st_nspc);
	s = spl5();

	dp = &qi->qi_mi->qm_tab;
	disksort(dp, bp);

	if (dp->b_active == 0)
		sdstart(qi->qi_mi);
	splx(s);
}

/*
 * Start up a transfer on a drive.
 */
sdstart(qm)
	register struct qb_ctlr *qm;
{
	register struct buf *bp;
	register struct qb_device *qi;
	register struct sddevice *sdaddr;
	register struct SD_stat *stat;
	register struct sdst *st;

	if ((bp = qm->qm_tab.b_actf) == NULL)
		return;

	/*
	 * Mark controller busy, and determine destination.
	 */
	qm->qm_tab.b_active++;
	qi = sddinfo[dkunit(bp)];		/* Controller */
	stat = &SD_stat[qm->qm_ctlr];
	st = &sdst[qi->qi_unit];
	sdaddr = (struct sddevice *)qm->qm_addr;

	/* 
	 * save away current data transfer drive info
	 */
	stat->sd_bn = bp->b_bn;
	stat->sd_addr = qbaddr(bp);
	stat->sd_bleft = bp->b_bcount;
	if (bp->b_flags & B_READ)
		stat->sd_cmd = SD_IE | SD_CBSY | SD_READ | (qi->qi_slave << 8);
	else
		stat->sd_cmd = SD_IE | SD_CBSY | SD_WRITE | (qi->qi_slave << 8);
	sdio(sdaddr, stat);
	if (qi->qi_dk >= 0) {
		dk_busy |= 1 << qi->qi_dk;
		dk_xfer[qi->qi_dk]++;
		dk_wds[qi->qi_dk] += bp->b_bcount >> 6;
	}
}

sdio(sdaddr, stat)
register struct sddevice *sdaddr;
register struct SD_stat	*stat;
{
	stat->sd_bpart = (stat->sd_bleft>SD_MAXCNT)? SD_MAXCNT: stat->sd_bleft;
	sdaddr->sdda = stat->sd_bn;
	sdaddr->sdba = stat->sd_addr;
	sdaddr->sdae = ((stat->sd_bn>>8)&0xFF00) | ((stat->sd_addr>>16)&0xFF);
	sdaddr->sdwc = stat->sd_bpart >> 1;
#ifdef	SDDEBUG
	printf("{cs %x, da %x, ba %x, ae %x, wc %x",
		stat->sd_cmd, sdaddr->sdda, sdaddr->sdba, 
		sdaddr->sdae, sdaddr->sdwc);
#endif	SDDEBUG
	sdaddr->sdcs = stat->sd_cmd;
}

/*
 * Handle a disk interrupt.
 */
sdintr(ctlr)
	register ctlr;
{
	register struct buf *bp;
	register struct qb_ctlr *qm = sdcinfo[ctlr];
	register struct qb_device *qi;
	register struct sddevice *sdaddr = (struct sddevice *)qm->qm_addr;
	register unit;
	struct SD_stat *stat = &SD_stat[ctlr];
	register struct sdst *st;
	register u_short cs;

#ifdef	SDDEBUG
	printf("}\n");
#endif	SDDEBUG
	stat->sd_wticks = 0;
	bp = qm->qm_tab.b_actf;
	qi = sddinfo[dkunit(bp)];
	st = &sdst[qi->qi_unit];
	dk_busy &= ~(1 << qi->qi_dk);
	/*
	 * Check for and process errors on either the drive or the controller.
	 */
	if ((cs = sdaddr->sdcs) & SD_ERR) {
/*printf("ERROR cs=%b\n", sdaddr->sdcs, SDCS_BITS); /**/
		/*
		 * After 10 retries give up.
		 */
		if (++qm->qm_tab.b_errcnt > 10) {
			harderr(bp, "sd");
			printf("cs=%b sw=%x %x %x\n", cs, SDCS_BITS,
			    sdaddr->sdsw[0],sdaddr->sdsw[1],sdaddr->sdsw[2]);
			bp->b_flags |= B_ERROR;
		} else {
			sdrezero(sdaddr, qi->qi_slave);	/* rezero unit and */
			qm->qm_tab.b_active = 0;	/* force retry */
		}
	}
	/*
	 * If still ``active'', then don't need any more retries.
	 */
	if (qm->qm_tab.b_active) {
		/* 
		 * check if more data from previous request
		 */
		if ((bp->b_flags & B_ERROR) == 0 &&
		     (stat->sd_bleft -= stat->sd_bpart) > 0) {
			stat->sd_addr += stat->sd_bpart;
			stat->sd_bn += (stat->sd_bpart/512);
			sdio(sdaddr, stat);
			return;
		}
		dk_busy &= ~(1 << qi->qi_dk);
		qm->qm_tab.b_active = qm->qm_tab.b_errcnt = 0;
		bp->b_resid = stat->sd_bleft;
		qm->qm_tab.b_actf = bp->av_forw;
		iodone(bp);
	}
	/*
	 * If controller not transferring and have request, start controller.
	 */
	if (qm->qm_tab.b_actf && qm->qm_tab.b_active == 0)
		sdstart(qm);
}

sdread(dev, uio)
dev_t	dev;
struct uio *uio;
{
	register int unit = minor(dev) >> 3;

	if (unit >= Nsd)
		return (ENXIO);
	return (physio(sdstrategy, &rsdbuf[unit], dev, B_READ, sdminphys, uio));
}

sdwrite(dev, uio)
dev_t dev;
struct uio *uio;
{
	register int unit = minor(dev) >> 3;

	if (unit >= Nsd)
		return (ENXIO);
	return (physio(sdstrategy, &rsdbuf[unit], dev, B_WRITE, sdminphys, uio));
}

/*
 * Reset driver after lost interupt. Cancsd software state of all pending 
 * transfers and restart all units and the controller.
 */
sdreset(ctlr)
{
	register struct qb_ctlr *qm;
	register struct qb_device *qi;
	register struct sddevice *sdaddr;
	register struct SD_stat *stat;
	register int unit;

	printf(" SD%d", ctlr);
	sdaddr = (struct sddevice *)qm->qm_addr;
	stat = &SD_stat[ctlr];
	qm->qm_tab.b_active = 0;
	stat->sd_bleft = 0;
	stat->sd_bpart = 0;
	sdwait(sdaddr);
	sdstart(qm);
}

/*
 * Wake up every second and if an interrupt is pending but nothing has happened
 * increment a counter. If nothing happens for 20 seconds, reset the controler
 * and begin anew.
 */
sdwatch()
{
	register struct qb_ctlr *qm;
	register ctlr, unit;
	register struct SD_stat *stat;

	timeout(sdwatch, (caddr_t)0, SD_TIMEOUT);
	for (ctlr = 0; ctlr < NSD; ctlr++) {
		qm = sdcinfo[ctlr];
		if (qm == 0 || qm->qm_alive == 0 || qm->qm_tab.b_active == 0)
			continue;
		stat = &SD_stat[ctlr];
		stat->sd_wticks++;
		if (stat->sd_wticks >= 20) {
			stat->sd_wticks = 0;
			printf("SD%d: lost interrupt\n", ctlr);
			sdreset(ctlr);
		}
	}
}

sdrezero(sdaddr, drive)
register struct sddevice *sdaddr;
{
	sdaddr->sdda = 0;	/* no rezero command, read block 0 instead */
	sdaddr->sdba = 0x400;
	sdaddr->sdae = 0;
	sdaddr->sdwc = 1;
	sdaddr->sdcs = SD_CBSY | SD_READ | (drive << 8);
	sdwait(sdaddr);
}

sddump(sdaddr)
{
}

sdsize(dev)
	dev_t dev;
{
	register int unit = minor(dev) >> 3;
	register struct qb_device *qi;
	register struct sdst *st;

	if (unit >= Nsd || (qi = sddinfo[unit]) == 0 || qi->qi_alive == 0)
		return (-1);
	st = &sdst[qi->qi_unit];
	return (st->st_size[minor(dev)&0x7].nblocks);
}

static 
sdwait(sdaddr)
struct sddevice *sdaddr;
{ 	
	long l = 0;

	while (sdaddr->sdcs == 0xffff)
		if (++l == 80000)
			return (-1);
	return (0);
}

sdminphys(bp)
	struct buf *bp;
{
	bp->b_bcount = min(bp->b_bcount, SD_MAXCNT);
}
#endif
