/*
 * jtagdefs.h
 */

typedef enum{
			  INSTRUCTION_REGISTER,
			  DATA_REGISTER, 
			  MAX_SHIFT_REGISTER
								} SHIFT_REGISTER_TYPE;
typedef enum{
			  TEST_LOGIC_RESET = 0,
			  RUN_TEST_IDLE,
			  PAUSE_DR,
			  PAUSE_IR,
			  SHIFT_DR,
			  SHIFT_IR,
			  MAX_JTAG_STATE,
			  UNDEFINED_JTAG_STATE
								} JTAG_STATE_TYPE;

typedef enum {
				PIN_0PIN,
				PIN_1PIN,
				PIN_2PIN,
				PIN_3PIN,
				RESET_PIN,
				MAX_OUTPUT_PIN
			 					} OUTPUT_PIN_TYPE;

typedef int bool;				
typedef unsigned char SCAN_DATA_TYPE;

/*
 * Global jtag error codes
 */
#define CSR_TIMEOUT		1
#define CARD_NOT_FOUND	2

/*
 * function prototypes
 *
 */
 
void Jtag_InitializeController(unsigned short port, 
							   unsigned long speed);

void Jtag_ResetTap(bool assert_trst, 
				   JTAG_STATE_TYPE state_e);

bool Jtag_InError(void);

void Jtag_ScanOut(SHIFT_REGISTER_TYPE jtag_register_e,
			 	  int length,
				  SCAN_DATA_TYPE out_data[],
				  JTAG_STATE_TYPE state_e
				 );

void Jtag_ScanIn(SHIFT_REGISTER_TYPE jtag_register_e,
				 int length,
				 unsigned char in_data[],
				 JTAG_STATE_TYPE state_e);

void Jtag_ScanIO(SHIFT_REGISTER_TYPE jtag_register_e,
				 int length,
				 SCAN_DATA_TYPE out_data[],
				 SCAN_DATA_TYPE in_data[],
				 JTAG_STATE_TYPE state_e
				 );

void Jtag_WritePin(bool assert,
		 		   OUTPUT_PIN_TYPE pin_e
				 );

void Jtag_SetSpeed( unsigned long speed );

void Jtag_SetTRST(bool assert);

void Jtag_WriteOutputs(unsigned char value);

void Jtag_EnterLoopBackMode(void);

void Jtag_ExitLoopBackMode(void);


/*
 * Address map for PCI JTAG card
 *
 * Offset		Write											Read
 * ------       -----                      						----
 * 0x00			Command Register								Status Register
 * 0x02			General Purpose Output Register					--
 * 0x04			Load Holding Register from D0-7 Unswapped		Read Input Shift Register - Unswapped
 * 0x06			Load TMS Register								--
 * 0x08			--												--
 * 0x0a			--												--
 * 0x0c			Load Holding Register from D8-15 - Unswapped	Read Input Shift Register - Unswapped
 * 0x0e			--												--
 * 0x10			--												--
 * 0x12			--												--
 * 0x14			Load Holding Register from D0-7 - Swapped		Read Input Shift Register - Unswapped
 * 0x16			--												--
 * 0x18			--												--
 * 0x1a			--												--
 * 0x1c			Load Holding Register from D8-15 - Swapped		Read Input Shift Register - Unswapped
 * 0x1e			--												--
 *
 *
 * -------------------------------
 * Command Register
 * -------------------------------
 *
 *  +------------------------------- SRST 		0 = hold chip in reset	1 = normal operation
 *  |
 *  |  +---------------------------- LPPBACK 	0 = normal operation	1 = loopback mode
 *  |  |
 *  |  |  +--+--+------------------- NSCNT[2:0	Bits to write, 1 to write, 7=8bits
 *  |  |  |  |  |
 *  |  |  |  |  |  +--+--+---------- CLKSEL[2:0] JTAG Clock Speed, 0 = fastest
 *  |  |  |  |  |  |  |  |
 *
 *  7  6  5  4  3  2  1  0
 *
 * -------------------------------
 * Status Register
 * -------------------------------
 *
 *  +------------------------------- LAST_DATA	Last bit returned from target, captured during TMS
 *  |
 *  |  +---------------------------- 			Always 0
 *  |  |
 *  |  |  +------------------------- CLKEN		0 = DATA IN Buffer Full, 1 = DATA IN Buffer invalid (empty)
 *  |  |  |
 *  |  |  |  +---------------------- HR_FULL	0 = DATA OUT buffer empty, 1 = DATA OUT Buffer full
 *  |  |  |  |
 *  |  |  |  |  +------------------- IN3		General Purpose Input 3
 *  |  |  |  |  |
 *  |  |  |  |  |  +---------------- IN2		General Purpose Input 2
 *  |  |  |  |  |  |
 *  |  |  |  |  |  |  +------------- IN1        General Purpose Input 1
 *  |  |  |  |  |  |  |
 *  |  |  |  |  |  |  |  +---------- IN0		General Purpose Input 0
 *  |  |  |  |  |  |  |  |
 *
 *  7  6  5  4  3  2  1  0
 *
 * -------------------------------
 * General Purpose Output Register
 * -------------------------------
 *
 *  +------------------------------- TRST		TRST Control, 0 = Inactive 1 = Active
 *  |
 *  |  +---------------------------- nc
 *  |  |
 *  |  |  +------------------------- nc
 *  |  |  |
 *  |  |  |  +---------------------- nc
 *  |  |  |  |
 *  |  |  |  |  +------------------- GPO3		General Purpose Output 3
 *  |  |  |  |  |
 *  |  |  |  |  |  +---------------- GPO2		General Purpose Output 2
 *  |  |  |  |  |  |
 *  |  |  |  |  |  |  +------------- GPO1		General Purpose Output 1
 *  |  |  |  |  |  |  |
 *  |  |  |  |  |  |  |  +---------- GPO0		General Purpose Output 0
 *  |  |  |  |  |  |  |  |
 *
 *  7  6  5  4  3  2  1  0
 *
 */
 
/* command register bit definitions */

#define	NSCNT_MASK			0x38
#define	NSCNT_SHIFT			0x3
#define NORMAL_MODE			0x00
#define	LOOPBACK_MODE		0x40
#define	CHIP_IN_RESET		0x00
#define	CHIP_NOT_IN_RESET	0x80

/* status register bit definitions */
#define GP_IN0				0x01
#define GP_IN1				0x02
#define	GP_IN2				0x04
#define GP_IN3				0x08
#define GP_INS_MASK			0x0f
#define DATA_OUT_FULL		0x10
#define	DATA_IN_EMPTY		0x20
#define LAST_DATA_IN_BIT	0x80

/* gp output register bit definitions */
#define GP_OUT0				0x01
#define	GP_OUT1				0x02
#define	GP_OUT2				0x04
#define GP_OUT3				0x08
#define	GP_OUTS_MASK		0x0f
#define TRST_ACTIVE 		0x80
#define	TRST_INACTIVE		0x00

/*
 * jtag I/O timeout (microseconds)
 */
#define  COMMAND_TIMEOUT     10000

typedef struct pciJtagRegs {
	unsigned char  cmdStat;			/* Command / Status Register */
	unsigned char  ___0;
	unsigned char  gpOut;			/* GP Output Register */
	unsigned char  ___1;
	unsigned char  IOLow;			/* Holding Register 0-7, input shift register */
	unsigned short TMSReg;			/* TMS Register */
	unsigned short ___2;
	unsigned short ___3;
	unsigned short ___4;
	unsigned char  IOHi;			/* Holding Register 8-15 */
} pciJtagRegs;

