/*  makemmu.c
 *  Appends ARM6x0 MMU tables to demon ROM image
 *
 *  RCS $Revision: 1.5 $
 *  Checkin $Date: 93/12/16 15:02:12 $
 *  Revising $Author: irickard $
 */

#include <stdio.h>

#define RAMSectionDesc 0xc0eL  /* R/W supervisor, R/W user, cache, wb */
#define ExpSectionDesc 0xc02L  /* R/W supervisor, R/W user            */
#define IOSectionDesc  0x402L  /* R/W supervisor,  no user            */
#define ROMSectionDesc 0x80aL  /* R/W supervisor, R   user, cache, wb */
#define InvSectionDesc 0x000L

main(argc,argv)
int argc ;
char *argv[] ;
{FILE *mmu ;
 unsigned long j ;
 short i ; /* if this is a long the compiler breaks on 4096 in the last loop ! */
 
 if ((mmu = fopen(argv[1],"r+b")) == NULL) {
    perror("fopen") ;
    exit(1) ;
    }
 if (fseek(mmu,0,2L) != 0) {
    perror("fseek1") ;
    exit(1) ;
    }
 j = ftell(mmu) ;
 j = (j & ~0x3fffL) + 0x4000L ;

 while( ftell(mmu) != j )
   fputc(0, mmu);
    
 for (i = 0 ; i < 16 ; i++) { 
    j = RAMSectionDesc | (i << 20) ;
    putword(j, mmu) ;
    }
 for (i = 16 ; i < 32 ; i++) {
    j = ExpSectionDesc | (i << 20) ;
    putword(j, mmu) ;
    }
 for (i = 32 ; i < 48 ; i++) {
    j = IOSectionDesc | (i << 20) ;
    putword(j, mmu) ;
    }
 for (i = 48 ; i < 64 ; i++) {
    j = ROMSectionDesc | (i << 20) ;
    putword(j, mmu) ;
    }
 for (i = 64 ; i < 4096 ; i++) {
    j = InvSectionDesc | (i << 20) ;
    putword(j, mmu) ;
    }
    
 for (i = 0 ; i < 1024 ; i++) { 
    j = RAMSectionDesc | (i << 20) ;
    putword(j, mmu) ;
    }
 for (i = 1024 ; i < 2048 ; i++) {
    j = ExpSectionDesc | (i << 20) ;
    putword(j, mmu) ;
    }
 for (i = 2048 ; i < 3072 ; i++) {
    j = IOSectionDesc | (i << 20) ;
    putword(j, mmu) ;
    }
 for (i = 3072 ; i < 4096 ; i++) {
    j = ROMSectionDesc | (i << 20) ;
    putword(j, mmu) ;
    }
    
 fclose(mmu) ;       
 return(0) ;   
 }

int putword(word,file)
unsigned long word ;
FILE *file ;
{
 if (fputc(word & 0xff,file) == EOF) {
    perror("PutWord1") ;
    exit(1) ;
    }
 if (fputc((word >> 8) & 0xff,file) == EOF) {
    perror("PutWord2") ;
    exit(1) ;
    }
 if (fputc((word >> 16) & 0xff,file) == EOF) {
    perror("PutWord3") ;
    exit(1) ;
    }
 if (fputc((word >> 24) & 0xff,file) == EOF) {
    perror("PutWord4") ;
    exit(1) ;
    }
 return(0) ;
}
