;/***************************************************************************\
;* level1_h.s                                                                *
;* Version 1.10                                                              *
;* Level 1 Debug Monitor Code Header                                         *
;* Copyright (C) 1991 Advanced RISC Machines Limited. All rights reserved.   *
;* Written by Dave Jaggar and Harry Meekings.                                *
;* Project started on 2nd January 1992.                                      *
;* Last change was 10th April 1992.                                          *
;\***************************************************************************/


;/***************************************************************************\
;*                             Error Codes                                   *
;\***************************************************************************/

RDIError_NoError                EQU     0

RDIError_Reset                  EQU     1
RDIError_UndefinedInstruction   EQU     2
RDIError_SoftwareInterrupt      EQU     3
RDIError_PrefetchAbort          EQU     4
RDIError_DataAbort              EQU     5
RDIError_AddressException       EQU     6
RDIError_IRQ                    EQU     7
RDIError_FIQ                    EQU     8
RDIError_Error                  EQU     9
RDIError_BranchThrough0         EQU     10

RDIError_NotInitialised         EQU     128
RDIError_UnableToInitialise     EQU     129
RDIError_WrongByteSex           EQU     130
RDIError_UnableToTerminate      EQU     131
RDIError_BadInstruction         EQU     132
RDIError_IllegalInstruction     EQU     133
RDIError_BadCPUStateSetting     EQU     134
RDIError_UnknownCoPro           EQU     135
RDIError_UnknownCoProState      EQU     136
RDIError_BadCoProState          EQU     137
RDIError_BadPointType           EQU     138
RDIError_UnimplementedType      EQU     139
RDIError_BadPointSize           EQU     140
RDIError_UnimplementedSize      EQU     141
RDIError_NoMorePoints           EQU     142
RDIError_BreakpointReached      EQU     143
RDIError_WatchpointAccessed     EQU     144
RDIError_NoSuchPoint            EQU     145
RDIError_ProgramFinishedInStep  EQU     146
RDIError_UserInterrupt          EQU     147
RDIError_NoPCValue              EQU     148

RDIError_LittleEndian           EQU     240
RDIError_BigEndian              EQU     241

RDIError_InsufficientPrivilege  EQU     253
RDIError_UnimplementedMessage   EQU     254
RDIError_UndefinedMessage       EQU     255

;/***************************************************************************\
;*                         RDP Message Numbers                               *
;\***************************************************************************/

RDP_Open                EQU     &0
RDP_Close               EQU     &1
RDP_Read                EQU     &2
RDP_Write               EQU     &3
RDP_CPURead             EQU     &4
RDP_CPUWrite            EQU     &5
RDP_CPRead              EQU     &6
RDP_CPWrite             EQU     &7
RDP_SetBreak            EQU     &a
RDP_ClearBreak          EQU     &b
RDP_SetWatch            EQU     &c
RDP_ClearWatch          EQU     &d
RDP_Execute             EQU     &10
RDP_Step                EQU     &11
RDP_Info                EQU     &12
RDP_OSOpReply           EQU     &13
RDP_LastRequest         EQU     &13

RDP_Stopped             EQU     &20
RDP_OSOp                EQU     &21
RDP_Fatal               EQU     &5e
RDP_Return              EQU     &5f

;/***************************************************************************\
;*                           Other RDI values                                *
;\***************************************************************************/

RDISex_Little           EQU     0 ; the byte sex of the debuggee
RDISex_Big              EQU     1
RDISex_DontCare         EQU     2

RDIPoint_EQ             EQU     0 ; the different types of break/watchpoints
RDIPoint_GT             EQU     1
RDIPoint_GE             EQU     2
RDIPoint_LT             EQU     3
RDIPoint_LE             EQU     4
RDIPoint_IN             EQU     5
RDIPoint_OUT            EQU     6

RDIWatch_ByteRead       EQU     1 ; types of data accesses to watch for
RDIWatch_HalfRead       EQU     2
RDIWatch_WordRead       EQU     4
RDIWatch_ByteWrite      EQU     8
RDIWatch_HalfWrite      EQU     16
RDIWatch_WordWrite      EQU     32

RDIReg_R15              EQU     (1 << 15) ; mask values for CPU
RDIReg_PC               EQU     (1 << 16)
RDIReg_CPSR             EQU     (1 << 17)
RDIReg_SPSR             EQU     (1 << 18)
RDINum_CPURegs          EQU     19

RDINum_CPRegs           EQU     10 ; current maximum

RDIMode_Curr            EQU     255

RDIInfo_Target          EQU     0
RDIInfo_Points          EQU     1
RDIInfo_Step            EQU     2
RDIInfo_MMU             EQU     3

RDISignal_Stop          EQU     &100

RDIVector_Catch         EQU     &180

RDIInfo_Cycles          EQU     &200
RDIInfo_CyclesSize      EQU     48
RDIInfo_ErrorP          EQU     &201

RDISet_Cmdline          EQU     &300

RDPOpen_Start           EQU     1
RDPOpen_ResetLine       EQU     2
RDPOpen_SexBig          EQU     4
RDPOpen_SexDontCare     EQU     8

;/***************************************************************************\
;*                               SWI numbers                                 *
;\***************************************************************************/

SWI_WriteC              EQU     &0
SWI_Write0              EQU     &2
SWI_ReadC               EQU     &4
SWI_CLI                 EQU     &5
SWI_GetEnv              EQU     &10
SWI_Exit                EQU     &11
SWI_EnterOS             EQU     &16

SWI_GetErrno            EQU     &60
SWI_Clock               EQU     &61
SWI_Time                EQU     &63
SWI_Remove              EQU     &64
SWI_Rename              EQU     &65
SWI_Open                EQU     &66
SWI_Close               EQU     &68
SWI_Write               EQU     &69
SWI_Read                EQU     &6a
SWI_Seek                EQU     &6b
SWI_Flen                EQU     &6c

SWI_IsTTY               EQU     &6e
SWI_TmpNam              EQU     &6f

SWI_InstallHandler      EQU     &70
SWI_GenerateError       EQU     &71

;/***************************************************************************\
;*                              Level 0 Routines                             *
;\***************************************************************************/

ROMResetV               EQU     4
InstallRDPV             EQU     8
ResetChannelV           EQU     12
ChannelSpeedV           EQU     16
GetByteV                EQU     20
PutByteV                EQU     24
ReadTimerV              EQU     28
SetLEDV                 EQU     32

; A macro to call a level 0 routine

                MACRO
$label          CallI   $usereg, $address
$label          MOV     $usereg, #ROMBase
                MOV     lr, pc
                LDR     pc, [$usereg, $address]
                MEND


NBreakPoints            EQU     16
NSWIArgs                EQU     4

TimeZero                EQU     Level0RAMLimit
FPRegsAddr              EQU     Level0RAMLimit + 4
FPAbortPossible         EQU     Level0RAMLimit + 8      ; a byte
SWIState                EQU     Level0RAMLimit + 9      ; a byte
DebuggeeRunning         EQU     Level0RAMLimit + &c     ; 0 => not running
DebuggeePC              EQU     Level0RAMLimit + &10
DebuggeeCPSR            EQU     Level0RAMLimit + &14
RAMBranchThrough0       EQU     Level0RAMLimit + &18    ;** 8 off an 8-bit constant
CaughtVectors           EQU     RAMBranchThrough0 + 9*4
ErrorP                  EQU     CaughtVectors + 4
ExpectedAbort           EQU     ErrorP + 4
        ASSERT  ExpectedAbort = Level0RAMLimit + &44

SWIArgDesc              EQU     Level0RAMLimit + &50    ;** 8-bit constant
Page0BreakPtCode        EQU     SWIArgDesc + NSWIArgs*8
BreakPoints             EQU     Page0BreakPtCode + 12*4 ;** 8-bit constant
BreakPointsEnd          EQU     BreakPoints + NBreakPoints*5*4  ; 0x140 bytes
        ASSERT  BreakPointsEnd = Level0RAMLimit + &1e0
WorkingDump             EQU     BreakPointsEnd
WorkingDumpEnd          EQU     WorkingDump + 16*4      ; 0x40 bytes
FPDumpEnd               EQU     WorkingDump + 8*12+4    ; 0x64 bytes
        ASSERT  FPDumpEnd = Level0RAMLimit + &244
Handlers                EQU     Level0RAMLimit + &250
HandlersEnd             EQU     Handlers + LastV * 2

BreakPointStackBase     EQU     WorkBase + &700 ; grows down for a few words
CommandLine             EQU     WorkBase + &700

SWIState_Active         EQU 1
SWIState_IgnoreGo       EQU 2

                END
