;;; Assembler source for FPA support code and emulator - PIE veneer
;;; Pre-core part.
;;; Copyright (C) Advanced RISC Machines Limited, 1992-3. All rights reserved.

;;; RCS $Revision: 1.5 $
;;; Checkin $Date: 93/11/15 19:04:04 $
;;; Revising $Author: hmeekings $

        AREA    |FP$$code|, CODE

        GET     level0_h.s

; Macros

        IMPORT  FPE_Install
        EXPORT  FP_CopyAndInstall

        IMPORT  |FPE$$code$$Base|
        IMPORT  |FPE$$code$$Limit|

FPInstalledAddress      EQU     &1400

InitUndefHandler
        MOV     r0, #-1
        MOVS    pc, lr

FP_CopyAndInstall
        STMFD   r13!, {r4 - r10}

 [ :DEF: Support_FPA
        IMPORT  FPS_Install
        IMPORT  |FPS$$code$$Base|
        IMPORT  |FPS$$code$$Limit|

; Here we determine whether FP hardware is present, in order to determine the
; right one of FP emulator and FP support code. Code to do this exists in the
; FP emulator/support code, but unfortunately the size of the combined emulator
; plus support code is too great for it to fit into the space allotted in the
; PIE memory map.

; Disable interrupts to avoid confusion
  [ {CONFIG} = 26
        MOV     r3,pc
        ORR     r0,r3,#&08000000
        TEQP    pc,r0
  |
        MRS     r3,CPSR_all
        ORR     r0,r3,#&80
        MSR     CPSR_all,r0
  ]

        MOV     r2,#SoftVectors
        LDR     r4,[r2,#4]
        ADR     r1,InitUndefHandler
        STR     r1,[r2,#4]

; Now we're ready to test for the presence of the hardware.

        MOV     r0,#0
        RFC     r1

; If hardware *is* present, we will assume (a) that reading the control
; register has enabled it, so that we can read the status register; (b) that
; writing the value we read back to the control register will disable the
; chip again.

        TEQ     r0,#0
        LDRNE   r0, =|FPE$$code$$Base|
        LDRNE   r1, =|FPE$$code$$Limit|
        LDRNE   r12, =FPE_Install
        BNE     InitDone

  [ :LNOT: :DEF: NoPowerDrainFix
        MVFS    f0,#1
        MUFS    f0,f0,f0
  ]

; Now return the hardware to its disabled state.

        WFC     r1

        LDR     r0, =|FPS$$code$$Base|
        LDR     r1, =|FPS$$code$$Limit|
        LDR     r12, =FPS_Install

InitDone
        STR     r4,[r2,#4]
; reenable interrupts
  [ {CONFIG} = 26
        TEQP    pc,r3
  |
        MSR     CPSR_all,r3
  ]

 |  ; :LNOT: :DEF: Support_FPA

        LDR     r0, =|FPE$$code$$Base|
        LDR     r1, =|FPE$$code$$Limit|
        LDR     r12, =FPE_Install
 ]

        MOV     r2, #FPInstalledAddress
01      LDMIA   r0!, {r3 - r10}
        STMIA   r2!, {r3 - r10}
        CMP     r0, r1
        BLO     %B01
        ; if we're big-endian, error strings at the end of the FPE
        ; image need to be reversed
        MOV     r3, #1
        STR     r3, [r2, #4]
        LDRB    r4, [r2, #4]
        TEQ     r3, r4
        SUB     r2, r2, r0      ; amount to relocate ROM addresses by
        BEQ     EndReverse2
        ADD     r1, r1, r2      ; end of FPE image in RAM

NextWord1
        LDR     r0, [r1, #-4]!
        CMP     r0, #-1
        BEQ     EndReverse1
        AND     r3, r0, #&ff000000
        CMP     r3, #&80000000
        BEQ     NextWord1       ; an error number, not part of a string

        ; reverse bytes in word
        EOR     r3, r0, r0, ROR #16
        BIC     r3, r3, #&ff0000
        MOV     r0, r0, ROR #8
        EOR     r0, r0, r3, LSR #8
        STR     r0, [r1]
        B       NextWord1

EndReverse1
        ; Before the error strings, and the -1 terminating word, there is a
        ; word containing the address of the FPE/S workspace (for the
        ; benefit of armulator), then a word describing the version of FPE/S
        ; interface with armulator / demon (0 => fpe300).
        ; >= 2 => before that there may be a set of pairs of words (start, end)
        ; describing tables of bytes which require to be reversed. The pairs
        ; are terminated by a single word with value -1.
        LDR     r5, [r1, #-8]!
        CMP     r5, #1
        BLE     EndReverse2

NextTable
        LDR     r5, [r1, #-4]!
        CMP     r5, #-1
        BEQ     EndReverse2
        LDR     r4, [r1, #-4]!
        ADD     r5, r5, r2      ; end and start of table in RAM
        ADD     r4, r4, r2
NextWord2
        LDR     r0, [r5, #-4]!
        EOR     r3, r0, r0, ROR #16
        BIC     r3, r3, #&ff0000
        MOV     r0, r0, ROR #8
        EOR     r0, r0, r3, LSR #8
        STR     r0, [r5]
        CMP     r5, r4
        BGT     NextWord2
        B       NextTable

EndReverse2
        LDMFD   r13!, {r4 - r10}
        ADD     pc, r12, r2

        END
