	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Utility Routines
;****************************************************************
;
;	$Workfile:   vgautil.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains utility routines commonly used in
;	the VGA BIOS.
;
; 	Modification History:
; 	$Log:   H:/vcs/vga/vgautil.asv  $
;      
;         Rev 1.2   07 Aug 1991 08:50:58   jime
;      new rev. from Don Ostrom.
;      
;         Rev 1.1   23 Jul 1991 20:54:24   dale
;      Enable_DAC_Video was destroying the sequencer index.
;      Also added a hook in the font loading routine.
;      
;         Rev 1.0   21 Dec 1990 11:01:08   Darryl
;      Initial checkin to VCS.
;
;	07/08/89  Speed optimizations made to the core VGA BIOS.
;		  No code changes to this module.
;
;****************************************************************
;
; 07-31-91 Change for supporting extended tables in the USER ENV
;
	.XLIST
	INCLUDE VGADATA.INC
	include	config.inc
	include options.inc
	.LIST

	%OUT	Assembling VGA BIOS Utility Routines

VGA_Segment	SEGMENT PUBLIC WORD

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

	EXTRN	Clear_Screen:NEAR
;	EXTRN   Configure_Chip_Fontfixup:NEAR
if 0
	EXTRN	DAC_Color_200_Table:BYTE
	EXTRN	DAC_Gray_200_Table:BYTE
	EXTRN	DAC_Color_400_Table:BYTE
	EXTRN	DAC_Gray_400_Table:BYTE
	EXTRN	DAC_Color_13_Table:BYTE
	EXTRN	DAC_Gray_13_Table:BYTE
	EXTRN	DAC_Default_Gray_Table:BYTE
	EXTRN	DAC_256_Color_Table:BYTE
	EXTRN	DAC_Mono_Table:BYTE
endif	;0
	EXTRN	Get_Env_Ptr:NEAR
	EXTRN	Get_Extended_Mode_Info:NEAR
	EXTRN	Get_Extended_Mode:NEAR
;	EXTRN	Get_Extended_Mode_Table:NEAR
	EXTRN	Gray_Sum:NEAR
	EXTRN	Message_Ctrl:BYTE
	EXTRN	Mono_9x14_Characters:BYTE
	EXTRN	Mono_9x16_Characters:BYTE
	EXTRN	OEM_Msg:BYTE
	EXTRN	Quadtel_Msg:BYTE
;gdl
	extrn	get_crtc_addr:near
;	extrn	wait_vretrace:near
	extrn	bios_date_msg:near
	extrn	cl_isdisp:byte
	extrn	cust_isdisp:byte
	extrn	con_mode:byte
	extrn	getreg:near
	extrn	get_tbl_ptr:near
 	extrn	wait_vretrace:near
 	extrn	Read_Reg_NI:near
	extrn	DetectEnvPtr:near		;v0.051

	PUBLIC	Build_Character_Set
	PUBLIC	Clear_DAC_Video
	PUBLIC	Default_Mode_Table
	PUBLIC	Disable_DAC_Video
	PUBLIC	Display_Signon_Message
	PUBLIC	Enable_DAC_Video
	PUBLIC	Error_Beep
	PUBLIC	Gate_Timer
	PUBLIC	Get_Mode_Table
	PUBLIC	Load_DAC_Registers
	PUBLIC	Read_Reg
	PUBLIC	Read_DAC
	PUBLIC	Read_DACF
	PUBLIC	Set_DAC_Registers
	PUBLIC	Set_VGA_Registers
	PUBLIC	Video_On
	PUBLIC	Video_Off
	PUBLIC	Write_DAC
	PUBLIC	Write_DACF

;****************************************************************
;   Read a Controller register. To read a register, the index
;   register must first be written, and then the data can be read
;   from the controller data address.
;
;   Entry: AL - Index register
;	   DX - Controller Index Address
;   Exit:  AH - Register data
;****************************************************************


if 0	; duplicated
Read_Reg_NI	PROC	NEAR
	OUT	DX,AL				;Write to index register
	JMP	SHORT $+2
	INC	DX				;Advance to data register
	MOV	AH,AL				;Save index register in AH
	IN	AL,DX				;Read data register
	DEC	DX				;Restore callers DX
	XCHG	AL,AH				;Restore Index register
	RET
Read_Reg_NI	ENDP
endif

;**********************************************************************
;   Read a Controller register. To read a register, the index
;   register must first be written, and then the data can be read
;   from the controller data address. Increment the index register.
;
;   Entry: AL - Index register
;	   DX - Index Address
;   Exit:  AL - Incremented
;	   AH - Register Data
;**********************************************************************


Read_Reg PROC NEAR
	OUT	DX,AL				;Write to index register
	INC	DX				;Advance to data register
	INC	AL				;Increment index offset
	MOV	AH,AL				;Save index in AH
	IN	AL,DX				;Read data from register
	DEC	DX				;Move back to index register
	XCHG	AL,AH				;Get index into AL
	RET
Read_Reg ENDP

;****************************************************************
;   Gate_Timer is used to clock an interval of time using the
;   constant clock source of the 8254 channel 2. The routine
;   can be used to clock time with or without sound.
;
;   Entry: AL - Port B value (enable/disable sound)
;	   CX - Duration (in overflow counts of timer 2)
;****************************************************************

Gate_Timer	PROC	NEAR
	MOV	BL,AL				;Save value to or to port B
	IN	AL,Port_B			;Get current port B value
	JMP	SHORT $+2			;Delay briefly
	MOV	BH,AL				;Save Port B or value
	AND	AL,0FCH 			;Clear sound bit initially
	OR	AL,BL				;Enable/disable speaker
	OR	AL,01				;Enable timer gate
	OUT	Port_B,AL			;Enable sound
	JMP	SHORT $+2			;Delay briefly
	MOV	AL,0B6H 			;Program timer 2 to mode 3
	OUT	Timer_Base + Timer_Mode,AL	;Write the timer mode register
	JMP	SHORT $+2			;Delay briefly
	MOV	AL,050H 			;Write count register value
	OUT	Timer_Base + 2,AL		;to generate a frequency
	JMP	SHORT $+2			;of approximately 1075MHZ
	MOV	AL,005H 			;Get high byte value
	OUT	Timer_Base + 2,AL		;Write high byte count
	MOV	DX,0FFFFH			;Start at highest count

Next_Cycle:
	MOV	AL,80H				;Latch timer value command
	OUT	Timer_Base + Timer_Mode,AL	;Latch timer 2 value
	JMP	SHORT $+2			;Delay briefly
	IN	AL,Timer_Base + 2		;Read the low byte
	JMP	SHORT $+2			;Delay briefly
	MOV	AH,AL				;Save the low byte
	IN	AL,Timer_Base + 2		;Read the high byte
	XCHG	AL,AH				;Put them in the correct order
	CMP	AX,DX				;Have we wrapped the time yet
	MOV	DX,AX				;Save new time
	JB	Next_Cycle			;No -Keep waiting for wrap
	LOOP	Next_Cycle			;Wrap time specified by CX
	IN	AL,Port_B			;Now turn the speaker off
	JMP	SHORT $+2			;Delay briefly
	AND	AL,BH				;Restore original port B value
	OUT	Port_B,AL			;Write value to port B
	RET
Gate_Timer	ENDP

;****************************************************************
;   Generate a long tone followed by a sequence of short tones.
;   The first tone will be approximately 2-3 seconds and the
;   short tones will be approx. 1 second with a quiet time
;   inbetween tones of about 3/4 of a second.
;
;   Entry:  AL - Number of short tones to generate
;****************************************************************

Error_Beep	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX				;Save callers registers
	PUSH	AX				;Save extra copy of count
	MOV	CX,580 * 3			;Generate 3 second tone
	MOV	AL,03				;Turn speaker on
	CALL	Gate_Timer			;Gate timer and wait
	POP	AX				;Restore count

Beep_Loop:
	PUSH	AX				;Save current short bell count
	MOV	CX,300				;Delay w/no sound ~1 sec
	MOV	AL,00				;Gate timer & speaker off
	CALL	Gate_Timer			;Gate timer and wait
	MOV	CX,580				;Short beep should be 1 second
	MOV	AL,02				;Turn speaker gate on
	CALL	Gate_Timer			;Gate timer,speaker and wait
	POP	AX				;Pop current short bell count
	DEC	AL				;Any more beeps left
	JNE	Beep_Loop			;Yes-Go delay and beep again
	POP	DX				;No -Restore callers registers
	POP	CX
	POP	BX
	POP	AX
	RET
Error_Beep	ENDP

;;****************************************************************
;;   Set the VGA registers to the mode specifed.
;;
;;	Entry: AL - Mode byte
;;****************************************************************
;
;Set_Mode_Table PROC NEAR
;	PUSH	AX				;Save registers
;	PUSH	SI
;	PUSH	ES
;	CALL	Get_Mode_Table			;Get pointer to table
;	CALL	Set_VGA_Registers		;Write registers
;	POP	ES				;Restore registers
;	POP	SI
;	POP	AX
;	RET
;Set_Mode_Table ENDP

;****************************************************************
;   Build character set passed as parameter.
;
;	Entry:	 ES:SI - Pointer to character set
;		 CX    - Number of characters
;		 DX    - Offset in table
;		 BH    - Number of bytes per character
;****************************************************************

Build_Character_Set PROC NEAR
	PUSH	AX				;Save registers
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	PUSH	ES
	CALL	Video_Off			;Make sure video is off

ifdef  (XGA_BUG)
	extrn	Is_Chip_Unlocked:near
	call	Is_Chip_Unlocked	;Are extentions available?
	jne	skipit
endif  ;(XGA_BUG)

		;
		; disable write buffer fast-page mode for 132-column mode
		; (bandwidth is not enough)
		;
		push	dx
		push	bx
		mov	dx,SEQIDX
;#5434(1)#{
	mov	al, 1fh
	call	getreg
	push	ax
;#5434(1)#{
		mov	al,0fh		; DRAM control
		call	getreg

		mov	bx,ax		; save original data in bx
;#5434(20)#{
	MOV	AL,Video_Mode			;Get current mode table
	cmp	al, 14h
	jz	is_132column
	cmp	al, 54h
	jz	is_132column
	cmp	al, 55h
	jnz	skip_SRF
is_132column:
	mov	al, 0fh
;#5434(20)#}
		or	ah,40h		; disable write buffer fast-page mode
		setreg			; done
skip_SRF:			;#5434(20)
;#5434(1)#{
	pop	ax
	setreg
	push	cx
	mov	cx, 800h
	loop	$
	pop	cx		;delay
;#5434(1)#{
		pop	ax
		pop	dx		; restore block start
		xchg	ax,bx
		push	ax
skipit:

	PUSH	DX				;Save block start
	MOV	DX,Sequencer			;Setup access to plane 2
	MOV	AX,0402H			;Write sequencer map
	OUT	DX,AX				;Enable plane 2
	MOV	AX,0704H			;Write sequencer memory mode
	OUT	DX,AX				;Write mode register
	MOV	DX,Graphics_Controller		;Setup graphics controller
	MOV	AX,0204H			;Set read map select
	OUT	DX,AX				;reg to plane 2
	MOV	AX,0005H			;Write graphics mode reg
	OUT	DX,AX
	MOV	AX,0406H			;Write miscellaneous
	OUT	DX,AX				;Set plane address
	POP	DX

	MOV	AX,ES				;Get register
	MOV	DS,AX				;Set register
	MOV	AX,0A000H			;Segment to write
	MOV	ES,AX				;Destination segment
	PUSH	BX				;Save register
	AND	BL,007H 			;Reset high bit
	ROR	BL,1				;Shift page bits
	ROR	BL,1				;Shift to high bits
	RCR	BL,1				;Test if extended char set
	JNC	VGA_Block_Number		;No -Use standard VGA blocks
	ADD	BL,10H				;Extended VGA block number

VGA_Block_Number:
	SHL	BL,1				;Set proper block size
	MOV	AH,BL				;Set in high address
	MOV	AL,00				;Reset low byte
	MOV	DI,AX				;Set offset
	OR	DX,DX				;Test for zero offset
	JE	Skip_Offset			;No offset specified
	MOV	AX,32				;Bytes per character
	MUL	DX				;Multiply by offset
	ADD	DI,AX				;Add offset

Skip_Offset:
	MOV	DX,32				;Bytes per character
	SUB	DL,BH				;Subtract bytes per character
	JCXZ	No_Font 			;Skip if not font

Write_Character_Set_Loop:
	PUSH	CX				;Save counter
	MOV	CL,BH				;Get bytes per character

comment	%
;(99){
	call	DetectEnvPtr			;v0.051
	jnz	short not_8x14			;v0.051
	cmp	bh, 14
	jnz	not_8x14
;v0.073inc	si
not_8x14:
;(99)}
%

	MOV	CH,00				;Reset high byte
	REP	MOVSB				;Move byte block
	ADD	DI,DX				;Next position
;(99){
	call	DetectEnvPtr			;v0.051
	jnz	short not_8x14a			;v0.051
	cmp	bh, 14
	jnz	not_8x14a
if 1;idk					;v1.10A2{
;
; must determine if this 8x14 font load is from a user calling to
; load an 8x14 font. If the segment of the font is NOT the same
; as the BIOS and the TSR is not loaded, then must NOT truncate
; the last 2 scan lines of the font that is specified, since what
; es:bp points to is a real 8x14 font and not the 8x16 font that is
; subsituted for it (in the BIOS)
;
	push	ax
	push	bx
	mov	ax,cs			;our executing segment
	mov	bx,ds			;segment where the font is
	cmp	bx,ax			;is the font segment the same as the
	pop	bx			;BIOS segment, if so, TSR is NOT loaded
	pop	ax			;and segments are same, mean that the
	jnz	not_8x14a		;last 2 line of the 8x16 font must be
					;skipped.
endif					;v1.10A2}
	inc	si
	inc	si				;v0.073
not_8x14a:
;(99)}
	POP	CX				;Get counter
	LOOP	Write_Character_Set_Loop	;Write a character

No_Font:
	POP	BX				;Restore register

		;
		; restore SR0F
		;
		mov	dx,SEQIDX	; set up register
ifdef  (XGA_BUG)
	call	Is_Chip_Unlocked	;Are extentions available?
	jne	skip_it
endif  ;(XGA_BUG)
;#5434(1)#{
	pop	cx
	mov	al, 1fh
	call	getreg
	push	ax
	mov	ax, cx
;#5434(1)#}
;#5434(1)#		pop	ax		; get original value
		setreg			; done
;#5434(1)#{
	pop	ax
	setreg
;#5434(1)#}

skip_it:
	POP	ES				;Restore registers
	POP	DS
	CALL	Fixup_Monochrome_Set		;Fix the monochrome
	MOV	DX,Sequencer			;Restore text mode state
	MOV	AX,0302H			;Enable planes 0 and 1
	OUT	DX,AX				;Write map mask reg
	MOV	AX,0304H			;Restore memory mode reg
	OUT	DX,AX				;to text and extended memory
	MOV	DX,Graphics_Controller		;Restore graphics registers
	MOV	AX,0004H			;Set map select
	OUT	DX,AX				;back to plane 0
	MOV	AX,1005H			;Write graphics mode
	OUT	DX,AX				;register to odd/even addr
	MOV	AX,0A06H			;Write miscellaneous reg
	CMP	M6845_Address,CRT_3B4		;Are we monochrome base
	JE	Mono_Base_Char			;Yes-Set B000 address
	MOV	AH,0EH				;No -Set B800 address

Mono_Base_Char:
	OUT	DX,AX				;Write miscellaneous

	CALL	Video_On			;Turn video on again
	POP	SI				;Restore registers
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
Build_Character_Set ENDP

;****************************************************************
;   Fixup the monochrome set if the either bit 6 or 7 of the
;   page register is set on entry. This bit is set as a special
;   entry by the mode command.
;****************************************************************

Fixup_Monochrome_Set PROC NEAR
	PUSH	AX				;Save registers
	PUSH	CX
	PUSH	DI
	PUSH	SI
	PUSH	ES
	MOV	CX,0A000H
	MOV	ES,CX
	TEST	BL,0C0H 			;Test for fixup table
	JE	Done_Fixup			;No fixup specified
	MOV	CX,007H 			;Will always be zero
	MOV	SI,OFFSET Mono_9x14_Characters	;Get pointer to 9x14 updates
	TEST	BL,080H 			;Are we doing 9x14
	JNE	Next_Mono_Entry 		;Yes-Go load alternate
	MOV	SI,OFFSET Mono_9x16_Characters	;Get pointer to 9x14 updates
	MOV	CL,08H				;Char size is 8 words

Next_Mono_Entry:
	MOV	AH,CS:[SI]			;Get character code
	INC	SI				;Advance to first char
	OR	AH,AH				;Is it zero
	JE	Done_Fixup			;Yes-Were done
	XOR	AL,AL				;No -char code in AH
	SHR	AX,1				;Shift down 3 bits is
	SHR	AX,1				;equiv to a mult x 32
	SHR	AX,1
	MOV	DI,AX				;Set character offset
	PUSH	CX				;Save bytes/character
	pushf
	CLI					;are used for each char
	REP	MOVS WORD PTR [DI],WORD PTR CS:[SI] ;Move in the new character
	popf					;Ok for interrupts
	POP	CX				;Restore bytes/character
	JMP	Next_Mono_Entry 		;Repeat for next entry

Done_Fixup:
	POP	ES				;Restore registers
	POP	SI
	POP	DI
	POP	CX
	POP	AX
	RET
Fixup_Monochrome_Set ENDP

;****************************************************************
;   Enable the video by setting bit 5 of the attribute
;   controller index address.
;****************************************************************

Video_On	PROC	NEAR
	PUSH	DX
	call	get_crtc_addr
;	MOV	DX,M6845_Address		;Get CRT base address
	ADD	DL,06				;Compute input status 0
; khu
; fixes logitech mouse driver bug
	push	dx				; save input status reg

	IN	AL,DX				;Clear attribute flip-flop
	MOV	DX,Attribute_Controller 	;Get attribute controller
	MOV	AL,20H				;Value to enable video
	OUT	DX,AL				;Turn video on

	pop	dx				; recover input status register
	in	al,dx				; set flip flop to index

	POP	DX
	RET
Video_On	ENDP

;****************************************************************
;   Disable the video by clearing bit 5 of the attribute
;   controller index address.
;****************************************************************

Video_Off	PROC	NEAR
	PUSH	DX
	call	get_crtc_addr
;	MOV	DX,M6845_Address		;Get CRT base address
	ADD	DX,06				;Compute input status 0
	IN	AL,DX				;Clear attribute flip-flop
	XOR	AL,AL				;Value to disable video
	MOV	DX,Attribute_Controller 	;Get attribute controller
	OUT	DX,AL				;Turn video off
	POP	DX
	RET
Video_Off	ENDP

;****************************************************************
;   Read the red, green, and blue DAC values to the specified
;   DAC register.
;
;   Entry: BX - DAC index register
;   Exit:  AH - Red value
;	   CH - Green value
;	   CL - Blue value
;	   BX - BX + 1
;****************************************************************

Read_DAC	PROC	NEAR
	PUSHF					;Save interrupt condition
	CLI					;No interrupts here

Read_DACF:
	MOV	DX,DAC_Read_Index		;Point DX to index
	MOV	AL,BL				;Get index register
	OUT	DX,AL				;Select register to read
	JMP	SHORT $+2
	ADD	DX,02				;Move to DAC data register
	IN	AL,DX				;Get red DAC value
	JMP	SHORT $+2
	MOV	AH,AL				;Save red DAC value
	IN	AL,DX				;Get green value
	JMP	SHORT $+2
	MOV	CH,AL				;Save green DAC value
	IN	AL,DX				;Get blue value
	MOV	CL,AL				;Write blue DAC value
	INC	BX				;Move to next register
	POPF					;Restore flags
	RET
Read_DAC	ENDP

;****************************************************************
;   Write the red, green, and blue DAC values to the specified
;   DAC register.
;
;   Entry: AH - Red value
;	   CH - Green value
;	   CL - Blue value
;	   BX - DAC index register
;   Exit:  BX - BX + 1
;****************************************************************

Write_DAC	PROC	NEAR
	PUSHF					;Save interrupt condition
	CLI					;No interrupts here

Write_DACF:

  if (WRITE_DAC_SLOWLY eq YES)

	EXTRN	Set_Low_Clk:near

	call	Set_Low_Clk

  endif ;(WRITE_DAC_SLOWLY eq YES)

	call	out_DAC			;(3/22/92) V1.20 Leo

	INC	BX				;Move to next register
  if (WRITE_DAC_SLOWLY eq YES)

	EXTRN	Rstore_Regs:near

	call	Rstore_Regs

  endif ;(WRITE_DAC_SLOWLY eq YES)

	POPF
	RET

Write_DAC	ENDP


	PUBLIC	out_DAC

out_DAC		proc	near
	MOV	DX,DAC_Write_Index		;Point DX to index
	MOV	AL,BL				;Get index register
	OUT	DX,AL				;Select register to load
	in	al, 80h				;(3/22/93 V1.20 Leo)
	INC	DX				;Move to DAC write register
	MOV	AL,AH				;Get red DAC value
	OUT	DX,AL				;Write red DAC value
	in	al, 80h				;(3/22/93 V1.20 Leo)
	MOV	AL,CH				;Get green value
	OUT	DX,AL				;Write green DAC value
	in	al, 80h				;(3/22/93 V1.20 Leo)
	MOV	AL,CL				;Get blue value
	OUT	DX,AL				;Write blue DAC value
	ret
out_DAC		endp

;
;	Disable_DAC_Video()
; 
; 	Input:
;			
; 	Returns:
; 
; 	Description: 
;
;-----------------------------------------------------------------------
Disable_DAC_Video	PROC	NEAR
	PUSH	DX
	MOV	DX,Sequencer
	IN      AL,DX
	PUSH    AX
	MOV	AL,01
	CALL	Read_Reg_NI
	OR	AH,020H
	OUT	DX,AX
	POP     AX
	OUT     DX,AL
	POP	DX
	RET
Disable_DAC_Video	ENDP


;-----------------------------------------------------------------------
;
;	Enable_DAC_Video()
; 
; 	Input:
;			
; 	Returns:
; 
; 	Description: 
;
;-----------------------------------------------------------------------
Enable_DAC_Video	PROC	NEAR
	PUSH	DX
	MOV	DX,Sequencer
	IN      AL,DX
	PUSH    AX
	MOV	AL,01
	CALL	Read_Reg_NI
	AND	AH,NOT 20H

	pushf
	cli
	OUT	DX,AX
	popf

	POP     AX
	OUT     DX,AL
	POP	DX
	RET
Enable_DAC_Video	ENDP

;****************************************************************
;  Disable DAC, clear all registers, then re-enable DAC
;****************************************************************

Clear_DAC_Video PROC	NEAR
	CALL	Disable_DAC_Video		;Disable video for DAC write
	MOV	SI,256				;Clear all DAC registers
	XOR	BX,BX				;with zero before performing
	XOR	AH,AH				;monitor detection test
	XOR	CX,CX				;AH/CH/CL contain R, G, B

Clear_DAC_Loop:
	CALL	Write_DAC			;Write DAC R, G, B register
	DEC	SI				;Decrement outer counter
	JNE	Clear_DAC_Loop			;Repeat for all 256 regs
	CALL	Enable_DAC_Video		;Now enable the video
	RET
Clear_DAC_Video ENDP

;****************************************************************
;   Write the data in the mode tables to the sequencer, CRT,
;   attribute, and graphics controller.
;
;   Entry:  ES:SI - Pointer to mode table
;****************************************************************
Set_VGA_Registers	PROC	NEAR
	PUSH	CX
	PUSH	DX

	CALL	Video_Off			;Make sure video is off

	add	si,05h				;Make SI point to Sequ parms
	mov	cx,4				;4 registers
	mov	al,01h				;Start at index 1, not 0
	MOV	DX,Sequencer			;Get address of sequencer
Set_Sequencer:
	call	program_registers

ifdef	XGA_VXD_BUG
	mov	ax,00300h
	out	dx,ax
endif   ;XGA_VXD_BUG

	MOV	Al,ES:[SI]			;Get next byte to write
	inc	si
	MOV	DX,Miscellaneous		;Now write misc reg
	OUT	DX,AL				;before releasing reset

	call	get_crtc_addr   ; get 3x4 address

Set_Mono_Base_Addr:
	MOV	M6845_Address,DX		;Save in BIOS data area

;gdl:01/20/92 Don't reset VIntr bits, so IRQ2 won't fire off.
	mov	al,11h
	call	getreg
	and	ah,not 80h
	setreg

  if (FLUSHFIFO_IN_CRTC eq YES)
%out "Including FLUSH FIFO before programming CRTC code"
	push	dx
	mov	al,91h
	call	getext
	or	ah,20h
	setreg
	pop	dx
  endif ;(FLUSHFIFO_IN_CRTC eq YES)

	MOV	CX,25				;Set all CRT registers
	MOV	Al,00				;Start at CRT offset 00

Set_CRT:
	call	program_registers

  if (FLUSHFIFO_IN_CRTC eq YES)
	pushf
	cli
	mov	bl,1
	call	wait_vretrace
	mov	al,91h
	call	getext
	and	ah,not 20h
	setreg
	popf
  endif ;(FLUSHFIFO_IN_CRTC eq YES)

	ADD	DX,06				;Advance to input status 0
	IN	AL,DX				;Clear attribute flip-flop
	XOR	AH,AH				;Reset index for attribute
	MOV	CX,16				;Prepare to load attribute
	MOV	DX,Attribute_Controller 	;controller.
	TEST	VGA_StatusA,Default_Palette	;Are we supposed to load
	JNE	Skip_Palettes			;No -Dont load overscan to

Set_Palette_Loop:
	MOV	AL,AH				;Get palette index
	OUT	DX,AL				;Select palette
	INC	AH				;Incremen palette index
	LODS	BYTE PTR ES:[SI]		;Get palette value
	OUT	DX,AL				;Write to palette register
	LOOP	Set_Palette_Loop		;Repeat for 16 registers

Skip_Palettes:
	ADD	AH,CL				;Advance to mode register
	ADD	SI,CX				;Advance table pointer
	MOV	CX,05				;Write 5 control regs

Set_Attribute:
	CMP	AH,11H				;Are we writing overscan
	JNE	Not_Overscan			;No -Write the register
	INC	SI				;Yes-We will skip it if
	TEST	VGA_StatusA,Default_Palette	;the default palette bit
	JNE	Skip_Overscan			;is set.
	DEC	SI				;Not set-write overscan

Not_Overscan:
	MOV	AL,AH				;Get index value
	OUT	DX,AL				;Write to controller
	JMP	SHORT $+2
	XOR	AL,AL				;Test for register 14H
	CMP	AH,14H				;Write color select to 0
	JE	Write_Attr_Reg
	LODS	BYTE PTR ES:[SI]		;Read byte from table

Write_Attr_Reg:
	OUT	DX,AL				;Write to attribute controller

Skip_Overscan:
	INC	AH				;Increment index count
	LOOP	Set_Attribute			;Repeat for 20 registers
comment % #5434(10)#
	XOR	AL,AL				;Set graphics 1 position
	MOV	DX,Graphics1_Pos		;Get graphics 1 address
	OUT	DX,AL				;Must be set to a zero
	INC	AL				;Graphics 2 must be a one
	MOV	DX,Graphics2_Pos		;Get graphics 2 position addr
	OUT	DX,AL				;And set the register
%
	XOR	AL,AL				;Clear index for graphics
	MOV	CX,09				;controller. Set 9 registers
	MOV	DX,Graphics_Controller		;Get graphics hardware addr

Set_Graphics:
	call	program_registers

	POP	DX				;Restore callers registers
	POP	CX
	RET
Set_VGA_Registers	ENDP

;***********************************************************************
;   Program a block of registers
;
;   Entry:
;	AL = first register to program
;	CX = number of registers to program
;	ES:SI = block of data to program
;
;***********************************************************************
program_registers	PROC
	mov	ah,es:[si]		; get data
	inc	si			; point to next data byte
	out	dx,ax			; write index and data (16bits)
	inc	al			; point to next register
	loop	program_registers	; do the whole block
	ret
program_registers	ENDP

;****************************************************************
;   Load the DAC registers with the appropriate red, green, and
;   blue values. The DAC values loaded depend on the video mode,
;   the vertical resolution, and whether a color or monochrome
;   monitor is attached.
;****************************************************************

Set_DAC_Registers	PROC	NEAR
	TEST	VGA_StatusA,Default_Palette	;Test if we are to load DAC
	JE	Load_DAC_Registers		;Yes-Continue
	RET					;No -Just exit

Load_DAC_Registers:

	MOV	DX,DAC_Pel_Mask 		;Dont mask any bits in
	IN	AL,DX				;Read mask register
	INC	AL				;Is it FF
	JE	Mask_Is_FF			;Yes-Dont need to set mask
	MOV	AL,0FFH 			;the DAC register
	OUT	DX,AL				;Clear mask register

Mask_Is_FF:
	XOR	BX,BX				;starting at DAC register 0
	mov	cx,0808h			;8 registers, 8 times each
	mov	si,offset Dac_Mono_Table	;00,2A,??,3F,00,2A,??,3F

	MOV	AL,Video_Mode			;Get current video mode
	CMP	AL,07H				;Are we mode 7
	JE	Do_Dac_Mono_Load
	CMP	AL,0FH				;Are we mode F
	JE	Do_Dac_Mono_Load

	CMP	AL,13H				;Now test for mode 13
	JE	DAC_Mode_13			;Yes-Go handle mode 13
	JB	SDR_Standard			;Go if standard VGA mode
	MOV	AH,AL				;Save video mode
	CALL	Get_Extended_Mode_Info		;Get ExtMode info byte
	XCHG	AH,AL				;Restore mode, AH=info
	TEST	AH,EVM_Color			;Are we monochrome
	JE	Do_Dac_Mono_Load		;Yes-use mode seven
	TEST	AH,EVM_Packed			;Are we planar
	JE	DAC_Hi_Res			;Yes-Go Use planar DAC tables
	JMP	SHORT DAC_Mode_13		;No -Use packed pixel tables

Do_Dac_Mono_Load:
	jmp	short Dac_Mono_Load

SDR_Standard:
	CMP	AL,04				;Test for text mode
	JB	Check_DAC_Hi_Res		;Go -Could be 400 lines
	CMP	AL,06				;Are we modes 4-6
	JBE	Dac_Lo_Res			;Yes-Use 200 lines DAC
	CMP	AL,08H				;Are we in mode 8
	JE	DAC_Hi_Res			;Yes-Use 350/400 line table
	CMP	AL,0EH				;use 200 line DAC table
	JBE	DAC_Lo_Res			;for mode 9 through E
	JMP	SHORT Dac_Hi_Res		;Must be 10-12, use 350/400

Check_DAC_Hi_Res:
	TEST	VGA_StatusA,Scans_400		;No -Can we do 400 lines
	JNE	DAC_Hi_Res			;Yes-Go handle 400 line DAC
	MOV	AH,EGA_StatusB			;Test for VGA monitor switches
	AND	AH,0FH				;3 and 9 since that indicates
	CMP	AH,03H				;350 line resolution
	JE	DAC_Hi_Res			;If 3 or 9 found then use
	CMP	AH,09H				;the 350/400 line DAC table
	JE	DAC_Hi_Res

DAC_Lo_Res:
;LEO	mov	cx,40h				;64 registers
	mov	cx,20h				;1st 32 registers
	MOV	SI,OFFSET DAC_Color_200_Table	;We have 200 line mode
	TEST	VGA_StatusA,Gray_Shades + VGA_Monochrome ;Are we gray or color
;LEO {
;	Jz	Do_DAC_rgbRGB_Load		;Go if color
	jnz	ff
	push	si				;color case
	push	cx
	call	DAC_rgbRGB_Loader		;1st 32 registers
	pop	cx
	pop	si
	jmp	short Do_DAC_rgbRGB_Load	;2nd 32 registers
ff:
;LEO }
;LEO	mov	cx,4001h			;64 registers once each
	mov	cx,2001h			;32 registers once each
	MOV	SI,OFFSET DAC_Gray_200_Table	;Get 200 line gray table
;LEO	Jmp	DAC_Mono_Load			;Go if mono
	push	si
	push	cx
	call	DAC_Mono_Loader			;2nd 32 register
	pop	cx
	pop	si
	jmp	short DAC_Mono_Load

DAC_Hi_Res:
	mov	cx,4001h			;64 registers once each
	MOV	SI,OFFSET DAC_Gray_400_Table	;Get 400 line gray table
	TEST	VGA_StatusA,Gray_Shades + VGA_Monochrome ;Are we gray or color
;LEO	Jz	Do_DAC_rgbRGB_Load		;Go if color
	jnz	DAC_Mono_Load			;Go if mono

	jmp	Load_DAC_color_400	;LEO

Do_DAC_rgbRGB_Load:
;LEO	jmp	DAC_rgbRGB_Load
	call	Dac_rgbRGB_Loader
	ret

Dac_Mono_Load:
	call	Dac_Mono_Loader
	ret

DAC_Mode_13:
;LEO	mov	cx,10h				;16 registers
	mov	cx,8h				;8 registers
;LEO	MOV	SI,OFFSET DAC_Color_13_Table	;Get mode 13h color table
	MOV	SI,OFFSET DAC_Color_200_Table	;Get mode 13h color table
	TEST	VGA_StatusA,Gray_Shades + VGA_Monochrome ;Are we gray or color
	jnz	DAC_Mode_13_Mono
;LEO {
	push	cx
	call	DAC_rgbRGB_Loader		;Go if color
	pop	cx
	MOV	SI,OFFSET DAC_Color_200_Table+10h	;Get mode 13h color table
	call	DAC_rgbRGB_Loader
;LEO }
	jmp	short DAC_Mode_13_Gray
DAC_Mode_13_Mono:
;LEO	mov	cx,1001h			;16 registers once each
	mov	cx,801h				;8 registers once each
	MOV	SI,OFFSET DAC_Gray_200_Table	;Get mode 13h gray table
;LEO {
	push	cx
	call	DAC_Mono_Loader			;Go if mono
	pop	cx
	MOV	SI,OFFSET DAC_Gray_200_Table+10h	;Get mode 13h gray table
	call	DAC_Mono_Loader			;Go if mono
;LEO }
	
DAC_Mode_13_Gray:
	mov	cx,1001h			;16 registers once each
	MOV	SI,OFFSET DAC_Default_Gray_Table ;Get mode 13h gray-scale table
	call	DAC_Mono_Loader			;Go load it

	mov	cx,0009h
	mov	si,offset DAC_HSI_Parm_Table
DAC_Mode_13_HSILoop:
	mov	dl,cs:[si]	
	mov	bh,cs:[si+1]	
	call	Make256ColorBlock
	add	si,2
	loop	DAC_Mode_13_HSILoop
	ret
;LEO	jmp	Set_Dac_Registers_Done

;------------------------------------------------------------------------
;Entry:	DL = minimum (base)
;	BL = start reg index
;	BH = scale
;Exit:	BL = start reg index+18h
;	AX,DX changed

Make256ColorBlock	proc	near

	push	si
	push	cx
	mov	si,offset ColorFunc	;Point to color lookup function
	mov	cx,18h			;24 DAC entries

Make256ColorLoop:
	push	cx			;Save loop count

	mov	al,cs:[si]		;Get color func value
	mul	bh			;Multiply by scale
	add	ax,007Fh		;Round up if necessary
	add	ah,dl			;AH now equals Red value to set
	mov	dh,ah			;DL = Red value

	mov	al,cs:[si+10h]		;Get color func value
	mul	bh			;Multiply by scale
	add	ax,007Fh		;Round up if necessary
	add	ah,dl			;AH now equals Green value to set
	mov	ch,ah			;CH = Green value

	mov	al,cs:[si+8h]		;Get color func value
	mul	bh			;Multiply by scale
	add	ax,007Fh		;Round up if necessary
	add	ah,dl			;AH now equals Blue value to set
	mov	cl,ah			;CL = Blue value

	mov	ah,dh
	push	dx
	CALL	Gray_Sum		;Gray sum the value
	call	Write_DAC
					;Hopefully BH=scale is not too bad.
	pop	dx
;	inc	bl
	inc	si
	pop	cx
	loop	Make256ColorLoop

	pop	cx
	pop	si
	ret

Make256ColorBlock	endp

;------------------------------------------------------------------------

;LEO	jmp	short Set_Dac_Registers_Done

Dac_Mono_Loader:		;BX = 0000 = starting index
				;CH = number of values in table
				;CL = number of times to repeat each entry
				;SI -> mono format table
	push	cx
Dac_Mono_Loop:
	push	cx
	mov	ch,cs:[si]
	mov	cl,ch
	mov	ah,ch
	call	Write_DAC
	pop	cx
	dec	cl
	jnz	Dac_Mono_Loop
	inc	si
	pop	cx
	dec	ch
	jnz	Dac_Mono_Loader

	ret

;------------------------------------------------------------------------

;LEO Dac_rgbRGB_Load:
;LEO	jmp	short Set_Dac_Registers_Done

Dac_rgbRGB_Loader:		;BX = 0000 = starting index
				;CX = number of values in table
				;SI -> rgbRGB format table
Dac_rgbRGB_Loop:
;LEO	push	cx
	mov	al,cs:[si]
	call	xfer_load_DAC
	inc	si
	loop	Dac_rgbRGB_Loop
	ret


xfer_load_DAC:
	push	cx
	xor	ah,ah
	test	al,04h
	jz	Dac_rgbRGB_Red2
	mov	ah,2Ah
Dac_rgbRGB_Red2:
	test	al,20h
	jz	Dac_rgbRGB_Green1
	add	ah,15h
Dac_rgbRGB_Green1:
	xor	cx,cx
	test	al,02h
	jz	Dac_rgbRGB_Green2
	mov	ch,2Ah
Dac_rgbRGB_Green2:
	test	al,10h
	jz	Dac_rgbRGB_Blue1
	add	ch,15h
Dac_rgbRGB_Blue1:
	test	al,01h
	jz	Dac_rgbRGB_Blue2
	mov	cl,2Ah
Dac_rgbRGB_Blue2:
	test	al,08h
	jz	Dac_rgbRGB_Prog
	add	cl,15h
Dac_rgbRGB_Prog:
	call	Write_DAC
	pop	cx
	ret


Load_DAC_color_400:
	mov	cx,40h				;64 registers
;LEO {
;	MOV	SI,OFFSET DAC_Color_400_Table	;We have 400 line mode
	xor	al, al
Color_400_load:
	push	ax
	call	xfer_load_DAC
	pop	ax
	inc	al
	loop	Color_400_load
	ret
;LEO }


;------------------------------------------------------------------------
;LEOSet_Dac_Registers_Done:
;LEO	ret

;------------------------------------------------------------------------
;------------------------------------------------------------------------

DAC_Color_200_Table	label byte
	db 00h,01h,02h,03h,04h,05h,14h,07h,00h,01h,02h,03h,04h,05h,14h,07h
	db 38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh
;LEO	db 00h,01h,02h,03h,04h,05h,14h,07h,00h,01h,02h,03h,04h,05h,14h,07h
;LEO	db 38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh

DAC_Gray_200_Table	label byte
	db 00h,05h,11h,1Ch,08h,0Bh,14h,28h,00h,05h,11h,1Ch,08h,0Bh,14h,28h
	db 0Eh,18h,2Dh,32h,20h,24h,38h,3Fh,0Eh,18h,2Dh,32h,20h,24h,38h,3Fh
;LEO	db 00h,05h,11h,1Ch,08h,0Bh,14h,28h,00h,05h,11h,1Ch,08h,0Bh,14h,28h
;LEO	db 0Eh,18h,2Dh,32h,20h,24h,38h,3Fh,0Eh,18h,2Dh,32h,20h,24h,38h,3Fh

;------------------------------------------------------------------------

DAC_Color_400_Table	label byte
;LEO	db 00h,01h,02h,03h,04h,05h,06h,07h,08h,09h,0Ah,0Bh,0Ch,0Dh,0Eh,0Fh
;LEO	db 10h,11h,12h,13h,14h,15h,16h,17h,18h,19h,1Ah,1Bh,1Ch,1Dh,1Eh,1Fh
;LEO	db 20h,21h,22h,23h,24h,25h,26h,27h,28h,29h,2Ah,2Bh,2Ch,2Dh,2Eh,2Fh
;LEO	db 30h,31h,32h,33h,34h,35h,36h,37h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh

DAC_Gray_400_Table	label byte
	db 00h,05h,11h,1Ch,08h,0Bh,25h,28h,02h,07h,1Bh,20h,0Fh,14h,28h,2Ch
	db 0Ch,11h,25h,2Ah,14h,1Eh,32h,36h,0Fh,13h,27h,2Ch,1Bh,20h,34h,39h
	db 06h,0Bh,1Fh,24h,13h,18h,2Ch,30h,09h,0Dh,21h,26h,15h,1Ah,2Eh,33h
	db 13h,17h,2Bh,30h,1Fh,24h,38h,3Dh,0Eh,18h,2Dh,32h,20h,24h,38h,3Fh

DAC_Mono_Table		label byte
	db 00h,2Ah
IFDEF ADAPTER
	db 2Ah
ELSE
	db 00h
ENDIF
	db 3Fh,00h,2Ah
IFDEF ADAPTER
	db 2Ah
ELSE
	db 00h
ENDIF
	db 3Fh

;------------------------------------------------------------------------

DAC_Color_13_Table	label byte
;LEO	db 00h,01h,02h,03h,04h,05h,14h,07h,38h,39h,3Ah,3Bh,3Ch,3Dh,3Eh,3Fh

DAC_Gray_13_Table	label byte
;LEO	db 00h,05h,11h,1Ch,08h,0Bh,14h,28h,0Eh,18h,2Dh,32h,20h,24h,38h,3Fh

DAC_Default_Gray_Table	label byte
	db 00h,05h,08h,0Bh,0Eh,11h,14h,18h,1Ch,20h,24h,28h,2Dh,32h,38h,3Fh

DAC_HSI_Parm_Table	label byte
;	   min, scale
	db 000h,0FCh	;20..37
	db 01Fh,080h	;38..4F
	db 02Dh,048h	;50..67
	db 000h,070h	;68..7F
	db 00Eh,038h	;80..97
	db 014h,020h	;98..AF
	db 000h,040h	;B0..C7
	db 008h,020h	;C8..DF
	db 00Bh,013h	;E0..F7

ColorFunc	label	byte
	db 00h,10h,20h,30h,40h,40h,40h,40h	;0
	db 40h,40h,40h,40h,40h,30h,20h,10h	;1
	db 00h,00h,00h,00h,00h,00h,00h,00h	;2
	db 00h,10h,20h,30h,40h,40h,40h,40h	;NOTE:Same as line 0
	db 40h,40h,40h,40h,40h,30h,20h,10h	;NOTE:Same as line 1

;------------------------------------------------------------------------
;------------------------------------------------------------------------

Set_DAC_Registers	endp


;****************************************************************
;   Compute the mode table entry for the specified mode. This
;   routine must determine whether the monitor has 400, 350
;   or 200 line resolution for text modes.
;
;   Entry:  AL	  - Video Mode (for Get_Mode_Table only)
;   Exit:   ES:SI - Mode table pointer
;****************************************************************

if 1
;%out "WARNING: Including untried and untested Default_Mode_Table/Get_Mode_Table!"

Default_Mode_Table	PROC	NEAR
	MOV	AL,Video_Mode			;Get current mode table

Get_Mode_Table:
	push	di
	push	cx
	push	bx

	mov	ch,al
	xor	bh,bh
	call	get_tbl_ptr
	mov	si,di

	pop	bx
	pop	cx
	pop	di

	ret

Default_Mode_Table	ENDP

else	;1

Mode_Table_400	LABEL	BYTE
	DB	17H, 17H, 18H, 18H, 04H
	DB	05H, 06H, 19H, 08H, 09H
	DB	0AH, 0BH, 0CH, 0DH, 0EH
	DB	11H, 12H, 1AH, 1BH, 1CH

Mode_Table_350	LABEL	BYTE
	DB	13H, 14H, 15H, 16H, 04H
	DB	05H, 06H, 07H, 08H, 09H
	DB	0AH, 0BH, 0CH, 0DH, 0EH
	DB	11H, 12H, 1AH, 1BH, 1CH

Mode_Table_200	LABEL	BYTE
	DB	00H, 01H, 02H, 03H, 04H
	DB	05H, 06H, 07H, 08H, 09H
	DB	0AH, 0BH, 0CH, 0DH, 0EH
	DB	11H, 12H, 1AH, 1BH, 1CH


Default_Mode_Table	PROC	NEAR
	MOV	AL,Video_Mode			;Get current mode table

Get_Mode_Table:
	PUSH	AX
	PUSH	BX				;Save callers BX

	CMP	AL,13H				;Are we an extended mode
	JBE	Standard_VGA_Mode		;Yes-Go determine mode
       	XOR     SI,SI				;Set Zero going
	MOV     ES,SI				;Into this subroutine
	CALL	Get_Extended_Mode	 	;Get table for extended mode
;	CALL	Get_Extended_Mode_Table 	;Get table for extended mode
	JNE	Standard_VGA_Mode		;Just continue if not found
	MOV     AX,ES				;Get the ES coming out
	OR      AX,AX				;Zero means old call
	JNE     Exit_DMT			;Non-Zero is new call
	MOV	AX,CS				;Return ES:SI pointing
	MOV	ES,AX				;to parameter table
	JMP	SHORT Exit_DMT			;Exit with table pointer

Standard_VGA_Mode:
	MOV	SI,OFFSET Mode_Table_400	;Start with 400 line table
	TEST	VGA_StatusA,Scans_400		;Can we do 400 lines
	JNE	Get_Mode_Entry			;Yes-use table to find entry
	MOV	SI,OFFSET Mode_Table_350	;No -Can we do 350 lines
	MOV	AH,EGA_StatusB			;Get switch settings
	AND	AH,0FH				;Isolate switches
	CMP	AH,03H				;Check for VGA enhanced
	JE	Get_Mode_Entry			;Yes-We can do 350 lines
	CMP	AH,09H				;Check EGA enhanced primary
	JE	Get_Mode_Entry			;Yes-We can do 250 lines
	CMP	AL,07H				;Test for mode 7
	JE	Get_Mode_Entry			;Yes-Since mode 7 is mono
	MOV	SI,OFFSET Mode_Table_200	;Must use 200 line table

Get_Mode_Entry:
	MOV	BL,AL				;Put video mode into BX
	XOR	BH,BH				;for indexing
	MOV	AL,CS:[BX+SI]			;Get table entry

Compute_Mode_Entry:
	MOV	AH,40H				;Each entry is 40H bytes long
	MUL	AH				;Compute offset to entry
	MOV	SI,AX				;Save offset to entry
	XOR	BX,BX				;Get base mode table
	CALL	Get_Env_Ptr			;located in the environment
	ADD	SI,BX				;Add base to offset

Exit_DMT:
	POP	BX				;Restore callers BX
	POP	AX
	RET
Default_Mode_Table	ENDP

endif	;1

;****************************************************************
;   Display the logon message and wait about 3 seconds
;   before continuing.
;****************************************************************

Display_Signon_Message	PROC	NEAR

	XOR	CL,CL			;No shift required
	xor	bl,bl		;gdl:02/03/92 Track if any messages displayed
	cmp	cs:cl_isdisp,0
	JE	Skip_Quadtel_Msg		;No -Skip it
	inc	bx		;gdl:02/03/92 Track if any messages displayed
	MOV	SI,OFFSET Quadtel_Msg		;Display sign on message
	CALL	Display_Message 		;during power on
	MOV	SI,OFFSET bios_date_msg		;Now print the chip/date
	CALL	Display_Message

Skip_Quadtel_Msg:
	cmp	cs:cust_isdisp,0
	JE	Skip_OEM_Msg			;No -Skip it
	inc	bx		;gdl:02/03/92 Track if any messages displayed
	MOV	SI,OFFSET OEM_Msg		;Now print the remains
	CALL	Display_Message 		;of the signon message

Skip_OEM_Msg:
	TEST	Message_Ctrl,04			;Are we to display eval message
	JE	Skip_Eval_Msg			;No -Skip the message
	CALL	Display_Eval_Message		;Display Eval Message (if any)

Skip_Eval_Msg:
Exit_DSM:
	RET
Display_Signon_Message	ENDP

;****************************************************************
;   Display the evaluation message if enabled.
;****************************************************************

Eval_Message	DB	0DH SHL 1,0AH SHL 1
		DB	'N' SHL 1,'o' SHL 1,'t' SHL 1
		DB	' ' SHL 1,'f' SHL 1,'o' SHL 1,'r' SHL 1
		DB	' ' SHL 1,'r' SHL 1,'e' SHL 1,'l' SHL 1
		DB	'e' SHL 1,'a' SHL 1,'s' SHL 1,'e' SHL 1
		DB	' ' SHL 1,'o' SHL 1,'r' SHL 1,' ' SHL 1
		DB	'p' SHL 1,'r' SHL 1,'o' SHL 1,'d' SHL 1
		DB	'u' SHL 1,'c' SHL 1,'t' SHL 1,'i' SHL 1
		DB	'o' SHL 1,'n' SHL 1,'.' SHL 1
		DB	0DH SHL 1,0AH SHL 1,00

Display_Eval_Message	PROC	NEAR
	MOV	SI,OFFSET Eval_Message		;Yes-Get ptr to eval message
	MOV	CL,01				;Shift right 1 bit
	CALL	Display_Message 		;Display the message
	RET
Display_Eval_Message	ENDP

;***********************************************************************
;   Display the specified message to the screen using the teletype
;   function of interrupt 10.
;
;   Entry: SI - Address of message located in CS segment
;***********************************************************************

Display_Message PROC	NEAR
	XOR	BH,BH				;Always use page zero

Next_Print_Char:
	MOV	AH,0EH				;No -Get teletype function
	LODS	BYTE PTR CS:[SI]		;Get character from msg
	SHR	AL,CL				;Convert if necessary
	TEST	AL,AL				;Are we at the end of msg
	JE	Exit_DM 			;Yes-Done with message
	INT	10H				;Print the character
	JMP	Next_Print_Char 		;Continue printing string

Exit_DM:
	RET
Display_Message ENDP

VGA_Segment	ENDS

		END
