	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module L
;****************************************************************
;
;	$Workfile:   oem.asm  $
;
;	Contents:
;
;	Modification History:
;	$Log:   M:/vcs/vga/64xx/oem.asv  $
;      
;
;****************************************************************

	.XLIST
	include		config.inc
	include		font.inc
	include		options.inc
	INCLUDE VGADATA.INC
	.LIST

	%OUT	Assembling OEM

cgroup	group	VGA_Segment

VGA_Segment SEGMENT BYTE PUBLIC

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Segment
	ASSUME	ES:NOTHING

;
; OEM data type equates
;
BIN_BYTE	equ	01h		; binary      byte data type
BIN_WORD	equ	02h		; binary      word data type
DEC_BYTE	equ	03h		; decimal     byte data type
DEC_WORD	equ	04h		; decimal     word data type
HEX_BYTE	equ	05h		; hexadecimal byte data type
HEX_WORD	equ	06h		; hexadecimal word data type
Y_N_BYTE	equ	07h		; yes or no kind of data type
STRING		equ	08h		; ascii string data
END_OEM		equ	0ffh		; end of OEM data

;
; OEM data structure
;
oemdata		struc
  type2		db	?		; data type
  offset2	dw	?		; starting location
  length2	dw	?		; length of the data items
oemdata		ends

MSG_MAX_LEN	equ	50h*2		; message string length
		extrn	font_ptr:near	; offset of font pointer table

if BIOS eq ROM
		extrn	Quadtel_Msg:near; offset of CL sign on message
else
		Quadtel_Msg	label	near	; keep LINK happy
				public	Quadtel_Msg
endif

bios_id		db	CHIP_TYPE	; Chip Version
bios_version	dw	BIOS_VER	; Bios Version

chip_revision	db	0		; ignored for Eagle
id_code		dw	PRODUCT_ID

cfg_tbl_2	label	byte		; secondary configuration table
;
;
; The following data definition is needed by OEMSI output heading
;
chip_supported	label byte
	db	'GD64XX',0	;WARNING: If this line EVER changes OEMSI needs to be updated.
	db	'GD54XX',0
	db	'GD62XX',0
	db	0		; dual-null-terminated

; Font pointer table
;
		db	NUM_FONTS	; number of fonts in the ROM
		dw	offset cgroup:font_ptr
		db	NUM_PANEL_TYPES	; number of panel type supported
;
; Cirrus Logic Sign On
;
cl_msg_offset	dw	offset cgroup:Quadtel_Msg; offset of CL sign on message

;
; The following data contains can't-be-categorized items. Any weird item
; will be added here with the side effect that OEMSI utility should be
; modified to support it. Use of pre-defined structure is recommended if
; possible.
;

		;
		; more irregular items can be placed here !!
		;
;
; The following data structures are pre-defined so that the OEMSI utility
; knows how to interpret them. As usual, new data item can simply be
; added to proper data structure.
;
cfg_tbl		label	near
		public	cfg_tbl

		dw	offset cgroup:cfg_tbl_2	; secondary config table

		oemdata <BIN_BYTE,bin_byte_tbl,BIN_BYTE_CNT>
		oemdata <BIN_WORD,bin_word_tbl,BIN_WORD_CNT>

		oemdata <DEC_BYTE,dec_byte_tbl,DEC_BYTE_CNT>
		oemdata <DEC_WORD,dec_byte_tbl,DEC_WORD_CNT>
			 
		oemdata <HEX_BYTE,hex_byte_tbl,HEX_BYTE_CNT>
		oemdata <HEX_WORD,hex_byte_tbl,HEX_WORD_CNT>

		oemdata <Y_N_BYTE,y_n_byte_tbl,Y_N_BYTE_CNT>

		extrn	OEM_Msg:near
		oemdata <STRING,  OEM_Msg,     MSG_MAX_LEN>
;gdl		oemdata <STRING,  cust_msg,    MSG_MAX_LEN>

		db	END_OEM			; end of OEM data

;
; binary, byte data item
;
bin_byte_tbl	label	byte

		public 	use_switches
use_switches	db	0A0h		; bit[7]->1=use dip switches for panel
					; bit[6]=>1=Supress bold font query
					; bit[5]=>1=supress setmode int 15h
					; bit[4]=>1=supress bold font int 15h
					; bit[3:0] =panel type if [7]=0
		public	avga_confbyte
avga_confbyte	db     000h		; bit[7]->0=EEprom is installed
					;         1=No EEprom is on adapter
					; bit[6]->0=Use SR08 for Mntr Switch
					;	  1=Use SR07 for Mntr Switch
					; bit[5]->0=Use SR08 for Panel Switch
					;	  1=Use SR07 for Panel Switch
					; bit[4]->0=No PI Bus Implementation
					;	  1=PI Bus enable @ POST
					; bit[3]->0=No Local Bus Implementation
					;	  1=L.B, Force MEMCS16 enable  
					; bit[2]->0=use analog monitor detect
					;	  1=use dip switches         
					; bit[1]->1=support 1Kx768 256C non-interlaced mode
					;         for AVGA2M/1MB memory
					;         0=no support
					; bit[0]->1=Avga2mr1 allowing spec
					; 	  0=stretching modes
		public	red_confbyte
;red_confbyte	db	14h
red_confbyte	db	10h
		public	green_confbyte
;green_confbyte	db	14h
green_confbyte	db	10h
		public	blue_confbyte
;blue_confbyte	db	14h
blue_confbyte	db	10h
		public	MClk5430
MClk5430	db	1Ch
BIN_BYTE_CNT	= $ - bin_byte_tbl
;
; binary, word data item
;
bin_word_tbl	label	byte

;** reserved for new item

BIN_WORD_CNT	= $ - bin_word_tbl


;
; hexdecimal, byte data item
;
hex_byte_tbl	label	byte

ifdef  (MONTYPE_VERT)
	ifdef (ALP_NEW)
;				 1024 x 768 frequency
;				 800 x 600 frequency
;				 RESERVED FOR OEM'S!(NEVER USE SR09)
;				   
	rom_opt1	db	01000100b	; SR09
	else	; (ALP_NEW)
;				 1024 x 768 frequency
;				 800 x 600 frequency
;				 Maximum resolution
;				 1280x1024 frequency RESERVED FOR OEM'S!(NEVER USE SR15)
	rom_opt1	db	10011000b	; SR09
	endif	; (ALP_NEW)

;cth	rom_opt1	db	00001000b	; SR09
else   ;(MONTYPE_VERT)
;				 Reserved
;				 Monitor Type
;				 RESERVED FOR OEM'S!(NEVER USE SR15)
	rom_opt1	db	00001100b	; SR09
endif  ;(MONTYPE_VERT)

	ifdef (ALP_NEW)
;				 Maximum resolution
;				 1280x1024 frequency
;				 High Refresh (0=60Hz, 1=High Refresh Flag)
	rom_opt2	db	00110000b	; SR0A
	else	; (ALP_NEW)
;				 Unused
;				 High Refresh (0=none, 1=high)
;				 Unused
;				 Video Memory Size
;				 CL-GD5420r1 Fixup
;				 16/8-bit mem(1=16bit, 0=8bit)
	rom_opt2	db	00000001b	; SR0A
	endif	; (ALP_NEW)

	ifdef (ALP_NEW)
;				 Reserved
;				 640X480@75Hz Default
;				 DPMS
	rom_opt3	db	00001000b	; SR14
;				 Reserved
;				 Horizontal Montype
;				 Video Memory Size
	rom_opt4	db	00000001b	; SR15
	endif	; (ALP_NEW)

			db 2 dup (00h)
		public	rom_opt1,rom_opt2
HEX_BYTE_CNT	= $ - hex_byte_tbl

;
; hexdecimal, word data item
;
hex_word_tbl	label	byte

;** reserved

HEX_WORD_CNT	= $ - hex_word_tbl

;
; yes(01) or no(00) data item
; 
y_n_byte_tbl	label	byte

	public	cl_isdisp	
	public	cust_isdisp
cl_isdisp	db	ISDISP_CL	; 1=display signon,0=no display
cust_isdisp	db	ISDISP_CUST	; 1=display signon,0=no display
Y_N_BYTE_CNT	= $ - y_n_byte_tbl


;
; decimal, byte data item
;
dec_byte_tbl	label	byte

cl_curpos	label	word		; row,col to display sign on
  cl_col	db	CURPOS_CL_COL	; column position
  cl_row	db	CURPOS_CL_ROW	; row position

cust_curpos1	label	word		; row,col to display sign on
  cust_col1	db	0ffh		; column position
  cust_row1	db	0ffh		; row position

cust_curpos2	label	word		; cursor position after POST
  cust_col2	db	0ffh		; column position
  cust_row2	db	0ffh		; row position

DEC_BYTE_CNT	= $ - dec_byte_tbl

;
; decimal, word data item
;
dec_word_tbl	label	byte

;** reserved

DEC_WORD_CNT	= $ - dec_word_tbl

	public	bios_date_msg
bios_date_msg	label	byte
;	db cProductName
;	db ' '
	db BIOS_DATE
;	db BIOS_TYPE_DATE
	db 0Dh,0Ah,00h

if 0
;
; string data items
; -----------------

;
; customer sign on message
;
cust_msg	db	13,10

		db	0
		db	(MSG_MAX_LEN - ($ - cust_msg)) dup (0)

;-----------------------------------------------------------------------
;
;	disp_signon()
;
;	Function:
;	   Conditionally display Cirrus Logic and custom sign on
;	message.
;
;	Input:
;
;	Returns:
;
;	Remarks:
;	   Destroys AX,BX,DX
;
;-----------------------------------------------------------------------
disp_signon	proc	near
		public	disp_signon

		push	ds		; save data segment
		push	cs		; cs to our data segment
		pop	ds

		mov	ah,02h		; set cursor position
		xor	bx,bx		; page
		mov	dx,cl_curpos	; row,col to DX
		int	10h

		cmp	cl_isdisp,NO	; disp CL sign on?
		je	chk_cust	; nope

		mov	si,cl_msg_offset; offset of string to print
		call	print_string	; print it

chk_cust:	cmp	cust_isdisp,NO	; display Custom sign on?
		je	chk_curs2	; nope, check custom cursor postion

		cmp	cust_curpos1,0ffffh; display at cursor?
		je	disp_custom	; yup

		mov	ah,02h		; set cursor position
		mov	dx,cust_curpos1	; row,col to DX
		int	10h

disp_custom:	mov	si,offset cgroup:cust_msg; custom message
		call	print_string	; print it

chk_curs2:	cmp	cust_curpos2,0ffffh; set cursor?
		je	disp_exit	; nope

		mov	ah,02h		; set cursor position
		mov	dx,cust_curpos2	; row,col to DX
		int	10h

disp_exit:	pop	ds		; restore data segment
		ret			; return to caller
disp_signon	endp

;-----------------------------------------------------------------------
;
;	print_string()
;
;	Function:
;	   Display with wr_tty null terminated string.
;
;	Input:		       
;          DS:SI -> pointer to string
;
;	Returns:
;
;	Remarks:
;	   Destroys AX.
;
;-----------------------------------------------------------------------
print_string	proc	near
		public	print_string

prt_loop:	lodsb	   		; character to al
		cmp	al,0		; end of string?
		je	print_done	; yup
		mov	ah,0eh		; write tty
		int	10h
		jmp	short prt_loop	; do next character

print_done:	ret			; return to caller
print_string	endp

endif	;0

VGA_Segment		ends
		end
