page		60,132
title		VESA VGA BIOS Extension Functions

;****************************************************************
;
;	$Workfile:   clvesa.asm  $
; 
; 
;	Contents:
;
; 	Modification History:
; 	$Log:   M:/vcs/vga/54xx/clvesa.asv  $
;      
;      
;****************************************************************
cgroup		group	VGA_Segment

	.XLIST
	include		config.inc
	include		font.inc
	include		biosdata.inc
	include		options.inc
	include		argframe.inc
	include		struc.inc
	INCLUDE VGADATA.INC
	.LIST

	%OUT	Assembling CLVESA

cgroup		group	VGA_Segment

VGA_Segment	SEGMENT PUBLIC BYTE

	ASSUME	CS:cgroup
	ASSUME	DS:bios_data
	ASSUME	ES:NOTHING

ifdef VESAVBEVERSION
;
; utilities
		extrn	getreg		:near	; get an indexed register
		extrn	GetMemSize	:near	; Get memory size in AL (64K blocks)
		extrn	GetModeTblPtr	:near	; Get mode table pointers

		public	VesaVBE
		public	Int10h			;v1.31 jliu

if (VESAVBEVERSION ge 101h)
		extrn	get_crtc_addr	:near
		extrn	getreg		:near	; get an indexed register
		extrn	Set_Palette	:near
endif	;(VESAVBEVERSION ge 101h)
ifdef  (XGA_BUG)
		extrn	Is_Chip_Unlocked:near
endif  ;(XGA_BUG)


if (CHIP_FAMILY ne GenericVGA)			;v1.31 jliu
	extrn	Direct_Video_Interface:near	;v1.31 jliu
endif	;(CHIP_FAMILY ne GenericVGA)		;v1.31 jliu

	extrn	wait_vretrace		:near	;v0.05B1
;-----------------------------------------------------------------------
;VESA VBE version number.  Returned by VESA VBE FN 00h:Return SuperVGA 
;Information. 

cMemInvalid	equ	00h
cMemText	equ	01h
cMemCgaGrfx	equ	02h
cMem16Grfx	equ	03h
cMem256Grfx	equ	04h
if (MODEDIRECTCOLOR eq YES)
cMemDCGrfx	equ	05h
endif	;(MODEDIRECTCOLOR eq YES)

cSegGrfx	equ	0A000h
cSegMText	equ	0B000h
cSegCText	equ	0B800h

rAttrAddr	equ	3C0h
rRMiscOutp	equ	3CCh
;rWMiscOutp	equ	3C2h
rCrtcColor	equ	3D4h
rCrtcMono	equ	3B4h

;-----------------------------------------------------------------------

cVbeMemMdlText		equ	00h
cVbeMemMdlCgaGrfx	equ	01h
cVbeMemMdlHgcGrfx	equ	02h
cVbeMemMdl16Grfx	equ	03h
cVbeMemMdlPackPix	equ	04h
;cVbeMemMdlSequ256	equ	05h
if (MODEDIRECTCOLOR eq YES)
cVbeMemMdlDirect	equ	06h
endif	;(MODEDIRECTCOLOR eq YES)
;cVbeMemMdlYUV		equ	07h
VesaVbeDpms		equ	10h		;v1.32 jliu

;-----------------------------------------------------------------------
;
;	VESA VBE v1.X
;
;	Input:
;	    ax = 4f00h VESA:Return Super VGA Information
;	    es:di -> 256-byte information block
;	Returns:
;	    ax = Status
;
;	Input:
;	    ax = 4f01h VESA:Return Super VGA Mode Information
;	    cx = Super VGA mode number
;	    es:di -> 256-byte information block
;	Returns:
;	    ax = Status
;
;	Input:
;	    ax = 4f02h VESA:Set Super VGA Mode
;	    bx = Super VGA mode number
;	Returns:
;	    ax = Status
;
;	Input:
;	    ax = 4f03h VESA:Get Super VGA Mode
;	Returns:
;	    ax = Status
;	    bx = Super VGA mode number
;
;	Input:
;	    ax = 4f04h VESA:Save/Restore Super VGA State
;	    cx = Requested states
;	    dl = 00h Return buffer size
;	Returns:
;	    ax = Status
;	    bx = Required buffer size, in 64-byte blocks
;
;	Input:
;	    ax = 4f04h VESA:Save/Restore Super VGA State
;	    cx = Requested states
;	    dl = 01h Save state
;	    es:bx -> buffer of sufficient size
;	Returns:
;	    ax = Status
;
;	Input:
;	    ax = 4f04h VESA:Save/Restore Super VGA State
;	    cx = Requested states
;	    dl = 02h Restore state
;	    es:bx -> buffer of previously saved information
;	Returns:
;	    ax = Status
;
;	Input:
;	    ax = 4f05h VESA:CPU Video Memory Control
;	    bh = 00h Set Super VGA video memory windows
;	    bl = Window # (0=A,1=B)
;	    dx = Window position (in win gran units)
;	Returns:
;	    ax = Status
;
;	Input:
;	    ax = 4f05h VESA:CPU Video Memory Control
;	    bh = 01h Get Super VGA video memory windows
;	    bl = Window # (0=A,1=B)
;	Returns:
;	    ax = Status
;	    dx = Window position (in win gran units)
;
;	Input:
;	    ax = 4f06h VESA:Set/Get Logical Scan Line Length
;	    bl = 00h Select Scan Line Length
;	    cx = Desired width in pixels
;	Returns:
;	    ax = Status
;	    bx = bytes per scan line
;	    cx = actual pixels per scan line
;	    dx = maximum number of scan lines
;
;	Input:
;	    ax = 4f06h VESA:Set/Get Logical Scan Line Length
;	    bl = 01h Return Scan Line Length
;	Returns:
;	    ax = Status
;	    bx = bytes per scan line
;	    cx = actual pixels per scan line
;	    dx = maximum number of scan lines
;
;	Input:
;	    ax = 4f07h VESA:Set/Get Display Start
;	    bl = 00h Select Display Start
;	    bh = 00h Reserved
;	    cx = X coord (in pixels)
;	    dx = Y coord (in pixels)
;	Returns:
;	    ax = Status
;
;	Input:
;	    ax = 4f07h VESA:Set/Get Display Start
;	    bl = 01h Return Display Start
;	Returns:
;	    ax = Status
;	    bh = 00h Reserved
;	    cx = X coord (in pixels)
;	    dx = Y coord (in pixels)
;
;	Input:
;	    ax = 4f08h VESA:Set/Get DAC Palette Control
;	    bl = 00h Set DAC Palette Width
;	    bh = Desired number of bits/color (Default=6)
;	Returns:
;	    ax = Status
;	    bh = Current number of bits/color (Normal=6)
;	
;	Input:
;	    ax = 4f08h VESA:Set/Get DAC Palette Control
;	    bl = 01h Get DAC Palette Width
;	Returns:
;	    ax = Status
;	    bh = Current number of bits/color (Normal=6)
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;Structure definition of return buffer from VESA VBE FN 00h:Return SuperVGA 
;Information. 

VgaInfoBlock	struc
	VESASignature	db 4 dup (?)
	VESAVersion	dw ?
	OEMStringPtr	dw ?
			dw ?
	Capabilities	dd ?
	VideoModePtr	dw ?			;Build this list in tail
			dw ?			;of Info structure?
	TotalMemory	dw ?			;VBE v1.1+
;	Reserved	db (256-$) dup (00h)
VgaInfoBlock	ends

;-----------------------------------------------------------------------
;Structure definition of return buffer from VESA VBE FN 01h:Return SuperVGA 
;Mode Information. 

ModeInfoBlock	struc
	ModeAttributes		dw ?
	WinAAttributes		db ?
	WinBAttributes		db ?
	WinGranularity		dw ?
	WinSize			dw ?
	WinASegment		dw ?
	WinBSegment		dw ?
	WinFuncPtr		dd ?
	BytesPerScanLine	dw ?

	XResolution		dw ?
	YResolution		dw ?
	XCharSize		db ?
	YCharSize		db ?
	NumberOfPlanes		db ?
	BitsPerPixel		db ?
	NumberOfBanks		db ?
	MemoryModel		db ?
	BankSize		db ?
if (VESAVBEVERSION ge 101h)
	NumberOfImagePages	db ?
	Reserved		db ?
if (VESAVBEVERSION ge 102h)
	RedMaskSize		db ?
	RedFieldPosition	db ?
	GreenMaskSize		db ?
	GreenFieldPosition	db ?
	BlueMaskSize		db ?
	BlueFieldPosition	db ?
	RsvdMaskSize		db ?
	RsvdFieldPosition	db ?
	DirectColorModeInfo	db ?
endif	;(VESAVBEVERSION ge 102h)
endif	;(VESAVBEVERSION ge 101h)
;	Reserved	db (256-$) dup (00h)
ModeInfoBlock	ends

;-----------------------------------------------------------------------
;ASCIZ string for OEM card type.  A pointer to this string is returned by
;VESA VBE FN 00h:Return SuperVGA Information. 

CLOEMString	db 'Cirrus Logic GD-'
	db cProductName
	db ' VGA',00h

;-----------------------------------------------------------------------
;Instance of blank SuperVGA Information block.  Used to fill in SuperVGA
;Information structure.

;VbeSvgaInfoBlock	VgaInfoBlock	<	\
;	'VESA',					\	;VESASignature
;	VESAVBEVERSION,				\	;VESAVersion
;	offset cgroup:CLOEMString,0C000h,	\	;OEMStringPtr
;	00000000h,				\	;Capabilities
;	0000h,0000h,				\	;VideoModePtr
;	256/64>						;TotalMemory

;-----------------------------------------------------------------------
;-----------------------------------------------------------------------

VesaVBEFuncTbl	label	word
	dw offset VbeSvgaInfo
	dw offset VbeModeInfo
	dw offset VbeSetMode
	dw offset VbeGetMode
	dw offset VbeState
	dw offset VbeWinCtrl
ifndef	(VESA_LITE)
  if (VESAVBEVERSION ge 101h)
	dw offset VbeScanLineCtrl
	dw offset VbeDispStartCtrl
    if (VESAVBEVERSION ge 102h)
	dw offset VbeDacPalCtrl
    endif   ;(VESAVBEVERSION ge 102h)
  endif	  ;(VESAVBEVERSION ge 101h)
endif	;(VESA_LITE)
cMaxVesaVBEFunc	equ (($ - offset VesaVBEFuncTbl)/2)-1

VesaVbeDpmsTbl	label	word		;v1.32 jliu
	dw	offset	VbePMCapabilities
	dw	offset	VbeSetPWState
	dw	offset	VbeGetPWState
NumOfVesaVbeDpmsTbl equ (($ - offset VesaVbeDpmsTbl)/2)-1

;-----------------------------------------------------------------------
;Entry point for VESA VBE functions.  Assumes that this is a VESA VBE
;Extension call.
;Entry:	AL = VESA VBE Sub-function number
;	

VesaVBE	proc	near

ifdef  (XGA_BUG)
	call	Is_Chip_Unlocked	;Are extentions available?
	jne	VesaVBEAbort		;invalid function -->> abort
allow_vesa_func:
endif  ;(XGA_BUG)

ifdef	(VESA_LITE)
VbeGetMode:				; Put these labels anywhere.
VbeState:
	cmp	al,5			; Function 5?
	je	good_vesa		; yes, will allow dispatch
	cmp	al,02h			; In LITE support, 3 & 4 are invalid
good_vesa:
else	;(VESA_LITE)
	cmp	al,VesaVbeDpms		;v1.32 jliu
	jnz	short FunChecking	;v1.32
	jmp	VesaVbeDpmsHandler	;v1.32
FunChecking:				;v1.32 jliu
	cmp	al,cMaxVesaVBEFunc	;Check for valid function call
endif	;(VESA_LITE)
	ja	VesaVBEAbort		;Invalid function -->> abort

	cbw			;Expand subFn to word
	mov	si,ax		;Plop it in SI

	shl	si,1		;Word CALL offset table
	call	cs:[si+VesaVBEFuncTbl]	;Call requested VESA Fn
	jmp	short VesaVBEExit	;Exit with any returns

VesaVBEAbort:			;Unknown Fn.  Abort with error.
	xor	al,al
VesaVBEExit:			;Exit point.
	cmp	al,4fh		;See if function supported.
	jne	VesaVBEDone	;If not, then don't trash stack, and NZ flag set
	mov	w_ax[bp],ax	;Place return value on stack
				;Set ZF if we were successful, so INT 42H
VesaVBEDone:			; won't be called.
	ret

VesaVBE	endp

;-----------------------------------------------------------------------
;Input:
;    ax = 4f00h VESA:Return Super VGA Information
;    es:di -> 256-byte buffer
;Returns:
;    ax = Status
;    es:di -> 256-byte Super VGA information block

VbeSvgaInfo	proc	near

	push	ds
	push	di
	push	cx

	mov	cx,20/2			;v1.40 3  for MOZDEMO.EXE
	call	clear_buffer

	mov	cx,es
	mov	ds,cx

	mov	word ptr ds:[di].VesaSignature  ,'EV'
	mov	word ptr ds:[di].VesaSignature+2,'AS'
	mov	ds:[di].VesaVersion,VESAVBEVERSION
	mov	ds:[di].OEMStringPtr  ,offset CLOEMString

	mov	ds:[di].OEMStringPtr+2,cs	;Patch up segment reference

	call	GetMemSize
	mov	ds:[di].TotalMemory,ax		;AX = # of 64K blocks

	mov	ax,di		;Calc tail offset where mode list will be built
	add	ax,SIZE VgaInfoBlock
	mov	ds:[di].VideoModePtr  ,ax	;Store ptr to tail
	mov	ds:[di].VideoModePtr+2,es
	mov	di,ax				;ES:DI -> tail area for mode list
ifdef	(VESA_LITE)
	mov	ax,0101h
	stosw
else	;(VESA_LITE)
	mov	cx,0014h			;First possible extended mode

VbeSvgaInfoLoop:
	mov	ax,cx
	push	es
	push	di
	call	GetModeTblPtr
	mov	si,es
	mov	ds,si
	mov	si,di
	pop	di
	pop	es
	cmp	si,0FFFFh
	je	VbeSvgaInfoNext

	mov	ax,ds:[si].s_vesa	;Does extd mode have a VESA 15-bit num?
	or	ax,ax
	jnz	VbeSvgaInfoStoreMode	;Yes:Store OEM mode in list 

	mov	al,ds:[si].s_mode	; a VESA 15-bit mode number.
VbeSvgaInfoStoreMode:
	stosw				;Yes:Store VESA mode in list, not OEM.

VbeSvgaInfoNext:
	inc	cx
	cmp	cl,80h
	jb	VbeSvgaInfoLoop

VbeSvgaInfoDone:
endif	;(VESA_LITE)
	mov	ax,-1			;Terminate list correctly.
	stosw

	pop	cx
	pop	di
	pop	ds
	mov	ax,004fh		;Function supported and successful
	ret

VbeSvgaInfo	endp

;-----------------------------------------------------------------------
;Input:
;    ax = 4f01h VESA:Return Super VGA Mode Information
;    cx = Super VGA mode number
;    es:di -> 256-byte information block
;Returns:
;    ax = Status

VbeModeInfo	proc	near

	push	ds
	push	di
	push	cx
	push	bx

	and	ch,7Fh		;Clear !CLS flag for stupid FRACTINT bug.

	mov	bx,cx
	mov	cx,256/2	;v1.40 3
	call	clear_buffer

	mov	al,bl
	test	bx,7f80h
	jz	VbeModeInfoLookup

	mov	al,0FFh
VbeModeInfoLookup:
	xor	ah,ah

	push	es
	push	di
	call	GetModeTblPtr
	mov	si,es
	mov	ds,si
	mov	si,di
	pop	di
	pop	es
	cmp	si,0FFFFh
	jne	VbeModeInfoFound
	jmp	VbeModeInfoError

VbeModeInfoFound:		;DS:SI -> correct supp struc
				;ES:DI -> unfilled VESA mode info struc
	mov	ax,ds:[si].s_horz
	mov	es:[di].XResolution,ax

	mov	ax,ds:[si].s_vert
	mov	es:[di].YResolution,ax

	mov	al,ds:[si].s_colors
	mov	es:[di].BitsPerPixel,al

	mov	al,ds:[si].s_xchar
	mov	es:[di].XCharSize,al

	mov	al,ds:[si].s_ychar
	mov	es:[di].YCharSize,al

	mov	es:[di].NumberOfPlanes,01h

	mov	al,ds:[si].s_miscinfo
	xor	ah,ah
;++Check if mode is currently available
	or	al,01h			;Mode available
	mov	es:[di].ModeAttributes,ax

	mov	al,ds:[si].s_memmodel
	mov	es:[di].MemoryModel,al

	push	ds
	mov	bx,es
	mov	ds,bx
	mov	ds:[di].WinAAttributes,07h
	mov	ds:[di].WinASegment,cSegGrfx
	mov	ds:[di].WinGranularity,0004h
	pop	ds

	test	ds:[si].s_gr0B,020h
	mov	ds,bx
	jz	keep_granularity
	mov	ds:[di].WinGranularity,0010h
keep_granularity:
	mov	ds:[di].WinSize,64
	mov	word ptr ds:[di].WinFuncPtr  ,offset VbeFarWinCtrl
	mov	word ptr ds:[di].WinFuncPtr+2,cs

	mov	ds:[di].NumberOfBanks,01h
if (VESAVBEVERSION ge 101h)
	mov	ds:[di].Reserved,1h
endif	;(VESAVBEVERSION ge 101h)

	cbw
	mov	bx,ax
	shl	bx,1
	jmp	word ptr cs:[VbeMIModeTbl+bx]

VbeMIModeTbl	label	word
	dw	VbeModeInfoText
	dw	VbeModeInfoCga
	dw	VbeModeInfoHgcGrfx
	dw	VbeModeInfoGrfx16
ifdef cVbeMemMdlPackPix
	dw	VbeModeInfoPackedPix
	dw	VbeModeInfoSequ256
ifdef cVbeMemMdlDirect
	dw	VbeModeInfoDirect
ifdef cVbeMemMdlYUV
	dw	VbeModeInfoYUV
endif	;cVbeMemMdlYUV
endif	;cVbeMemMdlDirect
endif	;cVbeMemMdlPackPix

VbeModeInfoText:
	mov	ds:[di].WinBAttributes,00h
	mov	ds:[di].WinGranularity,20h	;gdl:3/4/92 don't hang VTEST
	mov	ds:[di].WinSize,32
	mov	ds:[di].WinASegment,cSegCText
	mov	ds:[di].WinBSegment,00000h
	test	ds:[di].ModeAttributes,08h
	jnz	VbeModeInfoTextColor
	mov	ds:[di].WinASegment,cSegMText
VbeModeInfoTextColor:
	mov	word ptr ds:[di].WinFuncPtr  ,0000h
	mov	word ptr ds:[di].WinFuncPtr+2,0000h

	mov	ax,ds:[di].XResolution
	div	ds:[di].XCharSize
	xor	ah,ah
	mov	ds:[di].XResolution,ax

	mov	ax,ds:[di].YResolution
	div	ds:[di].YCharSize
	xor	ah,ah
	mov	ds:[di].YResolution,ax

	mov	ax,ds:[di].XResolution
	shl	ax,1
	mov	ds:[di].BytesPerScanLine,ax

if (VESAVBEVERSION ge 101h)
;gdl:04/02/92 Add support for multiple image pages.
	mov	bx,ax
	mov	ax,8000h
	xor	dx,dx
	div	bx
	div	byte ptr ds:[di].YResolution
	mov	byte ptr ds:[di].NumberOfImagePages,al
endif	;(VESAVBEVERSION ge 101h)

	jmp	VbeModeInfoSuccessful 

VbeModeInfoGrfx16:
;v0.08B5{
	mov	ax,0100h
	cmp	cs:[si].s_vesa,106h	;For CSHOW 1280x1024x16 issue!!!
	jz	short Vmode106
;v0.08B5}
	mov	ax,ds:[di].XResolution
	shr	ax,1
	shr	ax,1
	shr	ax,1
Vmode106:
	mov	ds:[di].BytesPerScanLine,ax

if (VESAVBEVERSION ge 101h)
;gdl:04/02/92 Add support for multiple image pages.

	call	common_1

	call	common_2

endif	;(VESAVBEVERSION ge 101h)

	mov	ds:[di].NumberOfPlanes,04h
	jmp	VbeModeInfoSuccessful 

ifdef cVbeMemMdlPackPix
VbeModeInfoPackedPix:
	mov	ax,ds:[di].XResolution
	mov	ds:[di].BytesPerScanLine,ax

if (VESAVBEVERSION ge 101h)
;gdl:04/02/92 Add support for multiple image pages.

	call	common_1

	call	common_3

endif	;(VESAVBEVERSION ge 101h)
	jmp	VbeModeInfoSuccessful 
endif	;cVbeMemMdlPackPix

ifdef cVbeMemMdlSequ256
VbeModeInfoSequ256:
	mov	ax,ds:[di].XResolution
	shr	ax,1
	shr	ax,1
	mov	ds:[di].BytesPerScanLine,ax

if (VESAVBEVERSION ge 101h)
;gdl:04/02/92 Add support for multiple image pages.

	call	common_1

	call	common_2

endif	;(VESAVBEVERSION ge 101h)

	mov	ds:[di].NumberOfPlanes,04h
	jmp	short VbeModeInfoSuccessful 
endif	;cVbeMemMdlSequ256

ifdef cVbeMemMdlDirect
VbeModeInfoDirect:
	mov	ax,ds:[di].XResolution
	shl	ax,1				;++Note:Assuming 16-bit
	cmp	ds:[di].BitsPerPixel,24
	jne	VbeModeInfoDirectCont
;v0.08B3{
	test	cs:[si].s_gr0B,020h
	jz	short Non32bits	
	shl	ax,1
	jmp	short VbeModeInfoDirectCont
Non32bits:
	mov	ax,2048
	mov	es:[di].BytesPerScanLine,ax
;v0.08B3}
VbeModeInfoDirectCont:
	mov	ds:[di].BytesPerScanLine,ax

if (VESAVBEVERSION ge 101h)
;gdl:04/02/92 Add support for multiple image pages.

	call	common_1

	call	common_3

endif	;(VESAVBEVERSION ge 101h)

if (VESAVBEVERSION ge 101h)
if (VESAVBEVERSION ge 102h)
	mov	ds:[di].RedMaskSize,5
	mov	ds:[di].RedFieldPosition,11
	mov	ds:[di].GreenMaskSize,6
	mov	ds:[di].GreenFieldPosition,5
	mov	ds:[di].BlueMaskSize,5

	cmp	ds:[di].BitsPerPixel,15
	jne	VbeModeInfoDCCont
	mov	ds:[di].RedFieldPosition,10
	mov	ds:[di].GreenMaskSize,5
VbeModeInfoDCCont:
	cmp	ds:[di].BitsPerPixel,24
	jne	VbeModeInfoDirectDone
;v0.08B3{
	test	cs:[si].s_gr0B,020h
	jz	short NoAdjBitsPerPix
	mov	es:[di].BitsPerPixel,32
NoAdjBitsPerPix:
;v0.08B3{
	mov	ds:[di].RedMaskSize,8
	mov	ds:[di].RedFieldPosition,16
	mov	ds:[di].GreenMaskSize,8
	mov	ds:[di].GreenFieldPosition,8
	mov	ds:[di].BlueMaskSize,8
VbeModeInfoDirectDone:
endif	;(VESAVBEVERSION ge 102h)
endif	;(VESAVBEVERSION ge 101h)
	jmp	short VbeModeInfoSuccessful 
endif	;cVbeMemMdlDirect

ifdef cVbeMemMdlYUV
VbeModeInfoYUV:
	mov	ax,ds:[di].XResolution
	shl	ax,1				;++Note:Assuming 16-bit 
	mov	ds:[di].BytesPerScanLine,ax

if (VESAVBEVERSION ge 101h)
;gdl:04/02/92 Add support for multiple image pages.

	call	common_1

	call	common_3

endif	;(VESAVBEVERSION ge 101h)

if (VESAVBEVERSION ge 101h)
if (VESAVBEVERSION ge 102h)
	mov	ds:[di].RedMaskSize,8
	mov	ds:[di].RedFieldPosition,8
	mov	ds:[di].GreenMaskSize,4
	mov	ds:[di].GreenFieldPosition,4
	mov	ds:[di].BlueMaskSize,4
endif	;(VESAVBEVERSION ge 102h)
endif	;(VESAVBEVERSION ge 101h)
	jmp	short VbeModeInfoSuccessful 
endif	;cVbeMemMdlYUV

VbeModeInfoSuccessful:

if (VESAVBEVERSION ge 101h)
	dec	byte ptr ds:[di].NumberOfImagePages
endif	;(VESAVBEVERSION ge 101h)

	mov	ax,004fh
	jmp	short VbeModeInfoExit

VbeModeInfoCga:
VbeModeInfoHgcGrfx:
ifndef cVbeMemMdlSequ256
	VbeModeInfoSequ256:
endif	;cVbeMemMdlSequ256
ifndef cVbeMemMdlDirect
	VbeModeInfoDirect:
endif	;cVbeMemMdlDirect
ifndef cVbeMemMdlYUV
	VbeModeInfoYUV:
endif	;cVbeMemMdlYUV
VbeModeInfoError:
	mov	ax,014fh

VbeModeInfoExit:
	pop	bx
	pop	cx
	pop	di
	pop	ds
	ret

if (VESAVBEVERSION ge 101h)
common_1:
	mov	bx,ax
	call	GetMemSize	;AL = memory size, in 64K blocks
	xor	dh,dh
	mov	dl,al
	xor	ax,ax		;DX:AX = the size of memory in bytes
	ret

common_2:
	shl	bx,1
	shl	bx,1
common_3:
	div	bx

	xor	dx,dx
	div	word ptr ds:[di].YResolution
	mov	byte ptr ds:[di].NumberOfImagePages,al
	ret

endif	;(VESAVBEVERSION ge 101h)



VbeModeInfo	endp

;-----------------------------------------------------------------------
;Input:
;    ax = 4f02h VESA:Set Super VGA Mode
;    bx = Super VGA mode number
;Returns:
;    ax = Status

VbeSetMode	proc	near

	push	bx

	mov	ax,bx
	and	ah,80h

	test	bx,7f80h
	jz	VbeSetModeNormal

	and	bh,7fh
	call	MapVesa2CLMode

	or	al,al
	jz	VbeSetModeError

VbeSetModeNormal:

	push	ax		;Save video mode

	or	al,ah		;OR in the !CLS flag
	xor	ah,ah		;VGA set mode
;v1.31	int	10h		;Attempt to set it
	call	Int10h		;v1.31 jliu

	mov	ah,0Fh		;Now to check if we succeeded
;v1.31	int	10h		;Get our current mode
	call	Int10h		;v1.31 jliu
	and	al,7Fh		;Discard !Cls flag

	pop	bx		;Get back requested mode
	cmp	al,bl		;Does requested == current?
	jne	VbeSetModeError	;Nope, not equal, so report failure
;v0.08B5{
	cmp	al,6Ch		;For CSHOW 1280x1024x16 issue!!!
	jnz	short NoModifyCR13
	mov	ax,8013h
	mov	dx,3D4h
	out	dx,ax
NoModifyCR13:
;v0.08B5}
	mov	ax,004fh	;Success!

VbeSetModeExit:
	pop	bx
	ret

VbeSetModeError:
	mov	ax,014fh
	jmp	short VbeSetModeExit

VbeSetMode	endp

ifndef	(VESA_LITE)
;-----------------------------------------------------------------------
;Input:
;    ax = 4f03h VESA:Get Super VGA Mode
;Returns:
;    ax = Status
;    bx = Super VGA mode number

VbeGetMode	proc	near

	xor	bx,bx
	mov	ds,bx
	mov	bl,ds:[0449h]

	mov	al,bl
	call	MapCL2VesaMode

VbeGetModeDone:
	mov	w_bx[bp],bx
	mov	ax,004fh
VbeGetModeExit:
	ret

VbeGetMode	endp

;-----------------------------------------------------------------------
;Input:
;    ax = 4f04h VESA:Save/Restore Super VGA State
;    cx = Requested states
;    dl = 00h Return buffer size
;Returns:
;    ax = Status
;    bx = Required buffer size, in 64-byte blocks
;
;Input:
;    ax = 4f04h VESA:Save/Restore Super VGA State
;    cx = Requested states
;    dl = 01h Save state
;    es:bx -> buffer of sufficient size
;Returns:
;    ax = Status
;
;Input:
;    ax = 4f04h VESA:Save/Restore Super VGA State
;    cx = Requested states
;    dl = 02h Restore state
;    es:bx -> buffer of previously saved information
;Returns:
;    ax = Status

VbeState	proc	near

	push	cx
	mov	al,cl
	and	al,08h
	shr	al,1
	shr	al,1
	shr	al,1

	or	cl,al

	push	es
	and	cx,not 0008h
	mov	ah,1ch
	mov	al,dl
;v1.31	int	10h
	call	Int10h		;v1.31 jliu
	pop	es

	cmp	al,1ch
	jne	VbeStateError

	mov	w_bx[bp],bx
	mov	ax,004fh

VbeStateExit:
	pop	cx
	ret

VbeStateError:
	mov	ax,014fh
	jmp	short VbeStateExit

VbeState	endp
endif	;(VESA_LITE)

;-----------------------------------------------------------------------
;Input:
;    ax = 4f05h VESA:CPU Video Memory Control
;    bh = 00h Set Super VGA video memory windows
;    bl = Window # (0=A,1=B)
;    dx = Window position (in win gran units)
;Returns:
;    ax = Status
;
;Input:
;    ax = 4f05h VESA:CPU Video Memory Control
;    bh = 01h Get Super VGA video memory windows
;    bl = Window # (0=A,1=B)
;Returns:
;    ax = Status
;    dx = Window position (in win gran units)
;-----------------------------------------------------------------------
VbeWinCtrl	proc	near
	call	VbeWinCtrlFunc
	or	bh,bh			;v0.08B4
	jz	short VbeWinCtrlRet	;v0.08B4
	mov	w_dx[bp],dx
VbeWinCtrlRet:
	ret
VbeWinCtrl	endp

VbeWinCtrlFunc	proc	near

	push	bx

	cmp	bl,01h			;Check validity of windows number
	ja	VbeWinCtrlError

	cmp	bh,01h
	ja	VbeWinCtrlError		;NOTE: Flags not modified!

	mov	ah,dl			;AH = requested bank
	mov	dx,GFXIDX
	in	al,dx
	push	ax

	je	VbeWinCtrlGet		;NOTE: Flags not modified!

VbeWinCtrlSet:
	mov	al,09h
	add	al,bl			;AL = 0E(Window A) or 0F(Window B)
	out	dx,ax

	jmp	short VbeWinCtrlSuccess	

VbeWinCtrlGet:
	mov	al,09h
	add	al,bl			;AL = 0E(Window A) or 0F(Window B)
	call	getreg
	mov	bl,ah
	xor	bh,bh

VbeWinCtrlSuccess:
	pop	ax
	out	dx,al
	mov	dx,bx

	mov	ax,004fh
	
VbeWinCtrlExit:
	pop	bx
	ret

VbeWinCtrlError:
	mov	ax,014fh
	jmp	short VbeWinCtrlExit

VbeWinCtrlFunc	endp

VbeFarWinCtrl	proc	far
	call	VbeWinCtrlFunc
	retf
VbeFarWinCtrl	endp

ifndef	(VESA_LITE)
  if (VESAVBEVERSION ge 101h)
;-----------------------------------------------------------------------
;Input:
;    ax = 4f06h VESA:Set/Get Logical Scan Line Length
;    bl = 00h Select Scan Line Length
;    cx = Desired width in pixels
;Returns:
;    ax = Status
;    bx = bytes per scan line
;    cx = actual pixels per scan line
;    dx = maximum number of scan lines
;
;Input:
;    ax = 4f06h VESA:Set/Get Logical Scan Line Length
;    bl = 01h Return Scan Line Length
;Returns:
;    ax = Status
;    bx = bytes per scan line
;    cx = actual pixels per scan line
;    dx = maximum number of scan lines

VbeScanLineCtrl	proc	near

	call	get_crtc_addr	;DX = CRTC
	mov	al,13h
	call	getreg
	mov	bh,ah		;Get current CRTC:Offset

	call	GetModeType	;AL = Mode Memory type

	cmp	bl,01h		;Return Scan Line Length?
	jb	VbeSLCtrlSet	;0 : Set Scan Line Length
	je	VbeSLCtrlInfo	;1 : Get Scan Line Length

DoVbeSLCtrlError:
	mov	ax,014fh
	jmp	short VbeSLCtrlExit

VbeSLCtrlSet:				;Set scan line info
	cmp	al,cMemText
	jb	DoVbeSLCtrlError	;Memory Type:Unknown
	je	VbeSLCtrlSetText	;Memory Type:Text

	cmp	al,cMem16Grfx
	jb	DoVbeSLCtrlError	;Memory Type:CGA Grfx
	je	VbeSLCtrlSet16Grfx	;Memory Type:16-color Grfx

	cmp	al,cMem256Grfx
	je	VbeSLCtrlSet256Grfx	;Memory Type:256-color Grfx
;++ Direct color modes
	jmp	short DoVbeSLCtrlError	;Memory Type:Unknown

VbeSLCtrlInfo:				;Get scan line info
	cmp	al,cMemText
	jb	DoVbeSLCtrlError	;Memory Type:Unknown
	je	VbeSLCtrlTextInfo	;Memory Type:Text

	cmp	al,cMem16Grfx
	jb	DoVbeSLCtrlError	;Memory Type:CGA Grfx
	je	VbeSLCtrl16GrfxInfo	;Memory Type:16-color Grfx

	cmp	al,cMem256Grfx
	je	VbeSLCtrl256GrfxInfo	;Memory Type:256-color Grfx

;++ Direct color

VbeSLCtrlSetText:		;Memory Type:Text
VbeSLCtrlTextInfo:		;Memory Type:Text
	jmp	short DoVbeSLCtrlError	;Memory Type:Unknown

VbeSLCtrlSet16Grfx:		;Memory Type:16-color Grfx
				;DX = CRTC Addr
				;BH = Current CRTC:Offset
	mov	ax,cx		;AX = Desired width in pixels
	add	ax,0Fh		;Round up to nearest even width
	shr	ax,1

	call	common_20

VbeSLCtrl16GrfxInfo:		;Memory Type:16Grfx
				;DX = CRTC Addr
				;BH = Current CRTC:Offset
	mov	bl,bh
	xor	bh,bh
	shl	bx,1		;BX = Bytes per line
	push	bx		;Save BX = Bytes per line
	push	bx		;Save a second copy for max lines calc below.

	shl	bx,1
	shl	bx,1
	shl	bx,1

	mov	cx,bx		;CX = pixels per line

	pop	bx		;BX = Bytes per line

	call	common_21
	shr	dx,2		;v0.08B5

	pop	bx		;BX = bytes per line
	jmp	short VbeSLCtrlInfoDone


VbeSLCtrlSet256Grfx:	;Memory Type:256-color Grfx
				;DX = CRTC Addr
				;BH = Current CRTC:Offset
	mov	ax,cx		;AX = Desired width in pixels
	add	ax,07h		;Round up to nearest even width

	call	common_20

VbeSLCtrl256GrfxInfo:		;Memory Type:256Grfx
				;DX = CRTC Addr
				;BH = Current CRTC:Offset
	mov	bl,bh
	xor	bh,bh
	shl	bx,1
	shl	bx,1
	shl	bx,1		;BX = Bytes per line
	mov	cx,bx		;CX = pixels per line

	call	common_21

VbeSLCtrlInfoDone:
	mov	w_bx[bp],bx
	mov	w_cx[bp],cx
	mov	w_dx[bp],dx
	mov	ax,004Fh

VbeSLCtrlExit:			;Done
	ret

public	common_20
common_20:
	shr	ax,1
	shr	ax,1
	shr	ax,1		;AX = candidate for new CRTC:Offset
				;	if CPU=8088
	mov	ah,al
	mov	bh,ah		;BH = current CRTC:Offset
	mov	al,13h
	out	dx,ax		;Set new CRTC:Offset
	ret

public	common_21
common_21:
	call	GetMemSize	;AL = memory size, in 64K blocks
	xor	dh,dh
	mov	dl,al
	xor	ax,ax		;DX:AX = the size of memory in bytes

	div	bx		;Divide by bytes/line
				;AX = number of scan lines
				;DX = remaining fractional scan line (ignored)
	mov	dx,ax		;DX = number of scan lines
				;CX = pixels per line
	ret

VbeScanLineCtrl	endp

;-----------------------------------------------------------------------
;Input:
;    ax = 4f07h VESA:Set/Get Display Start
;    bl = 00h Select Display Start
;    bh = 00h Reserved
;    cx = X coord (in pixels)
;    dx = Y coord (in pixels)
;Returns:
;    ax = Status
;
;Input:
;    ax = 4f07h VESA:Set/Get Display Start
;    bl = 01h Return Display Start
;Returns:
;    ax = Status
;    bh = 00h Reserved
;    cx = X coord (in pixels)
;    dx = Y coord (in pixels)

VbeDispStartCtrl	proc	near

	push	bx
	call	GetModeType	;AL = Mode Memory type
	cmp	bl,01h
	jb	VbeDSCSet
	je	DoVbeDSCInfo

VbeDSCError:
	mov	ax,014Fh
	jmp	VbeDSCExit

DoVbeDSCInfo:
	jmp	VbeDSCInfo

VbeDSCSet:
	cmp	al,cMemText
	jb	VbeDSCError		;Memory Type:Unknown
	je	VbeDSCtrlSetText	;Memory Type:Text

	cmp	al,cMem16Grfx
	jb	VbeDSCError		;Memory Type:CGA Grfx
	je	VbeDSCtrlSet16Grfx	;Memory Type:16-color Grfx

	cmp	al,cMem256Grfx
	je	VbeDSCtrlSet256Grfx	;Memory Type:256-color Grfx
;++ Direct color modes
VbeDSCtrlSetText:		;Memory Type:Text
	jmp	short VbeDSCError	;Memory Type:Unknown

VbeDSCtrlSet16Grfx:		;Memory Type:16-color Grfx

	push	dx		;Save DX = Y coord to pan to
	push	cx		;Save CX = X coord to pan to

	push	bp
	mov	bp, 1		;16 colors flag
	call	common_6
	pop	bp

	and	cl,07h		;CL = pixel to pan to within byte
common_11:
	mov	bh,cl
	mov	bl,13h
	call	Set_Palette
				;New StAddr now set.  Panning complete.
	pop	cx
	pop	dx
	jmp	VbeDSCDone

common_6:
	mov	bx,dx		;BX = Y coord to pan to
	call	get_crtc_addr	;DX = CRTC
	mov	al,13h		;CRTC:Offset
	call	getreg
	mov	al,ah
;v1.00a	{
	xor	ah,ah
	push	ax
	mov	al,1Bh		;Extended bit of CR13
	call	getreg
	test	ah,10h		;b4 = 1?
	pop	ax
	jz	short NoExtBit4CR13	
	or	ah,01h
NoExtBit4CR13:
;v1.00a	cbw
;v1.00a	}
	shl	ax,1		;AX = bytes per line

	push	dx		;Save DX = CRTC
	mul	bx		;DX:AX = offset to scan line
	mov	si,dx		;SI:AX = offset to scan line
	pop	dx		;Retrieve DX = CRTC

	push	cx		;Save X coord to pan to
	shr	cx,1
	shr	cx,1
	cmp	bp,1
	jnz	C256
	shr	cx, 1		;one more shift for 16 colors
C256:
	add	ax,cx
	adc	si,0		;SI:AX = offset of byte to pan to
	pop	cx

	mov	bl,al		;BL = new start address (low)
	mov	al,0Ch		;CRTC:StAddrH
	out	dx,ax
	jmp	short $+2

	inc	ax
	mov	ah,bl
	out	dx,ax

	mov	ax,si
	mov	bh,al
;** BH[0,1] contains display start address bits 16/17
	and	bh,02h		; take bit 1 (=bit 17)
	shl	bh,1		; reposition it to bit 2 so that it can be
				; OR'ed to CR1B[2] later on

	and	al,01h
	or	bh,al
	mov	al,1Bh
	call	getreg
	and	ah,not 05h
	or	ah,bh
	setreg
	ret


VbeDSCtrlSet256Grfx:	;Memory Type:256-color Grfx

	push	dx		;Save DX = Y coord to pan to
	push	cx		;Save CX = X coord to pan to

	push	bp
	mov	bp, 0		;256 colors flag
	call	common_6
	pop	bp

	and	cl,03h		;CL = pixel nibble to pan to within byte
	shl	cl,1		;CL = pixel to pan to within byte

	jmp	common_11

VbeDSCInfo:
	call	get_crtc_addr	;DX = CRTC addr
	push	ax		;Save AL = Memory Type

	mov	al,13h		;CRTC:Offset
	call	getreg
	mov	al,ah
;v1.00a	{
	xor	ah,ah
	push	ax
	mov	al,1Bh		;Extended bit of CR13
	call	getreg
	test	ah,10h		;b4 = 1?
	pop	ax
	jz	short NoExtdBit4CR13	
	or	ah,01h
NoExtdBit4CR13:
;v1.00a	cbw
;v1.00a	}
	shl	ax,1		;AX = Characters/line
	mov	cx,ax		;CX = Characters/line

	mov	al,0Ch		;CRTC:StAddrH
	call	getreg
	mov	bh,ah		;BH = high byte of StAddr

	inc	ax		;CRTC:StAddrL
	call	getreg
	mov	bl,ah		;BX = StAddr
	pop	ax		;AL = Memory Type

	cmp	al,cMemText
	jb	DoVbeDSCError		;Memory Type:Unknown
	je	VbeDSCtrlTextInfo	;Memory Type:Text

	cmp	al,cMem16Grfx
	jb	DoVbeDSCError		;Memory Type:CGA Grfx
	je	VbeDSCtrl16GrfxInfo	;Memory Type:16-color Grfx

	cmp	al,cMem256Grfx
	je	VbeDSCtrl256GrfxInfo	;Memory Type:256-color Grfx
;++ Direct color modes
DoVbeDSCError:
VbeDSCtrlTextInfo:		;Memory Type:Text
	jmp	VbeDSCError	;Memory Type:Unknown

VbeDSCtrl16GrfxInfo:	;Memory Type:16-color Grfx

				;DX = CRTC
				;BX = StAddr
				;CX = Character/line
	call	common_8
	push	ax		;Save Y coord to be POPped when done
	shl	cx,1		;CX = X coord of pixel byte
	call	common_9

	jmp	short common_10

VbeDSCtrl256GrfxInfo:	;Memory Type:256-color Grfx

				;DX = CRTC
				;BX = StAddr
				;CX = Character/line
	call	common_8
	push	ax		;Save Y coord to be POPped when done
	call	common_9

	shr	ah,1		;Fix AH to point to pixel, not sub-nibble
common_10:
	add	cl,ah
	adc	ch,0		;CX = X Coord currently panned to
	pop	dx		;DX = Y Coord currently panned to

;	jmp	VbeDSCDone

VbeDSCDone:
	mov	w_cx[bp],cx
	mov	w_dx[bp],dx
	mov	ax,004fh

VbeDSCExit:
	pop	bx
;v1.31A	xor	bh,bh	;BH should always be 00h on entry, and should be
			; 00h on exit.
	mov	b_bh[bp],00	;v1.31A
	ret

common_8:
	push	dx		;Save DX = CRTC

	mov	al,1Bh
	call	getreg
	mov	al,ah
	and	ax,0401h
	shr	ah,1
	or	al,ah
	xor	ah,ah
	mov	dx,ax

	mov	ax,bx		;AX = StAddr
	div	cx		;AX = Scan line
				;DX = pixel byte
	mov	cx,dx		;CX = pixel byte
	pop	dx		;Retrieve DX = CRTC

	ret

common_9:
	shl	cx,1
	shl	cx,1
	add	dl,06h		;DX = CRTC Status
	in	al,dx		;Reset flip-flop on Attr
	mov	bl,dl		;Save BL = Low(CRTC Status)

	mov	dl,Low(rAttrAddr)	;DX = rAttrAddr
	mov	al,13h		;Attr:PixelPan
	call	getreg		;AH = pixel panned to

	xchg	bl,dl		;DX = CRTC Status
	in	al,dx		;Reset flip-flop on Attr

	mov	dl,bl		;DX = rAttrAddr
	mov	al,20h		;Re-enable screen
	out	dx,al
	ret

VbeDispStartCtrl	endp
endif	;(VESAVBEVERSION ge 101h)

if (VESAVBEVERSION ge 102h)
;-----------------------------------------------------------------------
;	Input:
;	    ax = 4f08h VESA:Set/Get DAC Palette Control
;	    bl = 00h Set DAC Palette Width
;	    bh = Desired number of bits/color (Default=6)
;	Returns:
;	    ax = Status
;	    bh = Current number of bits/color (Normal=6)
;	
;	Input:
;	    ax = 4f08h VESA:Set/Get DAC Palette Control
;	    bl = 01h Get DAC Palette Width
;	Returns:
;	    ax = Status
;	    bh = Current number of bits/color (Normal=6)
;

VbeDacPalCtrl	proc	near

	mov	ax,014Fh	;Assume function unsuccessful

	cmp	bl,01h
	ja	VbeDPCExit
	je	VbeDPCGetDacWidth

VbeDPCSetDacWidth:
	cmp	bh,06h		;Request 6 bits/color?
	mov	bh,06h		;NOTE:Flags not modified
	jne	VbeDPCExit	;Anything else => return with error
				; (AX is already loaded with error flag)
VbeDPCGetDacWidth:
	mov	bh,06h		;Current DAC width always 6 bits/color

VbeDPCDone:
	mov	w_bx[bp],bx
	mov	ax,004Fh	;Function successful
VbeDPCExit:
	ret

VbeDacPalCtrl	endp
endif	;(VESAVBEVERSION ge 102h)
endif	;(VESA_LITE)

;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;Entry:	bx = VESA 15-bit mode number
;Exit:	al = Cirrus 7-bit mode number
;Change:none

MapVesa2CLMode	proc	near

	push	es
	push	ds
	push	di
	push	si
	push	cx
	mov	ch,ah

	mov	al,0FFh		;AL => look for VESA mode in BX
	xor	ah,ah		;AH=0 for scan code (unused)
	call	GetModeTblPtr	;Return ES:DI -> supp table
				; and DS:SI -> mode table
	xor	al,al		;Assume mode not found
	cmp	di,0FFFFh	;Supp table exists?
	je	MapVESA2CLModeExit	;No supp table.  Mode not found

	mov	al,es:[di].s_mode	;Get equivalent VESA mode number
					; from table.
MapVESA2CLModeExit:
	mov	ah,ch
	pop	cx		;Pop saved entry values.
	pop	si
	pop	di
	pop	ds
	pop	es
	ret
	
MapVesa2CLMode	endp

ifndef	(VESA_LITE)
;-----------------------------------------------------------------------
;Entry:	al = Cirrus 7-bit mode number
;Exit:	bx = VESA 15-bit mode number
;Change:none

MapCL2VesaMode	proc	near

	push	es
	push	ds
	push	di
	push	si
	push	ax
				;AL=extended mode
	xor	ah,ah		;AH=0 for scan code (unused)
	mov	bx,ax		;Assume mode is standard
	call	GetModeTblPtr	;Return ES:DI -> supp table
				; and DS:SI -> mode table
;	xor	bx,bx		;Assume mode not found
	cmp	di,0FFFFh	;Supp table exists?
	je	MapCL2VesaModeExit	;No supp table.  Mode not found

	mov	bx,es:[di].s_vesa	;Get equivalent VESA mode number
					; from table.
	or	bx,bx
	jnz	MapCL2VesaModeExit

	mov	bx,ax

MapCL2VesaModeExit:
	pop	ax		;Pop saved entry values.
	pop	si
	pop	di
	pop	ds
	pop	es
	ret
	
MapCL2VesaMode	endp


;-----------------------------------------------------------------------
if (VESAVBEVERSION ge 101h)

;Exit:	AL = Mode Memory Type

GetModeType	proc	near

	push	dx
	push	bx

	mov	bh,ah		;Preserve entry AH
;v1.404{
	mov	bl,cMemDCGrfx
	mov	dx,SEQIDX
	mov	al,07h
	call	getreg
	test	ah,06h
	jnz	short GetModeTypeDone
;v1.404}
	mov	bl,cMemText
	mov	dx,GFXIDX
	mov	al,06h
	call	getreg
	test	ah,01h		;Test Grfx(1)/Text(0)
	jz	GetModeTypeDone

	mov	bl,cMemCgaGrfx
	mov	al,05h
	call	getreg
	test	ah,20h		;Test shift clock: CGA(1)/Other(0)
	jnz	GetModeTypeDone

	mov	bl,cMem16Grfx
	test	ah,40h		;Test 256-color: 256(1)/16(0)
	jz	GetModeTypeDone

	mov	bl,cMem256Grfx

comment	#			;v1.404
if (MODEDIRECTCOLOR eq YES)
	mov	dl,Low(SEQIDX)
	mov	al,07h
	call	getreg
	test	ah,06h
	jz	GetModeTypeDone
	mov	bl,cMemDCGrfx
endif	;(MODEDIRECTCOLOR eq YES)
#				;v1.404
GetModeTypeDone:
	mov	ax,bx

	pop	bx
	pop	dx
	ret

GetModeType	endp

;Exit:	AL = Character width (in pixels)
GetCharWidth	proc	near

	push	dx
	push	bx
	mov	bh,ah

	mov	dx,SEQIDX
	mov	al,01h
	call	getreg

	and	ah,01h
	mov	al,09h
	sub	al,ah

	mov	ah,bh

	pop	bx
	pop	dx
	ret

GetCharWidth	endp

endif	;(VESAVBEVERSION ge 101h)
endif	;(VESA_LITE)

;-----------------------------------------------------------------------
;
;	clear_buffer()
;
;	Function:
;	   Clear the VESA Buffer
;
;	Input:
;	   ES:DI - Pointer to the buffer
;
;	Returns:
;	   Nothing
;
;	Remarks:
;	   AX and CX are destroyed
;
;-----------------------------------------------------------------------
clear_buffer proc near
	push	di
	xor	ax,ax
;v1.403mov	cx,256/2
	rep	stosw		;Init buffer to all 0
	pop	di
	ret
clear_buffer endp

;-----------------------------------------------------------------------
PmModeStruc	struc
	Port	db	?
	Index	db	?
	MaskVal	db	?
	Value	db	?
PmModeStruc	ends

ModeOffTbl	label	byte
;v1.00a	PmModeStruc<0C4h,00Bh,000h,020h>	;SR0B
;v1.00a	PmModeStruc<0C4h,01Bh,000h,03Fh>	;SR1B
;v1.00a	PmModeStruc<0D4h,011h,000h,040h>	;CR11
;v1.00a	PmModeStruc<0D4h,017h,07Fh,000h>	;CR17
;v1.00a PmModeStruc<0C4h,001h,000h,029h>	;SR01
;v1.00a	PmModeStruc<0D4h,000h,000h,009h>	;CR00
;v1.00a	PmModeStruc<0D4h,001h,000h,002h>	;CR01
;v1.00a	PmModeStruc<0D4h,004h,000h,003h>	;CR04
;v0.08B4PmModeStruc<0D4h,005h,000h,002h>	;CR05
RestoreOffTbl	label	byte
	PmModeStruc<0C4h,00Bh,0FFh,000h>	;SR0B  v1.00a
;v1.00a	PmModeStruc<0D4h,005h,000h,002h>	;CR05
;v0.08B4PmModeStruc<0C4h,01Fh,000h,004h>	;SR1F  v1.405
NumOfModeOff	equ (($-offset ModeOffTbl)/SIZE PmModeStruc)

StackBufSz	equ	20h

;-----------------------------------------------------------------------
VesaVbeDpmsHandler:
	cmp	bl,02h
	jbe	short ValidFunCall
	jmp	VesaVBEAbort		;Unknown Fn.  Abort with error!!!
ValidFunCall:
	mov	al,bl	
	cbw
	mov	si,ax
	shl	si,1
	add	si,offset VesaVbeDpmsTbl
	call	cs:[si]			;call requested VESA Fn.
	jmp	VesaVBEExit		;exit with any returns

;-----------------------------------------------------------------------
VbePMCapabilities	proc	near
	mov	ax,004Fh
	mov	w_bx[bp],0710h		;xxx
	mov	w_es[bp],0000h
	mov	w_di[bp],0000h
	ret
VbePMCapabilities	endp

;-----------------------------------------------------------------------
VbeSetPWState	proc	near
	test	bh,0F8h
	jnz	short WrongPWState
	cmp	bh,05h
	jae	short WrongPWState
	cmp	bh,03h
	jnz	short ValidPWState
WrongPWState:
;v0.08B2xor	al,al
	mov	ax,014Fh		;v0.08B2
	jmp	short VbeSetPWStateRet
ValidPWState:
	mov	dx,03C4h		;v0.05B1
	in	al,dx
	push	ax			;save sequence index
	mov	dl,0D4h
	in	al,dx
	push	ax			;save CRTC index
;v1.00b	{
	call	AccessSR12
	push	ax			;save SR12
	or	al,02h			;allow access to DAC
	out	dx,al
;v1.00b	call	EnableHdac
;v1.00b	}
	mov	ax,ss
	mov	es,ax
	sub	sp,StackBufSz
	mov	di,sp
	inc	di			;buffer starts from ES:DI
;
	or	bh,bh
	jz	short SetPwON
	cmp	bh,01h
	jz	short SetPwStandBy
	cmp	bh,02h
	jz	short SetPwSuspend
	call	SetOFF
	jmp	short RestoreSpCrtcSeq
SetPwON:
	call	SetON
	jmp	short RestoreSpCrtcSeq
SetPwStandBy:
	call	SetStandBy
	jmp	short RestoreSpCrtcSeq
SetPwSuspend:
	call	SetSuspend
RestoreSpCrtcSeq:
	add	sp,StackBufSz		;restore SP
;v1.00b	{
	call	AccessSR12
	pop	ax			;restore SR12
	out	dx,al
;v1.00b	call	DisableHdac
;v1.00b	}
	pop	ax
	mov	dl,0D4h
	out	dx,al			;restore CRTC index
	pop	ax
	mov	dl,0C4h
	out	dx,al			;restore sequence index
;
	mov	ax,bx			;return value
VbeSetPWStateRet:
	ret
VbeSetPWState	endp

;-----------------------------------------------------------------------
CheckPwStatus	proc	near
	mov	dx,03C4h
	mov	al,14h
	out	dx,al
	inc	dx
	in	al,dx
	and	al,07h			;v0.08B2
	ret
CheckPwStatus	endp

;-----------------------------------------------------------------------
PgmSR0b1bGR0E	proc	near
	call	WriteSR0bSR1b
;v0.05B2{
	call	ReadGR0E
	out	dx,al
;v0.05B2}
	ret
PgmSR0b1bGR0E	endp

;-----------------------------------------------------------------------
SetBackToOn	proc	near
;Current mode is either OFF or SUSPEND!!!
	pushf				;v0.05B1
	cli				;v0.05B1
;xxx	call	Reset3C6		;v0.08B3
	xor	bx,bx
	mov	al,03h			;index 3 of Ext. DAC
	mov	dl,0C7h
	out	dx,al
	in	al,dx			;delay
	mov	dl,0C9h
ReadExtDACLoop:
	in	al,dx
	cmp	al,3Fh			;terminator?
	jz	short ReadDone
	xchg	ah,al
;
	in	al,dx
	xchg	ah,al
	call	Transform2Byte
	mov	es:[di+bx],al
	inc	bx
	jmp	short ReadExtDACLoop
ReadDone:
;xxx	call	Restore3C6		;v0.08B3
	popf				;v0.05B1
	xor	bx,bx			;xxx
	mov	cx,NumOfModeOff
	mov	si,offset RestoreOffTbl
	add	bx,cx
RestoreLoop:
	mov	dl,cs:[si].Port
	mov	al,cs:[si].Index
	mov	ah,es:[di+bx]
	out	dx,ax
	dec	bx
	sub	si,4
	loop	RestoreLoop
;
	call	ClearDpmsStatus		;v1.00b
	out	dx,ax			;set ON flag

;v1.00b	mov	dx,03C4h
;v1.00b	mov	ax,0014h		;set ON flag
;v1.00b	out	dx,ax

	mov	dl,0C2h
	mov	al,es:[di]		;restore Misc
	out	dx,al
	mov	bx,004Fh
	ret
SetBackToOn	endp

;-----------------------------------------------------------------------
SetON	proc	near
	call	CheckPwStatus
	or	al,al
	jz	short SetOnRet		;current mode = ON?
	test	al,01h
	jnz	short StandByBefore
	call	PgmSR0b1bGR0E		;set for accessing HDAC
	call	SetBackToOn		;current mode is OFF or SUSPEND!!!
	jmp	short ModifyGR0E	;v0.08B2
StandByBefore:
	call	ClearDpmsStatus		;v1.00b
	out	dx,ax			;set ON flag

;v1.00b	mov	dx,03C4h		;v0.08B2
;v1.00b	mov	ax,0014h		;v0.08B2  set ON flag
;v1.00b	out	dx,ax			;v0.08B2

ModifyGR0E:				;v0.08B2
	call	ReadGR0E
	out	dx,al
SetOnRet:
	mov	bx,004Fh
	ret
SetON	endp

;-----------------------------------------------------------------------
SetStandBy	proc	near
	call	CheckPwStatus
	or	al,al
	jz	short OnBefore
	test	al,01h
	jnz	short SetStandByRet
	call	SetOn
OnBefore:
	call	ReadGR0E	
	or	al,02h
	out	dx,al
;
	call	ClearDpmsStatus		;v1.00b
	or	ah,01h			;v1.00b
	out	dx,ax			;set STANDBY flag

;v1.00b	mov	dx,03C4h
;v1.00b	mov	ax,0114h		;set STANDBY flag
;v1.00b	out	dx,ax

SetStandByRet:
	mov	bx,004Fh
	ret
SetStandBy	endp

;-----------------------------------------------------------------------
SetSuspend	proc	near
	call	CheckPwStatus
	or	al,al
	jz	short OnBfore
	test	al,04h
	jnz	short OffBefore		;current mode = OFF?
	test	al,02h
	jnz	short SetSuspendRet	;current mode = SUSPEND?
	call	SetOn			;current mode = STANDBY!
;Current mode is ON!!!
OnBfore:
	call	SaveMisc
	mov	cx,NumOfModeOff
	mov	si,offset ModeOffTbl
	call	SaveAndProgram
OffBefore:
	call	ClearDpmsStatus		;v1.00b
	or	ah,02h			;v1.00b
	out	dx,ax			;set SUSPEND flag

;v1.00b	mov	dx,03C4h
;v1.00b	mov	ax,0214h		;set SUSPEND flag
;v1.00b	out	dx,ax

	call	ReadGR0E
	or	al,04h
	out	dx,al
SetSuspendRet:
	mov	bx,004Fh
	ret
SetSuspend	endp

;-----------------------------------------------------------------------
SaveMisc	proc	near
	mov	dx,03CCh
	in	al,dx
	call	Transform2Word
	mov	es:[di],ax		;save MISC
	ret
SaveMisc	endp

;-----------------------------------------------------------------------
SetOFF	proc	near
	call	CheckPwStatus
	test	al,04h
	jnz	short SetOFFRet		;current mode = OFF
	or	al,al
	jz	short ItIsModeOn	;currnet mode = ON
	test	al,02h
	jnz	short SuspendBefore
	call	SetOn
ItIsModeOn:
	call	SaveMisc
	mov	cx,NumOfModeOff
	mov	si,offset ModeOffTbl
	call	SaveAndProgram
SuspendBefore:
	call	ClearDpmsStatus		;v1.00b
	or	ah,04h			;v1.00b
	out	dx,ax			;set OFF flag

;v1.00b	mov	dx,03C4h
;v1.00b	mov	ax,0414h		;set OFF flag
;v1.00b	out	dx,ax

	call	ReadGR0E
	or	al,06h
	out	dx,al
;
SetOFFRet:
	mov	bx,004Fh
	ret
SetOFF	endp

;-----------------------------------------------------------------------
Transform2Byte	proc	near
	shl	ah,4
	or	al,ah
	ret
Transform2Byte	endp

;-----------------------------------------------------------------------
Transform2Word	proc	near
	mov	ah,al
	and	ax,0F00Fh
	shr	ah,4
	ret
Transform2Word	endp

;-----------------------------------------------------------------------
SaveAndProgram	proc	near
	mov	bx,0002h		;xxx
Save2StackLoop:
	mov	dl,cs:[si].Port
	mov	al,cs:[si].Index
	out	dx,al
	inc	dx
	in	al,dx
	call	Transform2Word
	mov	es:[di+bx],ax		;save into stack
	in	al,dx
	mov	ah,al
	mov	al,cs:[si].MaskVal
	and	ah,al
	mov	al,cs:[si].Value
	or	al,ah
	out	dx,al			;program registers
	add	si,0004h
	add	bx,2
	loop	Save2StackLoop
	mov	al,0FFh
	mov	es:[di+bx],al		;write a terminator "FF" to stack
;
	pushf				;v0.05B1
	cli				;v0.05B1
	call	WriteSR0bSR1b		;v0.05B1
;xxx	call	Reset3C6		;v0.08B3
;v0.05B2{
	mov	al,00Eh
	mov	dl,0CEh
	out	dx,al
	inc	dx
	in	al,dx
	push	ax			;save GR0E
	and	al,0F9h
	out	dx,al
;v0.05B2}
	mov	al,3
	mov	dl,0C8h
	out	dx,al
	mov	dl,0C9h
	xor	bx,bx
NextByte:
	mov	al,es:[di+bx]
	cmp	al,0FFh			;terminator?
	jz	short SaveDone
	out	dx,al
	inc	bx	
	jmp	short NextByte
SaveDone:
	out	dx,al			;write a terminator "FF" to Ext. DAC
	out	dx,al			;v1.40 3  make a multiple of 3 times
	out	dx,al			;          for writing!!!
;v0.05B2{
;v1.00e	mov	dl,0CCh
;v1.00e	in	al,dx
;v1.00e	mov	dl,0C2h
;v1.00e	and	al,0F3h
;v1.00e	out	dx,al
;
	pop	ax			;restore GR0E
	mov	ah,00Eh
	xchg	ah,al
	mov	dl,0CEh
	out	dx,ax
;v0.05B2}
;xxx	call	Restore3C6		;v0.08B3
	call	RestoreSR0bSR1b		;v0.05B1
	popf				;v0.05B1
	ret
SaveAndProgram	endp

;-----------------------------------------------------------------------
VbeGetPWState	proc	near
	call	CheckPwStatus
	mov	bh,al
	mov	ax,004Fh
	mov	w_bx[bp],bx
	ret
VbeGetPWState	endp

;-----------------------------------------------------------------------
AccessSR12	proc	near
	mov	dx,3C4h
	mov	al,12h
	out	dx,al
	inc	dx
	in	al,dx
	ret
AccessSR12	endp

;-----------------------------------------------------------------------
WriteSR0bSR1b	proc	near
	mov	dl,0C4h
	mov	al,0Bh
	call	getreg
	mov	ch,ah			;save
	mov	ah,4Ah
	out	dx,ax
;
	mov	al,1Bh
	call	getreg
	mov	cl,ah			;save
	mov	ah,2Bh
	out	dx,ax
;
	mov	bl,1			;v0.05B1
	call	wait_vretrace		;v0.05B1
	ret
WriteSR0bSR1b	endp

;-----------------------------------------------------------------------
RestoreSR0bSR1b	proc	near
	mov	dl,0C4h
	mov	al,0Bh
	mov	ah,ch			;restore
	out	dx,ax
;
	mov	al,1Bh
	mov	ah,cl			;restore
	out	dx,ax
	ret
RestoreSR0bSR1b	endp

;-----------------------------------------------------------------------
comment	%				;v1.00b
EnableHdac	proc	near
	call	AccessSR12
	or	al,02h			;allow access to DAC
	out	dx,al
	ret
EnableHdac	endp

DisableHdac	proc	near
	call	AccessSR12
	and	al,NOT 02h		;disallow access to DAC
	out	dx,al
	ret
DisableHdac	endp
%

ClearDpmsStatus	proc	near
	mov	dx,03C4h
	mov	al,14h
	call	getreg
	and	ah,0F8h			;clear b0, b1, & b2
	ret
CLearDpmsStatus	endp

;-----------------------------------------------------------------------
ReadGR0E	proc	near
	mov	al,00Eh
	mov	dx,03CEh
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0F9h			;reset b2 & b1 of GR0E
	ret
ReadGR0E	endp

;-----------------------------------------------------------------------
comment	%
;v0.08B3{
.386
Reset3C6	proc	near
	push	ax
	mov	dl,0C6h
	in	al,dx
	mov	bl,al
	shl	ebx,16	
	xor	al,al
	out	dx,al
;	call	Read4Times
	in	al,dx
	in	al,dx
	in	al,dx
	in	al,dx
;
	pop	ax
	ret
Reset3C6	endp

;-----------------------------------------------------------------------
Restore3C6	proc	near
	push	ax
	mov	dl,0C6h
	shr	ebx,16	
	mov	al,bl
	out	dx,al
	pop	ax
	ret
Restore3C6	endp
;v0.08B3}
%
;-----------------------------------------------------------------------
endif	;VESAVBEVERSION

Int10h	proc	near			;v1.31 jliu
	pushf				;v1.31 jliu
	push	cs			;v1.31 jliu
	call	Direct_Video_Interface	;v1.31 jliu
	ret				;v1.31 jliu
Int10h	endp				;v1.31 jliu

VGA_Segment	ends
		end

