	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module L
;****************************************************************
;
;	$Workfile:   clutil.asm  $
;
;	Contents:
;
;	Modification History:
;	$Log:   M:/vcs/vga/54xx/clutil.asv  $
;      
;
;****************************************************************

	.XLIST
	include		config.inc
	include		biosdata.inc
	include		options.inc
	include		struc.inc
	INCLUDE VGADATA.INC
	.LIST

	%OUT	Assembling CLUTIL

VGA_Segment SEGMENT BYTE PUBLIC

	ASSUME	CS:VGA_Segment
	ASSUME	DS:NOTHING
	ASSUME	ES:NOTHING
	extrn	Is_16K_Granularity:near
	extrn	ana_ptr_tbl_c000:near
	extrn	ana_ptr_tbl_e000:near
if (MAXMEMSIZE gt 256)
	extrn	GetMemSize:near
ifdef MONTYPE
  if (MONTYPE_SIGNAL eq YES)
	extrn	use_switches:byte
  endif	;(MONTYPE_SIGNAL eq YES)
;	extrn	get_option:near
endif	;MONTYPE
endif	;(MAXMEMSIZE gt 256)
ifdef (MODE_OPTIMIZATION)
	extrn	ana_std_std:near
	extrn	ana_ext_std:near
        extrn	is_ram_modetbls:near
endif  ;(MODE_OPTIMIZATION)

page
;-----------------------------------------------------------------------
;
;	getreg()
;
;	Function:
;	   Get a value from an indexed register.
;
;	Input:
;	   al = index value
;	   dx = register address
;
;	Returns:
;	   ah = value
;	   al = preserved
;	   dx = preserved
;
;	Remarks:
;
;-----------------------------------------------------------------------
getreg		proc	near
		public	getreg

Read_Reg_NI	label	word
		public	Read_Reg_NI
if MEMIO eq YES
		int	READ_INT
else
		set1reg			; set the index
		inc	dx		; point to data
		mov	ah,al		; save the index in ah
		get1reg			; get the data value
		dec	dx		; point to index
		xchg	al,ah		; data in ah, index in al

endif
		ret			; and return
getreg		endp

ifdef SCRIDX
;-----------------------------------------------------------------------
;
;	getscr()
;
;	Function:
;	   Get a value from scratch pad register in the extensions.
;
;	Input:
;	   al = index value
;
;	Returns:
;	   ah = value
;	   al = preserved
;	   dx = EXTIDX
;
;	Remarks:
;	   None.
;
;-----------------------------------------------------------------------
getscr		proc	near
		public	getscr

		mov	dx,SCRIDX
ifdef   (XGA_BUG)
	call	Is_Chip_Unlocked	; Is chipset extentions there?
	jne	GetScrExit
endif	;(XGA_BUG)

if SCR_IN_MEM eq YES
		push	bx
		push	ds

		xor	bx,bx
		mov	ds,bx

		mov	bl,al		; index to BL
		sub	bl,SCR_START	; minus first scr. pad index
		add	bx,80h * 4	; start at INT 80h

		mov	ah,byte ptr [bx]; scratch pad
		mov	dx,SCRIDX
		pop	ds
		pop	bx
else
		call	getreg		; read it
endif
GetScrExit:

		ret			; return to caller
getscr		endp
;-----------------------------------------------------------------------
;
;	setscr()
;
;	Function:
;	   Set a value for the scratch pad register in the extensions.
;
;	Input:
;	   al = index value
;	   ah = data value
;
;	Returns:
;	   dx = EXTIDX
;
;	Remarks:
;	   None.
;
;-----------------------------------------------------------------------
setscr		proc	near
		public	setscr

if (SCR_IN_MEM eq YES)
		push	bx
		push	ds

		xor	bx,bx
		mov	ds,bx
		xor	bh,bh		; clear high byte
		mov	bl,al		; index to BL
		sub	bl,SCR_START	; minus first scr. pad index
		add	bx,80h * 4	; start at INT 80h

		mov	byte ptr [bx],ah; scratch pad
		mov	dx,SCRIDX	; scratch pad extensions
		pop	ds
		pop	bx
else
  ifdef   (XGA_BUG)
	call	Is_Chip_Unlocked
	jne	SetScrExit
  endif	;(XGA_BUG)

		mov	dx,SCRIDX	; scratch pad extensions
	        setreg			; set it
endif	;(SCR_IN_MEM eq YES)
SetScrExit:
		ret			; return to caller
setscr		endp
endif	;SCRIDX

;-----------------------------------------------------------------------
;
;	Set64KPage
;
;	Function:
; 	   Sets 64K page
;
;	Input:
;	   dl = 64K page #
;
;	Returns:
;	   Nothing.
;-----------------------------------------------------------------------
Set64KPage	proc	near
		public	Set64KPage

		push	ax		; save registers
		push	dx

		mov	ah,dl		; get 64K page#
		shl	ah,1		; multiply by 16
		shl	ah,1
		call	Is_16K_Granularity ; special 2MB mode?
		jnz	no_16K_gran     ; yes, shift over only twice (16k)
		shl	ah,1		; no, use 64K page
		shl	ah,1
no_16K_gran:
		mov	al,09h		; CPU Base Addr Mapping reg A
		mov	dx,GFXIDX	; extension register
		setreg			; set the page

		pop	dx		; restore registers
		pop	ax
		ret

Set64KPage	endp

;-----------------------------------------------------------------------
;
;	Inc64KPage
;
;	Function:
; 	   Sets the next 64K page
;
;	Input:
;	   None
;	Returns:
;	   Nothing.
;-----------------------------------------------------------------------
Inc64KPage	proc	near
		public	Inc64KPage

		push	ax		; save registers
		push	dx

		mov	al,09h		; CPU Base Addr Mapping reg A
		mov	dx,GFXIDX	; extension register
		call	getreg		; set the page
		add	ah,16		; increment to the next page
		call	is_16k_granularity
		jz	not_2m_mode
		sub	ah,12
not_2m_mode:
		setreg			; set the page

		pop	dx		; restore registers
		pop	ax
		ret

Inc64KPage	endp

page
;-----------------------------------------------------------------------
;
;	is_graphics()
;
;	Function:
;	   Determine if the ACTIVE adapter is in graphics mode.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   ZR if text mode
;	   NZ if graphics mode
;
;	Remarks:
;	   First we check the ega active bit to see if the ega/vga
;	is the active adapter.  If not, we decide by the mode number.
;	If it is, we decide by gr6:0
;
;	   All registers are preserved.
;
;-----------------------------------------------------------------------
is_graphics	proc	near
		public	is_graphics

		push	ds		; save caller's ds

		xor	ax,ax		; absolute zero
		mov	ds,ax		; into ds

		cmp	ds:[CON_MODE],4 ; cga text ?
		jb	is_text		; yes
		cmp	ds:[CON_MODE],7 ; mda text ?
		je	is_text		; yes
		cmp	ds:[CON_MODE],14h ; 132 column text?
		jb	is_grfx	
		cmp	ds:[CON_MODE],55h ; 132 column text?
		ja	is_grfx
is_text:
		xor	al,al		; set ZR flag
		or	al,al
		pop	ds
		ret
is_grfx:
		or	al,1
		pop	ds
		ret
is_graphics	endp


page
;-----------------------------------------------------------------------
;
;	get_crtc_addr()
;
;	Function:
;	   Return the actual address of the 3dx/3bx registers.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   dx <- the current crtc address
;
;	Remarks:
;	   This function checks the current state of the mono
;	mon bit in misc output to determine the crtc address.
;
;-----------------------------------------------------------------------
get_crtc_addr	proc	near
		public	get_crtc_addr

		push	ax		; save ax
		mov	dx,03cch	; misc output read back
		get1reg			; read it
		mov	dl,0d4h		; assume 3dx addressing
		test	al,1		; really 3dx ?
		jnz	gca_done	; yes
		mov	dl,0b4h		; 3bx

gca_done:	pop	ax		; restore ax
		ret			; and return
get_crtc_addr	endp
page
;-----------------------------------------------------------------------
;
;	vs_disable
;
;	Function:
;	   Make the video system go to sleep
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   ah == 4 on success
;	   ah != 4 on failure
;
;	Remarks:
;	   The vse register decodes as misc output when not
;	in vga mode.
;
;-----------------------------------------------------------------------
vs_disable	proc	near
		public	vs_disable

	mov	dx,VSEnable
	xor	al,al
	set1reg				; go to sleep

		mov	ah,4		; success return code
vsd_done:	ret			; and return
vs_disable	endp
page
;-----------------------------------------------------------------------
;
;	vs_enable
;
;	Function:
;	   Make the video system wake up
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;	   The vse register decodes as misc output when not
;	in vga mode.
;
;-----------------------------------------------------------------------
vs_enable	proc	near
		public	vs_enable

		mov	dx,VSEnable	; point to vse
if (VSEnable eq 3C3h)
		mov	al,1		; 1 = enable
else
		mov	al,0eh
endif
		set1reg	

		ret			; and return
vs_enable	endp
page

;------------------------------------------------------------------------
;GetModeTblPtr traverses the chain of Save Areas (0:4A8) searching for the 
;requested standard VGA or extended mode.  The structure of the Save Area
;is described below.
;------------------------------------------------------------------------
;
;					+-------+
;					| ????	|
;					+-------+
;					    :
;					+-------+
;					|PrevSav| -->>	...
;					+-------+
;					|SizeOpt|
;					+-------+
;					|SizeSup|
;					+-------+
;					|ExtdSup|
;					+-------+
;					|ExtdTbl|
;			+-------+	+-------+
;			| ????	|	| #Extd	|
;			+-------+	+-------+
;			    :		| CL ID	|
;			+-------+	+-------+
;			|PrevSav| -->>	|ModeTbl|
;			+-------+	+-------+
;			|SizeOpt|	|DynSave|
;			+-------+	+-------+
;			|SizeSup|	|AuxText|
;			+-------+	+-------+
;			|ExtdSup|	|AuxGrfx|
;			+-------+	+-------+
;			|ExtdTbl|	|SecSave|
;			+-------+	+-------+
;			| #Extd	|	|Rsvd1	|
;			+-------+	+-------+
;			| CL ID	|	|Rsvd2	|
;	+-------+	+-------+	+-------+
;	| 0:4A8	| -->>	|ModeTbl|	
;	+-------+	+-------+	
;			|DynSave|
;			+-------+
;			|AuxText|
;			+-------+
;			|AuxGrfx|
;			+-------+
;			|SecSave|
;			+-------+
;			|Rsvd1	|
;			+-------+
;			|Rsvd2	|
;			+-------+
;
;------------------------------------------------------------------------
;The algorithm for finding a requested video mode is to find a standard
;VGA mode in the normal way, through the ModeTbl pointer of the Save
;Area pointer, coupled with the scan line code.
;For extended modes the scan line code is ignored.  GetModeTblPtr looks
;through the list of extended modes, searching for a matching mode.  If 
;it finds a matching mode, it checks the memory size requirement against 
;the amount of currently installed memory.  It also checks the monitor 
;support list against the current monitor type.  If both tests are passed,
;then the mode is successfully found and returned back.  If the checks
;fail, then the searching continues, until the list of modes is exhausted.
;If the list of modes is exhausted, then the SizeOpt and PrevSav pointer 
;are checked to see if there is a previous Save Area to chain to.  If there 
;is a valid previous Save Area, then the search process continues on that 
;list.  If there is not a valid previous Save Area, then GetModeTblPtr 
;checks the Save Area within the ROM for the requested mode.
;------------------------------------------------------------------------

;------------------------------------------------------------------------

dSaveAreaPtr	equ 04A8h

;------------------------------------------------------------------------
;Returns a pointer to the requested standard or supplemental mode parameter 
;table.  This interface corresponds with the old BIOS calling parameters.
;Newer functions would be encouraged to call GetModeTblPtr, which returns
;back both pointer simultaneously.
;Entry:	CH = video mode number
;	BH = 0 get standard parameter table
;	   = 1 get supplemental parameter table
;	DS = 0
;Exit:	ES:DI -> requested table
;Change:none

get_tbl_ptr	proc	near
		public	get_tbl_ptr

	push	ds
	push	si
	push	ax
	call	GetScanLineCode		;AH = 0/1/2 = 200/350/400
	mov	al,ch			;AL = requested mode
	call	GetModeTblPtr		;DS:SI -> mode table
					;ES:DI -> supp table
	or	bh,bh			;Requested mode or supp table?
	jnz	GTPExit			;BH = 1 means return supp table

	mov	di,ds
	mov	es,di
	mov	di,si			;ES:DI -> mode table

GTPExit:
	pop	ax
	pop	si
	pop	ds
	ret

get_tbl_ptr	endp

;------------------------------------------------------------------------
;Returns a code for the number of scan lines there are, given the current
;mode and BIOS data area information.  Used for selecting various resolutions
;of text modes, etc.
;Entry:	DS = 0
;Exit:	AH = 0/1/2/3 = 200/350/400/480 lines
;Change:none

GetScanLineCode	proc	near
		public	GetScanLineCode

	push	bx			;Save BX

	xor	ah,ah			;Assume 200 lines
	xor	bh,bh			;Prepare for table indexing through BX
	mov	bl,ds:[0449h]		;Get BL = mode
	cmp	bl,13h			;For extended modes just return 0
	ja	GetScanLineCodeExit	;extended modes exit

	shl	bx,1			;word table
	mov	bx,cs:[bx+offset GMTScanTbl]	;BH = scan lines

	mov	ah,bh			;Get scan line code
	cmp	ah,0FFh			;Check if we need to figure out code
	jne	GetScanLineCodeExit	;Graphics mode.  code is valid already

	mov	ah,02h			;Assume 400-line text
	test	byte ptr ds:[0489h],10h	;Check 400 line bit
	jnz	GetScanLineCodeExit	;400-line mode active

	dec	ah			;Assume 350-line text
	mov	bl,ds:[0488h]		;Check switch settings
	and	bl,0Fh			;Switches = bits [3:0]
	cmp	bl,0Eh			;??Lo-res monitor?
	je	GetScanLine200		;Lo-res, 200-lines
	cmp	bl,08h			;??Lo-res monitor?
	jne	GetScanLineCodeExit	;Med-res, 350-lines

GetScanLine200:
	dec	ah			;Lo-res, 200-lines

GetScanLineCodeExit:
	pop	bx			;Restore entry BX
	ret

GetScanLineCode	endp

;------------------------------------------------------------------------
;Entry:	AL = mode number
;	AH = scan line code (0/1/2 = 200/350/400 scan lines)
;	if (AL>7F) then BX = VESA mode number
;Exit:	DS:SI -> standard mode tbl (or FFFF:FFFF if none found)
;	ES:DI -> supplemental parameter tbl (or FFFF:FFFF if none exists)
;Change:none

GetModeTblPtr	proc	near
		public	GetModeTblPtr

	push	dx
	push	cx
	push	bx
	push	ax

	cmp	al,13h		;Standard mode or extended mode?
				;NOTE: This doesn't support 14h:132x25
	ja	GetExtdModeTbl	;Go look for extended modes

	xor	bx,bx		;Zero upper byte of BX for table indexing
	mov	bl,al		;Lookup mode in scan line table
	shl	bx,1		;word table
	mov	bx,cs:[bx+offset GMTScanTbl]	;BL = index, BH = scan lines
	cmp	bh,0FFh		;FF means we have to check scan line code
				; passed in.
	jb	GetModeTblCalc
				;AL = mode number
				;AH = scan line code
				;BL = 200 scan line table index
	cmp	al,07h		;Mono text mode only has 350/400 line versions
	je	GetModeTbl07h	; so handle it specially

	cmp	ah,01h		;350 lines requested?
	jb	GetModeTblCalc	;200 lines requested, go calculate index

	add	bl,13h		;Bump mode index to point at 0*/1*/2*/3*
	cmp	ah,01h		;350 lines requested?
	je	GetModeTblCalc	;350 lines requested, go calculate index

	mov	bh,al		;BH = mode number
	sub	bl,bh		;De-adjust for 0/1/2/3
	shr	bh,1		;Shift right, since 0+ and 1+ share a table
				; and 2+ and 3+ share a table.
	add	bl,04h		;Bump mode index to point at 0/1+,2/3+
	add	bl,bh		;BL = corect 400 line mode index
	jmp	short GetModeTblCalc

GetModeTbl07h:
	cmp	ah,01h		;350 lines requested?
	jbe	GetModeTblCalc	;200 or 350 scan lines requested.  BL already
				; has correct mode table index.
	add	bl,12h		;Bump mode index to point at 7+
	
GetModeTblCalc:
				;AL = mode number
				;BL = mode index
	xor	si,si		;SI = 0 for segment reference
	mov	ds,si		;DS -> BIOS data area
	lds	si,ds:[dSaveAreaPtr]	;DS:SI -> Save Area table
	lds	si,ds:[si]	;DS:SI -> standard mode parameter table

	mov	al,40h		;AL = size of standard mode table
	mul	bl		;BL = mode index, AX = offset of mode tbl
	add	si,ax		;DS:SI -> standard mode parameter table

	mov	di,-1		;ES:DI = FFFF:FFFF = No supplemental table
	mov	es,di		; for standard modes.
	jmp	GetModeTblPtrExit	;Go to exit point

GetExtdModeTbl:
	xor	si,si		;SI = 0 for segment reference
	mov	ds,si		;DS -> BIOS data area
	lds	si,ds:[dSaveAreaPtr]	;DS:SI -> Save Area table

GetExtdModeTblCheck:
	cmp	word ptr ds:[si-2],PRODUCT_ID	;Is extension valid?
	jne	CheckRomExtdModeTbl	;Extension not valid.  Drop to ROM set.

	push	ds
	push	si		;Save current Save Area pointer

	mov	dx,ds:[si-2-2-4-4-2]	;DX = size of supplemental table
	mov	cx,ds:[si-2-2]		;CX = number of extended modes
	les	di,ds:[si-2-2-4-4]	;ES:DI -> Extended mode supplemental
	lds	si,ds:[si-2-2-4]	;DS:SI -> Extended mode standard

	jcxz	GEMTNextTable

GEMTFindLoop:
	test	al,80h			;Looking for VESA mode?
	jnz	GEMTVesaMode		;Yes, check VESA mode# in BX

	cmp	al,58h
	jne	skip_m58_translation
	cmp	es:[di].s_mode,06Ah	;See if mode number found
	je	GEMTCheckInfo		;Mode found - Check monitor, mem, etc.
skip_m58_translation:

	cmp	al,es:[di].s_mode	;See if mode number found
	je	GEMTCheckInfo		;Mode found - Check monitor, mem, etc.
	jmp	short GEMTFindMode

GEMTVesaMode:
	cmp	bx,es:[di].s_vesa	;See if VESA number found
	je	GEMTCheckInfo		;Mode found - Check monitor, mem, etc.

GEMTFindMode:

	add	si,40h		;Bump DS:SI up to point to next mode table
	add	di,dx		;Bump ES:DI up to point to next supp table
    ifdef (MODE_OPTIMIZATION)
	call	is_ram_modetbls			; is table pointing to RAM?
	jne	found_next_mode_table		; yes, dont run fixups
;(V1.3) {
	push	ax
ifdef (ALP_NEW)
	mov	al,es:[di].s_param		; get offset into ext modes
	and	al,0FFh				; mask for lower nibble only
else	; (ALP_NEW)
	mov	al,es:[di].s_ref_param		; get offset into ext modes
	and	al,0Fh				; mask for lower nibble only
endif	; (ALP_NEW)
	mov	si,offset ana_std_std + 40h*27	; SI = 640 x 480 x 16(mode 12)
	jz	next_mode_table			; got it
	cmp	al,2
	jae	use_ext_tbl
;
	add	si, 40h				; mode 13h
	jmp	short next_mode_table		; yes, ds:si is set
use_ext_tbl:
	mov	si,offset ana_ext_std		; no, si = extended modes
	sub	al,2				; adjust for offset 0 & 1
	mov	ah,40h				; find real offset
	mul	ah
	add	si,ax				; and add it to si
next_mode_table:
;(V1.3) }
	pop	ax	
found_next_mode_table:
    endif   ;(MODE_OPTIMIZATION)
	loop	GEMTFindLoop

GEMTNextTable:
	pop	si		;Retrieve current Save Area pointer
	pop	ds

	mov	dx,ds		;Get Seg(Save Area pointer)
	mov	cx,cs		;Get Seg(BIOS {us})
	cmp	dx,cx		;Is Save Area in BIOS?
	je	GEMTModeNotFound	;Mode not found - Give up and exit

	cmp	word ptr ds:[si-2-2-4-4-2-2],4	;Check size of extra area
	jb	CheckRomExtdModeTbl	;No valid pointer.  

	lds	si,ds:[si-2-2-4-4-2-2-4]	;Get prev Save Area pointer
	mov	dx,ds			;Check if prev Save Area is NULL ptr
	or	dx,si
	jnz	GetExtdModeTblCheck	;Try again to find mode
;	jz	GEMTModeNotFound	;Mode not found - Give up and exit
;
;	jmp	 short GetExtdModeTblCheck	;Try again to find mode

GEMTModeNotFound:
	mov	si,-1			;Mode not found, so return
	mov	di,si			
	mov	es,di			;ES:DI = FFFF:FFFF for failure
	mov	ds,si			;DS:SI = FFFF:FFFF for failure
	jmp	short GetModeTblPtrExit	;Exit function

CheckRomExtdModeTbl:
	mov	dx,cs			;Get our segment
	mov	ds,dx			;DS = Seg(ROMs Save Area)
	mov	si,offset ana_ptr_tbl_c000	;Assume C000 ROM segment
	cmp	dx,0E000h			;Is it E000?
	jne	CheckRomExtdModeTblC000		;Not E000, so assume C000
	mov	si,offset ana_ptr_tbl_e000	;assume E000 ROM segment
CheckRomExtdModeTblC000:
	jmp	GetExtdModeTblCheck		;Go around again to try to
						; find the requested mode.
GEMTCheckInfo:
				;DS:SI -> candidate mode table
				;ES:DI -> candidate supp table
				;AL = mode number
				;BX = VESA mode number (possibly)
				;DX = size of each supp table
				;CX = remaining number of modes in table
	push	ax		;Save requested mode number

if (MAXMEMSIZE gt 256)
	call	GetMemSize	;AL = Size of memory in 64K units (0 = 64K)
	cmp	al,es:[di].s_memreq	;Do we have enough memory?
	jb	GEMTInfoNextMode	;Not enough memory.  Keep searching.
;v1.00B1{
	call	MemSzMclkCheck
	jc	GEMTInfoNextMode
;v1.00B1}
	push	cx
	call	GetChipType		; CL = chip type
	mov	al,01h			; al[chip_type] = 1
	shl	al,cl
	pop	cx
	test	al,es:[di].s_resrvd	; Does chip type support this mode?
	jz	GEMTInfoNextMode	; no, look for next mode.

ifdef MONTYPE
;*  if (MONTYPE_SIGNAL eq YES)
;*MonTypeDebug:
;*	public	MonTypeDebug
;*
;*	test	cs:use_switches,20h	; supress setmode int 15h
;*	jnz	SkipMonTypeSignal	; bit set ? yes, skip the call
;*
;*	pop	ax			; retrieve mode number in AL
;*	push	ax			; save it again
;*	mov	ah,0c3h			; unique function #
;*	int	15h
;*	xchg	al,ah			; swap return code and monitor code
;*	cmp	ah,0c3h			; supported?
;*	je	GotMonType		; yes, skip scratch pad montype
;*	
;*	; Here AL=montype (returned from the call)
;*	;   assume all other registers preserved	
;*SkipMonTypeSignal:
;*  endif	;(MONTYPE_SIGNAL eq YES)
ifdef  (MONTYPE_VERT)
	push	dx			; int 15h did not occur
ifdef (ALP_NEW)
	mov	al, SP_OPT2
	call	getscr
	push	ax
	mov	al, SP_OPT1
	call	getscr
	pop	dx
	mov	dl, ah
	xchg	dx, ax
else	; (ALP_NEW)
	mov	al, SP_OPT1
	call	getscr
	mov	al, ah
endif	; (ALP_NEW)
	pop	dx

;*	jmp	short conversion_done	; and skip over int15h request handle
;*GotMonType:
;*	extrn	mt_compare_tbl:near
;*	mov	si, offset mt_compare_tbl ; int 15 did occur, convert montype
;*	xor	ah,ah			; number to vertical montype
;*	add	si,ax
;*	mov	al,byte ptr cs:[si]
conversion_done:
	CALL	is_valid_vert_montype
	jc	GEMTInfoNextMode	; yes, frequency/resolution too large
else	 ; (MONTYPE_VERT)
	push	dx
;5434(13){	mov	al,MONTYPE
;5434(13)	call	get_option
	mov	al, SP_OPT1
	call	getscr
	mov	al, ah
	shr	al, 1
	shr	al, 1
;5434(13){
	pop	dx
GotMonType:
	push	cx		;Save remaining number of modes in table
	mov	cl,al		;Get monitor type in CL
	mov	al,01h		;Get set to calc monitor mask
	shl	al,cl		;AL = monitor type bit mask for comparison
	pop	cx		;Retrieve remaining number of modes in table
	test	al,es:[di].s_monlist	;Can mode work on this monitor?
	jz	GEMTInfoNextMode	;Monitor not supported.  Keep searching.
endif	 ;(MONTYPE_VERT)
endif	;MONTYPE

GEMTModeFound:
endif	;(MAXMEMSIZE gt 256)

	pop	ax
				;Valid mode found!  Return pointers to mode
				; table and supp table.
				;DS:SI -> mode table
				;ES:DI -> supp table
	add	sp,4		;Discard saved Save Area ptr on stack.
if (MAXMEMSIZE gt 256)
	jmp	short GetModeTblPtrExit	;Done, exit.

GEMTInfoNextMode:
	pop	ax		;Retrieve requested mode number
	jmp	GEMTFindMode
endif	;(MAXMEMSIZE gt 256)

GetModeTblPtrExit:
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	ret

ifdef  (MONTYPE_VERT)

ifdef (ALP_NEW)
;-----------------------------------------------------------------------
;
;	is_valid_vert_montype()
;
;	Function:
;	   Get a value from an indexed register.
;
;	Input:
;	   	AL[7:5] - 1024x768 resolution
;	   	AL[4:2] - 800x600 resolution
;		AH[7:4] - Max. resolution
;		AH[3:1] - 1280x1024 resolution
;
;	Returns:
;	   Carry flag - Set - mode is invalid
;			Clear - mode is valid
;
;	Remarks:
;
;-----------------------------------------------------------------------
is_valid_vert_montype proc near
	
	push	ax
	push	bx
	push	dx
;

	mov	dx, ax
	mov	bh,es:[di].s_monlist	; AH = mode's required montype
	mov	bl, bh
	and	bh, 070h		; BH[6:4]

	and	bl, 00Fh		; BL[3:0]
	shr	ah, 4
	cmp	bl, ah	 		; Min. Required Vertical Res. > current Vertical Res?
	ja	IVVM_bad		; yes, resolution too large

	mov	bl, bh			; Required Vertical Res.
	cmp	es:[di].s_horz,800	; Are we checking 800x600?
	je	cmp_800_by_600		; Yes

	cmp	es:[di].s_horz,1024	; Are we checking 1024x768?
	je	cmp_1024_by_768		; YES

	cmp	es:[di].s_horz,1280	; Are we checking 1280x1024?
	je	cmp_1280_by_1024	; YES
	jmp	short IVVM_ok		; No

cmp_1280_by_1024:
	mov	ah, dh
	and	ah, 00Eh
	shl	ah, 3
	jmp	short res_check

cmp_1024_by_768:
	mov	ah, dl
	and	ah, 0E0h
	shr	ah, 1
	jmp	short res_check
cmp_800_by_600:
	mov	ah, dl
	and	ah, 01Ch
	shl	ah, 2
res_check:
	cmp	ah,70h			;v0.082  If [6:4] = 111b then don't care!!! 
	jz	short IVVM_bad		;v0.082
	cmp	ah, bl
	jae	short IVVM_ok
IVVM_bad:
	stc
	jmp	short IVVM_exit
IVVM_ok:
	clc
IVVM_exit:
	pop	dx
	pop	bx
	pop	ax
	ret
is_valid_vert_montype endp

else	; (ALP_NEW)

;-----------------------------------------------------------------------
;
;	is_valid_vert_montype()
;
;	Function:
;	   Get a value from an indexed register.
;
;	Input:
;	   al[7:0] = vertical montype code
;
;	Returns:
;	   Carry flag - Set - mode is invalid
;			Clear - mode is valid
;
;	Remarks:
;
;-----------------------------------------------------------------------
is_valid_vert_montype proc near
	
;5434(13+)	shl	al,1			; shift vert montype to [7:2]
;5434(13+)	shl	al,1			; AL = current montype
	mov	ah,es:[di].s_monlist	; AH = mode's required montype
	push	ax
	and	ax,00C0Ch
	cmp	ah,al	 		; Required montype > current montype?
	pop	ax
	ja	get_next_mode		; yes, resolution too large
	cmp	es:[di].s_horz,800
	je	cmp_800_by_600
	cmp	es:[di].s_horz,1024
;5434(13+){
	je	cmp_1024_by_768
	cmp	es:[di].s_horz,1280
;5434(13+)}
	jne	got_a_good_mode
;5434(13+){
cmp_1280_by_1024:
	and	ax,0303h
	cmp	ah,al			; Required freq > current freq?
	ja	get_next_mode		; yes, frequency too large
	jmp	short got_a_good_mode
cmp_1024_by_768:
;5434(13+)}
	and	ax,0C0C0h
	cmp	ah,al			; Required freq > current freq?
	ja	get_next_mode		; yes, frequency too large
	jmp	short got_a_good_mode
cmp_800_by_600:
	and	ax,03030h
	cmp	ah,al			; Required freq > current freq?
	ja	get_next_mode		; yes, frequency too large
	cmp	al,030h			; montype 1 with no 800 x 600?
	jne	got_a_good_mode		; no, resolution is o.k.
get_next_mode:
	stc
	ret

got_a_good_mode:
	clc
	ret
is_valid_vert_montype endp

endif	; (ALP_NEW)

endif	 ;(MONTYPE_VERT)

GMTScanTbl	label word
	dw 0FF00h		;Mode 0/0*/0+
	dw 0FF01h		;Mode 1/1*/1+
	dw 0FF02h		;Mode 2/2*/2+
	dw 0FF03h		;Mode 3/3*/3+
	dw 00004h		;Mode 4
	dw 00005h		;Mode 5
	dw 00006h		;Mode 6
	dw 0FF07h		;Mode 7*/7+
	dw 00008h		;Mode 8
	dw 00009h		;Mode 9
	dw 0000Ah		;Mode A
	dw 0000Bh		;Mode B
	dw 0000Ch		;Mode C
	dw 0000Dh		;Mode D
	dw 0000Eh		;Mode E
	dw 0010Fh+2		;Mode F*  (Note: Fudge for F/10 64K modes)
	dw 00110h+2		;Mode 10* (Note: Fudge for F/10 64K modes)
	dw 00311h+2+4+3		;Mode 11  (Note: Fudge for F/10 64K modes)
	dw 00312h+2+4+3		;Mode 12  ( as well as 0*/1*/2*/3* and   )
	dw 00013h+2+4+3		;Mode 13  ( 0/1+, 2/3+, and 7+           )

GetModeTblPtr	endp

;------------------------------------------------------------------------

  ifdef   (XGA_BUG)
;-----------------------------------------------------------------------
;
;	Is_Chip_Unlocked()
;
;	Function:
;		This function will test to see if the extention registers are
;	indeed available.  This will enforce the philosophy that the BIOS 
;	should enable the chipset only at post time.  If for what ever reason
;	the chipset gets locked, the BIOS should then act ONLY like a standard
;	VGA.  
;
;	Input:
;	   None
;
;	Returns:
;	   Flags - eq AH did equal 12h
;	 	   ne AH did not equal 12h
;
;	Remarks:
;		The code below should work for three cases: an AVGA1, the 
;	philosophy described above, and in the case that a microchannel XGA
;	adapter has been determined to be the primary VGA and this BIOS 
;	resides on the	motherboard (I.E. the system chipset is asleep,
;	but the BIOS is used for primary VGA output).
;
;		The philosophy can be further underlined by the following 
;  	rules.  There is no need to check at post time, registers may be
;	programmed then.  When "VGA ONLY" mode is detected, all VESA functions,
;	extended setmodes, and extended alternate functions will all be 
;	blocked off.  Also, the save/restore functions will be limited to 
;	vga registers only.
;
;-----------------------------------------------------------------------
		public	Is_Chip_Unlocked
Is_Chip_Unlocked  proc	near
	push	ax
	push	dx
;v1.00B1{
	call	get_crtc_addr
	mov	al,27h
	call	getreg
	and	ah,0FCh
	cmp	ah,0A0h			;CL-GD5430?
	jz	short UnlockCheckDone
;v1.00B1}
	mov	dx,SEQIDX		; read ext reg enable
	mov	al,006h
	call	getreg
	cmp	ah,12h			; are there any exention regs?
UnlockCheckDone:
	pop	dx
	pop	ax
	ret
Is_Chip_Unlocked  endp
  endif   ;(XGA_BUG)

;-----------------------------------------------------------------------
;
;	getchiptype
;
;	Function:
;
;	Input:		None
;
;	Returns:
;	   CL = Chip ID
;		5430   = 0
;		5434   = 1
;		5434CK = 2 
;	Remarks:
;
;-----------------------------------------------------------------------
public	GetChipType

GetChipType	proc	near
	push	dx
	push	ax

  ifdef (XGA_BUG)
	mov	cl,AVGA1 and 0Fh	; set for AVGA1
	call	is_chip_unlocked
	jne	ChipIDDone		; no, id is done
  endif	;(XGA_BUG)
	xor	cl,cl			;v1.10A2
	call	get_crtc_addr		; read CR27
	mov	al,27h
	call	getreg
	and	ah,0FCh
	cmp	ah,0A0h
	jz	ChipIDDone		; 5430
	mov	cl,01h
;v1.10A2{
	mov	al,25h
	call	getreg
	cmp	ah,06Bh			; 5434 CK?
	jnz	ChipIDDone
	mov	cl,02h			; 5434 CK
;v1.10A2}
ChipIDDone:
	pop	ax
	pop	dx
	ret
GetChipType	endp

;------------------------------------------------------------------------
; The following routine does memory size and memory clock checking during
; video mode set.  Only 5430 will be ckecked.
;
;	Input:	None
;	Output:	CF = 0; the requested video mode is allowed
;		CF = 1; the requested video mode is not allowed
;------------------------------------------------------------------------
extrn	Detect5430:near

MemSzMclkCheck	proc	near
	push	dx
	push	cx
	push	ax
	mov	al,1Fh
	mov	dx,03C4h
	call	getreg
	and	ah,3Fh			;dx = 3C4h, ah = SR1F[5:0]
	cmp	ah,19h
	jb	NotSupported		;cl = FFh; MCLK < 44.744Mhz
	xor	cl,cl
	cmp	ah,1Ch	
	jb	ReadMclkDone		;cl = 0; 50.114Mhz > MCLk >= 44.744Mhz
	mov	cl,1
	cmp	ah,21h
	jb	ReadMclkDone		;cl = 1; 59.062Mhz > MCLk >= 50.114Mhz
	mov	cl,2			;cl = 2; MCLk >= 59.062Mhz
ReadMclkDone:
	shl	cl,1
	mov	al,015h
	call	getreg			;ah = SR15
	and	ah,0Fh
	call	Detect5430
	jz	ItIs5430
	mov	al,es:[di].s_SzMclk34
	shr	al,cl
	cmp	ah,02h			;If 5434, 0010b = 1M.
	jz	CaseMem512K
	jmp	short ShiftRight
ItIs5430:
	mov	al,es:[di].s_SzMclk30
	shr	al,cl
	test	ah,02h			;b1 = 1 if 1M/2M installed; if 5430.
	jz	CaseMem512K
ShiftRight:
	shr	al,1
CaseMem512K:
	test	al,01h
	jz	NotSupported
Supported:
	clc
	jmp	short MemSzMclkCheckRet
NotSupported:
	stc
MemSzMclkCheckRet:
	pop	ax
	pop	cx
	pop	dx
	ret
MemSzMclkCheck	endp

;------------------------------------------------------------------------

VGA_Segment ENDS
	END
