// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Class declarations for COM Component

#include <objbase.h>
#include <Cesync.h>

#include ".\cldesktop\ListDB.h"
#include "ReplObjHandler.h"

// {25D4DEE2-9AAE-11d3-983B-00A024A0443A}
DEFINE_GUID(CLSID_ActiveSyncEg, 
0x25d4dee2, 0x9aae, 0x11d3, 0x98, 0x3b, 0x0, 0xa0, 0x24, 0xa0, 0x44, 0x3a);

extern LONG g_nComponents;
extern LONG g_nServerLocks;

extern const LPTSTR g_szFriendlyName;
extern const LPTSTR g_szVerIndProgID;
extern const LPTSTR g_szProgID;
extern const LPTSTR g_szStoreFile;

extern HINSTANCE g_hModule;

// Component
class CActiveSyncEg : public IReplStore 
{
public:

	CActiveSyncEg();
	virtual ~CActiveSyncEg();

	// IUnknown standard functions
	virtual HRESULT __stdcall QueryInterface(const IID& iid, void** ppv);
	virtual ULONG __stdcall AddRef ();
	virtual ULONG __stdcall Release();

	// IReplStore method implementations

    STDMETHOD(          Initialize )        (IReplNotify *pNotify, UINT uFlags );
    STDMETHOD(          GetStoreInfo )      (PSTOREINFO pStoreInfo );
    STDMETHOD(          ReportStatus )      (HREPLFLD hFld, HREPLITEM hItem, UINT uStatus, UINT uParam );
    STDMETHOD_( int,    CompareStoreIDs)    (LPBYTE, UINT, LPBYTE, UINT );

    // Item related routines
    STDMETHOD_( int,    CompareItem )       (HREPLITEM hItem1, HREPLITEM hItem2 );
    STDMETHOD_( BOOL,   IsItemChanged)      (HREPLFLD hFld, HREPLITEM hItem, HREPLITEM hItemComp );
    STDMETHOD_( BOOL,   IsItemReplicated )  (HREPLFLD hFld, HREPLITEM hItem );
    STDMETHOD_( void,   UpdateItem )        (HREPLFLD hFld, HREPLITEM hItemDst, HREPLITEM hItemSrc );

    // Folder related routines
    STDMETHOD(          GetFolderInfo )     (LPSTR lpszObjType, HREPLFLD *phFld, IUnknown ** );
    STDMETHOD(          IsFolderChanged )   (HREPLFLD hFld, BOOL *pfChanged );

    // Enumeration of folders
    STDMETHOD(          FindFirstItem )     (HREPLFLD hFld,  HREPLITEM *phItem, BOOL *pfExist );   // get first object the folder
    STDMETHOD(          FindNextItem )      (HREPLFLD hFld,  HREPLITEM *phItem, BOOL *pfExist );   // get next object the folder
    STDMETHOD(          FindItemClose )     (HREPLFLD hFld );                   // done enumerating

    // Object management routines
    STDMETHOD_(UINT,    ObjectToBytes )     (HREPLOBJ hObject, LPBYTE lpb );
    STDMETHOD_(HREPLOBJ,BytesToObject )     (LPBYTE lpb, UINT cb );
    STDMETHOD_(void,    FreeObject )        (HREPLOBJ hObject );
    STDMETHOD_(BOOL,    CopyObject )        (HREPLOBJ hObjSrc, HREPLOBJ hObjDest );
    STDMETHOD(          IsValidObject )     (HREPLFLD hFld, HREPLITEM hObject, UINT uFlags );

    // UI related routines
    STDMETHOD(          ActivateDialog)     (UINT uidDialog, HWND hwndParent, HREPLFLD hFld, IEnumReplItem *penumItem );
    STDMETHOD(          GetObjTypeUIData)   (HREPLFLD hFld, POBJUIDATA pData );
    STDMETHOD(          GetConflictInfo )   (PCONFINFO pConfInfo );
    STDMETHOD(          RemoveDuplicates )  (LPSTR lpszObjType, UINT uFlags );

private:
	LONG m_nRef;

	BOOL m_bInitialized;
	// CDataHandler implements IReplObjHandler
	CDataHandler m_DataHandler;
	CListDB m_ListDB;
};


// structure and define for HREPLITEM and HREPLFLD structures
#define RT_ITEM     1
#define RT_FOLDER   2

typedef struct tagREPLOBJECT
{
	// uType indicates if a folder (RT_FOLDER) or item (RT_ITEM) is currently being 
	// stored
	UINT uType;
	// Create a union so folder and item information can be 
	// stored in the same structure
	union 
	{
		BOOL fChanged;		// for folder, has the contents been changed
		struct				// for item, creation time (unique identifier) and last modify time
		{
			FILETIME ftCreated, ftModified;
		};
	};
} REPLOBJECT, *LPREPLOBJECT;
