// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// ListDB.h: interface for the CListDB class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LISTDB_H__66EB3CB4_9A81_11D3_983B_00A024A0443A__INCLUDED_)
#define AFX_LISTDB_H__66EB3CB4_9A81_11D3_983B_00A024A0443A__INCLUDED_

#define STRLEN_NOTE	256
#define STRLEN_TIME 20

typedef struct tagNOTE
{
	FILETIME ftOriginal;			// time when note was created
	FILETIME ftLastUpdate;			// time when note was last updated
	WCHAR szNote[STRLEN_NOTE];
} NOTE;

class CListDB
{
public:
#ifdef CL_DESKTOP
	BOOL ListNotes(CListCtrl& lstCtrl);
#endif
	BOOL OpenCreateDatabase();
	BOOL AddNote(FILETIME* ftCreateTime, FILETIME* ftModifyTime, LPCWSTR sNote);
	BOOL AddNote(LPCWSTR sNote);
	BOOL DeleteNote(LPCTSTR sNoteTime);
	BOOL DeleteNote(FILETIME* ftNoteTime);

	BOOL DeleteAll();
	BOOL UpdateNote(LPCTSTR sNoteTime, LPCWSTR sNote);
	BOOL UpdateNote(FILETIME* ftNoteTime, LPCWSTR sNote);

	BOOL FindNote(FILETIME* ftToFind, NOTE* lpNote = NULL);
	void StringToFileTime(FILETIME* fileTime, LPCTSTR sNoteTime);

	BOOL GetFirstNote(FILETIME* ftCreateTime, LPWSTR szNote, FILETIME* ftModifyTime);
	BOOL GetNextNote(FILETIME* ftCreateTime, LPWSTR szNote, FILETIME* ftModifyTime);

	CListDB();
	virtual ~CListDB();

	BOOL m_bChanged;		// has the data file changed?
private:
	HANDLE hFile;
	DWORD dwGetNextNote;	// postion in file where next note will be read from
};

#endif // !defined(AFX_LISTDB_H__66EB3CB4_9A81_11D3_983B_00A024A0443A__INCLUDED_)
