// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Registry.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <rapi.h>
#include <iostream.h>

BOOL CeGetPlatformName (LPTSTR  pszPlatformName) 
{
    BOOL        fSuccess    = FALSE;
    LONG        nRetVal     = 0;
    HKEY        hkey        = NULL;
    DWORD       dwType      = 0;
    DWORD       cbSize      = 0;
    WCHAR       szPlatformNameW[ MAX_PATH ];

    // get the registry key
    nRetVal = CeRegOpenKeyEx( HKEY_LOCAL_MACHINE, L"Ident", 0, KEY_ALL_ACCESS, &hkey );   // this will fail if we are not connected
    if ( ERROR_SUCCESS == nRetVal && hkey )
    {
        // get the registry value
        cbSize = sizeof(szPlatformNameW);
        nRetVal = CeRegQueryValueEx( hkey, 
					L"NAME", 
					0, 
					&dwType, 
					(LPBYTE)szPlatformNameW, 
					&cbSize );
        if ( ERROR_SUCCESS == nRetVal )
        {
			szPlatformNameW[cbSize / sizeof(WCHAR)] = '\0';
            // change the text from Unicode to Multibyte
            if (wcstombs( pszPlatformName, szPlatformNameW, MAX_PATH))
                fSuccess = TRUE;
        }
    }
    if (hkey) 
		CeRegCloseKey( hkey );
    return fSuccess;
}

int main(int argc, char* argv[])
{
	HRESULT hr;
	char szDeviceName[MAX_PATH];

	// Obtain device name of connected CE Device
	hr = CeRapiInit();
	if(FAILED(hr))
	{
		cout << "Could not initialize RAPI:" << GetLastError() << endl;
		return 1;
	}
	if(CeGetPlatformName(szDeviceName))
		cout << "Device Name: " << szDeviceName << endl;
	else
		cout << "Could not retrieve device name" << endl;
	hr = CeRapiUninit();
	if(FAILED(hr))
		cout << "Could not un-initialize RAPI" << endl;

	return 0;
}

