// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Notify 'mini-application'

#include <windows.h>

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPWSTR lpCmdLine, int nShowCmd)
{
	UINT nNotifyMsg = RegisterWindowMessage(_T("MSG_NOTIFY"));

	HWND hWnd = FindWindow(_T("Examples"), NULL);
	PROCESS_INFORMATION pi;
	HANDLE hEvent;

	if(hWnd == NULL)
	{
		// create non-signaled event
		hEvent = CreateEvent(NULL, TRUE, 0, _T("Examples_Event"));
		if(CreateProcess(_T("\\Examples.exe"), NULL, NULL, NULL, 
			FALSE,0, NULL, NULL, NULL, &pi))
		{
			CloseHandle(pi.hProcess);
			CloseHandle(pi.hThread);
			if(WaitForSingleObject(hEvent, 5000) == WAIT_FAILED)
				MessageBox(NULL, _T("Example.exe did not start properly"), NULL, MB_OK);
			CloseHandle(hEvent);
		}
		else
			MessageBox(NULL, _T("Could not start Example.exe"), NULL, MB_OK);
	
	}
	SendMessage(HWND_BROADCAST, nNotifyMsg, 0, 0);
	return 0;
}
