// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Input and output routines for sample files

#include "stdafx.h"
#include "examples.h"

const TCHAR endl[] = _T("\r\n");
const TCHAR tab[] = _T("\t");

COutput& COutput::operator<<(LPCTSTR lpOutput)
{
	int nIndex;

    nIndex = GetWindowTextLength(m_hEdit); 
    SendMessage(m_hEdit, EM_SETSEL, nIndex, nIndex); 
    SendMessage(m_hEdit, EM_REPLACESEL, 0, (LPARAM)lpOutput); 
	return *this;
}

COutput& COutput::operator <<(char* lpcharOutput)
{
	LPTSTR lpBuffer = new TCHAR[strlen(lpcharOutput) + 1];
	mbstowcs(lpBuffer, lpcharOutput, strlen(lpcharOutput));
	lpBuffer[strlen(lpcharOutput)] = '\0';
	*this << lpBuffer;
	return *this;
}

COutput& COutput::operator <<(CHAR cOutput)
{
	TCHAR szBuffer[2];
	szBuffer[0] = cOutput;
	szBuffer[1] = '\0';
	*this << szBuffer;
	return *this;
}

COutput& COutput::operator<<(DWORD dwOutput)
{
	TCHAR szBuffer[20];
	wsprintf(szBuffer, _T("%lu"), dwOutput);
	*this << szBuffer;
	return *this;
}

COutput& COutput::operator<<(WORD wOutput)
{
	TCHAR szBuffer[20];
	wsprintf(szBuffer, _T("%u"), wOutput);
	*this << szBuffer;
	return *this;
}

COutput& COutput::operator<<(FLOAT fOutput)
{
	TCHAR szBuffer[20];
	swprintf(szBuffer, _T("%f"), fOutput);
	*this << szBuffer;
	return *this;
}

COutput& COutput::operator<<(int nOutput)
{
	TCHAR szBuffer[20];
	wsprintf(szBuffer, _T("%d"), nOutput);
	*this << szBuffer;
	return *this;
}
void COutput::CLS()
{
	SetWindowText(m_hEdit, NULL);
}

// dialog box procedure for text input dialog

typedef struct tagRESPONSE_INFO
{
	LPCTSTR lpszPrompt;
	LPTSTR lpszValue;
	DWORD dwMax;
} RESPONSE_INFO, *LPRESPONSE_INFO;

LRESULT CALLBACK GetTextResponseDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LPRESPONSE_INFO lpRI;
	switch (message)
	{
		case WM_INITDIALOG:
			lpRI = (LPRESPONSE_INFO)lParam;
			SetWindowText(GetDlgItem(hDlg, IDC_PROMPT), lpRI->lpszPrompt);
			return TRUE;

		case WM_COMMAND:
			if ((LOWORD(wParam) == IDOK))
			{
				if(GetWindowTextLength(GetDlgItem(hDlg, IDC_VALUE)) == 0) 
				{
					MessageBox(hDlg, _T("Please enter a text value!"), szTitle, MB_OK | MB_ICONEXCLAMATION);
					return TRUE;
				}
				GetWindowText(GetDlgItem(hDlg, IDC_VALUE), lpRI->lpszValue, lpRI->dwMax);
				EndDialog(hDlg, TRUE);
				return TRUE;
			}
			else if((LOWORD(wParam) == IDCANCEL))
			{
				EndDialog(hDlg, FALSE);
				return TRUE;
			}
			break;
	}
    return FALSE;
}

// display a dialog box with prompt and get a text response from the user

BOOL GetTextResponse(LPCTSTR lpszPrompt, LPTSTR szText, DWORD dwMax)
{
	RESPONSE_INFO ri;
	ri.lpszPrompt = lpszPrompt;
	ri.lpszValue = szText;
	ri.dwMax = dwMax;

	return DialogBoxParam(hInst, (LPCTSTR)IDD_INPUT, 
					hWnd, (DLGPROC)GetTextResponseDlg, (LPARAM)&ri) == IDOK;
	
}

BOOL GetFilename(LPCTSTR lpszPrompt, LPTSTR szFilename, DWORD dwMax, BOOL bNew)
{
	OPENFILENAME ofn;
	
	szFilename[0] = '\0';
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = szFilename;
	ofn.nMaxFile = dwMax;
	ofn.lpstrFilter = _T("Text Files(*.txt)\0*.txt\0");
	ofn.nFilterIndex = 1;
	ofn.hwndOwner = hWnd;
	ofn.lpstrTitle = lpszPrompt;
	ofn.lpstrDefExt = _T("txt");
	if(bNew)
	{
		ofn.Flags = OFN_OVERWRITEPROMPT;
		return GetSaveFileName(&ofn);
	}
	else
	{
		ofn.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST;
		return GetOpenFileName(&ofn);
	}
}

