// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00


#if !defined(AFX_EXAMPLES_H__B1A30B34_2A0C_4DC1_8FF0_CC351B2F124A__INCLUDED_)
#define AFX_EXAMPLES_H__B1A30B34_2A0C_4DC1_8FF0_CC351B2F124A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"

#define MENU_HEIGHT 26
// Directs output to edit box in main application window.

class COutput
{
public:
	COutput(HWND hEdit) { m_hEdit = hEdit; };
	COutput() { m_hEdit = NULL; };

    COutput& operator<<(LPCTSTR);
	COutput& operator<<(WORD);
	COutput& operator<<(CHAR);
	COutput& operator<<(DWORD);
	COutput& operator<<(FLOAT);
	COutput& operator<<(int);
	COutput& operator<<(char* lpcharOutput);

	void SetOutputWindow(HWND hEdit) { m_hEdit = hEdit; };
	void COutput::CLS();

private:
	HWND m_hEdit;
};

extern const TCHAR endl[];
extern const TCHAR tab[];

BOOL GetTextResponse(LPCTSTR lpszPrompt, LPTSTR szFilename, DWORD dwMax);
BOOL GetFilename(LPCTSTR lpszPrompt, LPTSTR szFilename, DWORD dwMax, BOOL bNew = FALSE);

extern COutput cout;		
extern HWND	hWndEdit;		// Read only edit box for output display
extern HWND	hWnd;			// Handle to application window
extern HINSTANCE hInst;		// The current instance
extern TCHAR szTitle[];		// The title bar text
extern CENOTIFYREQUEST g_cNotifyRequest; // used for database notifications

void Listing2_1();
void Listing2_2();
void Listing2_3();
void Listing2_4();
void Listing2_5();
void Listing2_6();
void Listing2_7();
void Listing2_8();
void Listing2_9();
void Listing2_10();

void Listing3_1();
void Listing3_2();
void Listing3_3();
void Listing3_4();
void Listing3_5(WORD, DEV_BROADCAST_HDR*);// called in response to a WM_DEVICECHANGED message
void Listing3_6();	
void Listing3_7();
void Listing3_8();
void Listing3_9();
void Listing3_10();
void Listing3_11();
void Listing3_12();
void Listing3_13();
void Listing3_14();
void Listing3_15();

void Listing4_1();
void Listing4_2();
void Listing4_3();
HANDLE Listing4_4();
void Listing4_5(HANDLE hDB);
void Listing4_6();
void Listing4_7();
void Listing4_8();
void Listing4_9();
void Listing4_10();
void Listing4_11();
void Listing4_12();
void Listing4_13();
void Listing4_14();
void Listing4_15();
void Listing4_16();
void Listing4_17();
void Listing4_18(CEGUID* pceObjStore, CEOID ceDBOid);
void Listing4_19();
void Listing4_20();
void Listing4_21();
void Listing4_22();
void Listing4_23();
void Listing4_24();
void Listing4_25();

// Chapter 5 - Processes and Threads
void Listing5_1();
void Listing5_2(HWND hWnd);
void Listing5_3();
void Listing5_4();
void Listing5_5();
BOOL Listing5_6();
void Listing5_7();
void Listing5_8();
void Listing5_9();
void Listing5_10();
void Listing5_11();
void Listing5_12();

// Chapter 6 - Critical Sections
void Listing6_1();
void Listing6_2();
void Listing6_3();
void Listing6_4();

// Chapter 7 - Notifications
void Listing7_1();
void Listing7_2();
void Listing7_3();
void Listing7_4();
void Listing7_5();
void Listing7_6();
void Listing7_7();
void Listing7_8();
void Listing7_9();
void Listing7_10(HWND hWnd);
void Listing7_11();

// Chapter 8 - TCP/IP, HTTP etc.
void Listing8_1();		
void Listing8_2();
void Listing8_3();
void Listing8_4();
void Listing8_5();
void Listing8_6();
void Listing8_7();
void Listing8_8();
void Listing8_13();

// Chapter 9 - Serial Communications
void Listing9_1();		
void Listing9_2();		
void Listing9_3();
void Listing9_4();
void Listing9_5();

// Chapter 10 - RAPI Functions in separate projects

// Chapter 11 - TAPI and RAS
void Listing11_1();		
void Listing11_2();		
void Listing11_3();
void Listing11_4();
void Listing11_5();
void Listing11_6();
void Listing11_7(HWND hWnd);
void RasDialEvent(HWND hWnd, WPARAM wParam, LPARAM lParam);
void Listing11_8();
void Listing11_9();

// Chapter 12 - Memory Management
void Listing12_1();
void Listing12_2();
void Listing12_3();
void Listing12_4();
void Listing12_5();
void Listing12_6();
void Listing12_7();
void Listing12_8();
void Listing12_9();

// Chapter 13 - System Information and power management
void Listing13_1();
void Listing13_2();
void Listing13_3();
void Listing13_4();

// Chapter 14 - COM and ActiveX
void Listing14_1();
void Listing14_2();
void Listing14_3();
void Listing14_4(HWND);
void Listing14_5();
void Listing14_6();
void Listing14_7();
void Listing14_8();
void Listing14_9(HWND);
void Listing14_10();
void Listing14_11(HWND);
void Listing14_12(HWND);
void Listing14_13(HWND);
void Listing14_14();
void Listing14_15();

// Chapter 15 - MSMQ
void Listing15_1();
void Listing15_2();
void Listing15_3();
void Listing15_4();
void Listing15_5();
void Listing15_6();
void Listing15_7();
void Listing15_8();

// Chapter 16 - ADOCE, OLEDB and SQL Server
void Listing16_1();
void Listing16_2();
void Listing16_3();
void Listing16_4();
void Listing16_5();
void Listing16_6();
void Listing16_7();
void Listing16_8();
void Listing16_9();
void Listing16_10();
void Listing16_11();
void Listing16_12();
void Listing16_13();
void Listing16_14();
void Listing16_15();

#endif // !defined(AFX_EXAMPLES_H__B1A30B34_2A0C_4DC1_8FF0_CC351B2F124A__INCLUDED_)
