// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Examples.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "Examples.h"
#include <commctrl.h>
#include <aygshell.h>
#include <sipapi.h>
#include <ras.h>

#define MAX_LOADSTRING 100

// Global Variables:
// Global Variables:
HINSTANCE			hInst;			// The current instance
HWND				hwndCB;			// The command bar handle
HWND				hWndEdit;		// Read only edit box for output display
HWND				hWnd;			// Handle to application window
TCHAR				szTitle[MAX_LOADSTRING]; // The title bar text

COutput cout;
UINT nNotifyMsg;		// Global message for Notification from mini-app


static SHACTIVATEINFO s_sai;

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass	(HINSTANCE, LPTSTR);
BOOL				InitInstance	(HINSTANCE, int);
LRESULT CALLBACK	WndProc			(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About			(HWND, UINT, WPARAM, LPARAM);
HWND				CreateRpCommandBar(HWND);


int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	// determin if this is the first instance
	if(Listing5_6())
		return 0;

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_EXAMPLES);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    It is important to call this function so that the application 
//    will get 'well formed' small icons associated with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_EXAMPLES));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}

//
//  FUNCTION: InitInstance(HANDLE, int)
//
//  PURPOSE: Saves instance handle and creates main window
//
//  COMMENTS:
//
//    In this function, we save the instance handle in a global variable and
//    create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd = NULL;
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name

	hInst = hInstance;		// Store instance handle in our global variable
	// Initialize global strings
	LoadString(hInstance, IDC_EXAMPLES, szWindowClass, MAX_LOADSTRING);
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);

	//If it is already running, then focus on the window
	hWnd = FindWindow(szWindowClass, szTitle);	
	if (hWnd) 
	{
		SetForegroundWindow ((HWND) (((DWORD)hWnd) | 0x01));    
		return 0;
	} 

	MyRegisterClass(hInstance, szWindowClass);
	
	RECT	rect;
	GetClientRect(hWnd, &rect);
	
	hWnd = CreateWindow(szWindowClass, szTitle, WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	if (!hWnd)
	{	
		return FALSE;
	}
	//When the main window is created using CW_USEDEFAULT the height of the menubar (if one
	// is created is not taken into account). So we resize the window after creating it
	// if a menubar is present
	{
		RECT rc;
		GetWindowRect(hWnd, &rc);
		rc.bottom -= MENU_HEIGHT;
		if (hwndCB)
			MoveWindow(hWnd, rc.left, rc.top, rc.right, rc.bottom, FALSE);
	}


	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent, nCmdHt;
	RECT	rClient;
//	__try
	{

		if(message == nNotifyMsg) 
		{
			cout << "Notification: Application has run" << endl;
		}
		switch (message) 
		{
			case WM_RASDIALEVENT:
				RasDialEvent(hWnd, wParam, lParam);
				break;
			case WM_COMMAND:
				wmId    = LOWORD(wParam); 
				wmEvent = HIWORD(wParam); 
				// Par*se the menu selections:
				switch (wmId)
				{
					case IDM_HELP_ABOUT:
						DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
						break;
					case IDM_FILE_EXIT:
						DestroyWindow(hWnd);
						break;
					// Chapter 2
					case ID_CHAP2_1:
						cout.CLS();
						Listing2_1();
						break;
					case ID_CHAP2_2:
						cout.CLS();
						Listing2_2();
						break;
					case ID_CHAP2_3:
						cout.CLS();
						Listing2_3();
						break;
					case ID_CHAP2_4:
						cout.CLS();
						Listing2_4();
						break;
					case ID_CHAP2_5:
						cout.CLS();
						Listing2_5();
						break;
					case ID_CHAP2_6:
						cout.CLS();
						Listing2_6();
						break;
					case ID_CHAP2_7:
						cout.CLS();
						Listing2_7();
						break;
					case ID_CHAP2_8:
						cout.CLS();
						Listing2_8();
						break;
					case ID_CHAP2_9:
						cout.CLS();
						Listing2_9();
						break;
					case ID_CHAP2_10:
						cout.CLS();
						Listing2_10();
						break;
					// Chapter 3
					case ID_CHAP3_1:
						cout.CLS();
						Listing3_1();
						break;
					case ID_CHAP3_2:
						cout.CLS();
						Listing3_2();
						break;
					case ID_CHAP3_3:
						cout.CLS();
						Listing3_3();
						break;
					case ID_CHAP3_4:
						cout.CLS();
						Listing3_4();
						break;
					case ID_CHAP3_5:
						MessageBox(hWnd, _T("Routine called automatically in response to a WM_DEVICECHANGED message"), 
									szTitle, MB_OK);;
						break;
					case ID_CHAP3_6:
						cout.CLS();
						Listing3_6();
						break;
					case ID_CHAP3_7:
						cout.CLS();
						Listing3_7();
						break;
					case ID_CHAP3_8:
						cout.CLS();
						Listing3_8();
						break;
					case ID_CHAP3_9:
						cout.CLS();
						Listing3_9();
						break;
					case ID_CHAP3_10:
						cout.CLS();
						Listing3_10();
						break;
					case ID_CHAP3_11:
						cout.CLS();
						Listing3_11();
						break;
					case ID_CHAP3_12:
						cout.CLS();
						Listing3_12();
						break;
					case ID_CHAP3_13:
						cout.CLS();
						Listing3_13();
						break;
					case ID_CHAP3_14:
						cout.CLS();
						Listing3_14();
						break;
					case ID_CHAP3_15:
						cout.CLS();
						Listing3_15();
						break;
					// Chapter 4
					case ID_CHAP4_1:
						cout.CLS();
						Listing4_1();
						break;
					case ID_CHAP4_2:
						cout.CLS();
						Listing4_2();
						break;
					case ID_CHAP4_3:
						cout.CLS();
						Listing4_3();
						break;
					case ID_CHAP4_4:
						cout.CLS();
						HANDLE hDB;
						hDB = Listing4_4(); // open database
						Listing4_5(hDB); // close database
						break;
					case ID_CHAP4_6:
						cout.CLS();
						Listing4_6();
						break;
					case ID_CHAP4_7:
						cout.CLS();
						Listing4_7();
						break;
					case ID_CHAP4_8:
						cout.CLS();
						Listing4_8();
						break;
					case ID_CHAP4_9:
						cout.CLS();
						Listing4_9();
						break;
					case ID_CHAP4_10:
						cout.CLS();
						Listing4_10();
						break;
					case ID_CHAP4_11:
						cout.CLS();
						Listing4_11();
						break;
					case ID_CHAP4_12:
						cout.CLS();
						Listing4_12();
						break;
					case ID_CHAP4_13:
						cout.CLS();
						Listing4_13();
						break;
					case ID_CHAP4_14:
						cout.CLS();
						Listing4_14();
						break;
					case ID_CHAP4_15:
						cout.CLS();
						Listing4_15();
						break;
					case ID_CHAP4_16:
						cout.CLS();
						Listing4_16();
						break;
					case ID_CHAP4_17:
						cout.CLS();
						Listing4_17();
						break;
					case ID_CHAP4_19:
						cout.CLS();
						Listing4_19();
						break;
					case ID_CHAP4_20:
						cout.CLS();
						Listing4_20();
						break;
					case ID_CHAP4_21:
						cout.CLS();
						Listing4_21();
						break;
					case ID_CHAP4_22:
						cout.CLS();
						Listing4_22();
						break;
					case ID_CHAP4_23:
						cout.CLS();
						Listing4_23();
						break;
					case ID_CHAP4_24:
						cout.CLS();
						Listing4_24();
						break;
					case ID_CHAP4_25:
						cout.CLS();
						Listing4_25();
						break;
					//////////////////////////////////////////////////////////
					// Chapter 5 - Processes and Threads
					case ID_CHAP5_1:
						cout.CLS();
						Listing5_1();
						break;
					case ID_CHAP5_2:
						cout.CLS();
						Listing5_2(hWnd);
						break;
					case ID_CHAP5_3:
						cout.CLS();
						Listing5_3();
						break;
					case ID_CHAP5_4:
						cout.CLS();
						Listing5_4();
						break;
					case ID_CHAP5_5:
						cout.CLS();
						Listing5_5();
						break;
					case ID_CHAP5_6:
						cout.CLS();
						cout << _T("Called when application starts up");
						break;
					case ID_CHAP5_7:
						cout.CLS();
						Listing5_7();
						break;
					case ID_CHAP5_8:
						cout.CLS();
						Listing5_8();
						break;
					case ID_CHAP5_9:
						cout.CLS();
						Listing5_9();
						break;
					case ID_CHAP5_10:
						cout.CLS();
						Listing5_10();
						break;
					case ID_CHAP5_11:
						cout.CLS();
						Listing5_11();
						break;
					case ID_CHAP5_12:
						cout.CLS();
						Listing5_12();
						break;
					//////////////////////////////////////////////////////////
					// Chapter 7 - Notifications
					case ID_CHAP6_1:
						cout.CLS();
						Listing6_1();
						break;
					case ID_CHAP6_2:
						cout.CLS();
						Listing6_2();
						break;
					case ID_CHAP6_3:
						cout.CLS();
						Listing6_3();
						// this next call re-uses the stack, and
						// this clears out the memory occupied
						// by the THREADINFO structure.
						cout << _T("Returned from 6.3") << endl;
						break;
					case ID_CHAP6_4:
						cout.CLS();
						Listing6_4();
						// this next call re-uses the stack, and
						// this clears out the memory occupied
						// by the THREADINFO structure.
						cout << _T("Returned from 6.4") << endl;
						break;
					//////////////////////////////////////////////////////////
					// Chapter 7 - Notifications
					case ID_CHAP7_1:
						cout.CLS();
						Listing7_1();
						break;
					case ID_CHAP7_2:		// & 3
						cout.CLS();
						MessageBox(hWnd, _T("See code in \\Notify project"), szTitle, MB_OK);
						break;
					case ID_CHAP7_4:
						cout.CLS();
						Listing7_4();
						break;
					case ID_CHAP7_5:
						cout.CLS();
						Listing7_5();
						break;
					case ID_CHAP7_6:
						cout.CLS();
						Listing7_6();
						break;
					case ID_CHAP7_7:
						cout.CLS();
						Listing7_7();
						break;
					case ID_CHAP7_8:
						cout.CLS();
						Listing7_8();
						break;
					case ID_CHAP7_9:
						cout.CLS();
						Listing7_9();
						break;
					case ID_CHAP7_10:
						cout.CLS();
						Listing7_10(hWnd);
						break;
					case ID_CHAP7_11:
						cout.CLS();
						Listing7_11();
						break;

					//////////////////////////////////////////////////////////
					// Chapter 8 - TCP/IP
					case ID_CHAP8_1:
						cout.CLS();
						Listing8_1();
						break;
					case ID_CHAP8_2:
						cout.CLS();
						Listing8_2();
						break;
					case ID_CHAP8_3:
						cout.CLS();
						Listing8_3();
						break;
					case ID_CHAP8_4:
						cout.CLS();
						Listing8_4();
						break;
					case ID_CHAP8_5:
						cout.CLS();
						Listing8_5();
						break;
					case ID_CHAP8_6:
						cout.CLS();
						Listing8_6();
						break;
					case ID_CHAP8_7:
						cout.CLS();
						Listing8_7();
						break;
					case ID_CHAP8_8:
						cout.CLS();
						Listing8_8();
						break;
					case ID_CHAP8_13:
						cout.CLS();
						Listing8_13();
						break;
					//////////////////////////////////////////////////////////
					// Chapter 9 - Serial Communications
					case ID_CHAP9_1:
						cout.CLS();
						Listing9_1();
						break;
					case ID_CHAP9_2:
						cout.CLS();
						Listing9_2();
						break;
					case ID_CHAP9_3:
						cout.CLS();
						Listing9_3();
						break;
					case ID_CHAP9_4:
						cout.CLS();
						Listing9_4();
						break;
					case ID_CHAP9_5:
						cout.CLS();
						Listing9_5();
						break;

					//////////////////////////////////////////////////////////
					case ID_CHAP10:
						MessageBox(GetFocus(), 
								_T("All chapter 10 functions are in Win32 projects in the directory \\RAPI"), 
								_T("Examples"), MB_OK);
						break;

					//////////////////////////////////////////////////////////
					// Chapter 11 - TAPI and RAS
					case ID_CHAP11_1:
						cout.CLS();
						Listing11_1();
						break;
					case ID_CHAP11_2:
						cout.CLS();
						Listing11_2();
						break;
					case ID_CHAP11_3:
						cout.CLS();
						Listing11_3();
						break;
					case ID_CHAP11_4:
						cout.CLS();
						Listing11_4();
						break;
					case ID_CHAP11_5:
						cout.CLS();
						Listing11_5();
						break;
					case ID_CHAP11_6:
						cout.CLS();
						Listing11_6();
						break;
					case ID_CHAP11_7:
						cout.CLS();
						Listing11_7(hWnd);
						break;
					case ID_CHAP11_8:
						cout.CLS();
						Listing11_8();
						break;
					case ID_CHAP11_9:
						cout.CLS();
						Listing11_9();
						break;

					//////////////////////////////////////////////////////////
					// Chapter 12 - Memory Management
					case ID_CHAP12_1:
						cout.CLS();
						Listing12_1();
						break;
					case ID_CHAP12_2:
						cout.CLS();
						Listing12_2();
						break;

					//////////////////////////////////////////////////////////
					// Chapter 13 - System Information
					case ID_CHAP13_1:
						cout.CLS();
						Listing13_1();
						break;
					case ID_CHAP13_2:
						cout.CLS();
						Listing13_2();
						break;
					case ID_CHAP13_3:
						cout.CLS();
						Listing13_3();
						break;
					case ID_CHAP13_4:
						cout.CLS();
						Listing13_4();
						break;

					//////////////////////////////////////////////////////////
					// Chapter 14 - COM and ActiveX
					case ID_CHAP14_1:
						cout.CLS();
						Listing14_1();
						break;
					case ID_CHAP14_2:
						cout.CLS();
						Listing14_2();
						break;
					case ID_CHAP14_3:
						cout.CLS();
						Listing14_3();
						break;
					case ID_CHAP14_4:
						cout.CLS();
						Listing14_4(hWnd);
						break;
					case ID_CHAP14_5:
						cout.CLS();
						Listing14_5();
						break;
					case ID_CHAP14_6:
						cout.CLS();
						Listing14_6();
						break;
					case ID_CHAP14_7:
						cout.CLS();
						Listing14_7();
						break;
					case ID_CHAP14_8:
						cout.CLS();
						Listing14_8();
						break;
					case ID_CHAP14_9:
						cout.CLS();
						Listing14_9(hWnd);
						break;
					case ID_CHAP14_10:
						cout.CLS();
						Listing14_10();
						break;
					case ID_CHAP14_11:
						cout.CLS();
						Listing14_11(hWnd);
						break;
					case ID_CHAP14_12:
						cout.CLS();
						Listing14_12(hWnd);
						break;
					case ID_CHAP14_13:
						cout.CLS();
						Listing14_13(hWnd);
						break;
					case ID_CHAP14_14:
						cout.CLS();
						Listing14_14();
						break;
					case ID_CHAP14_15:
						cout.CLS();
						Listing14_15();
						break;
					//////////////////////////////////////////////////////////
					// Chapter 15 - COM and ActiveX
					case ID_CHAP15_1:
						cout.CLS();
						Listing15_1();
						break;
					case ID_CHAP15_2:
						cout.CLS();
						Listing15_2();
						break;
					case ID_CHAP15_3:
						cout.CLS();
						Listing15_3();
						break;
					case ID_CHAP15_4:
						cout.CLS();
						Listing15_4();
						break;
					case ID_CHAP15_5:
						cout.CLS();
						Listing15_5();
						break;
					case ID_CHAP15_6:
						cout.CLS();
						Listing15_6();
						break;
					case ID_CHAP15_7:
						cout.CLS();
						Listing15_7();
						break;
					case ID_CHAP15_8:
						cout.CLS();
						Listing15_8();
						break;
					//////////////////////////////////////////////////////////
					// Chapter 16 - ADOCE, OLEDB and SQL Server
					case ID_CHAP16_1:
						cout.CLS();
						Listing16_1();
						break;
					case ID_CHAP16_2:
						cout.CLS();
						Listing16_2();
						break;
					case ID_CHAP16_3:
						cout.CLS();
						Listing16_3();
						break;
					case ID_CHAP16_4:
						cout.CLS();
						Listing16_4();
						break;
					case ID_CHAP16_5:
						cout.CLS();
						Listing16_5();
						break;
					case ID_CHAP16_6:
						cout.CLS();
						Listing16_6();
						break;
					case ID_CHAP16_7:
						cout.CLS();
						Listing16_7();
						break;
					case ID_CHAP16_8:
						cout.CLS();
						Listing16_8();
						break;
					case ID_CHAP16_9:
						cout.CLS();
						Listing16_9();
						break;
					case ID_CHAP16_10:
						cout.CLS();
						Listing16_10();
						break;
					case ID_CHAP16_11:
						cout.CLS();
						Listing16_11();
						break;
					case ID_CHAP16_12:
						cout.CLS();
						Listing16_12();
						break;
					case ID_CHAP16_13:
						cout.CLS();
						Listing16_13();
						break;
					case ID_CHAP16_14:
						cout.CLS();
						Listing16_14();
						break;
					case ID_CHAP16_15:
						cout.CLS();
						Listing16_15();
						break;

					default:
						return DefWindowProc(hWnd, message, wParam, lParam);
				}
				break;
			case WM_CREATE:
				SHMENUBARINFO mbi;

				memset (&mbi, 0, sizeof (SHMENUBARINFO));
				mbi.cbSize     = sizeof (SHMENUBARINFO);
				mbi.hwndParent = hWnd;
				mbi.nToolBarId = IDM_MENU;
				mbi.hInstRes   = hInst;
				mbi.nBmpId     = 0;
				mbi.cBmpImages = 0;

				if (!SHCreateMenuBar(&mbi))
				{
					int nErr = GetLastError();
					TCHAR szBuffer[10];
					wsprintf(szBuffer, _T("%d"), nErr);
					MessageBox(hWnd, _T("SHCreateMenuBar Failed"), szBuffer, MB_OK);
				}

				GetClientRect(hWnd, &rClient);
				nCmdHt = CommandBar_Height(mbi.hwndMB);
				hWndEdit = CreateWindow(_T("Edit"), 
						NULL, WS_CHILD | WS_VISIBLE | ES_READONLY
								| ES_MULTILINE | WS_VSCROLL | WS_HSCROLL, 
						0, 0,
						rClient.right, rClient.bottom - 25, 
						hWnd, NULL, hInst, NULL);
				cout.SetOutputWindow(hWndEdit);

				// Used for notification from Notify.exe (Chapter 7)
				HANDLE hEvent;
				hEvent = CreateEvent(NULL, TRUE, 0, _T("Examples_Event"));
				ResetEvent(hEvent);
				CloseHandle(hEvent);
				break;
			case WM_DESTROY:
				CommandBar_Destroy(hwndCB);
				PostQuitMessage(0);
				break;
			case WM_DEVICECHANGE:
				switch (wParam)
				{
				case DBT_DEVICEARRIVAL:
				case DBT_DEVICEREMOVECOMPLETE: 
					Listing3_5(wParam, (DEV_BROADCAST_HDR*)lParam);
					break;
				default:
					cout << _T("Other WM_DEVICECHANGE message");
					break;
				}
				break;
			case WM_DBNOTIFICATION:   // Listing 4-16
				{
				CENOTIFICATION* cNote = (CENOTIFICATION*)lParam;
				cout << endl << _T("Database Notification: ");
				cout << (DWORD) cNote->dwParam << endl;
				switch(cNote->uType)
				{
					case DB_CEOID_CREATED: 
						cout << _T("New OID object was created.") << endl;
						break;
					case DB_CEOID_DATABASE_DELETED:
						cout << _T("Database was deleted on a volume.") << endl;
						break;
					case DB_CEOID_RECORD_DELETED: 
						cout << _T("Record was deleted in a database.") << endl;
						break;
					case DB_CEOID_CHANGED:
						cout << _T("Object was modified.") << endl; 
						break;
				}
				CeFreeNotification(&g_cNotifyRequest, cNote);
				break;
				}
			default:
				return DefWindowProc(hWnd, message, wParam, lParam);
	   }
	}
//	__except(EXCEPTION_EXECUTE_HANDLER)
//	{
//		MessageBox(hWnd, _T("Page Fault Caught in exception handling!"), szTitle, MB_OK | MB_ICONEXCLAMATION);
//	}
   return 0;
}

HWND CreateRpCommandBar(HWND hwnd)
{
	SHMENUBARINFO mbi;

	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize     = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hwnd;
	mbi.nToolBarId = IDM_MENU;
	mbi.hInstRes   = hInst;
	mbi.nBmpId     = 0;
	mbi.cBmpImages = 0;

	if (!SHCreateMenuBar(&mbi)) 
		return NULL;

	return mbi.hwndMB;
}

// Mesage handler for the About box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	SHINITDLGINFO shidi;

	switch (message)
	{
		case WM_INITDIALOG:
			// Create a Done button and size it.  
			shidi.dwMask = SHIDIM_FLAGS;
			 shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHInitDialog(&shidi);
			return TRUE; 

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
