// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Chapter 8: TCP/IP, HTTP, Sockets etc.

#include "stdafx.h"
#include "examples.h"

#include "wininet.h"

// *** Listing 8.1
//
// Prompts user for a URL and displays HTML code from web server using simple request

#define CHUNKSIZE 500

void Listing8_1()
{
	HINTERNET hHttpOpen = NULL;
	HINTERNET hHttpRequest = NULL;
	TCHAR szURL[MAX_PATH + 1];
	TCHAR szBuffer[CHUNKSIZE + 1];
	DWORD dwRead;
	char charBuffer[CHUNKSIZE + 1];

	if(!GetTextResponse(_T("Simple Request: Enter URL to Display: "), szURL, MAX_PATH))
		return;

	hHttpOpen = InternetOpen(_T("Example Agent"), INTERNET_OPEN_TYPE_DIRECT, 
			NULL, // no proxy
			NULL, // no bypass addresses
			0);	  // no flags

	hHttpRequest = InternetOpenUrl(hHttpOpen,  
         szURL, NULL, 0, 0, 0);
	do 
	{
		// read from Internet HTTP server
		if(!InternetReadFile(hHttpRequest, charBuffer, CHUNKSIZE, &dwRead))
		{
			cout << _T("Could not read data") << GetLastError();
			goto cleanUp;
		}
		// convert to Unicode and display
		charBuffer[dwRead] = '\0';
		mbstowcs(szBuffer, charBuffer, dwRead);
		szBuffer[dwRead] = '\0';
		cout << szBuffer;
	} while(dwRead > 0);
cleanUp:
	if(hHttpRequest != NULL)	
		InternetCloseHandle(hHttpRequest);
	if(hHttpOpen != NULL)
		InternetCloseHandle(hHttpOpen);
}

// *** Listing 8.2
//
// Prompts user for a URL and displays HTML code from web server using HttpOpenRequest

void Listing8_2()
{
	TCHAR szURL[MAX_PATH + 1];
	HINTERNET hHttpOpen = NULL;
	HINTERNET hHttpSession = NULL;
	HINTERNET hHttpRequest = NULL;
	char charBuffer[CHUNKSIZE + 1];
	TCHAR szBuffer[CHUNKSIZE + 1];
	DWORD dwRead;
	URL_COMPONENTS crackedURL;
	TCHAR szServer[1024];
	TCHAR szPath[1024];

	if(!GetTextResponse(_T("More Complex Request: Enter URL to Display: "), szURL, MAX_PATH))
		return;

	hHttpOpen = InternetOpen(_T("Example Agent"), INTERNET_OPEN_TYPE_DIRECT, 
			NULL, // no proxy
			NULL, // no bypass addresses
			0);	  // no flags

	if(hHttpOpen == NULL)
	{
		cout << _T("Could not open internet session ") << GetLastError();
		goto cleanUp;
	}
	// Crack the URL to get the server name
	memset(&crackedURL, 0, sizeof(crackedURL));
	crackedURL.dwStructSize = sizeof(crackedURL);
	crackedURL.lpszHostName = szServer;
	crackedURL.dwHostNameLength = 1024;
	crackedURL.lpszUrlPath = szPath;
	crackedURL.dwUrlPathLength = 1024;

	if(!InternetCrackUrl(szURL, 0, 0, &crackedURL))
	{
		cout << _T("Cannot crack URL") << GetLastError();
		goto cleanUp;
	}
	hHttpSession = InternetConnect(hHttpOpen, 
		crackedURL.lpszHostName,  // server name
		INTERNET_DEFAULT_HTTP_PORT,
		NULL,			// username
		NULL,			// password
		INTERNET_SERVICE_HTTP,
		0,	// no flags
		0);	// no context
	if(hHttpSession == NULL)
	{
		cout << _T("Could not open Internet connection ") << GetLastError();
		goto cleanUp;
	}

	
	hHttpRequest = HttpOpenRequest(hHttpSession, 
			NULL,		// verb is 'GET'
			crackedURL.lpszUrlPath,
			NULL,		// default version
			NULL,		// no referrer
			NULL,		// only accept text/* files
			0,			// no flags
			0);			// no context for call backs
	if(hHttpRequest == NULL)
	{
		cout << _T("Could not get HTTP request ") << GetLastError();
		goto cleanUp;
	}

	if(!HttpSendRequest(hHttpRequest, 
		NULL, 0,			// no headers
		0, 0))				// no optional data
	{
		cout << _T("Could not send request ") << GetLastError();
		goto cleanUp;
	}
	do 
	{
		// read from Internet HTTP server
		if(!InternetReadFile(hHttpRequest, charBuffer, CHUNKSIZE, &dwRead))
		{
			cout << _T("Could not read data") << GetLastError();
			goto cleanUp;
		}
		// convert to Unicode and display
		charBuffer[dwRead] = '\0';
		mbstowcs(szBuffer, charBuffer, dwRead);
		szBuffer[dwRead] = '\0';
		cout << szBuffer;
	} while(dwRead > 0);
cleanUp:
	if(hHttpRequest != NULL)	
		InternetCloseHandle(hHttpRequest);
	if(hHttpSession != NULL)
		InternetCloseHandle(hHttpSession);
	if(hHttpOpen != NULL)
		InternetCloseHandle(hHttpOpen);
}

// To send through a proxy, change the above call to InternetOpen to that shown below, changing
// "SPPROXY" to the name of your proxy server:

//	hHttpOpen = InternetOpen(_T("Example Agent"), INTERNET_OPEN_TYPE_PROXY, 
//			_T("SPPROXY"), // proxy server
//			NULL, // no bypass addresses
//			0);	  // no flags

// *** Listing 8.3
//
// Connecting to a secure site with user name and password, InternetErrorDlg

void Listing8_3()
{
	TCHAR szURL[MAX_PATH + 1];
	HINTERNET hHttpOpen = NULL;
	HINTERNET hHttpSession = NULL;
	HINTERNET hHttpRequest = NULL;
	char charBuffer[CHUNKSIZE + 1];
	TCHAR szBuffer[CHUNKSIZE + 1];
	DWORD dwRead;
	URL_COMPONENTS crackedURL;
	TCHAR szServer[1024];
	TCHAR szPath[1024];


	hHttpOpen = InternetOpen(_T("Example Agent"), INTERNET_OPEN_TYPE_DIRECT, 
			NULL, // no proxy
			NULL, // no bypass addresses
			0);	  // no flags

	if(hHttpOpen == NULL)
	{
		cout << _T("Could not open internet session ") << GetLastError();
		goto cleanUp;
	}
	if(!GetTextResponse(_T("Connect to secure site: Enter URL to Display: "), szURL, MAX_PATH))
		return;
	TCHAR szUser[30], szPassword[30];
	// Crack the URL to get the server name
	memset(&crackedURL, 0, sizeof(crackedURL));
	crackedURL.dwStructSize = sizeof(crackedURL);
	crackedURL.lpszHostName = szServer;
	crackedURL.dwHostNameLength = 1024;
	crackedURL.lpszUrlPath = szPath;
	crackedURL.dwUrlPathLength = 1024;

	if(!InternetCrackUrl(szURL, 0, 0, &crackedURL))
	{
		cout << _T("Cannot crack URL") << GetLastError();
		goto cleanUp;
	}
	if(!GetTextResponse(_T("User: "), szUser, 30))
		return;
	if(!GetTextResponse(_T("Password: "), szPassword, 30))
		return;
	hHttpSession = InternetConnect(hHttpOpen, 
		crackedURL.lpszHostName,  // server name
		INTERNET_DEFAULT_HTTP_PORT,
		NULL, //szUser,				// username
		NULL, //szPassword,			// password
		INTERNET_SERVICE_HTTP,
		0,	// no flags
		0);	// no context
	if(hHttpSession == NULL)
	{
		cout << _T("Could not open Internet connection ") << GetLastError();
		goto cleanUp;
	}

	hHttpRequest = HttpOpenRequest(hHttpSession, 
		NULL,		// verb is 'GET'
		crackedURL.lpszUrlPath,
		NULL,		// default version
		NULL,		// no referrer
		NULL,		// only accept text/* files
		INTERNET_FLAG_KEEP_CONNECTION,		
		0);			// no context for call backs

resend:
	if(!HttpSendRequest(hHttpRequest, 
		NULL, 0,			// no headers
		0, 0))				// no optional data
	{
		cout << _T("Could not send request ") << GetLastError();
		goto cleanUp;
	}
	DWORD dwErrorCode, dwError;

	dwErrorCode = hHttpRequest ? ERROR_SUCCESS : GetLastError();

	dwError = InternetErrorDlg(GetFocus(), hHttpRequest, dwErrorCode, 
							   FLAGS_ERROR_UI_FILTER_FOR_ERRORS | 
							   FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS |
							   FLAGS_ERROR_UI_FLAGS_GENERATE_DATA,
							   NULL);

	if (dwError == ERROR_INTERNET_FORCE_RETRY)
		goto resend;
	do 
	{
		// read from Internet HTTP server
		if(!InternetReadFile(hHttpRequest, charBuffer, CHUNKSIZE, &dwRead))
		{
			cout << _T("Could not read data") << GetLastError();
			goto cleanUp;
		}
		// convert to Unicode and display
		charBuffer[dwRead] = '\0';
		mbstowcs(szBuffer, charBuffer, dwRead);
		szBuffer[dwRead] = '\0';
		cout << szBuffer;
	} while(dwRead > 0);
cleanUp:
	if(hHttpRequest != NULL)	
		InternetCloseHandle(hHttpRequest);
	if(hHttpSession != NULL)
		InternetCloseHandle(hHttpSession);
	if(hHttpOpen != NULL)
		InternetCloseHandle(hHttpOpen);
}

// *** Listing 8.4
//
// Connecting to a secure site with user name and password, InternetSetOption

void Listing8_4()
{
	TCHAR szURL[MAX_PATH + 1];
	HINTERNET hHttpOpen = NULL;
	HINTERNET hHttpSession = NULL;
	HINTERNET hHttpRequest = NULL;
	char charBuffer[CHUNKSIZE + 1];
	TCHAR szBuffer[CHUNKSIZE + 1];
	DWORD dwRead;
	URL_COMPONENTS crackedURL;
	TCHAR szServer[1024];
	TCHAR szPath[1024];


	hHttpOpen = InternetOpen(_T("Example Agent"), INTERNET_OPEN_TYPE_DIRECT, 
			NULL, // no proxy
			NULL, // no bypass addresses
			0);	  // no flags

	if(hHttpOpen == NULL)
	{
		cout << _T("Could not open internet session ") << GetLastError();
		goto cleanUp;
	}
	if(!GetTextResponse(_T("Connect to secure site: Enter URL to Display: "), szURL, MAX_PATH))
		return;
	TCHAR szUser[30], szPassword[30];
	// Crack the URL to get the server name
	memset(&crackedURL, 0, sizeof(crackedURL));
	crackedURL.dwStructSize = sizeof(crackedURL);
	crackedURL.lpszHostName = szServer;
	crackedURL.dwHostNameLength = 1024;
	crackedURL.lpszUrlPath = szPath;
	crackedURL.dwUrlPathLength = 1024;

	if(!InternetCrackUrl(szURL, 0, 0, &crackedURL))
	{
		cout << _T("Cannot crack URL") << GetLastError();
		goto cleanUp;
	}
	if(!GetTextResponse(_T("User: "), szUser, 30))
		return;
	if(!GetTextResponse(_T("Password: "), szPassword, 30))
		return;
	hHttpSession = InternetConnect(hHttpOpen, 
		crackedURL.lpszHostName,  // server name
		INTERNET_DEFAULT_HTTP_PORT,
		NULL, //szUser,				// username
		NULL, //szPassword,			// password
		INTERNET_SERVICE_HTTP,
		0,	// no flags
		0);	// no context
	if(hHttpSession == NULL)
	{
		cout << _T("Could not open Internet connection ") << GetLastError();
		goto cleanUp;
	}

	hHttpRequest = HttpOpenRequest(hHttpSession, 
		NULL,		// verb is 'GET'
		crackedURL.lpszUrlPath,
		NULL,		// default version
		NULL,		// no referrer
		NULL,		// only accept text/* files
		INTERNET_FLAG_KEEP_CONNECTION,
		0);			// no context for call backs

	DWORD dwStatus, dwStatusSize;

	dwStatusSize = sizeof(DWORD);
	if(!HttpQueryInfo(hHttpRequest, HTTP_QUERY_FLAG_NUMBER | 
              HTTP_QUERY_STATUS_CODE, &dwStatus, &dwStatusSize, NULL))
	{
		cout << _T("Could not query info") << GetLastError();
	}

	if(dwStatus == HTTP_STATUS_DENIED) // Server Authentication Required
	{
        // Insert code to set strUsername and strPassword
        InternetSetOption(hHttpRequest, INTERNET_OPTION_USERNAME, 
                          szUser, wcslen(szUser) + 1);
        InternetSetOption(hHttpRequest, INTERNET_OPTION_PASSWORD, 
                          szPassword, wcslen(szUser) + 1);
	}

	do 
	{
		// read from Internet HTTP server
		if(!InternetReadFile(hHttpRequest, charBuffer, CHUNKSIZE, &dwRead))
		{
			cout << _T("Could not read data") << GetLastError();
			goto cleanUp;
		}
		// convert to Unicode and display
		charBuffer[dwRead] = '\0';
		mbstowcs(szBuffer, charBuffer, dwRead);
		szBuffer[dwRead] = '\0';
		cout << szBuffer;
	} while(dwRead > 0);
cleanUp:
	if(hHttpRequest != NULL)	
		InternetCloseHandle(hHttpRequest);
	if(hHttpSession != NULL)
		InternetCloseHandle(hHttpSession);
	if(hHttpOpen != NULL)
		InternetCloseHandle(hHttpOpen);
}


// *** Listing 8.5
//
// Prompts user for a URL and displays HTML code from web server using simple request

void Listing8_5()
{
	HINTERNET hHttpOpen = NULL;
	HINTERNET hHttpRequest = NULL;
	TCHAR szURL[MAX_PATH + 1];
	TCHAR szData[MAX_PATH + 1];
	TCHAR szDataCan[MAX_PATH + 1];
	TCHAR szURLRequest[MAX_PATH * 2 + 1];

	TCHAR szBuffer[CHUNKSIZE + 1];
	DWORD dwRead, dwBuffLen;
	char charBuffer[CHUNKSIZE + 1];

	if(!GetTextResponse(_T("URL With Data: Enter URL to Display: "), szURL, MAX_PATH))
		return;
	if(!GetTextResponse(_T("Data To Send: "), szData, MAX_PATH))
		return;

	hHttpOpen = InternetOpen(_T("Example Agent"), INTERNET_OPEN_TYPE_DIRECT, 
			NULL, // no proxy
			NULL, // no bypass addresses
			0);	  // no flags

	dwBuffLen = MAX_PATH;
	if(!InternetCanonicalizeUrl(szData, szDataCan, &dwBuffLen, 0))
	{
		cout << _T("Could not encode request %d") << GetLastError();
		return;
	}
	wcscpy(szURLRequest, szURL);
	wcscat(szURLRequest, szDataCan);
	cout << _T("URL Request: ") << szURLRequest << endl;

	hHttpRequest = InternetOpenUrl(hHttpOpen, szURLRequest, NULL, 0, 0, 0);
	do 
	{
		// read from Internet HTTP server
		if(!InternetReadFile(hHttpRequest, charBuffer, CHUNKSIZE, &dwRead))
		{
			cout << _T("Could not read data") << GetLastError();
			goto cleanUp;
		}
		// convert to Unicode and display
		charBuffer[dwRead] = '\0';
		mbstowcs(szBuffer, charBuffer, dwRead);
		szBuffer[dwRead] = '\0';
		cout << szBuffer;
	} while(dwRead > 0);
cleanUp:
	if(hHttpRequest != NULL)	
		InternetCloseHandle(hHttpRequest);
	if(hHttpOpen != NULL)
		InternetCloseHandle(hHttpOpen);
}

// *** Listing 8.6
//
// Posts information to an Internet Server

LPCTSTR lpHeader = _T("Content-Type: application/x-www-form-urlencoded\r\n");
LPCTSTR lpData = _T("The data to be sent to the Internet Server");
	

void Listing8_6()
{
	TCHAR szURL[MAX_PATH + 1];
	HINTERNET hHttpOpen = NULL;
	HINTERNET hHttpSession = NULL;
	HINTERNET hHttpRequest = NULL;
	char charBuffer[CHUNKSIZE + 1];
	TCHAR szBuffer[CHUNKSIZE + 1];
	DWORD dwRead;
	URL_COMPONENTS crackedURL;
	TCHAR szServer[1024];
	TCHAR szPath[1024];

	if(!GetTextResponse(_T("Enter URL to post to: "), szURL, MAX_PATH))
		return;

	hHttpOpen = InternetOpen(_T("Example Agent"), INTERNET_OPEN_TYPE_DIRECT, 
			NULL, // no proxy
			NULL, // no bypass addresses
			0);	  // no flags

	if(hHttpOpen == NULL)
	{
		cout << _T("Could not open Internet session ") << GetLastError();
		goto cleanUp;
	}
	// Crack the URL to get the server name
	memset(&crackedURL, 0, sizeof(crackedURL));
	crackedURL.dwStructSize = sizeof(crackedURL);
	crackedURL.lpszHostName = szServer;
	crackedURL.dwHostNameLength = 1024;
	crackedURL.lpszUrlPath = szPath;
	crackedURL.dwUrlPathLength = 1024;

	if(!InternetCrackUrl(szURL, 0, 0, &crackedURL))
	{
		cout << _T("Cannot crack URL") << GetLastError();
		goto cleanUp;
	}
	hHttpSession = InternetConnect(hHttpOpen, 
		crackedURL.lpszHostName,  // server name
		INTERNET_DEFAULT_HTTP_PORT,
		NULL,			// username
		NULL,			// password
		INTERNET_SERVICE_HTTP,
		0,	// no flags
		0);	// no context
	if(hHttpSession == NULL)
	{
		cout << _T("Could not open Internet connection ") << GetLastError();
		goto cleanUp;
	}

	hHttpRequest = HttpOpenRequest(hHttpSession, 
			_T("POST"),		// verb 
			crackedURL.lpszUrlPath,
			NULL,		// default version
			NULL,		// no referrer
			NULL,		// only accept text/* files
			0,			// no flags
			0);			// no context for call backs
	if(hHttpRequest == NULL)
	{
		cout << _T("Could not get HTTP request ") << GetLastError();
		goto cleanUp;
	}

	if(!HttpAddRequestHeaders(hHttpRequest,
                       lpHeader, 
					   wcslen(lpHeader), 
					   HTTP_ADDREQ_FLAG_REPLACE | HTTP_ADDREQ_FLAG_ADD))
	{
		cout << _T("Could not add HTTP header ") << GetLastError();
		goto cleanUp;
	}

	// convert the data to ANSI
	char szAnsi[1024];
	wcstombs(szAnsi, lpData, wcslen(lpData));
	szAnsi[wcslen(lpData)] = '\0';

	if(!HttpSendRequest(hHttpRequest, 
		NULL, 0,			// no headers
		(LPVOID)szAnsi, strlen(szAnsi)))				// data to be sent
	{
		cout << _T("Could not send request ") << GetLastError();
		goto cleanUp;
	}
	do 
	{
		// read from Internet HTTP server
		if(!InternetReadFile(hHttpRequest, charBuffer, CHUNKSIZE, &dwRead))
		{
			cout << _T("Could not read data") << GetLastError();
			goto cleanUp;
		}
		// convert to Unicode and display
		charBuffer[dwRead] = '\0';
		mbstowcs(szBuffer, charBuffer, dwRead);
		szBuffer[dwRead] = '\0';
		cout << szBuffer;
	} while(dwRead > 0);
cleanUp:
	if(hHttpRequest != NULL)	
		InternetCloseHandle(hHttpRequest);
	if(hHttpSession != NULL)
		InternetCloseHandle(hHttpSession);
	if(hHttpOpen != NULL)
		InternetCloseHandle(hHttpOpen);
}

// *** Listing 8.7
//
// Displays device's IP address and host name
//

void Listing8_7()
{
	WSADATA wsaData;
	char szHostName[1024];
	HOSTENT* lphostent;
	in_addr address;

	if(WSAStartup(MAKEWORD(1,1), &wsaData) != 0)
	{
		cout << _T("Could not initialize sockets") << endl; 
		return;
	}
	if(gethostname (szHostName, 1024) == SOCKET_ERROR)
	{
		cout << _T("Could not get host name") << WSAGetLastError() << endl; 
		return;
	}
	cout << _T("Host Name:") << szHostName << endl;

	lphostent = gethostbyname(szHostName);
	if(lphostent == NULL)
	{
		cout << _T("Could not get host information:") << WSAGetLastError() << endl; 
		return;
	}
	cout << _T("Official Host name:") << lphostent->h_name << endl;
	cout << _T("Length of address (bytes):") << lphostent->h_length << endl;
	for(int i = 0; lphostent->h_addr_list[i] != NULL; i++)
	{
		memcpy(&address, lphostent->h_addr_list[i], sizeof(address));
		cout << _T("IP Address: ") 
			<< address.S_un.S_un_b.s_b1 << _T(".") 
			<< address.S_un.S_un_b.s_b2 << _T(".") 	
			<< address.S_un.S_un_b.s_b3 << _T(".") 	
			<< address.S_un.S_un_b.s_b4 << endl;
	}

	if(WSACleanup() == SOCKET_ERROR)
	{
		cout << _T("Could not cleanup sockets:") << WSAGetLastError() << endl; 
		return;
	}
	return;
}


// *** Listing 8.8
//
// Pings an IP address
//

// These .H files are in the project directory as they're not included in all platform builds

extern "C"
{
#include "ipexport.h"
#include "icmpapi.h"
}

// NOTE: include icmplib.lib into the project. May not run under emulation

void Listing8_8()
{
	TCHAR szIPAddr[30];
	char szchrIPAddr[30];
	HANDLE hIcmp;
	char* lpToSend = "Ping information";

	BYTE bIn[1024];
	int rc;
	in_addr ipFromAddress;
	PICMP_ECHO_REPLY lpEchoReply;
	DWORD dwToPing;

	if(!GetTextResponse(_T("IP Address (e.g. 192.168.0.2) to Ping: "), szIPAddr, 30))
		return;
	// Convert to ANSI char string
	wcstombs(szchrIPAddr, szIPAddr, wcslen(szIPAddr) + 1);
	dwToPing = inet_addr(szchrIPAddr);
	if(dwToPing == -1)
	{
		cout << _T("Invalid IP address") << endl;
		return;
	}
	hIcmp = IcmpCreateFile();
	if(hIcmp == INVALID_HANDLE_VALUE)
	{
		cout << _T("Cannot open Icmp") << endl;
		return;
	}
	
	rc  = IcmpSendEcho(hIcmp, dwToPing, lpToSend, strlen(lpToSend), 
				NULL, bIn, sizeof(bIn), 2000);
	if(rc == 0)
		cout << _T("Ping failed:") << GetLastError() << endl;
	else
	{
		lpEchoReply = (PICMP_ECHO_REPLY)bIn;
		for(int i = 0; i < rc; i++)
		{
			memcpy(&ipFromAddress, &lpEchoReply->Address, sizeof(in_addr));
			cout << _T("Reply from: ") 
					<< inet_ntoa(ipFromAddress)
					<< _T(" Number bytes: ") << lpEchoReply->DataSize 
					<< _T(" Round Trip: ") << lpEchoReply->RoundTripTime 
					<< _T(" Milliseconds.") << endl;
			lpEchoReply++;	// move to next reply
		}
	}
	IcmpCloseHandle(hIcmp);
}

// *******
// For Listings 8-9 to 8-12 see project \SockClient and \SockServer.
//

// *** Listing 8.13
//
// Display list of IR devices in range
//

#include <af_irda.h>

void Listing8_13()
{
	SOCKET irSocket;
	char chBuffer[1024];
	int nSize;
	ULONG ul;
	TCHAR szDeviceName[23];

	DEVICELIST *pDevList;

	irSocket = socket(AF_IRDA, SOCK_STREAM, 0);
	if(irSocket == INVALID_SOCKET)
	{
		cout << _T("Could not open IR socket") << endl;
		return;
	}

	nSize = sizeof(chBuffer);
	if(getsockopt(irSocket, SOL_IRLMP, IRLMP_ENUMDEVICES, chBuffer, &nSize)
			== SOCKET_ERROR)
	{
		cout << _T("Could not get device list:") << WSAGetLastError() << endl;
		closesocket(irSocket);
		return;
	}
	pDevList = (DEVICELIST*) chBuffer;
	if(pDevList->numDevice == 0)
		cout << _T("No devices found") << endl;
	else
	{
		for(ul = 0; ul < pDevList->numDevice; ul++)
		{
			cout << _T("Device ID:") <<
					pDevList->Device[ul].irdaDeviceID[0] <<
					pDevList->Device[ul].irdaDeviceID[1] <<
					pDevList->Device[ul].irdaDeviceID[2] <<
					pDevList->Device[ul].irdaDeviceID[3];
			mbstowcs(szDeviceName, pDevList->Device[ul].irdaDeviceName,
					sizeof(pDevList->Device[ul].irdaDeviceName));
			cout << _T(" Name: ") << szDeviceName << endl;
		}		
	}
	closesocket(irSocket);
}
