// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Chapter 6: Synchronization. Sample Code

#include "stdafx.h"
#include "examples.h"


// *** Listing 6.1
//
// Critical Sections

float g_fValue;
CRITICAL_SECTION g_cs;
DWORD WINAPI f1(LPVOID);
DWORD WINAPI f2(LPVOID);

void Listing6_1()
{
	HANDLE hThread1, hThread2;
	DWORD dwThreadID;

	g_fValue = 10.0;
	InitializeCriticalSection(&g_cs);
	hThread1 = CreateThread(NULL, 0, f1, NULL, 0, &dwThreadID);
	hThread2 = CreateThread(NULL, 0, f2, NULL, 0, &dwThreadID);
	// Wait until thread 1 and thread 2 completes
	WaitForSingleObject(hThread1, INFINITE);
	WaitForSingleObject(hThread2, INFINITE);
	DeleteCriticalSection(&g_cs);
	CloseHandle(hThread1);
	CloseHandle(hThread2);
	cout << _T("Finished:") << g_fValue << endl;
}

DWORD WINAPI f1(LPVOID)
{
	EnterCriticalSection(&g_cs);
	g_fValue = g_fValue * g_fValue;
	LeaveCriticalSection(&g_cs);
	return 0;
}

DWORD WINAPI f2(LPVOID)
{
	EnterCriticalSection(&g_cs);
	g_fValue = (float)3.0 + g_fValue;
	LeaveCriticalSection(&g_cs);
	return 0;
}

// *** Listing 6.2
//
// Using Mutex objects

float g_fValueMutex = 10.0;
DWORD WINAPI fc1(LPVOID);
DWORD WINAPI fc2(LPVOID);
HANDLE hMutex;

void Listing6_2()
{
	HANDLE hThread1, hThread2;
	DWORD dwThreadID;

	g_fValueMutex = 10.0;
	// Create mutex that's initially owned by this thread
	hMutex = CreateMutex(NULL, TRUE, NULL);
	hThread1 = CreateThread(NULL, 0, fc1, NULL, 0, &dwThreadID);
	hThread2 = CreateThread(NULL, 0, fc2, NULL, 0, &dwThreadID);
	// Release Mutex to allow both threads to execute their code.
	ReleaseMutex(hMutex);
	// Wait until thread 1 and thread 2 completes
	WaitForSingleObject(hThread1, INFINITE);
	WaitForSingleObject(hThread2, INFINITE);
	// Close handle for the mutex and threads
	CloseHandle(hMutex);
	CloseHandle(hThread1);
	CloseHandle(hThread2);
	cout << _T("Finished:") << g_fValueMutex << endl;
}

DWORD WINAPI fc1(LPVOID)
{
	WaitForSingleObject(hMutex, INFINITE);
	g_fValueMutex = g_fValueMutex * g_fValueMutex;
	ReleaseMutex(hMutex);
	return 0;
}

DWORD WINAPI fc2(LPVOID)
{
	WaitForSingleObject(hMutex, INFINITE);
	g_fValueMutex = (float)3.0 + g_fValueMutex;
	ReleaseMutex(hMutex);
	return 0;
}

// *** Listing 6.3
//
// Code requiring synchronization

typedef struct tagTHREADINFO {
		DWORD dwVal1, dwVal2;
} THREADINFO, *LPTHREADINFO;

DWORD WINAPI ThreadFunc(LPVOID lpThreadInfo);

void Listing6_3()
{
	THREADINFO threadInfo;
	HANDLE hThread;
	DWORD dwThreadId;

	threadInfo.dwVal1 = 20;
	threadInfo.dwVal2 = 40;

	hThread = CreateThread(NULL, 0, ThreadFunc,
				(LPVOID)&threadInfo, 0, &dwThreadId);
	CloseHandle(hThread);
}

DWORD ThreadFunc(LPVOID lpThreadInfo)
{
	LONG lResult;
	THREADINFO tInfo = *((LPTHREADINFO)lpThreadInfo);
	lResult = tInfo.dwVal1 * tInfo.dwVal2;
	cout << _T("Result: ") << lResult << endl;
	return 0;
}

// *** Listing 6.4
//
// Using Events for synchronization

DWORD WINAPI ThreadFunc2(LPVOID lpThreadInfo);
HANDLE hEvent;

void Listing6_4()
{
	THREADINFO threadInfo;
	HANDLE hThread;
	DWORD dwThreadId;

	threadInfo.dwVal1 = 20;
	threadInfo.dwVal2 = 40;

	hEvent = CreateEvent(NULL,
			TRUE,   // manual event
			FALSE,	// initially non-signaled
			NULL);	// no name
	hThread = CreateThread(NULL, 0, ThreadFunc2,
				(LPVOID)&threadInfo, 0, &dwThreadId);
	WaitForSingleObject(hEvent, INFINITE);
	CloseHandle(hEvent);
	CloseHandle(hThread);
}

DWORD ThreadFunc2(LPVOID lpThreadInfo)
{
	LONG lResult;
	THREADINFO tInfo = *((LPTHREADINFO)lpThreadInfo);
	SetEvent(hEvent);
	lResult = tInfo.dwVal1 * tInfo.dwVal2;
	cout << _T("Result: ") << lResult << endl;
	return 0;
}



