// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Chapter 2: Files. Sample Code

#include "stdafx.h"
#include "examples.h"


// *** Listing 2.1
//
// Determines the content type of a text file (ANSI or Unicode).

void Listing2_1()
{
	HANDLE hFile;
	WORD wLeadin;
	DWORD dwNumRead;
	TCHAR szFilename[MAX_PATH + 1];

	if(!GetFilename(_T("Enter filename:"), szFilename, MAX_PATH))
		return;
	hFile = CreateFile(szFilename, GENERIC_READ, 0, 0, OPEN_EXISTING, 0, 0);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		cout << _T("Could not open file. Error:") << GetLastError();
		return;
	}
	if(ReadFile(hFile, &wLeadin, 2, &dwNumRead, 0))
	{
		// is this a Unicode file? Determine byte order sequence
		if(wLeadin == 0xFEFF)
			cout << _T("Unicode File") << endl;
		else if(wLeadin == 0xFFFE)
			cout << _T("Byte reversed Unicode file") << endl;
		else
			cout << _T("Text file") << endl;
	} 
	else 
	{

		cout << _T("Could not read file. Error: ") << GetLastError();
	}
	CloseHandle(hFile);
}

// *** Listing 2.2
//
// Displays the contents of a Unicode text file

void Listing2_2()
{
	HANDLE hFile;
	WORD wLeadin;
	DWORD dwNumRead;
	TCHAR szFilename[MAX_PATH + 1], szChar[2];

	if(!GetFilename(_T("Enter filename:"), szFilename, MAX_PATH))
		return;
	hFile = CreateFile(szFilename, GENERIC_READ, 0, 0, OPEN_EXISTING, 0, 0);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		cout << _T("Could not open file. Error:") << GetLastError();
		return;
	}
	if(ReadFile(hFile, &wLeadin, 2, &dwNumRead, 0))
	{
		if(wLeadin == 0xFEFF)
			// read file character by character
			while(ReadFile(hFile, szChar, sizeof(TCHAR), &dwNumRead, 0) && dwNumRead > 0)
			{
				szChar[1] = '\0';
				cout << szChar;
			}
		else 
			cout << _T("File is not Unicode!") << endl;
	} 
	else 
		cout << _T("Could not read file. Error: ") << GetLastError();
	CloseHandle(hFile);
}

// *** Listing 2.3
//
// Displays the file times associated with the given file

void ShowTime(FILETIME t)
{
	FILETIME ft;
	SYSTEMTIME st;

	FileTimeToLocalFileTime(&t, &ft);
	FileTimeToSystemTime(&ft, &st);
	cout << st.wMonth << _T("/") << st.wDay
		 << _T("/") << st.wYear << _T(" ") << st.wHour 
		 << _T(":") << st.wMinute << endl;
}

void Listing2_3()
{
	HANDLE hFile;
	TCHAR szFilename[MAX_PATH + 1];
	FILETIME ftCreate, ftLastWrite, ftLastAccess;

	if(!GetFilename(_T("Enter filename:"), szFilename, MAX_PATH))
		return;
	hFile = CreateFile(szFilename, GENERIC_READ, 0, 0, OPEN_EXISTING, 0, 0);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		cout << _T("Could not open file. Error:") << GetLastError();
		return;
	}
	if(GetFileTime(hFile, &ftCreate, &ftLastWrite, &ftLastAccess))
	{
		cout << _T("Create time: ");
		ShowTime(ftCreate);
		cout << _T("Last write time: ");
		ShowTime(ftLastWrite);
		cout << _T("Last Access time: ");
		ShowTime(ftLastAccess);
	}
	else
		cout << _T("Could not file times. Error: ") << GetLastError();
	CloseHandle(hFile);
}


// *** Listing 2.4
//
// Reports size of file in bytes.

void Listing2_4()
{
	HANDLE hFile;
	TCHAR szFilename[MAX_PATH + 1];
	DWORD dwSizeLo, dwSizeHi;

	if(!GetFilename(_T("Enter filename:"), szFilename, MAX_PATH))
		return;
	hFile = CreateFile(szFilename, GENERIC_READ, 0, 0, OPEN_EXISTING, 0, 0);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		cout << _T("Could not open file. Error:") << GetLastError();
		return;
	}
	
	dwSizeLo = GetFileSize (hFile, &dwSizeHi);
	if(dwSizeLo == 0xFFFFFFFF && GetLastError() != NO_ERROR)
		cout << _T("Error getting file size: ") << GetLastError();
	else
		cout << _T("Filesize (Low, High) : ") << dwSizeLo << _T(",") << dwSizeHi;
	CloseHandle(hFile);
}

// *** Listing 2.5
//
// Reports file attributes.

void ShowAttributes(DWORD dwAttributes)
{
	if(dwAttributes & FILE_ATTRIBUTE_READONLY)
		cout << _T("Read only") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_HIDDEN)
		cout << _T("Hidden") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_SYSTEM)
		cout << _T("System") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_DIRECTORY)
		cout << _T("Directory") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_ARCHIVE)
		cout << _T("Archive") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_INROM)
		cout << _T("In ROM") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_NORMAL)
		cout << _T("Normal") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_TEMPORARY)
		cout << _T("Temporary") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_COMPRESSED)
		cout << _T("Compressed") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_ROMSTATICREF)
		cout << _T("ROM Static Ref") << endl;
	if(dwAttributes & FILE_ATTRIBUTE_ROMMODULE)
		cout << _T("ROM Module") << endl;
}

void Listing2_5()
{
	TCHAR szFilename[MAX_PATH + 1];
	DWORD dwAttributes;

	if(!GetFilename(_T("Enter filename:"), szFilename, MAX_PATH))
		return;
	dwAttributes = GetFileAttributes(szFilename);
	ShowAttributes(dwAttributes);
}

// *** Listing 2.6
//
// List all information for a given file.

void Listing2_6()
{
	HANDLE hFile;
	TCHAR szFilename[MAX_PATH + 1];
	BY_HANDLE_FILE_INFORMATION fiInfo;

	if(!GetFilename(_T("Enter filename:"), szFilename, MAX_PATH))
		return;
	hFile = CreateFile(szFilename, GENERIC_READ, 0, 0, OPEN_EXISTING, 0, 0);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		cout << _T("Could not open file. Error:") << GetLastError();
		return;
	}
	if(GetFileInformationByHandle(hFile, &fiInfo))
	{
		ShowAttributes(fiInfo.dwFileAttributes);
		cout << _T("Create time: ");
		ShowTime(fiInfo.ftCreationTime);
		cout << _T("Last write time: ");
		ShowTime(fiInfo.ftLastWriteTime);
		cout << _T("Last Access time: ");
		ShowTime(fiInfo.ftLastAccessTime);
		cout << _T("Volume serial number: ") << fiInfo.dwVolumeSerialNumber << endl;
		cout << _T("File size: ") << fiInfo.nFileSizeLow << endl;
		cout << _T("High index: ") << fiInfo.nFileIndexHigh << endl;
		cout << _T("Low index: ") << fiInfo.nFileIndexLow << endl;
		cout << _T("Object ID: ") << fiInfo.dwOID << endl;
	}
	CloseHandle(hFile);
}

// *** Listing 2.7
//
// Writing structures to a file.

typedef struct
{
	int a, b, c;
} DATA;

void Listing2_7()
{
	HANDLE hFile;
	TCHAR szFilename[MAX_PATH + 1];
	BOOL bSuccess;
	DATA dataRec;
	int x;
	DWORD numWrite;

	if(!GetFilename(_T("Enter filename to create:"), szFilename, MAX_PATH, TRUE))
		return;
	cout << szFilename;
	hFile = CreateFile(szFilename, GENERIC_WRITE, 0, 0, CREATE_NEW, 0, 0);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		cout << _T("Could not open file. Error:") << GetLastError();
		return;
	}
	x = 0;
	do
	{
		dataRec.a = dataRec.b = dataRec.c = x;
		bSuccess = WriteFile(hFile, &dataRec, sizeof(dataRec), &numWrite, 0);
	} 
	while(bSuccess && x++ < 10);

	CloseHandle(hFile);
}


// *** Listing 2.8
//
// Get 5th record from file created in Listing 2.7 and displays it.

void Listing2_8()
{
	HANDLE hFile;
	DWORD dwNumRead;
	TCHAR szFilename[MAX_PATH + 1];
	DATA dataRec;

	if(!GetFilename(_T("Enter filename:"), szFilename, MAX_PATH))
		return;
	hFile = CreateFile(szFilename, GENERIC_READ, 0, 0, OPEN_EXISTING, 0, 0);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		cout << _T("Could not open file. Error:") << GetLastError();
		return;
	}
	SetFilePointer(hFile, 5 * sizeof(DATA), 0, FILE_BEGIN);
	if(GetLastError() != NO_ERROR)
	{
		cout << _T("Could not seek to file. Error:") << GetLastError();
	}
	else 
	{
		if(ReadFile(hFile, &dataRec, sizeof(DATA), &dwNumRead, 0))
		{
			cout << _T("Record 5: ") << dataRec.a << _T(" ") 
					<< dataRec.b << _T(" ") << dataRec.c << endl;
		} 
		else 
		{
			cout << _T("Could not read file. Error: ") << GetLastError();
		}
	}
	CloseHandle(hFile);
}

// *** Listing 2.9
//
// Display Unicode text file using file mapping.

void Listing2_9()
{
	HANDLE hFile;
	TCHAR szFilename[MAX_PATH + 1];
	HANDLE hFileMap;
	LPTSTR lpFile;

	if(!GetFilename(_T("Enter filename:"), szFilename, MAX_PATH))
		return;
	hFile = CreateFileForMapping(szFilename, GENERIC_READ, 0, 0, OPEN_EXISTING, 0, 0);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		cout << _T("Could not open file. Error:") << GetLastError();
		return;
	}
	hFileMap = CreateFileMapping(hFile, 0, PAGE_READONLY, 0, 0, NULL);
	if(hFileMap == NULL)
	{
		cout << _T("Could not create file mapping. Error:") << GetLastError();
		CloseHandle(hFile);
		return;
	}
	lpFile = (LPTSTR) MapViewOfFile(hFileMap, FILE_MAP_READ, 0, 0, 0);
	if(lpFile == NULL)
		cout << _T("Could not create view of map. Error:") << GetLastError();
	else
	{
		if((DWORD)*lpFile != 0xFEFF)
			cout << _T("Not a Unicode file");
		else
		{
			lpFile++;		// skip over first two bytes.
			cout << lpFile; // DANGEROUS! Assumes '\0' terminated file
		}
		UnmapViewOfFile(lpFile);
	}
	CloseHandle(hFileMap);
	CloseHandle(hFile);
}

// *** Listing 2.10
//
// Display Unicode text file using writable file mapping.

void Listing2_10()
{
	HANDLE hFile;
	TCHAR szFilename[MAX_PATH + 1];
	HANDLE hFileMap;
	LPTSTR lpFile;
	DWORD dwSizeLo;

	if(!GetFilename(_T("Enter filename:"), szFilename, MAX_PATH))
		return;
	hFile = CreateFileForMapping(szFilename, GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, 0, 0);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		cout << _T("Could not open file. Error:") << GetLastError();
		return;
	}
	dwSizeLo = GetFileSize (hFile, NULL);	// assume < 4 gigabytes
	hFileMap = CreateFileMapping(hFile, 0, PAGE_READWRITE, 0, dwSizeLo + 1, NULL);
	if(hFileMap == NULL)
	{
		cout << _T("Could not create file mapping. Error:") << GetLastError();
		CloseHandle(hFile);
		return;
	}
	lpFile = (LPTSTR) MapViewOfFile(hFileMap, FILE_MAP_WRITE, 0, 0, 0);
	if(lpFile == NULL)
		cout << _T("Could not create view of map. Error:") << GetLastError();
	else
	{
		if((DWORD)*lpFile != 0xFEFF)
			cout << _T("Not a Unicode file");
		else
		{
			// add terminating NULL character
			lpFile[dwSizeLo] = '\0';
			lpFile++;		// skip over first two bytes.
			cout << lpFile; 
		}
		UnmapViewOfFile(lpFile);
	}
	CloseHandle(hFileMap);
	// remove NULL character at end of file
	SetFilePointer(hFile, -2, NULL, FILE_END);
	SetEndOfFile(hFile);
	CloseHandle(hFile);
}


