// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Chapter 14: COM and ActiveX Sample code

#include "stdafx.h"
#include "examples.h"


// *** Listing 14.1
//
// Initialize COM

#include <objbase.h>
// include ole32.lib and oleaut32.lib in project

void Listing14_1()
{
	HRESULT hr;

	hr = CoInitializeEx(NULL, COINIT_MULTITHREADED);
	if(FAILED(hr))
		cout << _T("Failed to initialize COM") << endl;
	else
		cout << _T("COM Initialized") << endl;
}

// *** Listing 14.2
//
// Uninitialize COM

void Listing14_2()
{
	CoUninitialize();
	cout << _T("COM Uninitialized") << endl;
}

// *** Listing 14.3
//
// Create POOM Object

// #define INITGUID in stdafx.h before #include <windows.h>

#include <pimstore.h>
IPOutlookApp *g_poomApp;

void Listing14_3()
{
	HRESULT hr;
	hr = CoCreateInstance(CLSID_Application, 
				NULL, 
				CLSCTX_INPROC_SERVER, 
				IID_IPOutlookApp, (LPVOID *)&g_poomApp);
	if (FAILED(hr)) 
		cout << _T("Could not create Outlook Application Object");
	else
		cout << _T("Outlook Application Object created") << endl;
}


// *** Listing 14.4
//
// Logon to POOM and display version number

void Listing14_4(HWND hWnd)
{
	HRESULT hr;
	BSTR bstrVersion;

	hr = g_poomApp->Logon((long) hWnd);
	if (FAILED(hr))
		cout << _T("Could not login") << endl;
	else
	{
		g_poomApp->get_Version(&bstrVersion);
		cout << _T("POOM Version: ") << bstrVersion << endl;
		SysFreeString(bstrVersion);
	}
}

// *** Listing 14.5
//
// Delete POOM Object

void Listing14_5()
{
	// First log-off then release interface
	g_poomApp->Logoff();
	g_poomApp->Release();
	cout << _T("POOM Object released") << endl;
}

// *** Listing 14.6
//
// Display email address from contacts

void Listing14_6()
{
	IFolder *pFolder;
	IPOutlookItemCollection *pItems;
	IContact *pContact;
	BSTR szFirstName, szLastName, szEmail;
	int nItems;

	Listing14_1();
	Listing14_3();
	Listing14_4(NULL);

	g_poomApp->GetDefaultFolder(olFolderContacts, &pFolder);
	if(pFolder == NULL)
	{
		cout << _T("Could not get contacts folder") << endl;
		return;
	}
	pFolder->get_Items(&pItems);
	pItems->get_Count(&nItems);
	cout << _T("Number of contacts: ") << nItems << endl;
	pItems->Find(
		_T("[LastName] = \"Grattan\" AND \
					[FirstName] = \"Nick\""), 
			(IDispatch**)&pContact);
	pContact->get_FirstName(&szFirstName);
	pContact->get_LastName(&szLastName);
	pContact->get_Email1Address(&szEmail);
	cout    << szFirstName << _T(" ") 
			<< szLastName << _T(" ") 
			<< szEmail << endl;
	SysFreeString(szFirstName);
	SysFreeString(szLastName);
	SysFreeString(szEmail);

	pContact->Release();
	pItems->Release();
	pFolder->Release();
	Listing14_5();
	Listing14_2();
}

// *** Listing 14.7
//
// QueryInterface

void Listing14_7()
{
	IFolder *pFolder;
	IPOutlookItemCollection *pItems;
	IPOlItems *pItems2;

	IContact *pContact;
	BSTR szFirstName, szLastName;
	int nItems;

	Listing14_1();
	Listing14_3();
	Listing14_4(NULL);

	g_poomApp->GetDefaultFolder(olFolderContacts, &pFolder);
	if(pFolder == NULL)
	{
		cout << _T("Could not get contacts folder") << endl;
		return;
	}
	pFolder->get_Items(&pItems);
	pFolder->Release();
	pItems->QueryInterface(IID_IPOlItems, (LPVOID *) &pItems2);
	pItems->Release();
	if(pItems2 == NULL)
		cout << _T("Query Interface Failed") << endl;
	else
	{
		pItems2->SetColumns(_T("LastName, FirstName"));
		pItems2->get_Count(&nItems);
		cout << _T("Contacts: ") << nItems << endl;
		for(int i = 1; i <= nItems; i++) // NB: 1 Based!
		{
			pItems2->Item(i, (IDispatch**)&pContact);
			if(pContact == 0)
			{
				cout << _T("Could not get contact") << endl;
				break;
			}
			else
			{
				pContact->get_FirstName(&szFirstName);
				pContact->get_LastName(&szLastName);
				cout << szFirstName << _T(" ") << szLastName << endl;
				SysFreeString(szFirstName);
				SysFreeString(szLastName);
			}
		}
		pItems2->Release();
	}
	Listing14_5();
	Listing14_2();
}

// *** Listing 14.8
//
// Add a contact

void AddContact(IPOutlookItemCollection *pItems, 
					LPTSTR szFirstName, LPTSTR szLastName)
{
	IContact *pContact;
	pItems->Add((IDispatch**)&pContact);
	if(pContact == NULL)
	{
		cout << _T("Could not get IContact interface") << endl;
		return;
	}
	pContact->put_FirstName(szFirstName);
	pContact->put_LastName(szLastName);
	if(FAILED(pContact->Save()))
		cout << _T("Could not save contact") << endl;
	pContact->Release();
	pItems->Release();
}

void Listing14_8()
{
	IPOutlookItemCollection *pItems;
	IFolder *pFolder;
	 
	Listing14_1();
	Listing14_3();
	Listing14_4(NULL);

	g_poomApp->GetDefaultFolder(olFolderContacts, &pFolder);

	if(pFolder == NULL)
	{
		cout << _T("Could not get contacts folder") << endl;
		return;
	}
	pFolder->get_Items(&pItems);
	pItems->AddRef();
	AddContact(pItems, _T("XXXXX"), _T("ZZZZZ"));
	pItems->Release();
	pFolder->Release();

	Listing14_5();
	Listing14_2();
}

// *** Listing 14.9
//
// Using Smart Pointers

#include <comdef.h>

_COM_SMARTPTR_TYPEDEF(IPOutlookApp, __uuidof(IPOutlookApp));

void _com_issue_error(HRESULT hr)
{
	cout << _T("Error in Smart Pointer access (NULL pointer?)") << endl;
}

// Assumes that CoInitializeEx has been called already
void Listing14_9(HWND hWnd)
{
	IPOutlookAppPtr pOutlookApp;
	HRESULT hr;
	BSTR bstrVersion;

	hr = pOutlookApp.CreateInstance(CLSID_Application);
	if (FAILED(hr))
	{
		cout << _T("Could not create object") << endl;
		return;
	}
	hr = pOutlookApp->Logon((long) hWnd);
	if (FAILED(hr))
		cout << _T("Could not login") << endl;
	else
	{
		pOutlookApp->get_Version(&bstrVersion);
		cout << _T("POOM Version: ") << bstrVersion << endl;
		pOutlookApp->Logoff();
		SysFreeString(bstrVersion);
	}
}

// *** Listing 14.10
//
// Create a recurring appointment

_COM_SMARTPTR_TYPEDEF(IAppointment, __uuidof(IAppointment));
_COM_SMARTPTR_TYPEDEF(IRecurrencePattern, __uuidof(IRecurrencePattern));


void CreateAppointment(IPOutlookAppPtr& pOutlookApp)
{
	IAppointmentPtr pAppt;
	IAppointment *pInterfaceAppt;
	IRecurrencePattern *pInterfaceRecur;
	IRecurrencePatternPtr pRecur;
	DATE date;
	SYSTEMTIME st;

	pOutlookApp->CreateItem(olAppointmentItem, (IDispatch **) &pInterfaceAppt);
	pAppt.Attach(pInterfaceAppt, FALSE);
	
	// Convert Monday, July/3/2000 at 10:00 AM to a date
	memset(&st, 0, sizeof(SYSTEMTIME));
	st.wMonth = 7;
	st.wDay = 3;
	st.wYear = 2000;
	st.wHour = 10;

	// Convert to date format
	pOutlookApp->SystemTimeToVariantTime(&st, &date);
	
	// Set the subject and start date to 10:00 AM
	pAppt->put_Subject(_T("Recurring Appointment"));
	pAppt->put_Start(date);

	// Set the recurrence pattern
	pAppt->GetRecurrencePattern(&pInterfaceRecur);
	pRecur.Attach(pInterfaceRecur, FALSE);
	pRecur->put_RecurrenceType(olRecursWeekly);
	pRecur->put_DayOfWeekMask(olMonday);
	pRecur->put_NoEndDate(VARIANT_TRUE);
	
	// Save the appointment
	pAppt->Save();
	cout << _T("Appointment added") << endl;
}

void Listing14_10()
{
	IPOutlookAppPtr pOutlookApp;
	HRESULT hr;

	hr = pOutlookApp.CreateInstance(CLSID_Application);
	if (FAILED(hr))
	{
		cout << _T("Could not create object") << endl;
		return;
	}
	hr = pOutlookApp->Logon((long) hWnd);
	if (FAILED(hr))
		cout << _T("Could not login") << endl;
	else
	{
		CreateAppointment(pOutlookApp);
		pOutlookApp->Logoff();
	}
}

// *** Listing 14.11
//
// IDispatch Interface: Logon and Logoff using IDispatch::Invoke

#include <dispex.h> // for IID_IDispatch definition

_COM_SMARTPTR_TYPEDEF(IDispatch, IID_IDispatch);

BOOL GetIDispatch(IDispatchPtr& pDispatchPtr)
{
	HRESULT hr;
	hr = pDispatchPtr.CreateInstance(CLSID_Application);
	if (FAILED(hr))
	{
		cout << _T("Could not create object") << endl;
		return FALSE;	}
	return TRUE;
}

#include <coguid.h> // for GUID_NULL and IID_NULL

BOOL Logon(IDispatchPtr& pDispatchPtr, HWND hWnd)
{
	DISPID dispLogon;
	HRESULT hr;
	VARIANTARG varg;
	DISPPARAMS disparms = {
			&varg, NULL,
			1, 	// one parameter
			0	// zero named parameter
			};
	LPTSTR names[] = {_T("Logon")};
	// first get the dispatch ID for IPOutlookApp::Logon
	hr = pDispatchPtr->GetIDsOfNames(IID_NULL, names, 1, GetUserDefaultLCID(), &dispLogon);
	if(FAILED(hr))
	{
		cout << _T("Could not get dispid for Logon") << endl;
		return FALSE;
	}
	VariantInit(&varg);
	varg.vt = VT_I4;
	varg.lVal = (LONG)hWnd;
	hr = pDispatchPtr->Invoke(dispLogon, IID_NULL, GetUserDefaultLCID(), DISPATCH_METHOD,
				&disparms, NULL, NULL, NULL);
	if(FAILED(hr))
	{
		cout << _T("Could not invoke Logon") << endl;
		return FALSE;
	}
	cout << _T("Logon invoked") << endl;
	return TRUE;
}

BOOL Logoff(IDispatchPtr& pDispatchPtr)
{
	DISPID dispLogoff;
	HRESULT hr;
	DISPPARAMS disparms = {
			NULL, NULL,
			0, 	// zero parameters
			0	// zero named parameters
			};
	LPTSTR names[] = {_T("Logoff")};
	// first get the dispatch ID for IPOutlookApp::Logoff
	hr = pDispatchPtr->GetIDsOfNames(IID_NULL, names, 1, GetUserDefaultLCID(), &dispLogoff);
	if(FAILED(hr))
	{
		cout << _T("Could not get dispid for Logoff") << endl;
		return FALSE;
	}
	hr = pDispatchPtr->Invoke(dispLogoff, IID_NULL, GetUserDefaultLCID(), DISPATCH_METHOD,
				&disparms, NULL, NULL, NULL);
	if(FAILED(hr))
	{
		cout << _T("Could not invoke Logoff") << endl;
		return FALSE;
	}
	cout << _T("Logoff invoked") << endl;
	return TRUE;
}

BOOL DisplayVersion(IDispatchPtr& pDispatchPtr)
{
	DISPID dispVersion;
	HRESULT hr;
	VARIANTARG varResult;
	DISPPARAMS disparms = {
			NULL, NULL,
			0, 	// zero parameters
			0	// zero named parameters
			};

	LPTSTR names[] = {_T("Version")};
	// first get the dispatch ID for IPOutlookApp::Version
	hr = pDispatchPtr->GetIDsOfNames(IID_NULL, names, 1, GetUserDefaultLCID(), &dispVersion);
	if(FAILED(hr))
	{
		cout << _T("Could not get dispid for Version") << endl;
		return FALSE;
	}
	hr = pDispatchPtr->Invoke(dispVersion, IID_NULL, GetUserDefaultLCID(), DISPATCH_PROPERTYGET,
				&disparms, &varResult, NULL, NULL);
	if(FAILED(hr))
	{
		cout << _T("Could not invoke Version") << endl;
		return FALSE;
	}
	
	cout << _T("Version invoked:") << varResult.bstrVal << endl;
	SysFreeString(varResult.bstrVal);
	return TRUE;
}

void Listing14_11(HWND hWnd)
{
	IDispatchPtr pDispatchPtr;

	if(!GetIDispatch(pDispatchPtr))
	{
		cout << _T("Could not get dispatch pointer") << endl;
		return;
	}
	if(Logon(pDispatchPtr, hWnd))
	{
		DisplayVersion(pDispatchPtr);
		Logoff(pDispatchPtr);
	}
}

// *** Listing 14.12
//
//  See Chapter14MFC.cpp 

// *** Listing 14.13
//
// See Chapter14MFC.cpp 

// *** Listing 14.14
//
// IDispatch Interface: GetTypeInfoCount

void Listing14_14()
{
	IDispatchPtr pDispatchPtr;
	UINT nInfo;

	if(!GetIDispatch(pDispatchPtr))
		return;
	pDispatchPtr->GetTypeInfoCount(&nInfo);
	cout << _T("GetTypeInfoCount returned: ") << (int)nInfo;
}

// *** Listing 14.15
//
// List Automation Methods and properties

_COM_SMARTPTR_TYPEDEF(ITypeInfo, IID_ITypeInfo);

void Listing14_15()
{
	IDispatchPtr pDispatchPtr;
	ITypeInfo *pTypeInfo;
	ITypeInfoPtr pTypeInfoPtr;
	BSTR bstrName;

	if(!GetIDispatch(pDispatchPtr))
		return;
	pDispatchPtr->GetTypeInfo(0, 0, &pTypeInfo);
	pTypeInfoPtr.Attach(pTypeInfo);

	FUNCDESC* pfuncdesc;	
	for(int i=0; i < 20; i++)
	{
		pTypeInfoPtr->GetFuncDesc(i, &pfuncdesc);

		if(FAILED(pTypeInfoPtr->GetDocumentation(pfuncdesc->memid, 
					&bstrName, NULL, NULL, NULL)))
			cout << _T("Could not get Documentation") << endl;
		else
		{
			cout << bstrName << endl;
			SysFreeString(bstrName);
		}
		cout << _T("\tInvocation Kind: ");
		switch (pfuncdesc->invkind)
		{
			case DISPATCH_METHOD:
				cout << _T("Dispatch Method") << endl;
				break;
			case DISPATCH_PROPERTYGET:
				cout << _T("Property Get") << endl;
				break;
			case DISPATCH_PROPERTYPUT:
				cout << _T("Property Put") << endl;
				break;
			case DISPATCH_PROPERTYPUTREF:
				cout << _T("Reference Property Assignment") << endl;
				break;
		}
		cout << _T("\tNumber of params: ") << pfuncdesc->cParams << endl;

		pTypeInfoPtr->ReleaseFuncDesc(pfuncdesc);
	}
}

