// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Chapter 12: Memory Management. Sample Code

#include "stdafx.h"
#include "examples.h"

// *** Listing 12.1
//
// Get System Information

void Listing12_1()
{
	SYSTEM_INFO si;

	GetSystemInfo(&si);
	switch (si.wProcessorArchitecture)
	{
		case PROCESSOR_ARCHITECTURE_INTEL:
			cout << _T("Intel Processor");
			if(si.wProcessorLevel == 4)
				cout << _T(" 486") << endl;
			else
				cout << _T(" Pentium") << endl;
			break;
		case PROCESSOR_ARCHITECTURE_MIPS:
			cout << _T("Mips Processor");
			if(si.wProcessorLevel == 3)
				cout << _T(" R3000") << endl;
			else
				cout << _T(" R4000") << endl;
			break;
		case PROCESSOR_ARCHITECTURE_ALPHA:
			cout << _T("Alpha Processor") << endl;
			break;
		case PROCESSOR_ARCHITECTURE_PPC:
			cout << _T("PPC Processor") << endl;
			break;
		case PROCESSOR_ARCHITECTURE_SHX:
			cout << _T("SHX Processor") << endl;
			break;
		case PROCESSOR_ARCHITECTURE_ARM:
			cout << _T("ARM Processor") << endl;
			break;
		case PROCESSOR_ARCHITECTURE_IA64:
			cout << _T("IA64 Processor") << endl;
			break;
		case PROCESSOR_ARCHITECTURE_ALPHA64:
			cout << _T("Alpha 64 Processor") << endl;
			break;
		case PROCESSOR_ARCHITECTURE_UNKNOWN:
			cout << _T("Unknown Processor") << endl;
			break;
	}
	cout << _T("Processor revision: ") << si.wProcessorRevision << endl;
	cout << _T("Page size: ") 
		<< si.dwPageSize << endl;
	cout << _T("Alloc. Granularity: ") 
		<< si.dwAllocationGranularity << endl;
	cout << _T("Min. Application Address: ") << 
		(DWORD)si.lpMinimumApplicationAddress << endl;
	cout << _T("Max. Application Address: ") << 
		(DWORD)si.lpMaximumApplicationAddress << endl;

}

// *** Listing 12.2
//
// Memory Status

void Listing12_2()
{
	MEMORYSTATUS ms;
	ms.dwLength = sizeof(ms);
	GlobalMemoryStatus(&ms);
	cout << _T("Total Phys: ") << ms.dwTotalPhys << endl;
	cout << _T("Avail Phys:") << ms.dwAvailPhys << endl;
	cout << _T("Total Page: ") << ms.dwTotalPageFile << endl;
	cout << _T("Avail Page: ") << ms.dwAvailPageFile << endl;
	cout << _T("Total Virtual: ") << ms.dwTotalVirtual << endl;
	cout << _T("Avail Virtual: ") << ms.dwAvailVirtual << endl;
}