// Component implmenentation

#include "stdafx.h"
#include "component.h"

LONG g_nComponents = 0;

//////////////////////////////////////////////////////////////////////////////
// CComponent implemention

CComponent::CComponent() : m_nRef(0)
{ 
	InterlockedIncrement(&g_nComponents);
}

CComponent::~CComponent() 
{ 
	InterlockedDecrement(&g_nComponents);
}

// Standard IUnknown methods

HRESULT __stdcall CComponent::QueryInterface(const IID& iid, void** ppv)
{
	if(iid == IID_IUnknown)
		*ppv = (IMyInterface*) (this);
	// TODO: Update to use the IID of your interface. Repeat if you have multiple
	//		 interfaces
	else if(iid == IID_MyInterface)
		*ppv = (IMyInterface*) (this);
	else
	{
		*ppv = NULL;
		return E_NOINTERFACE;
	}
	((IUnknown*)(*ppv))->AddRef();
	return S_OK;
}

ULONG __stdcall CComponent::AddRef ()
{
	return InterlockedIncrement((LONG*)&m_nRef);
}

ULONG __stdcall CComponent::Release()
{
	if(InterlockedDecrement((LONG*)&m_nRef) == 0)
	{
		delete this;
		return 0;
	}
	return m_nRef;
}

