/****************************************************************************
 writerap.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.13  $
   $Author:   kcatlin  $
     $Date:   18 Mar 1992 10:14:12  $

 Demonstration program for SPaper and Translation objects.  Also 
 demonstrates the xlist returned by the translation objects and how
 to interpret its data.

 NOTE: This application is for demo purposes ONLY.  It is not of product
 quality.
****************************************************************************/

#include <app.h>
#include <appmgr.h>
#include <spaper.h>
#include <xlate.h>
#include <xlist.h>
#include <xlfilter.h>
#include <sysgraf.h>
#include <frame.h>
#include <tktable.h>
#include <menu.h>
#include <string.h>
#include <writerap.h>
#include <methods.h>
#include <debug.h>

// Data structure for the menu 
static const TK_TABLE_ENTRY menuBar[] = {
	{"Clear",			msgWriterAppClear, 0},
	{"Translator", 		0, 0, 0, tkMenuPullDown},
      {0, 0, 0, 0, 0, clsChoice},      
   		{"Word",		msgWriterAppTranslator, 0, 0, tkButtonOn},
   		{"Number",		msgWriterAppTranslator,	1},
   		{"Text",		msgWriterAppTranslator,	2},
        {pNull},
	  {pNull},
    {pNull}
};

// Data structure to pass in to the xlist traversal routine
typedef struct {
	OBJECT self;
	RECT32 rect;
	S32 baseline;
	OBJECT dc;
} SHOW_DATA, *P_SHOW_DATA;

/****************************************************************************
 ShowText

 This function is called for each element in the xlist.  The xlist being
 traversed consists of xtBounds/xtText pairs.  The bounds are stored in
 our traversal data structure.  When the text is traversed, a simple
 string is drawin in the window.

 NOTE:  Damage to the drawn text is not handled properly.  This means that
 a window covering the printed text and moved away will NOT allow the 
 underlying window to repaint.
 ***************************************************************************/
STATUS GLOBAL ShowText (
	P_XLIST pXList,
	P_XLIST_ELEMENT pElem,
	P_SHOW_DATA pArgs)
{
	SYSDC_TEXT_OUTPUT tx;

	switch (pElem->type) {
		case xtBounds:
			pArgs->rect = ((P_XLATE_BDATA)(pElem->pData))->box;
			pArgs->baseline = ((P_XLATE_BDATA)(pElem->pData))->baseline;
			break;

		case xtText:
			memset(&tx, 0, sizeof(SYSDC_TEXT_OUTPUT));
			tx.alignChr = sysDcAlignChrBaseline;
			tx.pText = (P_STRING)(pElem->pData);
			tx.lenText = strlen(pElem->pData);
			tx.stop = maxS32;
			tx.spaceChar = 32;
			tx.cp.x = pArgs->rect.origin.x;
			tx.cp.y = pArgs->baseline - 20; // one line below
			ObjectCall(msgDcDrawText, pArgs->dc, &tx);
			break;
	}
	return stsOK;
	Unused(pXList);
}

/****************************************************************************
 SetupFont

 Simple utility function to change a dc's font.
 ***************************************************************************/
STATUS GLOBAL SetupFont(
	U16 font, 
	U16 sizeX,
	U16 sizeY, 
	OBJECT dc)
{
	STATUS				s;
	SCALE				scale;
	SYSDC_FONT_SPEC		fs;
	SIZE32				sz;

	ObjCallWarn(msgDcUnitsPoints, dc, Nil(P_ARGS));
	sz.h = sizeY;
	sz.w = sizeX;
	ObjCallWarn(msgDcLUCtoLWC_SIZE32, dc, &sz);
	ObjCallWarn(msgDcUnitsDevice, dc, Nil(P_ARGS));

	memset(&fs, 0, sizeof(SYSDC_FONT_SPEC));
	fs.id = font;
	fs.attr.group = sysDcGroupSansSerif;
	fs.attr.weight = sysDcWeightNormal;
	fs.attr.aspect = sysDcAspectNormal;
	fs.attr.encoding = sysDcEncodeAdobeStandard;
	ObjCallRet(msgDcOpenFont, dc, &fs, s);
	scale.x = FxMakeFixed((S16)sz.w, 0);
	scale.y = FxMakeFixed((S16)sz.h, 0);
	ObjCallRet(msgDcScaleFont, dc, &scale, s);
	return s;
}

/****************************************************************************
 WriterCompleted

 Called when the translation is complete.  Will get xlist from the spaper
 (self), set up a dc to draw the text, and traverse the xlist to draw the
 text. 
 *************************************************************************/
MsgHandler(WriterCompleted) 
{
	XLATE_DATA xData;
	SHOW_DATA show;
	SYSDC_NEW dcNew;
	STATUS s;

	// Get the translated data from the spaper (self)
	xData.heap = osProcessHeapId;
	ObjCallRet(msgSPaperGetXlateData, self, &xData, s);

	// Convert the xlist form bounds/word/bounds/word pairs to
	// bounds/text/bounds/text
	XList2Text(xData.pXList);

	// Create a drawing context to paint the text and initialize
	ObjectCall(msgNewDefaults, clsSysDrwCtx, &dcNew);
	ObjCallRet(msgNew, clsSysDrwCtx, &dcNew, s);
	ObjectCall(msgDcSetWindow, dcNew.object.uid, self);
	ObjectCall(msgDcUnitsDevice, dcNew.object.uid, Nil(P_ARGS));
	ObjectCall(msgDcSetForegroundRGB, dcNew.object.uid, (P_ARGS)sysDcRGBBlack);
	ObjectCall(msgDcSetBackgroundRGB, dcNew.object.uid, (P_ARGS)sysDcRGBWhite);

	// Set up the font of the drawing context to something reasonable
	SetupFont(SysDcFontId("HE55"), 16, 16, dcNew.object.uid);

	// Begin painting
	ObjCallJmp(msgWinBeginPaint, dcNew.object.uid, Nil(P_ARGS), s, error);

	// Traverse the xlist and display the text
	show.self = self;
	show.dc = dcNew.object.uid;
	XListTraverse(xData.pXList, ShowText, &show);

error:
	// End the painting, destroy the drawing context, and free the xlist
	ObjectCall(msgWinEndPaint, dcNew.object.uid, Nil(P_ARGS));
	ObjectCall(msgDestroy, dcNew.object.uid, Nil(P_ARGS));
	XListFree(xData.pXList);
	return stsOK;
	MsgHandlerParametersNoWarning;
}

/***************************************************************************
 WriterInit

 Intalls the clsWriter class.  This is a subclass of spaper.
 **************************************************************************/
STATUS GLOBAL WriterInit(void) 
{
	CLASS_NEW c;

	ObjectCall(msgNewDefaults, clsClass, &c);
	c.object.uid =		clsWriter;
	c.object.cap |= 	objCapCall;
	c.object.key =		(OBJ_KEY)clsWriter;
	c.cls.pMsg = 		clsWriterTable;
	c.cls.ancestor =	clsSPaper;
	c.cls.size = 		Nil(SIZEOF); // no instance data
	c.cls.newArgsSize =	SizeOf(SPAPER_NEW);
	return ObjectCall(msgNew, clsClass, &c);
}

/***************************************************************************
 WriterAppInit

 Initialize the display for the first time.
****************************************************************************/
MSG_HANDLER WriterAppInit(
	const	MESSAGE			msg,
	const	OBJECT			self,
	const	P_ARGS			pArgs,
	const	CONTEXT			ctx,
	const	P_IDATA			pData)
{
	APP_METRICS		am;
    WIN_METRICS     wm;
    MENU_NEW        mNew;
    SPAPER_NEW		sNew;
	STATUS			s;

	// Ancestor called in method table

	// Get the main window
	ObjCallRet(msgAppGetMetrics, self, &am, s);

	// Create the client window
	ObjCallRet(msgNewDefaults, clsWriter, &sNew, s);
	sNew.sPaper.flags |= spCapture | spRedisplay | spGrab | spProx;
	ObjCallRet(msgNew, clsWriter, &sNew, s);

	// Create the menu bar
    ObjectCall(msgNewDefaults, clsMenu, &mNew);
    mNew.tkTable.pEntries = menuBar;
    mNew.tkTable.client = self;
    ObjCallRet(msgNew, clsMenu, &mNew, s);

	// Set the client window and menu bar in the application frame
	ObjCallRet(msgFrameSetClientWin, am.mainWin, (P_ARGS)sNew.object.uid, s);
	ObjCallRet(msgFrameSetMenuBar, am.mainWin, (P_ARGS)mNew.object.uid, s);

	// Force a translator (word) to be created
	ObjectCall(msgWriterAppTranslator, self, (P_ARGS)0);

	// Force the applicaiton to lay itself out
    wm.options = wsLayoutResize;
    ObjectCall(msgWinLayout, am.mainWin, &wm);

	return stsOK;
	MsgHandlerParametersNoWarning;
}

/***************************************************************************
 WriterAppClear

 This message is sent from the menu of the applicaiton to the application
 when clear is picked from the menu.  Will get the spaper out of the
 frame of the application and clear the text out.
 **************************************************************************/
MsgHandler(WriterAppClear)
{
	APP_METRICS am;
	FRAME_METRICS fm;
	STATUS s;

	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetMetrics, am.mainWin, &fm, s);
	return ObjCallWarn(msgSPaperClear, fm.clientWin, Nil(P_ARGS));
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
 WriterAppTranslator

 Called when the translator is changed from the menu in the application.
 Will create a new translator based on which menu item was chosen and 
 and give to the spaper.  Will cause translation to re-occur.
 ***************************************************************************/
MsgHandler(WriterAppTranslator)
{
	APP_METRICS am;
	FRAME_METRICS fm;
	XLATE_NEW xNew;
	STATUS s;
	OBJECT oldTranslator;

	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetMetrics, am.mainWin, &fm, s);

	switch ((U16)(U32)pArgs) {
		case 0:	
			//clsXWord
			ObjectCall(msgNewDefaults, clsXWord, &xNew);
			ObjCallRet(msgNew, clsXWord, &xNew, s);
			break;

		case 1: 
			// clsXText with only numbers
			ObjectCall(msgNewDefaults, clsXText, &xNew);
			xNew.xlate.charConstraints = xltDisableUpperCase | xltDisableLowerCase
											| xltDisableCommonPunct | xltDisableOtherPunct;
			ObjectCall(msgNew, clsXText, &xNew);
			break;

		case 2:
			// clsXText
			ObjectCall(msgNewDefaults, clsXText, &xNew);
			ObjectCall(msgNew, clsXText, &xNew);
			break;

		default:
			return stsOK;
	}

	// dirty everything for the repaint
	ObjectCall(msgWinDirtyRect, fm.clientWin, Nil(P_ARGS));

	// force the repaint
	ObjectCall(msgWinUpdate, fm.clientWin, Nil(P_ARGS));

	ObjCallRet(msgSPaperGetTranslator, fm.clientWin, &oldTranslator, s);
	ObjCallRet(msgSPaperSetTranslator, fm.clientWin, &xNew.object.uid, s);

	// Free the old translator
	if (oldTranslator != objNull)
		ObjectCall(msgDestroy, oldTranslator, Nil(P_ARGS));

	// force retranslation
	ObjectCall(msgSPaperComplete, fm.clientWin, Nil(P_ARGS));
	return stsOK;
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
 ClsWriterAppInit
	
 Install the application class
 ***************************************************************************/
STATUS ClsWriterAppInit (void)
{
	APP_MGR_NEW	new;
	STATUS		s;

	// Install the application class
	ObjectCall(msgNewDefaults, clsAppMgr, &new);
	new.object.uid	 		  	= clsWriterApp;
	new.object.key 		  	    = (OBJ_KEY)clsWriterApp;
	new.cls.pMsg			  	= clsWriterAppTable;
	new.cls.ancestor		  	= clsApp;
	new.cls.size			  	= Nil(SIZEOF); // no instance data
	new.appMgr.flags.accessory	= false;
	new.appMgr.flags.stationery = true;
	strcpy(new.appMgr.defaultDocName, new.appMgr.name);
	strcpy(new.appMgr.company, "GO Corporation");
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	return stsOK;
}

/****************************************************************************
 Main application entry point.
 ***************************************************************************/
void CDECL main (int argc, char *argv[], U16 processCount)
{
	if (processCount == 0) {
		// install the application class
		ClsWriterAppInit();
		AppMonitorMain(clsWriterApp, objNull);
	}

	else {

		// install the local class
		WriterInit();
   		AppMain();
	}
	Unused(argc); Unused(argv);

}

