/****************************************************************************
 File: tttmbar.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.4  $
 $Author:   kcatlin  $
 $Date:   05 Feb 1992 09:19:06  $

 This file contains some of the implementation of TttApp's menu bar.
***************************************************************************/

#ifndef TKTABLE_INCLUDED
#include <tktable.h>
#endif

#ifndef TTTPRIV_INCLUDED
#include <tttpriv.h>
#endif

#ifndef TTTAPP_INCLUDED
#include <tttapp.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifdef DEBUG

static const TK_TABLE_ENTRY dumpTreeMenu[] = {
  {"From Frame",	msgTttAppDumpWindowTree, 0},
  {"From View",		msgTttAppDumpWindowTree, 1},
  {pNull}
};


//
// Arguably this could be improved by showing making three exclusive
// choices, and displaying the current state in the menu.  But there's
// no way to get the trace state from the clsmgr, and even if there was,
// it's not terribly important to be that careful with debugging code.
//
static const TK_TABLE_ENTRY traceMenu[] = {
  {"Trace App On",		msgTttAppChangeTracing,	MakeU32(0,1)},
  {"Trace App Off",		msgTttAppChangeTracing,	MakeU32(0,0)},
  {"Trace View On",		msgTttAppChangeTracing,	MakeU32(1,1)},
  {"Trace View Off",  	msgTttAppChangeTracing,	MakeU32(1,0)},
  {"Trace Data On",		msgTttAppChangeTracing,	MakeU32(2,1)},
  {"Trace Data Off",  	msgTttAppChangeTracing,	MakeU32(2,0)},
  {pNull}
};

static const TK_TABLE_ENTRY debugMenu[] = {
  {"Dump View",			msgTttAppDumpView,			0},
  {"Dump Data",			msgTttAppDumpDataObject,	0},
  {"Dump App",		  	msgDump,			 		0},
  {"Dump Window Tree",	(U32)dumpTreeMenu, 			0, 0, tkMenuPullRight},
  {"Trace",			  	(U32)traceMenu,	  0, 0, tkMenuPullRight | tkBorderEdgeTop},
  {"Force Repaint",		msgTttAppForceRepaint,		0, 0, tkBorderEdgeTop},
  {pNull}
};

#endif // DEBUG


static const TK_TABLE_ENTRY    tttRealMenuBar[] = {
#ifdef DEBUG
  {"Debug",	(U32)debugMenu, 0, 0, tkMenuPullDown},
#endif
  {pNull}
};


// 
// Why two variables, one "real" and one not real?  The reason is that
// including including tktable.h (which is where TK_TABLE_ENTRY is
// defined) defines do many symbols that the compiler is overwhelmed.
// This bit of trickery allows clients to refer to tttMenuBar without
// including tktable.h
// 
P_UNKNOWN
tttMenuBar = (P_UNKNOWN)tttRealMenuBar;
