/****************************************************************************
 File: buttons.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.7  $
   $Author:   kcatlin  $
     $Date:   05 Feb 1992 09:06:58  $

 This file contains the clsButton demoing code of the tkdemo application.
****************************************************************************/

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif 

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif 

#ifndef BUTTON_INCLUDED
#include <button.h>
#endif 

#ifndef MBUTTON_INCLUDED
#include <mbutton.h>
#endif 

#ifndef MENU_INCLUDED
#include <menu.h>
#endif 

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif 


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

static const TK_TABLE_ENTRY sampleMenu[] = {
	{"This"},
	{"That"},
	{"Other"},
	{pNull}
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


STATUS LOCAL AddButtonExamples (WIN	parent)
{
	STATUS				s;
	BUTTON_NEW			bn;
	MENU_BUTTON_NEW	 	mbn;
	MENU_NEW			mn;

	AddLabel(parent, "Default");

	ObjCallRet(msgNewDefaults, clsButton, &bn, s);
	bn.label.pString = "Button";
	ObjCallRet(msgNew, clsButton, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Decorated Feedback");

	ObjCallRet(msgNewDefaults, clsButton, &bn, s);
	bn.border.style.edge = bsEdgeNone;
	bn.border.style.shadow = bsShadowNone;
	bn.control.style.showDirty = false;
	bn.label.pString = "Button";
	bn.button.style.feedback = bsFeedbackDecorate;
	bn.button.style.offDecoration = lsDecorationNonExclusiveOff;
	bn.button.style.onDecoration = lsDecorationNonExclusiveOn;
	ObjCallRet(msgNew, clsButton, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Inverted Feedback");

	ObjCallRet(msgNewDefaults, clsButton, &bn, s);
	bn.border.style.join = bsJoinSquare;
	bn.label.pString = "Button";
	bn.button.style.feedback = bsFeedbackInvert;
	ObjCallRet(msgNew, clsButton, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Decorated Feedback, Toggle Contact, Word Wrap");

	ObjCallRet(msgNewDefaults, clsButton, &bn, s);
	bn.border.style.edge = bsEdgeNone;
	bn.border.style.shadow = bsShadowNone;
	bn.control.style.showDirty = false;
	bn.label.style.wordWrap = true;
	bn.label.style.numCols = lsNumAbsolute;
	bn.label.cols = 10;
	bn.label.pString = "This is a toggle with a very long string.";
	bn.button.style.feedback = bsFeedbackDecorate;
	bn.button.style.offDecoration = lsDecorationNonExclusiveOff;
	bn.button.style.onDecoration = lsDecorationNonExclusiveOn;
	bn.button.style.contact = bsContactToggle;
	ObjCallRet(msgNew, clsButton, &bn, s);

	bn.win.parent = parent;
	ObjCallRet(msgWinInsert, bn.object.uid, &bn.win, s);

	AddLabel(parent, "Menu Button With Pull-Down Menu");

	ObjCallRet(msgNewDefaults, clsMenu, &mn, s);
	mn.tkTable.pEntries = sampleMenu;
	mn.menu.style.type = msTypeMenu;
	ObjCallRet(msgNew, clsMenu, &mn, s);

	ObjCallRet(msgNewDefaults, clsMenuButton, &mbn, s);
	mbn.label.pString = "Edit";
	mbn.menuButton.style.subMenuType = mbMenuPullDown;
	mbn.menuButton.menu = mn.object.uid;
	ObjCallRet(msgNew, clsMenuButton, &mbn, s);

	mbn.win.parent = parent;
	ObjCallRet(msgWinInsert, mbn.object.uid, &mbn.win, s);

	AddLabel(parent, "Menu Button With Pull-Right Menu");

	ObjCallRet(msgNewDefaults, clsMenuButton, &mbn, s);
	mbn.label.pString = "Edit";
	mbn.menuButton.style.subMenuType = mbMenuPullRight;
	mbn.menuButton.menu = mn.object.uid;
	ObjCallRet(msgNew, clsMenuButton, &mbn, s);

	mbn.win.parent = parent;
	ObjCallRet(msgWinInsert, mbn.object.uid, &mbn.win, s);

	return stsOK;

} /* AddButtonExamples */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddButtonsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	otn.tableLayout.style.childXAlignment = tlAlignLeft;
	otn.tableLayout.style.childYAlignment = tlAlignTop;
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "Buttons", otn.object.uid), s);

	// fill the card with border examples
	StsRet(AddButtonExamples(otn.object.uid), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddButtonsCard */


