/****************************************************************************
 File: foo.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.4  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:37:30  $

 This file contains the API definition for clsFoo.
****************************************************************************/
#ifndef FOO_INCLUDED
#define FOO_INCLUDED

#include <clsmgr.h>

typedef OBJECT FOO, *P_FOO;

#define clsFoo							MakeWKN(3514,1,wknGlobal)

// Status codes.
#define stsFooError1					MakeStatus(clsFoo, 1)
#define stsFooError2					MakeStatus(clsFoo, 2)

// Quick Help codes.
#define qhFooQuickHelp1					MakeTag(clsFoo, 1)
#define qhFooQuickHelp2					MakeTag(clsFoo, 2)

typedef struct FOO_STYLE {

	U16		style1		:1;
	U16		style2		:1;
	U16		reserved	:14;

} FOO_STYLE, *P_FOO_STYLE;

typedef struct FOO_METRICS {

	FOO_STYLE	style;
	U32			reserved1[2];			// Reserved.
	U16			reserved2		:16;	// Reserved.

} FOO_METRICS, *P_FOO_METRICS;

/****************************************************************************
 msgNew	takes P_FOO_NEW, returns STATUS
	Create a new object.
*/
typedef struct FOO_NEW_ONLY {

	// Your new parameters here...
	FOO_STYLE	style;
	U32			reserved;

} FOO_NEW_ONLY, *P_FOO_NEW_ONLY;

#define	fooNewFields	\
	objectNewFields		\
	FOO_NEW_ONLY		foo;

typedef struct FOO_NEW {

	fooNewFields

} FOO_NEW, *P_FOO_NEW;

/****************************************************************************
 msgFooGetMetrics	takes P_FOO_METRICS, returns STATUS
	Get foo metrics.
*/
#define msgFooGetMetrics	 				MakeMsg(clsFoo, 1)

/****************************************************************************
 msgFooGetStyle		takes P_FOO_STYLE, returns STATUS
	Get foo style.
*/
#define msgFooGetStyle		 				MakeMsg(clsFoo, 2)

/****************************************************************************
 msgFooSetStyle		takes P_FOO_STYLE, returns STATUS
	Set foo style.
*/
#define msgFooSetStyle		 				MakeMsg(clsFoo, 3)

#endif	// FOO_INCLUDED
