/****************************************************************************
 File: foo.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.4  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:37:38  $

 This file contains the class definition and methods for clsFoo.
****************************************************************************/
#include <methods.h>
#include <foo.h>
#include <string.h>
#include <debug.h>
#include <resfile.h>


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc	 			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct FOO_INST {

	FOO_METRICS		metrics;

} FOO_INST, *P_FOO_INST;

typedef struct FILED_DATA {

	// Your filed instance data here...
	FOO_STYLE	style;
	U32			reserved1;
	U16			reserved2		:16;	// Reserved.

} FILED_DATA, *P_FILED_DATA;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Message Handlers  							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
	FooNewDefaults
	
	Respond to msgNewDefaults.
****************************************************************************/
MsgHandlerArgType(FooNewDefaults, P_FOO_NEW)
{

	memset(&(pArgs->foo), 0, sizeof(FOO_NEW_ONLY));

	pArgs->foo.style.style1		= false;
	pArgs->foo.style.style2		= false;
	pArgs->foo.reserved			= 0;

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// FooNewDefaults

/****************************************************************************
	FooDump

	Respond to msgDump.
****************************************************************************/
MsgHandlerArgType(FooDump, P_ARGS)
{
	Debugf("foo: msgDump");

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// FooDump

/****************************************************************************
	FooNew
	
	Respond to msgInit.  Create a new object.
****************************************************************************/
MsgHandlerArgType(FooNew, P_FOO_NEW)
{
	FOO_INST	inst;

	memset(&inst, 0, sizeof(FOO_INST));

	// Update instance data.
	ObjectWrite(self, ctx, &inst);

	return stsOK;
	MsgHandlerParametersNoWarning;

}  // FooNew

/****************************************************************************
	FooFree
	
	Destroy an object.
****************************************************************************/
MsgHandlerArgType(FooFree, P_ARGS)
{

	return stsOK;
	MsgHandlerParametersNoWarning;

}  // FooFree

/****************************************************************************
	FooSave
	
	Save self to a file.
****************************************************************************/
MsgHandlerArgType(FooSave, P_OBJ_SAVE)
{
	P_FOO_INST			pInst;
	STREAM_READ_WRITE	fsWrite;
	FILED_DATA			filed;
	STATUS 				s;

	pInst = IDataPtr(pData, FOO_INST);
	memset(&filed, 0, sizeof(FILED_DATA));

	filed.style	= pInst->metrics.style;

	// Write filed instance data to the file.
	fsWrite.numBytes	= SizeOf(FILED_DATA);
	fsWrite.pBuf		= &filed;
	ObjCallRet(msgStreamWrite, pArgs->file, &fsWrite, s);

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// FooSave

/****************************************************************************
	FooRestore
	
	Restore self from a file.
****************************************************************************/
MsgHandlerArgType(FooRestore, P_OBJ_RESTORE)
{
	STREAM_READ_WRITE	fsRead;
	FOO_INST			inst;
	FILED_DATA			filed;
	STATUS 		 		s;

	memset(&inst, 0, sizeof(FOO_INST));

	// Read instance data from the file.
	fsRead.numBytes	= SizeOf(FILED_DATA);
	fsRead.pBuf		= &filed;
	ObjCallRet(msgStreamRead, pArgs->file, &fsRead, s);

	inst.metrics.style	= filed.style;

	// Update instance data.
	ObjectWrite(self, ctx, &inst);

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// FooRestore


/****************************************************************************
	FooGetStyle
	
	Get foo style.
****************************************************************************/
MsgHandlerArgType(FooGetStyle, P_FOO_STYLE)
{
	P_FOO_INST		pInst = IDataPtr(pData, FOO_INST);
	MsgHandlerParametersNoWarning;

	*pArgs = pInst->metrics.style;

	return stsOK;

}	// FooGetStyle

/****************************************************************************
	FooSetStyle
	
	Set foo style.
****************************************************************************/
MsgHandlerArgType(FooSetStyle, P_FOO_STYLE)
{
	FOO_INST		selfInst;
	P_FOO_INST		pInst;

	selfInst = IDataDeref(pData, FOO_INST);
	pInst 	= &selfInst;

	// Update instance data.
	pInst->metrics.style = *pArgs;
	ObjectWrite(self, ctx, pInst);

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// FooSetStyle

/****************************************************************************
	FooGetMetrics
	
	Get foo metrics.
****************************************************************************/
MsgHandlerArgType(FooGetMetrics, P_FOO_METRICS)
{
	P_FOO_INST		pInst;

	pInst = IDataPtr(pData, FOO_INST);
	*pArgs = pInst->metrics;

	return stsOK;
	MsgHandlerParametersNoWarning;

}	// FooGetMetrics

/****************************************************************************
	ClsFooInit
	
	Install the class.
****************************************************************************/
STATUS ClsFooInit (void)
{
	CLASS_NEW		new;
	STATUS			s;

	// Create the class.
	ObjectCall(msgNewDefaults, clsClass, &new);
	new.object.uid		= clsFoo;
	new.object.key		= (OBJ_KEY)clsFooTable;
	new.cls.pMsg		= clsFooTable;
	new.cls.ancestor	= clsObject;
	new.cls.size		= SizeOf(FOO_INST);
	new.cls.newArgsSize	= SizeOf(FOO_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return stsOK;

}  // ClsFooInit

