/****************************************************************************
 $Workfile:   PWIN.C  $
 
 (C) Copyright 1992 by GO Corporation, All Rights Reserved.
			  
 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
   $Author:   kcatlin  $
     $Date:   18 Mar 1992 09:07:44  $

 This file implements the Paint window.
****************************************************************************/

#include <stdlib.h>		// for rand()
#include <os.h>			// for OSMemAlloc()
#include <string.h>		// for memset()
#include <sysgraf.h>
#include <pen.h>
#include <input.h>
#include <acetate.h>
#include "pwin.h"
#include "methods.h"
#include <debug.h>

/****************************************************************************/
/*					D E F I N E S   A N D   T Y P E D E F S					*/
/****************************************************************************/

#define MAX_EVENTS 4000

typedef struct INSTANCE_DATA {

	P_XY32	pEventList;
	U32		eventCount;
	U32		eventLast;
	U32		bEventPending;
	U32		bPenDown;
	COORD16 thickness;

	BOOLEAN	bNibSampled;
	BOOLEAN	bNibItalic;
	BOOLEAN	bNibSquare;

	BOOLEAN	bPenMoveDelta;
	BOOLEAN	bPenPoll;
	BOOLEAN	bPenShowInk;
	OBJECT	dc;

} INSTANCE_DATA, *P_INSTANCE_DATA;

/****************************************************************************/
/*					F O R W A R D   D E C L A R A T I O N S					*/
/****************************************************************************/

/****************************************************************************/
/*				S T A T I C   D A T A   D E C L A R A T I O N S				*/
/****************************************************************************/

/****************************************************************************/
/*			L O C A L   F U N C T I O N S   &   M E T H O D S			    */
/****************************************************************************/

STATIC STATUS DrawSquare(
	OBJECT dc,
	U32 thickness,
	P_SYSDC_POLYLINE pPolyLine)
{
	SYSDC_POLYLINE polyLine;
	XY32 dots[6];
	XY32 p1;
	XY32 p2;
	XY32 ptmp;
	U32 off1 = (thickness - 1) >> 1;
	U32 off2 = thickness - 1 - off1;
	U32 i;

	polyLine.count = 6;
	polyLine.points = dots;
	for(i = 0; i < pPolyLine->count - 1; i++)
	  {
		p1 = pPolyLine->points[i];
		p2 = pPolyLine->points[i+1];
		if(p1.y > p2.y)
		  {
		  	ptmp = p1;
			p1 = p2;
			p2 = ptmp;
		  }
		if(p1.x < p2.x)
		  {
			dots[0].x = p1.x - off1;
			dots[0].y = p1.y - off1;
			dots[1].x = p1.x + off2;
			dots[1].y = p1.y - off1;
			dots[2].x = p2.x + off2;
			dots[2].y = p2.y - off1;
			dots[3].x = p2.x + off2;
			dots[3].y = p2.y + off2;
			dots[4].x = p2.x - off1;
			dots[4].y = p2.y + off2;
			dots[5].x = p1.x - off1;
			dots[5].y = p1.y + off2;
		  }
		else
		  {
			dots[0].x = p1.x + off2;
			dots[0].y = p1.y - off1;
			dots[1].x = p1.x + off2;
			dots[1].y = p1.y + off2;
			dots[2].x = p2.x + off2;
			dots[2].y = p2.y + off2;
			dots[3].x = p2.x - off1;
			dots[3].y = p2.y + off2;
			dots[4].x = p2.x - off1;
			dots[4].y = p2.y - off1;
			dots[5].x = p1.x - off1;
			dots[5].y = p1.y - off1;
		  }
		ObjectCall(msgDcDrawPolygon, dc, &polyLine);
	  }
	return stsOK;
}
STATIC STATUS DrawItalic(
	OBJECT dc,
	U32 thickness,
	P_SYSDC_POLYLINE pPolyLine)
{
	SYSDC_POLYLINE polyLine;
	XY32 dots[4];
	U32 off1 = (thickness - 1) >> 1;
	U32 off2 = thickness - 1 - off1;
	U32 i;

	polyLine.count = 4;
	polyLine.points = dots;
	for(i = 0; i < pPolyLine->count - 1; i++)
	  {
		dots[0].x = pPolyLine->points[i].x - off1;
		dots[0].y = pPolyLine->points[i].y - off1;
		dots[1].x = pPolyLine->points[i].x + off2;
		dots[1].y = pPolyLine->points[i].y + off2;
		dots[2].x = pPolyLine->points[i+1].x + off2;
		dots[2].y = pPolyLine->points[i+1].y + off2;
		dots[3].x = pPolyLine->points[i+1].x - off1;
		dots[3].y = pPolyLine->points[i+1].y - off1;
		ObjectCall(msgDcDrawPolygon, dc, &polyLine);
	  }
	return stsOK;
}
STATIC STATUS DrawLine(
	P_INSTANCE_DATA pData,
	P_SYSDC_POLYLINE pPolyLine)
{

	if(pPolyLine->count < 2)
		return stsFailed;

	if(pData->bNibItalic)
		DrawItalic(pData->dc, pData->thickness, pPolyLine);
	else if(pData->bNibSquare)
		DrawSquare(pData->dc, pData->thickness, pPolyLine);
	else
		ObjectCall(msgDcDrawPolyline, pData->dc, pPolyLine);
	return stsOK;
}

STATIC STATUS PollPen(
	OBJECT self,
	P_INSTANCE_DATA pData,
	P_XY32 pFirstPoint)
{
	XY32 dots[2];
	XY32 delta;
	WIN_METRICS wm;
	SYSDC_POLYLINE polyLine;
	BOOLEAN bSampled = pData->bNibSampled;
	U32 eventCount = 0;
	CURRENT_STD_PEN_DATA pd;
	  
	ObjectCall(msgWinBeginPaint, self, pNull);

	wm.bounds.origin.x = 0;
	wm.bounds.origin.y = 0;
	wm.bounds.size.w = 0;
	wm.bounds.size.h = 0;
	wm.parent = theRootWindow;
 	ObjCallWarn(msgWinTransformBounds, self, &wm);
	delta = wm.bounds.origin;

	polyLine.count = 2;
	polyLine.points = dots;

	pd.positionAcetate = *pFirstPoint;
	dots[0] = pd.positionAcetate;
	dots[1] = dots[0];
	pData->pEventList[eventCount++] = pd.positionAcetate;

	DrawLine(pData, &polyLine);

	while(true)
	{
	  	OSTaskDelay(0);
		PenCurrentStandardData(&pd);
		if(pd.penTipState != penTipDownState)
			break;
		pd.positionAcetate.x -= delta.x;
		pd.positionAcetate.y -= delta.y;
		if(	(pd.positionAcetate.x == dots[1].x) AND
			(pd.positionAcetate.y == dots[1].y))
			continue;
		dots[0] = dots[1];
		dots[1] = pd.positionAcetate;
		pData->pEventList[eventCount++] = pd.positionAcetate;
		if(bSampled)
			dots[0] = dots[1];

		DrawLine(pData, &polyLine);
		if(eventCount >= MAX_EVENTS)
			break;
	}

	ObjectCall(msgWinEndPaint, self, pNull);
	pData->eventCount = eventCount;
	pData->eventLast = 0;

	Dbg(Debugf("Exit poll pen");)
	return stsOK;
}

/****************************************************************************
	msgInit
****************************************************************************/
MsgHandlerWithTypes(PaintWinInit, P_PAINT_WIN_NEW, P_INSTANCE_DATA)
{
	STATUS s;
	INSTANCE_DATA inst;
	SIZEOF length;
	SYSDC_NEW	dcn;
	SYSDC_LINE line;
	SYSDC_MODE dcMode;

	Dbg(Debugf("PaintWin[%p] msgInit", self);)

	// NOTE:  These should be set in response to msgNewDefaults.
	pArgs->win.flags.input = 0;
	pArgs->win.flags.input |= inputTip;
	pArgs->win.flags.input |= inputMoveDown;
	pArgs->win.flags.input |= inputNoBusy;

	ObjCallAncestorRet(msg, self, pArgs, ctx, s);

	memset(&inst, 0, sizeof(inst));
	ObjectWrite(self, ctx, &inst);

	length = MAX_EVENTS * SizeOf(inst.pEventList[0]);
	StsRet(OSHeapBlockAlloc(osProcessHeapId, length, &inst.pEventList), s);
	inst.eventCount = 0;
	inst.eventLast = 0;
	inst.bEventPending = false;
	inst.bPenDown = false;

	ObjCallRet(msgNewDefaults, clsSysDrwCtx, &dcn, s);
	ObjCallRet(msgNew, clsSysDrwCtx, &dcn, s);
	inst.dc = dcn.object.uid;
	ObjectCall(msgDcSetBackgroundRGB, inst.dc, (P_ARGS)SysDcGrayRGB(0));
	ObjectCall(msgDcSetWindow, inst.dc, (P_ARGS)self);
	ObjectCall(msgDcUnitsDevice, inst.dc, Nil(P_ARGS));
	ObjectCall(msgDcGetLine, inst.dc, &line);
	line.thickness = inst.thickness;
	line.cap = sysDcCapRound;
   line.join = sysDcJoinRound;
	ObjectCall(msgDcSetLine, inst.dc, &line);
	dcMode = (SYSDC_MODE)ObjectCall(msgDcGetMode, inst.dc, pNull);
	dcMode |= sysDcWindingFill;
 	ObjectCall(msgDcSetMode, inst.dc, (P_ARGS)dcMode);
	ObjectWrite(self, ctx, &inst);

	Dbg(Debugf("pEventList[%p] length=%ld", pData->pEventList, (S32)length);)

	ObjectCall(msgPaintWinCommand, self, (P_ARGS)penPoll);
	ObjectCall(msgPaintWinCommand, self, (P_ARGS)nibItalic);
	ObjectCall(msgPaintWinSetThickness, self, (P_ARGS)3);

	return stsOK;
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	msgFree
****************************************************************************/
MsgHandlerWithTypes(PaintWinFree, P_ARGS, P_INSTANCE_DATA)
{
	STATUS s;
	INSTANCE_DATA inst = *pData;

	Dbg(Debugf("PaintWin[%p] msgFree", self);)

	if (inst.pEventList) {
		StsWarn(OSHeapBlockFree(inst.pEventList));
   }
	if (inst.dc) {
		ObjectCall(msgDestroy, inst.dc, pNull);
	}

	ObjCallAncestorRet(msg, self, pArgs, ctx, s);

	return stsOK;
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	msgPaintWinCommand
****************************************************************************/
MsgHandlerWithTypes(PaintWinCommand, P_ARGS, P_INSTANCE_DATA)
{
	STATUS s;
	INSTANCE_DATA inst = *pData;
	WIN_METRICS wm;
	U32 command = (U32)pArgs;

	if(command == nibSampled)
	  {
	  	// Toggle Sampled Mode

		inst.bNibSampled = !inst.bNibSampled;
		Dbg(Debugf("Set Sampled Mode to %s", inst.bNibSampled ?"true":"false");)
		ObjectWrite(self, ctx, &inst);
	  }
	else if(command == penShowInk)
	  {
	  	// Toggle Ink flag
		inst.bPenShowInk = !inst.bPenShowInk;
		Dbg(Debugf("Set InkThrough to %s", inst.bPenShowInk ?"true":"false");)
		ObjectWrite(self, ctx, &inst);
	  }
	else if(command == penMoveDelta)
	  {
		inst.bPenMoveDelta = true;
		inst.bPenPoll = false;
		Dbg(Debugf("Set MoveDelta to true");)
		ObjectWrite(self, ctx, &inst);
	  }
	else if(command == penPoll)
	  {
		inst.bPenMoveDelta = false;
		inst.bPenPoll = true;
		Dbg(Debugf("Set PollPen to true");)
		ObjectWrite(self, ctx, &inst);
	  }
	else if(command == penStandard)
	  {
		inst.bPenMoveDelta = false;
		inst.bPenPoll = false;
		Dbg(Debugf("Set PaintMode to normal");)
		ObjectWrite(self, ctx, &inst);
	  }
	else if(command == nibRound)
	  {
		inst.bNibItalic = false;
		inst.bNibSquare = false;
		ObjectWrite(self, ctx, &inst);
	  }
	else if(command == nibSquare)
	  {
		inst.bNibItalic = false;
		inst.bNibSquare = true;
		ObjectWrite(self, ctx, &inst);
	  }
	else if(command == nibItalic)
	  {
		inst.bNibItalic = true;
		inst.bNibSquare = false;
		ObjectWrite(self, ctx, &inst);
	  }

	if(inst.bNibItalic OR inst.bNibSquare)
		ObjectCall(msgDcSetLineThickness, pData->dc, (P_ARGS)1);
	else
		ObjectCall(msgDcSetLineThickness, pData->dc, (P_ARGS)inst.thickness);

	ObjCallRet(msgWinGetFlags, self, &wm, s);
	if(inst.bPenShowInk OR (!inst.bPenPoll))
		wm.flags.input |= inputInk;
	else
		wm.flags.input &= ~inputInk;

	if(inst.bPenPoll)
		wm.flags.input &= ~inputMoveDown;
	else
		wm.flags.input |= inputMoveDown;

	if(inst.bPenPoll OR inst.bPenMoveDelta)
		wm.flags.input |= inputMoveDelta;
	else
		wm.flags.input &= ~inputMoveDelta;
	ObjCallRet(msgWinSetFlags, self, &wm, s);

	return stsOK;
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	msgPaintWinClear
****************************************************************************/
MsgHandlerWithTypes(PaintWinClear, P_ARGS, P_INSTANCE_DATA)
{
	STATUS s;
	SYSDC_NEW dcn;
	OBJECT dc;
	OBJECT offscreen;

	ObjCallWarn(msgPixWinPixelmap, self, &offscreen);
	ObjCallRet(msgNewDefaults, clsSysDrwCtx, &dcn, s);
	ObjCallRet(msgNew, clsSysDrwCtx, &dcn, s);
	dc = dcn.object.uid;
	ObjectCall(msgDcSetBackgroundRGB, dc, (P_ARGS)SysDcGrayRGB(255));
	ObjectCall(msgDcSetForegroundRGB, dc, (P_ARGS)SysDcGrayRGB(255));
	ObjCallWarn(msgDcSetWindow, dc, (P_ARGS)offscreen);
	ObjectCall(msgWinBeginPaint, dc, pNull);
	ObjectCall(msgDcFillWindow, dc, pNull);
	ObjectCall(msgWinEndPaint, dc, pNull);
	ObjectCall(msgDestroy, dc, pNull);

	ObjCallWarn(msgWinDirtyRect, self, pNull);
	return stsOK;
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	msgPaintWinSetColor
****************************************************************************/
MsgHandlerWithTypes(PaintWinSetColor, P_ARGS, P_INSTANCE_DATA)
{
	U32 color = (U32)pArgs;
	ObjectCall(msgDcSetForegroundRGB, pData->dc, (P_ARGS)SysDcGrayRGB(color));
	ObjectCall(msgDcSetBackgroundRGB, pData->dc, (P_ARGS)SysDcGrayRGB(color));
	return stsOK;
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	msgPaintWinSetThickness
****************************************************************************/
MsgHandlerWithTypes(PaintWinSetThickness, P_ARGS, P_INSTANCE_DATA)
{
	COORD16 thickness = (COORD16)(S32)pArgs;
	INSTANCE_DATA inst = *pData;
	inst.thickness = thickness;
	ObjectWrite(self, ctx, &inst);

	if(!(pData->bNibItalic OR pData->bNibSquare))
		ObjectCall(msgDcSetLineThickness, pData->dc, pArgs);
	return stsOK;
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	msgPaintWinUpdate
****************************************************************************/
MsgHandlerWithTypes(PaintWinUpdate, P_ARGS, P_INSTANCE_DATA)
{
	INSTANCE_DATA inst = *pData;
	BOOLEAN bEndLine = (BOOLEAN)(U32)pArgs;
	SYSDC_POLYLINE polyLine;

	ObjectCall(msgWinBeginPaint, pData->dc, pNull);

	if(pData->bNibSampled)
	  {
	  	XY32 xy[2];
		U32 i;

		polyLine.count = 2;
		polyLine.points = xy;

		for(i = 0; i < pData->eventCount; i++)
		  {
			xy[0] = pData->pEventList[i + pData->eventLast];
			xy[1] = xy[0];
			DrawLine(pData, &polyLine);
			//ObjectCall(msgDcDrawPolyline, pData->dc, &polyLine);
		  }
	  }
	else
	  {
		polyLine.count = (U16)pData->eventCount;
		polyLine.points = &pData->pEventList[pData->eventLast];
		if(polyLine.count == 1)
		  {
		  	polyLine.count = 2;
			polyLine.points[1] = polyLine.points[0];
		  }
		DrawLine(pData, &polyLine);
	  }

	ObjectCall(msgWinEndPaint, pData->dc, pNull);

	inst.eventLast += inst.eventCount - 1;
	if (inst.eventCount == 0)
		Dbg(Debugf("eventLast %ld,eventCount %ld", 
						inst.eventCount, inst.eventLast);)

	if (bEndLine)
	  {
		inst.eventCount = 0;
	  }
	else
	  {
		inst.eventCount = 1;
	  }

	inst.bEventPending = false;
	ObjectWrite(self, ctx, &inst);

	return stsOK;
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	msgPaintWinPaintOffscreen

****************************************************************************/
MsgHandlerWithTypes(PaintWinPaintOffscreen, P_INPUT_EVENT, P_INSTANCE_DATA)
{
#ifdef ACCURATE_BUT_SLOW
	STATUS s;
	INSTANCE_DATA inst;
	OBJECT offscreen;


	inst = *pData;
	inst.eventCount += inst.eventLast;
	inst.eventLast = 0;
	ObjectWrite(self, ctx, &inst);

	ObjCallWarn(msgPixWinPixelmap, self, &offscreen);
	ObjCallWarn(msgDcSetWindow, pData->dc, (P_ARGS)offscreen);
	ObjCallWarn(msgPaintWinUpdate, self, (P_ARGS)true);
	ObjCallWarn(msgDcSetWindow, pData->dc, (P_ARGS)self);

#else

	STATUS s;
	INSTANCE_DATA inst;
	SYSDC_PIXELS cp;
	SYSDC_NEW dn;
	OBJECT dc;
	OBJECT offscreen;
	RECT32 bounds;
	U32 thickness = (pData->thickness + 1) >> 1;
	U32 count;
	U32 i;

	bounds.origin.x = 10000;
	bounds.origin.y = 10000;
	bounds.size.h = -10000;
	bounds.size.w = -10000;
	count = pData->eventCount + pData->eventLast;
	for(i = 0; i < count; i++)
	  {
	  	bounds.origin.x = Min(pData->pEventList[i].x, bounds.origin.x);
	  	bounds.origin.y = Min(pData->pEventList[i].y, bounds.origin.y);
	  	bounds.size.w = Max(pData->pEventList[i].x, bounds.size.w);
	  	bounds.size.h = Max(pData->pEventList[i].y, bounds.size.h);
	  }
	// adjust for thickness
	bounds.size.w += thickness;
	bounds.size.h += thickness;
	bounds.origin.x -= thickness;
	bounds.origin.y -= thickness;
	// convert x1,y1 - x2,y2 to x,y - w,h
	bounds.size.w -= bounds.origin.x;
	bounds.size.h -= bounds.origin.y;

	inst = *pData;
	inst.eventCount = 0;
	inst.eventLast = 0;
	ObjectWrite(self, ctx, &inst);

	ObjCallWarn(msgPixWinPixelmap, self, &offscreen);

	cp.srcWindow	= self;
	cp.pBounds		= &bounds;
	cp.xy			= bounds.origin;
	cp.dstDirty		= FALSE;

	// create a drawing context
	ObjCallWarn(msgNewDefaults, clsSysDrwCtx, &dn);
	ObjCallRet(msgNew, clsSysDrwCtx, &dn, s);
	dc = dn.object.uid;
	ObjCallWarn(msgDcUnitsDevice, dc, pNull);

	// bind the context to window
	ObjCallWarn(msgDcSetWindow, dc, offscreen);

	// copy the pixels
	ObjectCall(msgWinBeginPaint, dc, pNull);
	ObjCallWarn(msgDcCopyPixels, dc, &cp);
	ObjectCall(msgWinEndPaint, dc, pNull);

	// destroy dc 
	ObjCallWarn(msgDestroy, dc, pNull);
#endif

	return stsOK;
	MsgHandlerParametersNoWarning;
}
/****************************************************************************
	msgInputEvent

	HandleInputEvent
****************************************************************************/
MsgHandlerWithTypes(PaintWinInputEvent, P_INPUT_EVENT, P_INSTANCE_DATA)
{
	INSTANCE_DATA inst = *pData;

	if (pData->bPenPoll)
	  {
		if (pArgs->devCode != msgPenDown)
			return stsInputTerminate;

		PollPen(self, &inst, &pArgs->xy);
		ObjectWrite(self, ctx, &inst);
		ObjCallWarn(msgPaintWinPaintOffscreen, self, pNull);
		return stsInputTerminate;
	  }

	// Is this a pen down event??
	//
	if (pArgs->devCode == msgPenDown)
	  {
	  	if (pData->bPenDown) {
			Dbg(Debugf("Got msgPenDown when I thought pen was down!!");)
		}
	  	inst.bPenDown = true;
		inst.eventCount = 0;
		inst.eventLast = 0;
		ObjectWrite(self, ctx, &inst);
	  }
	if (pArgs->devCode == msgPenUp)
	  {
	  	if (!pData->bPenDown)
		  {
			Dbg(Debugf("Got msgPenUp when I thought pen was up!!");)
			return stsInputTerminate;
		  }
	  }

	// Events that cause data to be saved
	//
	switch(pArgs->devCode)
	  {
	  	default:
			Dbg(Debugf("Strange event %d",  (int)TagNum(pArgs->devCode));)
			return stsInputTerminate;

		case msgPenDown:
		case msgPenEnterDown:
		case msgPenMoveDown:
		case msgPenUp:
		case msgPenExitDown:
			if(pData->eventCount >= MAX_EVENTS)
			  {
			  	//Debugf("PaintWin:  Tossing an event!!");
				//ObjCallWarn(msgPaintWinUpdate, self, (P_ARGS)false);
				return stsInputGrabTerminate;
			  }
//Debugf("EventCount %ld (%ld,%ld)", pData->eventCount, pArgs->xy.x, pArgs->xy.y);

			pData->pEventList[pData->eventLast + pData->eventCount] = pArgs->xy;
			inst.eventCount++;
			ObjectWrite(self, ctx, &inst);
			break;
	  }

	// Events that cause data to be flushed
	//
	if(pData->bPenDown AND pArgs->devCode == msgPenUp)
	  {
//Debugf("PenUp:  eventLast=%ld, eventCount=%ld", pData->eventLast, pData->eventCount);
		inst.bPenDown = false;
		ObjectWrite(self, ctx, &inst);

		ObjCallWarn(msgPaintWinUpdate, self, (P_ARGS)true);
		ObjCallWarn(msgPaintWinPaintOffscreen, self, pNull);
		return stsInputTerminate;
	  }

	// send self an event...
	if(!pData->bEventPending)
	  {
		inst.bEventPending = true;
		ObjectWrite(self, ctx, &inst);
//Debugf("Send event to self");

		ObjCallWarn(msgPaintWinUpdate, self, (P_ARGS)false);
	  }

	return stsInputGrabTerminate;
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	msgWinRepaint
****************************************************************************/
MsgHandlerWithTypes(PaintWinRepaint, P_ARGS, P_INSTANCE_DATA)
{
	STATUS s;
	SYSDC_NEW dcn;
	OBJECT dc;

	ObjCallRet(msgNewDefaults, clsSysDrwCtx, &dcn, s);
	ObjCallRet(msgNew, clsSysDrwCtx, &dcn, s);
	dc = dcn.object.uid;
	ObjectCall(msgDcSetBackgroundRGB, dc, (P_ARGS)SysDcGrayRGB(255));
	ObjectCall(msgDcSetForegroundRGB, dc, (P_ARGS)SysDcGrayRGB(255));
	ObjectCall(msgDcSetWindow, dc, (P_ARGS)self);
	ObjectCall(msgDcFillWindow, dc, pNull);
	ObjectCall(msgDestroy, dc, pNull);
	return stsOK;
	MsgHandlerParametersNoWarning;
}


STATUS ClsPaintWinInit()
{
	STATUS			s;
	CLASS_NEW		new;

	ObjCallRet(msgNewDefaults, clsClass, &new, s);
	new.object.uid		= clsPaintWin;
	new.object.key		= objWKNKey;
	new.cls.pMsg	  	= PaintWinMethodTable;
	new.cls.ancestor	= PAINT_WIN_ANCESTOR;
	new.cls.size		= SizeOf(INSTANCE_DATA);
	new.cls.newArgsSize	= SizeOf(PAINT_WIN_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return stsOK;
}

