/****************************************************************************
 File: hellotk2.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.9  $  (from hello.c 1.1)
   $Author:   kcatlin  $
     $Date:   18 Mar 1992 08:57:58  $

 This file contains the application class for a "Hello World" application
 using toolkit components.
 This uses the PenPoint UI Toolkit to draw in its window -- thus it
 does not create a window class.

 Instead, it creates a custom layout window in its frame and inserts a
 label within the layout window.

 Other versions of hellotk.c don't use custom layout, or
 create several toolkit windows.

 It does not have any state it needs to save.
 It does not have any instance data.

 If you turn on the "F20" debugging flag (e.g. by putting
	DEBUGSET=/F0020
 in \penpoint\boot\environ.ini), then messages to clsHelloWorld will be
 traced.
 If you turn on the "F40" debugging flag then the custom layout window
 will be visible (gray background, rounded border).

***************************************************************************/
#ifndef DEBUG_INCLUDED
#include <debug.h>				// for debugging statements.
#endif
#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>				// for O-OP support.
#endif
#ifndef APP_INCLUDED
#include <app.h>				// for application messages
#endif
#ifndef APPMGR_INCLUDED
#include <appmgr.h>				// for AppMgr startup stuff
#endif
#ifndef _STRING_H_INCLUDED
#include <string.h>				// for strcpy().
#endif
#ifndef LABEL_INCLUDED
#include <label.h>				// for label.
#endif
#ifndef FRAME_INCLUDED
#include <frame.h>				// for frame metrics (and clayout.h)
#endif

#include <methods.h>				// method function prototypes generated by MT

#define clsHelloWorld	wknGDTc	// avoids clashing with other HelloWorlds

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                         		Methods		  							   		*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
	HelloAppInit
	
	Respond to msgAppInit by creating long-lived objects (filed state).
	But I create and destroy my user interface in msgAppOpen/msgAppClose,
	so do nothing.
****************************************************************************/
MsgHandler(HelloAppInit)
{
	Dbg(Debugf("HelloTK: msgAppInit");)

	// When the message gets to clsApp the frame will be created.
	return stsOK;
	MsgHandlerParametersNoWarning;
} /* HelloAppInit */

/****************************************************************************
	HelloOpen
	
	Respond to msgAppOpen by creating the U.I.:
		o	a custom layout window
		o	and a label within it.
****************************************************************************/
MsgHandler(HelloOpen)
{
	APP_METRICS				am;
	WIN_METRICS				wm;
	CSTM_LAYOUT_NEW			cn;
	CSTM_LAYOUT_CHILD_SPEC	cs;
	LABEL_NEW				ln;
	STATUS					s;

	Dbg(Debugf("HelloTK: Create the client Win");)

	ObjCallWarn(msgNewDefaults, clsCustomLayout, &cn);
	// ?? Needed??	cn.win.parent = frame;

	// If the frame is floating, this will make it wrap neatly
	// around the label.
	cn.border.style.leftMargin = cn.border.style.rightMargin = bsMarginSmall;
	cn.win.flags.style |= wsShrinkWrapHeight;

	
	if (DbgFlagGet('F', 0x40L)) {
		cn.border.style.join				= bsJoinRound;
		cn.border.style.edge				= bsEdgeAll;
		cn.border.style.backgroundInk	= bsInkGray33;
	}

	ObjCallRet(msgNew, clsCustomLayout, &cn, s);

	// Create the Hello label window.
	ObjCallWarn(msgNewDefaults, clsLabel, &ln);
	ln.label.pString = "Hello World!";
	ObjCallJmp(msgNew, clsLabel, &ln, s, error1);

	// Insert the Hello win in the custom layout window.
	wm.parent = cn.object.uid;
	ObjCallJmp(msgWinInsert, ln.object.uid, &wm, s, error2);

	// Specify how the custom layout window should position the label.
	CstmLayoutSpecInit(&(cs.metrics));
	cs.child = ln.object.uid;
	cs.metrics.x.constraint = ClAlign(clCenterEdge, clSameAs, clCenterEdge);
	cs.metrics.y.constraint = ClAlign(clCenterEdge, clSameAs, clCenterEdge);
	cs.metrics.w.constraint = clAsIs;
	cs.metrics.h.constraint = clAsIs;
	ObjCallJmp(msgCstmLayoutSetChildSpec, cn.object.uid, &cs, s, error2);

	
	// Get the app's main window (its frame).
	ObjCallJmp(msgAppGetMetrics, self, &am, s, error2);

	// Insert the custom layout window in the frame.
	ObjCallJmp(msgFrameSetClientWin, am.mainWin, \
						(P_ARGS)cn.object.uid, s, error2);

	// When the message gets to its ancestor this will all go on-screen.
	return stsOK;
	MsgHandlerParametersNoWarning;


error2:
	ObjCallWarn(msgDestroy, ln.object.uid, Nil(OBJ_KEY));

error1:
	ObjCallWarn(msgDestroy, cn.object.uid, Nil(OBJ_KEY));

	return s;

} /* HelloOpen */

/****************************************************************************
	HelloClose
	
	Respond to msgAppClose by destroying the client window.
	The ancestor has already taken us off-screen.
****************************************************************************/
MsgHandler(HelloClose)
{
	APP_METRICS		am;
	WIN				win;
	OBJ_KEY			key = objWKNKey;
	STATUS			s;

	// Get the client window.
	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetClientWin, am.mainWin, (P_ARGS)&win, s);

	// Destroy it.
	ObjCallRet(msgDestroy, win, &key, s);
	Dbg(Debugf("HelloTK: back from freeing client Win");)

	// Tell the app that it no longer has a client window.
	ObjCallRet(msgFrameSetClientWin, am.mainWin, (P_ARGS)objNull, s);

	return stsOK;
	MsgHandlerParametersNoWarning;
} /* HelloClose */


/****************************************************************************
	ClsHelloInit
	
	Install the Hello application.
****************************************************************************/
STATUS ClsHelloInit (void)
{
	APP_MGR_NEW	new;
	STATUS		s;


	// Install the class.
	ObjCallWarn(msgNewDefaults, clsAppMgr, &new);
	new.object.uid				= clsHelloWorld;
	new.object.key 		  		= (OBJ_KEY)clsHelloTable;
	new.cls.pMsg			  	= clsHelloTable;
	new.cls.ancestor		  	= clsApp;
	// This class has no instance data, so its size is zero.
	new.cls.size				= Nil(SIZEOF);
	// This class has no msgNew arguments of its own.
	new.cls.newArgsSize			= SizeOf(APP_NEW);
	new.appMgr.flags.stationery		= true;
	new.appMgr.flags.accessory		= true;
	new.appMgr.flags.allowEmbedding	= false;
	new.appMgr.flags.hotMode		= false;
	strcpy(new.appMgr.company, "GO Corporation");
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	if (DbgFlagGet('F', 0x20L)) {
		Dbg(Debugf("Turning on message tracing for clsHelloWorld (toolkit)");)
		(void)ObjCallWarn(msgTrace, clsHelloWorld, (P_ARGS) true);
	}

	return stsOK;

} /* ClsHelloInit */

/****************************************************************************
	main
	
	Main application entry point.
****************************************************************************/
void CDECL main (
	int			argc,
	char *		argv[],
	U16			processCount)
{
	Dbg(Debugf("main: starting HelloTK2.exe[%d]", processCount);)

	if (processCount == 0) {
		// Initialize self.
		ClsHelloInit();

		// Invoke app monitor to install this application.
		AppMonitorMain(clsHelloWorld, objNull);
	} else {
		// Start the application.
		AppMain();
	}
	Unused(argc);  Unused(argv);	// Suppress compiler warnings
} /* main */
