/****************************************************************************
 File: hellotk1.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.8  $ 
   $Author:   kcatlin  $
     $Date:   18 Mar 1992 08:57:50  $

 This file contains the application class for a "Hello World" application
 using toolkit components.
 This uses the PenPoint UI Toolkit to draw in its window -- thus it
 does not create a window class.
 It creates a label as its client window in response to msgAppInit.
 It has dummy message handlers for msgAppClose and msgAppOpen so it can
 share the same methods.tbl with hellotk2.c.

 It does not have any state it needs to save.
 It does not have any instance data.

 Most applications have more than one window in their frame.  hellotk2.c
 is an alternative version of hellotk.c which creates a label inside a
 custom layout window.

 If you turn on the "F20" debugging flag (e.g. by putting
	DEBUGSET=/F0020
 in \penpoint\boot\environ.ini), then messages to clsHelloWorld will be
 traced.

***************************************************************************/
#ifndef DEBUG_INCLUDED
#include <debug.h>				// for debugging statements.
#endif
#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>				// for O-OP support.
#endif
#ifndef APP_INCLUDED
#include <app.h>				// for application messages (and clsmgr.h)
#endif
#ifndef APPMGR_INCLUDED
#include <appmgr.h>				// for AppMgr startup stuff
#endif
#ifndef _STRING_H_INCLUDED
#include <string.h>				// for strcpy().
#endif
#ifndef LABEL_INCLUDED
#include <label.h>				// for label.
#endif
#ifndef FRAME_INCLUDED
#include <frame.h>				// for frame metrics.
#endif

#include <methods.h>				// method function prototypes generated by MT

#define clsHelloWorld	wknGDTb	// avoids clashing with other HelloWorlds

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                         		Methods		  							   		*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
	HelloAppInit
	
	Respond to msgAppInit by creating the client window (a label).
****************************************************************************/
MsgHandler(HelloAppInit)
{
	APP_METRICS				am;
	LABEL_NEW				ln;
	STATUS					s;

	Dbg(Debugf("HelloTK: Create the client Win");)

	// Create the Hello label window.
	ObjCallWarn(msgNewDefaults, clsLabel, &ln);
	ln.label.style.scaleUnits	= bsUnitsFitWindowProper;
	ln.label.style.xAlignment	= lsAlignCenter;
	ln.label.style.yAlignment	= lsAlignCenter;
	ln.label.pString			= "Hello World!";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	// Get the app's main window (its frame).
	ObjCallJmp(msgAppGetMetrics, self, &am, s, error);

	// Insert the label in the frame as its client window.
	ObjCallJmp(msgFrameSetClientWin, am.mainWin, \
					   	(P_ARGS)ln.object.uid, s, error);

	return stsOK;
	MsgHandlerParametersNoWarning;

error:
	ObjCallWarn(msgDestroy, ln.object.uid, Nil(OBJ_KEY));
	return s;
} /* HelloAppInit */

/****************************************************************************
	HelloOpen
	
	Respond to msgAppOpen by creating UI objects that aren't filed.
	But I create my user interface in msgAppInit, so it's filed and
	restored for me, so do nothing.
****************************************************************************/
MsgHandler(HelloOpen)
{
	Dbg(Debugf("HelloTK: msgAppOpen");)

	// When the message gets to clsApp the app will go on-screen.
	return stsOK;
	MsgHandlerParametersNoWarning;
} /* HelloOpen */


/****************************************************************************
	HelloClose
	
	Respond to msgAppClose by destroying UI objects that aren't filed.
	But I create my user interface in msgAppInit, so it's filed and
	restored for me, so do nothing.
****************************************************************************/
MsgHandler(HelloClose)
{
	Dbg(Debugf("HelloTK: msgAppClose");)

	// When the message gets to its ancestor the frame will be taken
	// off-screen.
	return stsOK;
	MsgHandlerParametersNoWarning;
} /* HelloClose */


/****************************************************************************
	ClsHelloInit
	
	Install the Hello application.
****************************************************************************/
STATUS ClsHelloInit (void)
{
	APP_MGR_NEW	new;
	STATUS		s;

	// Install the class.
	ObjCallWarn(msgNewDefaults, clsAppMgr, &new);
	new.object.uid				= clsHelloWorld;
	new.object.key 		  		= (OBJ_KEY)clsHelloTable;
	new.cls.pMsg			  	= clsHelloTable;
	new.cls.ancestor		  	= clsApp;
	// This class has no instance data, so its size is zero.
	new.cls.size				= Nil(SIZEOF);
	// This class has no msgNew arguments of its own.
	new.cls.newArgsSize			= SizeOf(APP_NEW);
	new.appMgr.flags.stationery		= true;
	new.appMgr.flags.accessory		= true;
	new.appMgr.flags.allowEmbedding	= false;
	new.appMgr.flags.hotMode		= false;
	strcpy(new.appMgr.company, "GO Corporation");
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	if (DbgFlagGet('F', 0x20L)) {
		Dbg(Debugf("Turning on message tracing for clsHelloWorld (toolkit)");)
		(void)ObjCallWarn(msgTrace, clsHelloWorld, (P_ARGS) true);
	}

	return stsOK;

} /* ClsHelloInit */

/****************************************************************************
	main
	
	Main application entry point.
****************************************************************************/
void CDECL main (
	int			argc,
	char *		argv[],
	U16			processCount)
{
	Dbg(Debugf("main: starting HelloTK1.exe[%d]", processCount);)

	if (processCount == 0) {
		// Initialize self.
		ClsHelloInit();

		// Invoke app monitor to install this application.
		AppMonitorMain(clsHelloWorld, objNull);
	} else {
		// Start the application.
		AppMain();
	}
	Unused(argc);  Unused(argv);	// Suppress compiler warnings
} /* main */
