/****************************************************************************
 File: hello.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.7  $
   $Author:   kcatlin  $
     $Date:   18 Mar 1992 08:55:28  $

 This file contains the application class for a simple "Hello World"
 application.
 It creates an instance of clsHelloWin and inserts it in its frame.
 It does not have any state it needs to save.
 It does not have any instance data.

 If you turn on the "F10" debugging flag (e.g. by putting
	DEBUGSET=/DF0010
 in \penpoint\boot\environ.ini), then messages to clsHelloWorld will be
 traced.

***************************************************************************/
#ifndef DEBUG_INCLUDED
#include <debug.h>				// for debugging statements.
#endif
#ifndef APP_INCLUDED
#include <app.h>				// for application messages.
#endif
#ifndef APPMGR_INCLUDED
#include <appmgr.h>				// for AppMgr startup stuff
#endif
#ifndef FRAME_INCLUDED
#include <frame.h>				// for frame metrics.
#endif
#include <string.h>				// for strcpy().

#include <heltbl.h>				// method definitions
#include <hellowin.h>			// clsHelloWin's UID and msgNew args.

#define clsHelloWorld           MakeWKN(2164,1,wknGlobal)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Methods			  							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
	HelloOpen
	
	Respond to msgAppOpen by creating a clsHelloWin instance and inserting
	it as the frame's client window.
****************************************************************************/
MsgHandler(HelloOpen)
{
	HELLO_WIN_NEW	hwn;
	APP_METRICS		am;
	STATUS			s;


	// Get the app's main window (its frame).
	ObjCallRet(msgAppGetMetrics, self, &am, s);

	// Create the Hello window.
	ObjCallWarn(msgNewDefaults, clsHelloWin, &hwn);
	ObjCallRet(msgNew, clsHelloWin, &hwn, s);

	// Insert the Hello win in the frame.
	ObjCallJmp(msgFrameSetClientWin, am.mainWin, (P_ARGS)hwn.object.uid,
				s, exit);

	// Ancestor will put it all on the screen.

	return stsOK;
	MsgHandlerParametersNoWarning;				// suppress compiler warnings about unused parameters

exit:
	ObjCallWarn(msgDestroy, hwn.object.uid, pNull);
	return s;

} /* HelloOpen */

/****************************************************************************
	HelloClose
	
	Respond to msgAppClose by destroying the client window.
****************************************************************************/
MsgHandler(HelloClose)
{
	APP_METRICS		am;
	WIN				clientWin;
	STATUS			s;

	// Ancestor has taken the main window (frame) off the screen.

	// Get the client window.
	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetClientWin, am.mainWin, &clientWin, s);

	// Destroy it.
	ObjCallRet(msgDestroy, clientWin, objWKNKey, s);
	Dbg(Debugf("Hello: back from freeing HelloWin");)

	// Update the frame since the client window is gone.
	ObjCallRet(msgFrameSetClientWin, am.mainWin, (P_ARGS)objNull, s);

	return stsOK;
	MsgHandlerParametersNoWarning;				// suppress compiler warnings about unused parameters
} /* HelloClose */


/****************************************************************************
	ClsHelloInit
	
	Install the Hello application.
****************************************************************************/
STATUS ClsHelloInit (void)
{
	APP_MGR_NEW	new;
	STATUS		s;


	// Install the application class.
	ObjCallWarn(msgNewDefaults, clsAppMgr, &new);
	new.object.uid				= clsHelloWorld;
	new.object.key 		  		= (OBJ_KEY)clsHelloWorldTable;
	new.cls.pMsg			  	= clsHelloWorldTable;
	new.cls.ancestor		  	= clsApp;
	// This class has no instance data, so its size is zero.
	new.cls.size				= Nil(SIZEOF);
	// This class has no msgNew arguments of its own.
	new.cls.newArgsSize			= SizeOf(APP_NEW);
	new.appMgr.flags.stationery		= true;
	new.appMgr.flags.accessory		= true;
	strcpy(new.appMgr.company, "GO Corporation");
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	if (DbgFlagGet('F', 0x10L)) {
		Dbg(Debugf("Turning on message tracing for clsHelloWorld");)
		(void)ObjCallWarn(msgTrace, clsHelloWorld, (P_ARGS) true);
	}

	return stsOK;

} /* ClsHelloInit */

/****************************************************************************
	main
	
	Main application entry point.
****************************************************************************/
void CDECL main (
	int			argc,
	char *		argv[],
	U16			processCount)
{
	Dbg(Debugf("main: starting Hello.exe[%d]", processCount);)

	if (processCount == 0) {
		//
		// Initialize self.
		//
		// Note that the loader calls DLLMain in the Hello World DLL,
		// which creates clsHelloWin.
		//
		ClsHelloInit();

		// Invoke app monitor to install this application.
		AppMonitorMain(clsHelloWorld, objNull);
	} else {
		// Start the application.
		AppMain();
	}
	Unused(argc);  Unused(argv);	// Suppress compiler warnings
} /* main */
