/****************************************************************************
 File: ncbwin.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.1  $
   $Author:   kguzik  $
     $Date:   13 Mar 1992 11:43:02  $

 This file contains the class definition and methods for clsNoteCorkBoardWin.
 It inherits from clsCorkBoardWin and provides observation of apps inserted 
 into the window.
****************************************************************************/

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef GOTO_INCLUDED
#include <goto.h>
#endif

#ifndef UID_INCLUDED
#include <uid.h>
#endif

#ifndef OS_INCLUDED
#include <os.h>
#endif

#ifndef APPWIN_INCLUDED
#include <appwin.h>
#endif

// private header files that need no guardians
#include <methods.h>
#include <ncbwin.h>
#include <embedwin.h>

typedef struct INSTANCE_DATA {
	U32						dummy;
} INSTANCE_DATA, *P_INSTANCE_DATA;

/****************************************************************************
	NoteCorkBoardWinGetDirName

	Returns the corkboard's directory name.
 ****************************************************************************/
MsgHandlerWithTypes(NoteCorkBoardWinGetDirName, P_STRING, P_IDATA)
{
	strcpy(pArgs, "Clock Alarm Corkboard");

	return stsOK;

	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	NoteCorkBoardWinGetDest
	
	Respond to msgEmbeddedWinGetDest.
 ****************************************************************************/
MsgHandlerWithTypes(NoteCorkBoardWinGetDest, P_EMBEDDED_WIN_GET_DEST, P_IDATA)
{
	FS_NEW		fn;
	STATUS		s;

	// Force the app to be put in our own sub-directory.
	pArgs->locator.pPath = pArgs->path;
	ObjectCall(msgNoteCorkBoardWinGetDirName, self, pArgs->path);

	// Make sure the dir exists.
	ObjectCall(msgNewDefaults, clsDirHandle, &fn);
	fn.fs.locator	= pArgs->locator;
	fn.fs.mode		= fsDirNewDefaultMode;
	fn.fs.exist		= fsExistOpen | fsNoExistCreate;
	ObjCallRet(msgNew, clsDirHandle, &fn, s);

	ObjCallRet(msgDestroy, fn.object.uid, pNull, s);

	return stsOK;

	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	NoteCorkBoardWinNewDefaults
	
	Respond to msgNewDefaults.
****************************************************************************/
MSG_HANDLER NoteCorkBoardWinNewDefaults(
	const MESSAGE msg,
	const OBJECT self,
	const P_ICON_WIN_NEW pArgs,
	const CONTEXT ctx,
	const P_INSTANCE_DATA pData)
{

	// override IconWin's default
	pArgs->win.flags.style						|= wsShrinkWrapWidth;
	pArgs->win.flags.style						|= wsShrinkWrapHeight;
	pArgs->tableLayout.style.reverseY			= false;
	pArgs->tableLayout.style.childYAlignment	= tlAlignTop;
	pArgs->tableLayout.style.tblYAlignment		= tlAlignTop;
	pArgs->iconWin.style.iconType				= awSmallPictAndTitle;
	pArgs->iconWin.style.propagateIconType		= true;
  	pArgs->iconWin.style.allowOpenInPlace		= false;
	pArgs->iconWin.style.constrainedLayout		= true;
	pArgs->iconWin.style.showOptions			= false;
						 					  
	return stsOK;

	// supress compiler warnings
	MsgHandlerParametersNoWarning;

}	// NoteCorkBoardWinNewDefaults



/****************************************************************************
	NoteCorkBoardWinLayoutSelf
	
	Respond to msgWinLayoutSelf.
****************************************************************************/
MsgHandlerArgType(NoteCorkBoardWinLayoutSelf, P_WIN_METRICS)
{				  
	WIN_METRICS		wm;
	STATUS			s;
	BORDER_UNITS	bu;
	MsgHandlerParametersNoWarning;

	Dbg(Debugf("Note Corkboard Win: NoteCorkBoardWinLayoutSelf");)

	ObjCallAncestorRet(msg, self, pArgs, ctx, s);

	if (FlagOff(wsLayoutResize, pArgs->options))
		return stsOK;

	ObjCallRet(msgWinGetFlags, self, &wm, s);

	bu.win			= theRootWindow;
	bu.fromUnits	= bsUnitsLayout;
	bu.toUnits		= bsUnitsDevice;
	bu.size.w		= 110;
	bu.size.h		= 25;
	ObjCallWarn(msgBorderConvertUnits, self, &bu);

	if (WinShrinkWrapHeight(wm.flags.style))
		pArgs->bounds.size.h = Max(pArgs->bounds.size.h, bu.size.h);

	if (WinShrinkWrapWidth(wm.flags.style))
		pArgs->bounds.size.w = Max(pArgs->bounds.size.w, bu.size.w);

	return stsOK;

}	// NoteCorkBoardWinLayoutSelf
	   


/****************************************************************************
	ClsNoteCorkBoardWinInit
	
	Install the class.
****************************************************************************/
STATUS ClsNoteCorkBoardWinInit (void)
{
	CLASS_NEW	new;
	STATUS		s;


	// Create the class.
	ObjCallRet(msgNewDefaults, clsClass, &new, s);
	new.object.uid		= clsNoteCorkBoardWin;
	new.object.key		= (OBJ_KEY)clsNoteCorkBoardWinTable;
	new.cls.pMsg		= clsNoteCorkBoardWinTable;
	new.cls.ancestor	= clsCorkBoardWin;
	new.cls.size		= SizeOf(INSTANCE_DATA);
	new.cls.newArgsSize	= SizeOf(CORKBOARD_WIN_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return stsOK;

}  // ClsNoteCorkBoardWinInit




