/****************************************************************************
 File: adderevl.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.6  $
   $Author:   kcatlin  $
     $Date:   18 Mar 1992 08:38:04  $

 This file contains the class definition and methods for clsAdderEvaluator.
****************************************************************************/

#ifndef OS_INCLUDED
#include <os.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef _STRING_H_INCLUDED
#include <string.h>
#endif

#ifndef _STDIO_H_INCLUDED
#include <stdio.h>
#endif

#ifndef _CTYPE_H_INCLUDED
#include <ctype.h>
#endif

#ifndef _STDLIB_H_INCLUDED
#include <stdlib.h>
#endif

#ifndef ADDEREVL_INCLUDED
#include <adderevl.h>
#endif

#include <methods.h>


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc	 			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define SPACE ' '

#define MAX_TOK 80

// these must be internally consistant
#define minus_op1 '\xF0'
#define minus_op2 '-'
#define delims "-+"

// Global storage where tokens are taken apart
char token[MAX_TOK];    // the current token
char tok_type;
char *cursor;           // current position within parsed string
char err[MAX_SYNTAX];

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Utility Routines				 			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


// forward define this for recursion in get_subexpr()
void eval_terms(double *answer);  // return true if c is a delimiter


isdelim(char c)
{
	return strchr(delims, c) != NULL;
} // isdelim()


void get_token(void)
{
	char *temp;

	tok_type = 0;
	temp = token;
	*temp = '\0';

	if (!*cursor) {
		return; // end of expression
	}

	// skip white space
	while (isspace( (U8) *cursor)) {
		++cursor; 	
	}

	if (isdelim(*cursor)) {
		tok_type = DELIMITER;
		*temp++ = *cursor++; // copy and move to next char
	} else if (isalpha( (U8) *cursor)) {
		// copy letters or digits and advance
		while (isalnum( (U8) *cursor)) {
			*temp++ = *cursor++;
		}
	  	tok_type = VARIABLE;
	} else if (isdigit( (U8) *cursor) || *cursor == '.') {
		// copy digits to token and advance, suppress leading zeros
		while (isdigit( (U8) *cursor) || *cursor == '.') {
			if ( !(*cursor == '0' && temp == token) ) {
				*temp++ = *cursor;  // copy char if not leading zero
			}
			cursor++;
		}

		if (temp == token) {
			*temp++ = '0';  // don't zero-suppress a '0' to nothing
		}
		tok_type = NUMBER;
	} else {  // unknown token type
		*temp++ = '?';
	}
	*temp = '\0';
	Dbg(Debugf("get_token() type %d, <%s>  cursor: <%s>", 
						tok_type, token, cursor);)

	return;
} // get_token()


void eval_number(double *answer)
{
	if (tok_type == NUMBER) {
      
		// convert to double
		*answer = atof(token);
      
		get_token();      // prefetch next token
		return;
	}

	strcpy(err, "Missing number");
	Dbg(Debugf("Missing number before [%s], token is [%s]", cursor, token);)
} // eval_number()


void eval_signed(double *answer)
{
	char op;

	op = 0;
	if ((tok_type == DELIMITER) && *token=='+' || *token == minus_op1 ||
		   *token == minus_op2) {
		op = *token;
		get_token();
	} // if

	eval_number(answer);
	
	if (op == minus_op1 || op == minus_op2) 
      *answer = - *answer;  // was: FpNegate(answer);

} // eval_signed()


void eval_terms(double *answer)
{
	char 	op;
	double 	temp;

	eval_number(answer);
	while ((op = *token) == '+' || op == minus_op1 || op == minus_op2) {
		get_token();
		eval_signed(&temp);
		switch(op) {
			case minus_op1:
			case minus_op2:
	            *answer -= temp;  
				break;
			case '+':
    	        *answer += temp;  
				break;
		} // switch
	} // while

} // eval_terms()


BOOLEAN expr_ok(double *answer, char *exprIn, char error[])
{
	// initialize global vars: error message, cursor & first token.
	*err = '\0';
	cursor = exprIn;
	get_token();

	if (!*token) {
		strcpy(err, "No expression");
		Dbg(Debugf("No expresion before [%s], token is [%s]", cursor, token);)
	} else {
		eval_terms(answer);
	}

	if (*token && !*err)  {
		strcpy(err, "Extra text at end of line");
		Dbg(Debugf("Extra text at [%s], token is [%s]", cursor, token);)
	}

	if (*err) {
		strcpy(error, err);
		*answer = nullValue; 
		return FALSE;
	} else 
		return TRUE;

} // expr_ok()



//
// remove leading and trailing blanks from s
//

void deblank(char s[])
{
	char *tmp;
	int ix;

	tmp = s;
	while ( *tmp == SPACE ) {
		tmp++;
	}

	ix = strlen(s);
	if (ix>0) {
		ix--;
		while ( s[ix] == SPACE ) {
			s[ix--] = NULL;
		} // while
	}

	strcpy(s, tmp);
} // deblank


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Message Handlers  							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	AdderEvaluatorEval()

   Evaluate an expression from client in response to msgAdderEvaluatorEval.
****************************************************************************/
MsgHandlerArgType (AdderEvaluatorEval, P_EVAL_FRAME)
{
	CHAR  tempString[maxExprLen];
   
	strcpy(tempString, pArgs->expression);

	// Attempt to evaluate the given expression, put result in value
	// and error in valueStr
	if (expr_ok(&(pArgs->value), tempString, pArgs->valueStr)) {
		// It passed, so convert the result to a string for our client   
		pArgs->badExpr = false;
		sprintf(pArgs->valueStr, "%g", pArgs->value);
		deblank(pArgs->valueStr);   // remove leading, trailing blanks
	} else {
		// It failed, so set the error message flag
		pArgs->badExpr = true;
		pArgs->value = nullValue;   
		// pArgs->valueStr will already have the error message
	}

	return stsOK;
	MsgHandlerParametersNoWarning;
}  // AdderEvaluatorEval
			

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Installation	   					   		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
	ClsAdderEvaluatorInit
	
	Install the class.
****************************************************************************/

STATUS PASCAL ClsAdderEvaluatorInit (void)
{
	CLASS_NEW		new;
	STATUS			s;

	/* Create the class. */
	ObjCallRet(msgNewDefaults, clsClass, &new, s);
	new.object.key			= (OBJ_KEY)clsAdderEvaluatorTable;
	new.object.uid			= clsAdderEvaluator;
	new.cls.pMsg			= clsAdderEvaluatorTable;
	new.cls.ancestor	   	= clsObject;
	new.cls.size			= Nil(SIZEOF);	// no instance data
	new.cls.newArgsSize		= SizeOf(OBJECT_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return stsOK;

}  /* ClsAdderEvaluatorInit */
