/****************************************************************************
 xteach.h
 Copyright 1992, GO Corporation, All Rights Reserved

 Interface file for clsXTeach

 $Revision:   1.11  $
   $Author:   gmills  $
     $Date:   24 Feb 1992 16:57:02  $

    clsXTeach inherits from clsXtract.

****************************************************************************/
#ifndef XTEACH_INCLUDED
#define XTEACH_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef UID_INCLUDED
#include <uid.h>
#endif
#ifndef GEO_INCLUDED
#include <geo.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef enum {

	// evaluation results
	xteachNoMatch,			// no matches

	xteachSingular,			// matches only the correct character
	xteachSuperior,			// matches the correct character best
	xteachEquivalent,		// matches the correct character and an
							//   incorrect character equally well

	xteachSecondary,		// matches an incorrect character best,
							//   but also matches the correct character
	xteachInferior,			// same as secondary, except that the best
							//   match is marginal

	xteachNotProposed,		// matches only incorrect characters marginally
	xteachMisRecognized,	// matches an incorrect character with a good score

	xteachEvaluateFailed,

	// execute results
	xteachOK,
	xteachGeometricUpdated,
	xteachPrototypeAdded,

	xteachOutOfMem,

	xteachPrototypeRemoved,
	xteachPrototypeDowngraded,
	xteachAbort,
	xteachExecuteFailed

} TEACH_STATUS, *P_TEACH_STATUS;

#define xteachMaxConflict		(64)
#define xteachMaxCharConflict  (8)

typedef struct XTEACH_DATA {
	U32 id;								// character/symbol id
	TEACH_STATUS status;				// evaluation results
	U16 conflictCount;					// number of conflicting protos
	CHAR conflicts [xteachMaxConflict];		// conflicting characters
	U32 conflictId [8];					// indices of conflicting protos
	S16 conflictPenalty;				// penalty to assess
	P_UNKNOWN pFirstStroke;				// pointer to first stroke
	P_UNKNOWN pContext;					// pointer to HWX context
	XY32 target;						// coordinate of hot point target
	CHAR hotPointPath;					//
	CHAR hotPointExtrema;					//
} XTEACH_DATA, * P_XTEACH_DATA;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Messages										   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNewDefaults:  takes P_XLATE_NEW, returns STATUS.
	Sets default values for a new Teach translation object.
*/


/****************************************************************************
 msgNew:  takes P_XLATE_NEW, returns STATUS.
	Creates a new Teach translation object.
*/


/****************************************************************************
 msgXlateData:              takes P_XLATE_DATA, returns STATUS.
	Returns Teach results.
*/


typedef struct TEACH_DATA {
	TEACH_STATUS status;				// required action
	CHAR charConflicts [xteachMaxCharConflict];	// conflicting characters
} TEACH_DATA, *P_TEACH_DATA;


/****************************************************************************
 msgXTeachSetId:   takes P_CHAR, returns STATUS
    Establishes expected translation results.
*/
#define msgXTeachSetId						MakeMsg(clsXTeach, 0x01)


/****************************************************************************
 msgXTeachExecute:          takes P_XLIST, returns STATUS
    Executes teaching per TEACH_STATUS.
*/
#define msgXTeachExecute					MakeMsg(clsXTeach, 0x02)


/****************************************************************************
 msgXTeachEvaluationGet:    takes P_XLATE_DATA, returns STATUS
    Reads evaluation data.
*/
#define msgXTeachEvaluationGet				MakeMsg(clsXTeach, 0x03)


/****************************************************************************
 msgXTeachSetTarget:        takes P_XY32, returns STATUS
    Sets the target coordinates for the hot point.
*/
#define msgXTeachSetTarget					MakeMsg(clsXTeach, 0x05)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Notification Messages							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
 msgXTeachCompleted:        takes P_XLIST, returns STATUS
    Signals completion of training.

 This message is sent to all observers of the translation object following
 successful completion of the method for msgXTeachExecute.
*/
#define msgXTeachCompleted					MakeMsg(clsXTeach, 0x04)


#endif // XTEACH_INCLUDED
