/****************************************************************************
 File: tbutton.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.19  $
   $Author:   sbartlet  $
     $Date:   04 Mar 1992 13:55:40  $

 This file contains the API definition for clsTabButton.

 clsTabButton inherits from clsButton.
 Provides a class of button useful in the popup choice contained
 in the title of option sheets, because tab buttons hold some flags,
 a window uid, and an extra client.
****************************************************************************/

#ifndef TBUTTON_INCLUDED
#define TBUTTON_INCLUDED

												#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
												#endif
												#ifndef BUTTON_INCLUDED
#include <button.h>
												#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Common #defines and typedefs					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct TAB_BUTTON_METRICS {
	U16		flags;			// arbitrary flags
	WIN		win;			// associated window uid
	OBJECT	client;			// associated client
	U32		clientData[2];	// arbitrary client data
	U32		spare;			// reserved
} TAB_BUTTON_METRICS, *P_TAB_BUTTON_METRICS;

/****************************************************************************
 msgNew			takes P_TAB_BUTTON_NEW, returns STATUS
	category: class message
	Creates a tab button.

 The fields you commonly set are:
	pArgs->tabButton.metrics.win:		a window uid to hold
	pArgs->tabButton.metrics.client:	a client uid to hold
*/

typedef struct TAB_BUTTON_NEW_ONLY {
	TAB_BUTTON_METRICS	metrics;
	U32					spare;		// reserved
} TAB_BUTTON_NEW_ONLY, *P_TAB_BUTTON_NEW_ONLY;

#define tabButtonNewFields	\
	buttonNewFields			\
	TAB_BUTTON_NEW_ONLY		tabButton;
        
typedef struct TAB_BUTTON_NEW {
	tabButtonNewFields
} TAB_BUTTON_NEW, *P_TAB_BUTTON_NEW;


/****************************************************************************
 msgNewDefaults			takes P_TAB_BUTTON_NEW, returns STATUS
	category: class message
	Initializes the TAB_BUTTON_NEW structure to default values.

 Zeroes out pArgs->tabButton.
*/


/****************************************************************************
 msgTabButtonGetMetrics			takes P_TAB_BUTTON_METRICS, returns STATUS
	Passes back the metrics of a tab button.
*/
#define msgTabButtonGetMetrics	MakeMsg(clsTabButton, 1)


/****************************************************************************
 msgTabButtonSetMetrics			takes P_TAB_BUTTON_METRICS, returns STATUS
	Sets the metrics of a tab button.
*/
#define msgTabButtonSetMetrics	MakeMsg(clsTabButton, 2)


/****************************************************************************
 msgTabButtonGetFlags			takes P_U16, returns STATUS
	Passes back the flags of a tab button.
*/
#define msgTabButtonGetFlags	MakeMsg(clsTabButton, 3)


/****************************************************************************
 msgTabButtonSetFlags			takes U16, returns STATUS
	Sets the flags of a tab button.
*/
#define msgTabButtonSetFlags	MakeMsg(clsTabButton, 4)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSave	takes P_OBJ_SAVE, returns STATUS
	Causes an object to file itself in an object file.

 clsTabButton will save its instance data.

 If the TAB_BUTTON_METRICS.win is not null and the window's wsSendFile
 flag is on, the window will be filed with msgResPutObject (the window's
 wsFileInline flag is cleared first).

 If the TAB_BUTTON_METRICS.client is OSThisApp(), this fact is saved so that
 clsTabButton's response to msgRestore will restore the client to OSThisApp()
 again.  If the client is not OSThisApp(), msgRestore will set the client
 to null.
*/

/****************************************************************************
 msgRestore	takes P_OBJ_RESTORE, returns STATUS
	Creates and restores an object from an object file.

 clsTabButton restores its instance data.

 If the TAB_BUTTON_METRICS.client had been OSThisApp() at msgSave time,
 msgRestore will set the client to OSThisApp() again.
*/


#endif

