/****************************************************************************
 File: tbar.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.51  $
   $Author:   cmeyer  $
     $Date:   23 Mar 1992 20:33:50  $

 This file contains the API definition for clsTitleBar.

 clsTitleBar inherits from clsButton.
 Title bars are the standard frame decorations which support dragging a 
 frame, bringing a frame to the front, and flicking to zoom.
****************************************************************************/
#ifndef TBAR_INCLUDED
#define TBAR_INCLUDED

													#ifndef BUTTON_INCLUDED
#include <button.h>
													#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT TITLE_BAR;

typedef struct TITLE_BAR_STYLE {
	U16	spare		: 16;	// unused (reserved)
} TITLE_BAR_STYLE, *P_TITLE_BAR_STYLE;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_TITLE_BAR_NEW, returns STATUS
	category: class message
	Creates a title bar window.
*/

typedef struct TITLE_BAR_NEW_ONLY {
	TITLE_BAR_STYLE	style;
	U32				spare1;	// unused (reserved)
	U32				spare2;	// unused (reserved)
} TITLE_BAR_NEW_ONLY, *P_TITLE_BAR_NEW_ONLY;

#define	titleBarNewFields	\
	buttonNewFields			\
	TITLE_BAR_NEW_ONLY		titleBar;

typedef struct TITLE_BAR_NEW {
	titleBarNewFields
} TITLE_BAR_NEW, *P_TITLE_BAR_NEW;


/****************************************************************************
 msgNewDefaults				takes P_TITLE_BAR_NEW, returns STATUS
	category: class message
	Initializes the TITLE_BAR_NEW structure to default values.

 Zeroes out pArgs->titleBar and sets
//{
	pArgs->border.style.join			= bsJoinSquare;
	pArgs->border.style.shadow 			= bsShadowNone;
	pArgs->border.style.leftMargin		= bsMarginMedium;
	pArgs->border.style.rightMargin		= bsMarginMedium;
	pArgs->border.style.bottomMargin	= bsMarginSmall + bsMarginSmall;
	pArgs->border.style.topMargin		= bsMarginMedium + bsMarginSmall;

	pArgs->border.style.drag = bsDragHoldDown;

	pArgs->border.style.top = bsTopUp;
	pArgs->border.style.getDeltaWin = true;

	pArgs->control.style.previewEnable = false;

	pArgs->label.style.xAlignment = lsAlignCustom;

	pArgs->button.style.feedback = bsFeedbackNone;
//}
*/

/****************************************************************************
 msgTitleBarGetStyle		takes P_TITLE_BAR_STYLE, returns STATUS
	Passes back the current style values.
*/
#define msgTitleBarGetStyle	  	MakeMsg(clsTitleBar, 1)

/****************************************************************************
 msgTitleBarSetStyle		takes P_TITLE_BAR_STYLE, returns STATUS
	Sets the style values.
*/
#define msgTitleBarSetStyle	  	MakeMsg(clsTitleBar, 2)

#endif	// TBAR_INCLUDED
