/****************************************************************************
 File: strobj.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.14  $
   $Author:   kguzik  $
     $Date:   24 Feb 1992 19:34:42  $

 This file contains the API definition for clsString.

 clsString inherits from clsByteBuf.

 clsString provides a facility to store null-terminated ASCII byte strings.
 Each object of clsString stores a single string. This class provides
 convenient object filing of the string data. Storage for each object's
 string is allocated out of the creator's shared process heap using
 OSHeapBlockAlloc.

 Clients who want to store uninterpreted byte arrays should use clsByteBuf
 (see bytebuf.h).

 clsString and clsByteBuf do not share messages. clsByteBuf messages cannot
 be sent to a clsString object.

****************************************************************************/
#ifndef STROBJ_INCLUDED
#define STROBJ_INCLUDED

#include <go.h>
#include <clsmgr.h>

typedef OBJECT STROBJECT, *P_STROBJECT;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Class Messages							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_STROBJ_NEW_ONLY, returns STATUS
	category: class message
	Creates a new string object. 

 This message allocates shared heap storage for the specified string and
 copies the client string data into it.
*/

typedef struct STROBJ_NEW_ONLY {
	P_CHAR	pString;
} STROBJ_NEW_ONLY, *P_STROBJ_NEW_ONLY;

#define strObjNewFields			\
	objectNewFields				\
	STROBJ_NEW_ONLY		strobj;

typedef struct STROBJ_NEW {
	strObjNewFields
} STROBJ_NEW, *P_STROBJ_NEW;

/****************************************************************************
 msgNewDefaults				takes P_STROBJ_NEW, returns STATUS
	category: class message
	Initializes the STROBJ_NEW structure to default values.

 Sets
 //{
	pNew->strobj.pString	= pNull;
 //}
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Object Messages							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgStrObjGetStr	takes PP_CHAR, returns STATUS
	Passes back the object's string.

 The pointer passed back references the object's global storage. Clients
 must not modify or free this storage.
*/
#define msgStrObjGetStr	 				MakeMsg(clsString, 1)

/****************************************************************************
 msgStrObjSetStr	takes P_CHAR, returns STATUS
	Copies the specified string data into the object's string buffer.

 Previously retrieved string pointers will be invalid after this operation.
 Clients must call msgStrObjGetStr to retrieve a pointer to the valid
 object buffer.
*/
#define msgStrObjSetStr	 				MakeMsg(clsString, 2)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Observer Messages							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgStrObjChanged	takes OBJECT, returns nothing
	category: observer notification
	Sent to observers when the string object data changes.

 The message argument is the UID of the clsString object that changed.
*/
#define msgStrObjChanged 				MakeMsg(clsString, 3)

#endif
