/****************************************************************************
 sort.h

 Copyright 1992, GO Corporation, All Rights Reserved

 Interfaces to sorting routines.

 $Revision:   1.5  $
	$Author:   kcatlin  $
	  $Date:   23 Mar 1992 20:59:36  $

 This file contains the API definition for the quicksort sorting algorithm.

 NOTE: qsort can be found in stdlib.h
****************************************************************************/

#ifndef SORT_INCLUDED
#define SORT_INCLUDED	 Version 1.0

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Public Functions								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 quicksort 		returns pointer
	Sorts a linked list of records using the "quicksort" algorithm.

 Usage:
//{
	 struct record *head;
	 int comp (struct record *p, struct record *q);

	 head = quicksort (head, comp);
//}

 The routine "quicksort" takes an argument "head", which is a pointer to
 the first record of a linked list.	 It also takes an argument "comp",
 which is the name of a user-supplied routine for comparing two list
 records.  The routine "comp" must take as its arguments a pointer to each
 of two list records, and must return an integer, either (-1) if the first
 record is "smaller than" the second, (0) if the first record is "equal
 to" the second, or (+1) if the first record is "larger than" the second.

 After sorting, "quicksort" returns a pointer to the new first record of
 the linked list (i.e., the new "head" of the list).

 The structure of the linked list records is as follows.  The first field
 of each list record must be the "next" pointer.  The actual data in the
 list records may be of variable size.

//{
	 +------+	  +------+	   +------+		+------+	 +------+
	 | head |---->| next |---->| next |---->| next |---->| next |---->pNull
	 +------+	  +------+	   +------+		+------+	 +------+	   
				  | data |	   | data |		| data |	 | data |	   
				  | .... |	   | .... |		| .... |	 | .... |	   
				  | .... |	   +------+		| .... |	 | .... |	   
				  +------+					| .... |	 +------+
											+------+	  
//}

 The "quicksort" algorithm is fast.	 However, it is recursive.	When there
 are N records in the list, the maximum recursion depth will average
 around (ln N) calls.  Each recursion puts about 30 bytes on the stack.
****************************************************************************/

extern	void ** quicksort(void **head, int (*comp)(void **, void **));

#endif	// SORT_INCLUDED
