/*
 *  signal.h
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988-1991.  All rights reserved.
 */
#ifndef _SIGNAL_H_INCLUDED

#include <go.h>

typedef int     sig_atomic_t;

typedef void (CDECL * P_SIG_HANDLER)(int);

#define SIG_IGN         (P_SIG_HANDLER)1
#define SIG_DFL         (P_SIG_HANDLER)2
#define SIG_ERR         (P_SIG_HANDLER)3

#define SIGABRT         1
#define SIGFPE          2

/* Not currently generated by PenPoint */
#define SIGILL          3
#define SIGSEGV         4
#define SIGTERM         5
#define SIGINT          6

#define _SIGMIN     1
#define _SIGMAX     6

P_SIG_HANDLER signal( int __sig, P_SIG_HANDLER __func );
int  raise( int __sig );

#define _SIGNAL_H_INCLUDED
#endif
