/****************************************************************************
 File: shadow.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.48  $
   $Author:   kcatlin  $
     $Date:   10 Mar 1992 13:28:28  $

 This file contains the API definition for clsShadow.

 clsShadow inherits from clsCustomLayout.
 Implements a true shadow as a separate window underneath the shadowed
 window.
****************************************************************************/
#ifndef SHADOW_INCLUDED
#define SHADOW_INCLUDED

													#ifndef _INCLUDED
#include <clayout.h>
													#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT	SHADOW;

typedef struct SHADOW_STYLE {
	U16	trueShadow		: 1,	// create a window for true-shadow effect
		spare			: 15;	// unused (reserved)
} SHADOW_STYLE, *P_SHADOW_STYLE;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_SHADOW_NEW, returns STATUS
	category: class message
	Creates in instance of clsShadow.

 If pArgs->win.flags.style has wsTransparent on, clsShadow will do the
 following:
	-: set border.style.getDeltaWin for pArgs->shadow.borderWin to true.  This
	   will forward any drag/resize operations on the border window to
	   the shadow window.

	-: if pArgs->shadow.style.trueShadow is true the following is done:

		   if pArgs->shadow.shadowWin is objNull, an instance of
		   clsBorder is created as the true shadow window.
			   
		   self's pArgs->border.style.shadow/resize are copied
		   to shadowWin's border style.  Also, border.style.getDeltaWin
		   for shadowWin is set to true.

		   shadowWin is inserted as a child of self, underneath the borderWin,
		   if any.

 If pArgs->borderWin is not objNull, the wsShrinkWrapWidth/Height window
 flags of the borderWin are changed to match self's and the borderWin is
 inserted as a child of self, above the shadowWin, if any.
*/

typedef struct SHADOW_NEW_ONLY {
	SHADOW_STYLE	style;
	WIN				borderWin;
	U32				spare;		// unused (reserved)
} SHADOW_NEW_ONLY, *P_SHADOW_NEW_ONLY;
  

#define	shadowNewFields	\
	customLayoutNewFields		\
	SHADOW_NEW_ONLY			shadow;

typedef struct SHADOW_NEW {
	shadowNewFields
} SHADOW_NEW, *P_SHADOW_NEW;

/****************************************************************************
 msgNewDefaults				takes P_SHADOW_NEW, returns STATUS
	category: class message
	Initializes the SHADOW_NEW structure to default values.

 Zeroes out pArgs->shadow and sets
//{
	pArgs->win.flags.input |= inputDisable | inputTransparent;

	pArgs->win.flags.style |= wsTransparent | wsGrowBottom | wsGrowRight;
	pArgs->gWin.style.gestureEnable = false;

	pArgs->border.style.edge = bsEdgeAll;
	pArgs->border.style.shadow = bsShadowThickGray;
	pArgs->border.style.shadowGap = bsGapWhite;
	pArgs->border.style.borderInk = bsInkGray66;
	pArgs->border.style.resize = bsResizeCorner;
	pArgs->border.style.drag = bsDragHoldDown;
	pArgs->border.style.top = bsTopUp;

	pArgs->customLayout.style.limitToRootWin = true;
//}
*/
/*
 Default SHADOW_STYLE:
//{
 	trueShadow	= false
//}
*/

/****************************************************************************
 msgShadowGetStyle		takes P_SHADOW_STYLE, returns STATUS
	Passes back the current style values.
*/
#define msgShadowGetStyle			MakeMsg(clsShadow, 1)

/****************************************************************************
 msgShadowSetStyle		takes P_SHADOW_STYLE, returns STATUS
	Sets the style values.

 Changes in self's border style are passed on to the borderWin and shadowWin.
*/
#define msgShadowSetStyle			MakeMsg(clsShadow, 2)

/****************************************************************************
 msgShadowGetBorderWin		takes P_WIN, returns STATUS
	Passes back the border window.
*/
#define msgShadowGetBorderWin		MakeMsg(clsShadow, 3)

/****************************************************************************
 msgShadowSetBorderWin		takes WIN, returns STATUS
	Sets the border window.

 The new borderWin is altered as in msgNew.
*/
#define msgShadowSetBorderWin		MakeMsg(clsShadow, 4)

/****************************************************************************
 msgShadowGetShadowWin		takes P_WIN, returns STATUS
	Passes back the shadow window.
*/
#define msgShadowGetShadowWin		MakeMsg(clsShadow, 5)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgWinSetFlags takes P_WIN_METRICS, returns STATUS
    Sets the window flags.

 clsShadow will alter the borderWin's window flags to match the
 wsShrinkWrapWidth/Height flags of self.
*/

/****************************************************************************
 msgCstmLayoutGetChildSpec		takes P_CSTM_LAYOUT_CHILD_SPEC, returns STATUS
	category: self-sent
	Passes back the current spec for the specified child.

 clsShadow responds by providing the custom layout constraints for
 borderWin and shadowWin.

 The shadowWin is placed and sized to provide a gap area on the lower-left and
 upper-right.

 The borderWin is placed above the bottom shadow of the shadowWin and
 sized width-wise to extend to the left of the right shadow of the shadowWin.
*/

/****************************************************************************
 msgWinRepaint takes nothing, returns STATUS
    category: descendant responsibility
    Tells a window to repaint itself.

 If self has wsTransparent on, clsShadow prevents any painting by
 not calling ancestor and painting nothing.
*/

#endif	// SHADOW_INCLUDED
