/****************************************************************************
 File: sendserv.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.35  $
   $Author:   pma  $
     $Date:   20 Mar 1992 14:09:02  $

 This file contains the class definition and methods for clsSendableService.
 clsSendableService inherits from clsService.
 Provides the API for the services which appear on the Document Send menu.

 clsSendableService is an abstract superclass which defines the sendable
 services protocol. This protocol is used by the Send Manager and the
 address book to interact with services on theSendableServices service
 manager. All services on this list *must* implement this protocol.   
****************************************************************************/
#ifndef SENDSERV_INCLUDED
#define SENDSERV_INCLUDED

#ifndef ADDRBOOK_INCLUDED
#include	<addrbook.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  		Common #defines and typedefs  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Data window fields are empty. */
#define stsSendServAddrWinEmpty			MakeWarning(clsSendableService, 1)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSendServCreateAddrWin	takes P_SEND_SERV_ADDR_WIN, returns STATUS
	Converts address data into a window displaying the data.

 This message is sent to a sendable service by the address book.
 A sendable service should create a display window(pArgs->win). The
 sendable service should wait for msgSendServFillAddrWin before it
 fills in the fields in the window.

 Parameters:
    pArgs->numAttrs:   In: number of attributes in the attrs array.
    pArgs->attrs:      In: an array of size pArgs->numAttrs.  
					       pArgs->attrs[x].value contains what the sendable 
						   service needs to display.
    pArgs->win:        Out: sendable-service-created display window.
*/
#define msgSendServCreateAddrWin			MakeMsg(clsSendableService, 1)

typedef struct SEND_SERV_ADDR_WIN {
	U16					numAttrs;
	P_ADDR_BOOK_ATTR	attrs;
	P_STRING			addrSummary;
	BOOLEAN				errNote;
	OBJECT				win;
} SEND_SERV_ADDR_WIN, *P_SEND_SERV_ADDR_WIN;


/****************************************************************************
 msgSendServGetAddrSummary	takes P_SEND_SERV_ADDR_WIN, returns STATUS
	given pArgs->attrs, set pArgs->addrSummary to be a displayable string 
	that sums up the address.

 Parameters:
    pArgs->numAttrs:     In:   number of attributes in the attrs array.
    pArgs->attrs:        In:   an array of size pArgs->numAttrs.  
    pArgs->addrSummary:  Out:  a string that sums up the address information 
						       described in attribute-value form in pArgs->attrs.
*/
#define msgSendServGetAddrSummary			MakeMsg(clsSendableService, 9)

/****************************************************************************
 msgSendServFillAddrWin	takes P_SEND_SERV_ADDR_WIN, returns STATUS
	Sendable service refreshes pArgs->win with information in pArgs->attrs.

 An address book sends a sendable service this message to refresh the
 window that contains information described in pArgs->attrs.

 Parameters:
    pArgs->numAttrs:    In: number of attributes in the attrs array.
						    If 0, then clear all fields.
    pArgs->attrs:       In: an array of size pArgs->numAttrs.  
					        pArgs->attrs[x].value contains what the sendable 
						    service needs to display.
    pArgs->win:         In: uid of sendable-service-created display window.
*/
#define msgSendServFillAddrWin			MakeMsg(clsSendableService, 8)


/****************************************************************************
 msgSendServEncodeAddrWin	takes P_SEND_SERV_ADDR_WIN, returns STATUS
	Converts a window which displays address data into data.

 The service must convert the window into an array of attribute-values,
 as described in ADDR_BOOK_SERVICE_DESC.
 Storage for this array should be created by the sendable service from a 
 global heap. The caller client is responsible for freeing 
 this storage. 

 Parameters:
    pArgs->numAttrs:	Out: Number of elements in the .attrs array
    pArgs->attrs:		Out: fill in the values of each attribute.
    pArgs->errNote:		In:  if TRUE, then the service should display some 
						     kind of note on the screen when error occurs 
							 during data collection and validation.
    pArgs->win:			In:  the window to get the data from.  Presumably
							 the sendable service created this window in 
							 response to a previous msgSendServCreateAddrWin.

 Return Value
	stsServiceDataWinEmpty:		All data element fields are empty.
	stsFailed:					Some error occurs during data collection and
								validation.
*/
#define msgSendServEncodeAddrWin			MakeMsg(clsSendableService, 2)




/****************************************************************************
 msgSendServEncodeAddrData	takes P_SEND_SERV_CONVERT_ADDR_DATA, returns STATUS
	Converts serrvice-specific data into ASCII byte array.

 *** This message is obsolete ***
	
 The service converts attributes in .attrs into ASCII. Storage for this
 array should be created by the service from osProcessSharedHeapId. The 
 caller is responsible for freeing this storage.


 Return Value
	stsServiceDataWinEmpty:		All data element fields are empty.
*/
#define msgSendServEncodeAddrData			MakeMsg(clsSendableService, 3)

typedef struct SEND_SERV_CONVERT_ADDR_DATA {
	P_U8				pBuf;	// In/Out:	Encoded addressing data
	U16					bufLen;	// In/Out:	Length of pBuf
	U16					numAttrs;
	P_ADDR_BOOK_ATTR	attrs;
} SEND_SERV_CONVERT_ADDR_DATA, *P_SEND_SERV_CONVERT_ADDR_DATA;


/****************************************************************************
 msgSendServDecodeAddrData	takes P_SEND_SERV_CONVERT_ADDR_DATA, returns STATUS
 *** This message is obsolete ***
	
	Converts ASCII data into service-specific data.

 The resulting data is put into .attrs and update the attribute count in
 .numAttrs.
*/
#define msgSendServDecodeAddrData			MakeMsg(clsSendableService, 4)


/****************************************************************************
 msgAppExecute	takes P_APP_EXECUTE, returns STATUS
	Displays a UI for obtaining addressing info	and executing the send.

 This message is a standard clsApp message which is forwarded to the 
 service the user has selected from the standard "Send" menu. The service
 should create and display their UI for obtaining addressing information
 from the user.

 Declaration for the APP_EXECUTE data structure can be found in app.h 
*/

/****************************************************************************
 msgSendServGetAddrDesc		takes P_ADDR_BOOK_SVC_DESC, returns STATUS
	 Responsibility of a sendable service to return its service
	 attribute-value pairs that describe its service address

 An address book usually send this message to a sendable service as part of
 of initialization to find out the service address description.
 */
#define msgSendServGetAddrDesc		MakeMsg(clsSendableService, 7)

#endif	// SENDSERV_INCLUDED


