/****************************************************************************
 File: prlayout.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.5  $
   $Author:   tbartlet  $
     $Date:   21 Feb 1992 17:00:22  $

 This file contains the API definition for clsPrLayout.

 clsPrLayout inherits from clsObject.
 A prLayout object makes a document paginate.

 A print layout object guides the top-level document through the 
 pagination process and assists it in implementing its embeddees' 
 print properties.
 
****************************************************************************/
#ifndef PRLAYOUT_INCLUDED
#define PRLAYOUT_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef UID_INCLUDED
#include <uid.h>
#endif
#ifndef PRINT_INCLUDED
#include <print.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct PRLAYOUT_METRICS {

    OBJECT      topLevelApp;	// outermost document printed
	OBJECT		currentApp;		// current document being printed 
								// as top-level
    OBJECT      prFrame;		// instance of clsPrFrame
    OBJECT      winDev;			// printer is bound to this window device
    OBJECT      printJob;	  	// "owner" of this object
	U32			reserved;

} PRLAYOUT_METRICS, *P_PRLAYOUT_METRICS;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Messages											   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/****************************************************************************
 msgNew	takes P_PRLAYOUT_NEW, returns STATUS
	Create a new object.
*/
typedef struct PRLAYOUT_NEW_ONLY {

    OBJECT      topLevelApp;
    OBJECT      prFrame;
    OBJECT      winDev;
    OBJECT      printJob;
	U32			reserved;

} PRLAYOUT_NEW_ONLY, *P_PRLAYOUT_NEW_ONLY;

#define	prLayoutNewFields	\
	objectNewFields		\
	PRLAYOUT_NEW_ONLY		prLayout;

typedef struct PRLAYOUT_NEW {

	prLayoutNewFields

} PRLAYOUT_NEW, *P_PRLAYOUT_NEW;

/****************************************************************************
 msgPrLayoutGetMetrics	takes P_PRLAYOUT_METRICS, returns STATUS
	Get PrLayout metrics.
*/
#define msgPrLayoutGetMetrics	 			MakeMsg(clsPrLayout, 1)

/****************************************************************************
 msgPrLayoutSetMetrics	takes P_PRLAYOUT_METRICS, returns STATUS
	Set PrLayout metrics.
*/
#define msgPrLayoutSetMetrics	 			MakeMsg(clsPrLayout, 2)

/****************************************************************************
 msgPrLayoutNextPage	takes PRLAYOUT_PAGE, returns STATUS
	Get next page.

 Uses print protocol messages defined in print.h to get the next page
 from the document being printed. 
*/
#define msgPrLayoutNextPage	 				MakeMsg(clsPrLayout, 3)

typedef struct PRLAYOUT_PAGE {
	U16 pageNumber;				// In:	paper sheets
	U16 displayPageNumber;		// In:	number displayed on page 
	U16 logicalPageNumber;		// Out: num times msgPrintStartPage sent
    OBJECT  currentApp;         // Out: top level app supplying current page
    BOOLEAN appChanged;         // Out: true if first page from currentApp
    
} PRLAYOUT_PAGE, *P_PRLAYOUT_PAGE;

#endif

