/****************************************************************************
 File: pdictmgr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.13  $
   $Author:   rfoster  $
     $Date:   22 Feb 1992 15:35:02  $

 This file contains the API definition for clsPDictProtoInstallMgr.
 clsPDictProtoInstallMgr inherits from clsInstallMgr.
 It performs personal dictionary installation and maintenance.
 
 See Also
	instlmgr.h
****************************************************************************/
#ifndef PDICTMGR_INCLUDED
#define PDICTMGR_INCLUDED

#ifndef INSTLMGR_INCLUDED
#include <instlmgr.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  		Common #defines and typedefs  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Popup Editor messages and tags  ****/
#define msgPIMPopUpEditor   			MakeMsg(clsPDictInstallMgr, 100)
#define tagPIMPopUpEditor  				MakeTag(clsPDictInstallMgr, 1) 
#define hlpPIMEditorButton   		   	MakeTag(clsPDictInstallMgr, 100) 


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew						takes P_PIM_NEW, returns STATUS
	category: class message
	Creates a new personal dictionary install manager. 

 There is only one instance of this class, theInstalledPDicts, in the 
 system. Clients should never send msgNew.
*/

typedef struct PIM_NEW {
	installMgrNewFields
} PIM_NEW, *P_PIM_NEW;

#endif	// PDICTMGR_MGR_INCLUDED


