/****************************************************************************
 File: intl.h

 (C) Copyright 1992 by Go Corporation, All Rights Reserved.

 $Revision:   1.2  $
   $Author:   jbennett  $
	 $Date:   03 Mar 1992 11:20:52  $

 Definitions used while internationalizing code.

 The main content of this file is macros that map the names of UNICODE
 string functions for PENPOINT 2.0 to the 8-bit functions used currently.
 They are intended to be used with items of type CHAR, which are 8-bit
 currently and will switch to 16-bit in 2.0.  By using these macros
 code that deals with strings will have a chance of working in 2.0 with
 only a recompile.

****************************************************************************/
#ifndef INTL_INCLUDED
#define INTL_INCLUDED

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						UNICODE strings/characters						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 To define characters or strings in PENPOINT 1.0, use the "U_L" macro
 on them.  This maps to the original string, and thus does nothing.
 In 2.0 the define will be changed so that it inserts "L" in front of
 the string.  This will convert the character or string into a wide
 character or string to match the 2.0 definition of CHAR.  

 Here is some sample code to show its use.  This code would compile
 and run under both 1.0 and 2.0, the only difference would be the
 space allocated for each character (1 vs. 2 bytes).
	//{
   		CHAR	cc;
		P_CHAR	pString;

		pString	= U_L("sample string");
		cc		= U_L('s');

		if (cc == pString[0])
			pString[0]	= U_L('S');
	//}
*/

#define U_L(str)		str		// Does nothing in PENPOINT 1.0
// #define U_L(str)		L##str	// Definition to be used in PENPOINT 2.0

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *			Mapping of 16-bit string/character functions for 1.0		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* 
 For each of the sections below, it is necessary to include the base
 header file in order to use the macros defined here.

 These macros are intended to be used with variables of type CHAR.
 CHAR is currently U8, and will be converted to U16 in PENPOINT 2.0.
*/

/****  Extensions to STRING.H  ****/

#define Ustrcat         strcat
#define Ustrncat        strncat
#define Ustrcmp         strcmp
#define Ustrncmp        strncmp
#define Ustrcpy         strcpy
#define Ustrncpy        strncpy
#define Ustrlen         strlen
#define Ustrdup         strdup
#define Ustrrev         strrev
#define Ustrset         strset
#define Ustrnset        strnset
#define Ustrchr         strchr
#define Ustrrchr        strrchr
#define Ustrspn         strspn
#define Ustrcspn        strcspn
#define Ustrpbrk        strpbrk
#define Ustrstr         strstr
#define Ustrtok         strtok
#define Ustricmp        stricmp
/* 'strcmpi' the same as 'stricmp', we don't need U versions of both. */
#define Ustrnicmp       strnicmp
#define Ustrlwr         strlwr
#define Ustrupr         strupr

#define Umemcpy         memcpy
#define Umemccpy        memccpy
#define Umemchr         memchr
#define Umemcmp         memcmp
#define Umemicmp        memicmp
#define Umemmove        memmove
#define Umemset         memset
#define Ustrerror       strerror

/****  Extensions to CTYPE.H  ****/

#define Uisalpha        isalpha
#define Uisalnum        isalnum
#define Uisascii        isascii
#define Uiscntrl        iscntrl
#define Uisprint        isprint
#define Uisgraph        isgraph
#define Uisdigit        isdigit
#define Uisxdigit       isxdigit
#define Uislower        islower
#define Uisupper        isupper
#define Uisspace        isspace
#define Uispunct        ispunct
#define Utolower        tolower
#define Utoupper        toupper

/****  Extensions to STDLIB.H  ****/

#define Uatoi           atoi
#define Uatol           atol
#define Uitoa           itoa
#define Ultoa           ltoa
#define Uutoa           utoa
#define Ustrtol         strtol
#define Uatof           atof
#define Ustrtod         strtod
#define Ustrtoul        strtoul

/*
 This goes directly to its 2.0 definition because it does not
 make sense on an ascii text stream, and if the current text is
 not ascii, then having it automatically convert to Unicode by
 recompile in 2.0 won't work.  It is included mostly to reserve
 the name, and let programers know that it will be available.
*/
#define Uswab(s,d,n)    swab((char *)s, (char *)d, n*2)

/****  Extensions to STDIO.H  ****/

#define Ufopen          fopen
#define Usprintf        sprintf
#define Uvsprintf       vsprintf
#define Usscanf         sscanf
#define Uputc           putc
#define Ufputc          fputc
#define Ugetc           getc
#define Ufgetc          fgetc
#define Uungetc         ungetc
#define Ufdopen         fdopen
#define Ufreopen		freopen
#define Uprintf		 	printf
#define Ufprintf		fprintf
#define Uvprintf		vprintf
#define Uvfprintf		vfprintf
#define Uscanf			scanf
#define Ufscanf		 	fscanf
#define Uvscanf		 	vscanf
#define Uvfscanf		vfscanf
#define Uvsscanf		vsscanf
#define Ugetchar		getchar
#define Ufgetchar		fgetchar
#define Ugets			gets
#define Ufgets			fgets
#define Uputchar		putchar
#define Ufputchar		fputchar
#define Uputs			puts
#define Ufputs			fputs
#define Uremove		 	remove
#define Urename		 	rename
#define Utmpnam		 	tmpnam

/****  Extensions to FCNTL.H  ****/

#define Uopen			open
#define Usopen			sopen
#define Ucreat			creat

/****  Extensions to TIME.H  ****/

#define Uasctime		asctime
#define Uctime			ctime

/****  Extensions to UNISTD.H  ****/

#define Urmdir			rmdir
#define Uchdir			chdir
#define Ugetcwd		 	getcwd

/****  Extensions to DIRENT.H  ****/

#define Uopendir		opendir
#define Ureaddir		readdir

#endif		// INTL_INCLUDED
