/****************************************************************************
 File: hwxserv.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.55  $
   $Author:   sisaac  $
     $Date:   02 Mar 1992 10:09:00  $

 This file contains the API definition for clsHWXEngineService.
 clsHWXEngineService inherits from clsService.
 Provides default behavior for handwriting engine services.
****************************************************************************/
#ifndef HWXSERV_INCLUDED
#define HWXSERV_INCLUDED

#ifndef SERVICE_INCLUDED
#include <service.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew				takes P_HWX_SVC_NEW, returns STATUS
	category: class message
	Creates a new service object. 

*/

typedef struct HWX_SVC_NEW_ONLY {
	U32						unused1;
	U32						unused2;
	U32						unused3;
	U32						unused4;
} HWX_SVC_NEW_ONLY, *P_HWX_SVC_NEW_ONLY;

#define	hwxServiceNewFields	\
	serviceNewFields		\
	HWX_SVC_NEW_ONLY		hwxService;

typedef struct HWX_SVC_NEW {
	hwxServiceNewFields	
} HWX_SVC_NEW, *P_HWX_SVC_NEW;


/****************************************************************************
 msgHWXSvcCurrentChanged  	takes P_HWX_SVC_CURRENT_CHANGED, returns STATUS
    The current handwriting prototype set has changed.

 The user has switched to or from a handwriting prototype set that uses this 
 engine. See hwxmgr.h and instlmgr.h for details on handwriting prototype set 
 management.

 pArgs->newHandle and pArgs->oldHandle provide the handles of the new and
 old prototype sets. objNull means that the new/former prototype set used
 some other engine.
*/
#define msgHWXSvcCurrentChanged 			MakeMsg(clsHWXEngineService, 1)

typedef struct HWX_SVC_CURRENT_CHANGED {
	OBJECT					newHandle;
	OBJECT					oldHandle;
} HWX_SVC_CURRENT_CHANGED, *P_HWX_SVC_CURRENT_CHANGED;

#endif	// HWXSERV_INCLUDED

											
