/****************************************************************************
 File: hwxmgr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.47  $
   $Author:   rfoster  $
     $Date:   22 Feb 1992 15:34:54  $

 This file contains the API definition for clsHWXProtoInstallMgr.
 clsHWXProtoInstallMgr inherits from clsInstallMgr.
 It performs handwriting prototype installation and maintenance.
 
 There is a single instance of clsHWXProtoInstallMgr in the system; the 
 well-known uid theInstalledHWXProtos.

 The hwxproto manager maintains the installed and deinstalled handwriting
 prototype sets on the system, and their relation to the installable 
 handwriting translation engines, which are kept on theHWXEngines service
 manager.  The hwxproto manager differs from a generic install manager in the 
 area of hwx engine identification and its tie-in with theHWXEngines 
 service manager.

 A handwriting prototype set is a directory which contains engine-specific
 information.  Each installed engine on the system must have at least one
 hwxproto set in theInstalledHWXProtos in order for it to be used.

 See Also
	instlmgr.h

****************************************************************************/
#ifndef HWXMGR_INCLUDED
#define HWXMGR_INCLUDED

#ifndef INSTLMGR_INCLUDED
#include <instlmgr.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  		Common #defines and typedefs  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Status Codes  ****/

/* The hwx engine for this prototype set is not available */
#define  stsHIMEngineUnavailable	   	MakeStatus(clsHWXProtoInstallMgr, 0)

/* Can't change current hwx prototype; hwx engine is in use with it */
#define  stsHIMCurrentEngineInUse 	   	MakeStatus(clsHWXProtoInstallMgr, 1)

/* No training for this handwriting set. */
#define  stsHIMNoTraining		 	   	MakeStatus(clsHWXProtoInstallMgr, 2)

/* No practice for this handwriting set. */
#define  stsHIMNoPractice		 	   	MakeStatus(clsHWXProtoInstallMgr, 2)


/****  Filesystem attribute definitions  ****/

/* HWX Engine name */
#define himAttrEngineName			FSMakeStrAttr(clsHWXProtoInstallMgr, 0)

/* Is the engine for this hwxproto available? */
#define himAttrEngineAvailable	  	FSMakeFix32Attr(clsHWXProtoInstallMgr, 1)
typedef enum HIM_ATTR_ENGINE_AVAILABLE {
	himEngineAvailable		  = 0,	 // Same as no attribute
	himEngineUnavailable	  = 1 
} HIM_ATTR_ENGINE_AVAILABLE;

/*
 HWX Training window class.  This is stamped on the HWX Engine Service class
 directory.
*/
#define himAttrTrainingWinClass		FSMakeFix32Attr(clsHWXProtoInstallMgr, 3)

/*
 HWX Practice window class.  This is stamped on the HWX Engine Service's
 class directory.
*/
#define himAttrPracticeWinClass		FSMakeFix32Attr(clsHWXProtoInstallMgr, 4)

/*
 Gesture Training window class.  This is stamped on the Gesture Engine 
 Service's class directory.
*/
#define himAttrGestTrainingWinClass FSMakeFix32Attr(clsHWXProtoInstallMgr, 5)

/*
 Gesture Practice window class.  This is stamped on the Gesture Engine 
 Service's class directory.
*/
#define himAttrGestPracticeWinClass	FSMakeFix32Attr(clsHWXProtoInstallMgr, 6)


/****  Popup Training and Practice tags  ****/

#define msgHIMPopUpTraining   			MakeMsg(clsHWXProtoInstallMgr, 100)
#define msgHIMPopUpPractice   			MakeMsg(clsHWXProtoInstallMgr, 101)
#define msgHIMPopUpGestureTraining   	MakeMsg(clsHWXProtoInstallMgr, 102)
#define msgHIMPopUpGesturePractice   	MakeMsg(clsHWXProtoInstallMgr, 103)
#define tagHIMPopUpTraining  			MakeTag(clsHWXProtoInstallMgr, 1) 
#define tagHIMPopUpPractice  			MakeTag(clsHWXProtoInstallMgr, 2) 
#define tagHIMPopUpGestureTraining  	MakeTag(clsHWXProtoInstallMgr, 3) 
#define tagHIMPopUpGesturePractice  	MakeTag(clsHWXProtoInstallMgr, 4) 
#define hlpHIMTrainingButton   		   	MakeTag(clsHWXProtoInstallMgr, 100) 
#define hlpHIMPracticeButton   		   	MakeTag(clsHWXProtoInstallMgr, 101) 
#define hlpHIMGestureTrainingButton   	MakeTag(clsHWXProtoInstallMgr, 102) 
#define hlpHIMGesturePracticeButton   	MakeTag(clsHWXProtoInstallMgr, 103) 

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew						takes P_HIM_NEW, returns STATUS
	category: class message
	Creates a new handwriting prototype install manager. 

 There is only one instance of this class, theInstalledHWXProtos, in the 
 system.  Clients should never send msgNew.
*/

typedef struct HIM_NEW {
	installMgrNewFields
} HIM_NEW, *P_HIM_NEW;


/****************************************************************************
 msgHIMGetEngine			takes P_HIM_GET_SET_ENGINE, returns STATUS
	Gets the name and availability of the engine associated with this hwxprot.

 Engine names can be up to nameLength characters long.
*/
#define msgHIMGetEngine		 		 	MakeMsg(clsHWXProtoInstallMgr, 1)

typedef struct HIM_GET_SET_ENGINE {
	IM_HANDLE			handle;		// hwxproto handle to get engine name of.
	P_STRING			pEngineName;// Out: Name.  Must have at least
									//   nameBufLength bytes allocated.
	BOOLEAN				available;	// Out: Is the engine available?
} HIM_GET_SET_ENGINE, *P_HIM_GET_SET_ENGINE;


/****************************************************************************
 msgHIMSetEngine	   			takes P_HIM_GET_SET_ENGINE, returns STATUS
	Set the hwxproto's engine name.

 Note: This message is rarely used.  Typically, handwriting prototype sets
 have the engine attribute stamped on them when they are created, and it
 is never changed.
*/
#define msgHIMSetEngine		   			MakeMsg(clsHWXProtoInstallMgr, 2)


/****************************************************************************
 msgHIMAvailabilityChanged	takes P_HIM_AVAILABILITY_NOTIFY, returns STATUS
	category: observer notification
	An hwx proto's engine availability has changed.

*/
#define msgHIMAvailabilityChanged 		MakeMsg(clsHWXProtoInstallMgr, 20)

typedef struct HIM_AVAILABILITY_NOTIFY {
	OBJECT				manager;	// manager that sent notification
	IM_HANDLE			handle;		// handle that changed
	BOOLEAN				available;	// new engine availability state
} HIM_AVAILABILITY_NOTIFY, *P_HIM_AVAILABILITY_NOTIFY;


#endif	// HWXMGR_INCLUDED


