/****************************************************************************
 File: HWLetter.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.5  $
   $Author:   pstahl  $
     $Date:   20 Feb 1992 17:20:54  $

 This file contains definitions for clsHWLetterFrame.
 clsHWLetterFrame inherits from clsFrame.

 This file contains the API definition for clsHWLetterFrame.  Instances of
 clsHWLetterFrame are created by the Settings Notebook when the user taps
 the "Practice" button on the Installed Handwriting page.  The Settings
 Notebook will pass in the handle of the prototype set to practice.
 It is up to clsHWLetterFrame instances to carry out the practice session
 and destroy themselves when finished.
****************************************************************************/

/**** Debugging Flags ****/
/*
 clsHWLetterFrame uses the Handwriting debug flag set 'Z'.
 clsHWLetterFrame uses:

    10000:  Show all internal debugging messages

*/

#ifndef HWLETTER_INCLUDED
#define HWLETTER_INCLUDED

#ifndef FRAME_INCLUDED
#include <frame.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct HWLETTER_NEW_ONLY {
    OBJECT  protoSetHandle;     // handle of prototype set to practice
} HWLETTER_NEW_ONLY;

#define hwLetterNewFields \
    frameNewFields       \
    HWLETTER_NEW_ONLY   hwletter;

typedef struct HWLETTER_NEW {
    hwLetterNewFields
} HWLETTER_NEW, *P_HWLETTER_NEW;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNewDefaults				takes P_HWLETTER_NEW, returns STATUS
	category: class message
	Initializes the HWLETTER_NEW structure to default values.
    Default values are the same as for clsFrame, with a protoSetHandle of 0.

*/

/****************************************************************************
 msgNew		takes P_HWLETTER_NEW, returns STATUS
	category: class message
	Creates a handwriting practice frame window, using the
    handwriting prototype set in pArgs->hwletter.protoSetHandle.
    If protoSetHandle==0, uses the current InstalledHWXProtos.

*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								  Quick Help Tags						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define hlpLetterPractice   MakeTag(clsHWLetterFrame, 1)
#define hlpLWInputSPaper    MakeTag(clsHWLetterFrame, 2)
#define hlpLWKeyboard       MakeTag(clsHWLetterFrame, 3)
#define hlpLWPrevScribble   MakeTag(clsHWLetterFrame, 4)
#define hlpLWXlateResult    MakeTag(clsHWLetterFrame, 5)
#define hlpLWAnimationWin   MakeTag(clsHWLetterFrame, 6)

#endif //HWLETTER_INCLUDED
